unit
  UtilISAPI;
(*##*)
(*******************************************************************
*                                                                 *
*   U  T  I  L  I  S  A  P  I    isapi access routines for Delphi  *
*                                                                 *
*   Copyright (c) 2000, A.Ivanov. All rights reserved.             *
*   Conditional defines:                                           *
*                                                                 *
*   Last Revision: May 23 2000                                     *
*   Last fix     : May 23 2000                                    *
*   Lines        :                                                 *
*   History      :                                                *
*   Printed      : ---                                             *
*                                                                 *
********************************************************************)
(*##*)

interface

uses
  Windows, SysUtils, Classes, ISAPI,
{$IFDEF VER140}
    IsapiHTTP, HTTPProd,
{$ENDIF}

  HttpApp, ISAPIApp;

type
  TGetExtensionVersion = function (var Ver: THSE_VERSION_INFO): Bool; stdcall;
  THttpExtensionProc = function (var ECB: TEXTENSION_CONTROL_BLOCK ): DWORD; stdcall;


function GetVersionISAPI(AModuleName: String): String;

// CallISAPI load library, execute and unload
function CallISAPI(AModuleName, AMethod, APathInfo: String;
  AParameterlist, AServerVarList: TStrings): String;

// or you can load DLL, and then call
// load library
function LoadISAPI(AModuleName: String; var Handle: LongWord; var HttpExtensionProc: THttpExtensionProc): Boolean;
// function do call loaded DLL (Handle, HttpExtensionProc)
function DoCallISAPI(Handle: LongWord; HttpExtensionProc: THttpExtensionProc;
  AMethod, APathInfo: String; AParameterlist, AServerVarList: TStrings): String;

function GetServerVarList(ARequest: TWebRequest): TStrings;
function ReadStringSmallPortions(ARequest: TWebRequest; var S: String): Boolean;
{ utility }
function CreateParameterList(AList: TStrings): PChar;

implementation
const
  ServerVariables: array[0..28] of string = (
    '*METHOD',
    'SERVER_PROTOCOL',
    'URL',
    '*GET_QUERY_STRING',
    '*PATH_INFO',
    '*PATH_TRANSLATED',
    'HTTP_CACHE_CONTROL',
    'HTTP_DATE',
    'HTTP_ACCEPT',
    'HTTP_FROM',
    'HTTP_HOST',
    'HTTP_IF_MODIFIED_SINCE',
    'HTTP_REFERER',
    'HTTP_USER_AGENT',
    'HTTP_CONTENT_ENCODING',
    'CONTENT_TYPE',
    'CONTENT_LENGTH',
    'HTTP_CONTENT_VERSION',
    'HTTP_DERIVED_FROM',
    'HTTP_EXPIRES',
    'HTTP_TITLE',
    'REMOTE_ADDR',
    'REMOTE_HOST',
    'SCRIPT_NAME',
    'SERVER_PORT',
    '*POST_DATA',
    'HTTP_CONNECTION',
    'HTTP_COOKIE',
    'HTTP_AUTHORIZATION');

type
  TConnRec = record
    ResultString: ^String;
    ServerVars: TStrings;
  end;

  PConnRec = ^TConnRec;

// TGetServerVariableProc = function(hConn: HCONN; VariableName: PChar; Buffer: Pointer; var Size: DWORD): BOOL stdcall;
// request for server variables
function MyGetServerVariableProc(ConnID: HCONN; VariableName: PChar;
  Buffer: Pointer; var Size: DWORD): BOOL stdcall;
var
  Dest: PConnRec;
begin
  Result:= True;
  Dest:= Pointer(ConnID);
  StrPLCopy(Buffer, Dest^.ServerVars.Values[VariableName], Size);
  Size:= Length(PChar(Buffer))+1;
  // Dest^.Reserved^:= Dest^.ServerVars.Values[VariableName];
  // Buffer:= @(Dest^.Reserved^[1]);
  // if Length(Dest^.Reserved^) >= Size then SetLength(Dest^.Reserved^, Size-1);
end;

// TWriteClientProc = function(ConnID: HCONN; Buffer: Pointer; var Bytes: DWORD; dwReserved: DWORD ): BOOL stdcall;
function MyWriteClientProc(ConnID: HCONN; Buffer: Pointer; var Bytes: DWORD;
  dwReserved: DWORD): BOOL stdcall;
var
  L: Cardinal;
  Dest: PConnRec;
begin
  Result:= True;
  Dest:= Pointer(ConnID);
  L:= Length(Dest^.ResultString^);
  SetLength(Dest^.ResultString^, L + Bytes);
  Move(Buffer^, Dest^.ResultString^[L+1], Bytes);
end;

// TReadClientProc  = function(ConnID: HCONN; Buffer: Pointer; var Size: DWORD ): BOOL stdcall;
function MyReadClientProc(ConnID: HCONN; Buffer: Pointer; var Bytes: DWORD;
  dwReserved: DWORD ): BOOL stdcall;
begin
  Result:= True;
end;

// TServerSupportFunctionProc = function(hConn: HCONN; HSERRequest: DWORD; Buffer: Pointer; var Size: DWORD; var DataType: DWORD ): BOOL stdcall;
function MyServerSupportFunction(hConn: HCONN; HSERRequest: DWORD; Buffer: Pointer; var Size: DWORD; var DataType: DWORD ): BOOL stdcall;
begin
  Result:= False;
end;

function GetVersionISAPI(AModuleName: String): String;
var
  GetExtensionVersion: TGetExtensionVersion;
  Handle: LongWord;
  FTHSE_VERSION_INFO: THSE_VERSION_INFO;
begin
  Handle:= LoadLibrary(PChar(AModuleName));
  if Handle <> 0 then begin
    @GetExtensionVersion:= GetProcAddress(Handle, 'GetExtensionVersion');
    if @GetExtensionVersion <> nil then  begin
      if GetExtensionVersion(FTHSE_VERSION_INFO) then begin
        Result:= FTHSE_VERSION_INFO.lpszExtensionDesc;
      end else begin
        Result:= 'Error';
      end;
    end else begin
      raise Exception.CreateFmt(' %s    .', [AModuleName]);
    end;
    FreeLibrary(Handle);
  end else begin
    raise Exception.CreateFmt('  DLL %s.', [AModuleName]);
  end;
end;

function CreateParameterList(AList: TStrings): PChar;
var
  i, L: Integer;
  S: String;
begin
  if Assigned(AList) then begin
    S:= '';
    for i:= 0 to AList.Count - 1 do begin
      S:= S + AList[i] + '&';
    end;
    L:= Length(S);
    if L > 0 then begin
      Delete(S, L, 1);
      Dec(L);
    end;
    GetMem(Result, L + 1);
    StrLCopy(Result, PChar(S), L);
  end else Result:= Nil;
end;

function DoCallISAPI(Handle: LongWord; HttpExtensionProc: THttpExtensionProc;
  AMethod, APathInfo: String; AParameterlist, AServerVarList: TStrings): String;
var
  err: Integer;
  ECB: TEXTENSION_CONTROL_BLOCK;
  Destination: TConnRec;
begin
  FillChar(ECB, SizeOf(ECB), 0);
  with ECB do begin
    // cbSize:= SizeOf(ECB); must be 0
    Destination.ResultString:= @Result;
    Destination.ServerVars:= AServerVarList;
    Pointer(ConnID):= @Destination;

    lpszMethod:= PChar(AMethod);
    GetMem(lpszPathInfo, Length(APathInfo)+1);
    StrPCopy(lpszPathInfo, APathInfo);
    if AnsiCompareText(AMethod, 'GET') = 0 then begin
      lpszQueryString:= CreateParameterList(AParameterList);
    end else begin
      lpbData:= CreateParameterList(AParameterList);
      cbAvailable:= Length(PChar(lpbData));
      cbTotalBytes:= cbAvailable
    end;
    WriteClient:= @MyWriteClientProc;
    GetServerVariable:= @MyGetServerVariableProc;
    ReadClient:= @MyReadClientProc;
    ServerSupportFunction:= MyServerSupportFunction;
    err:= HttpExtensionProc(ECB) ;
    FreeMem(lpszQueryString);
    FreeMem(lpszPathInfo);
  end;
  if err <> HSE_STATUS_SUCCESS then begin
    raise Exception.CreateFmt('  %s  %d.', ['', err]);
  end;
end;

function LoadISAPI(AModuleName: String; var Handle: LongWord; var HttpExtensionProc: THttpExtensionProc): Boolean;
begin
  Result:= False;
  // load library
  Handle:= LoadLibrary(PChar(AModuleName));
  if Handle <> 0 then begin
    @HttpExtensionProc:= GetProcAddress(Handle, 'HttpExtensionProc');
    if @HttpExtensionProc <> nil
    then Result:= True
    else FreeLibrary(Handle);
  end;
end;

function CallISAPI(AModuleName, AMethod, APathInfo: String;
  AParameterlist, AServerVarList: TStrings): String;
var
  Handle: LongWord;
  HttpExtensionProc: THttpExtensionProc;
begin
  // load library
  if LoadISAPI(AModuleName, Handle, HttpExtensionProc) then  begin
    // execute
    Result:= DoCallISAPI(Handle, HttpExtensionProc,
      AMethod, APathInfo, AParameterlist, AServerVarList);
  end else begin
    // if fails
    if Handle = 0
    then raise Exception.CreateFmt('  DLL %s.', [AModuleName]);
    if not Assigned(HttpExtensionProc)
    then raise Exception.CreateFmt(' %s    .', [AModuleName]);
  end;
  // do not! if Handle <> 0 then FreeLibrary(Handle);
end;

function GetServerVarList(ARequest: TWebRequest): TStrings;
var
  ind: Integer;
  S: String;
begin
  Result:= TStringList.Create;
  for ind:= 0 to 28 do with ARequest as TISAPIRequest do begin
    S:= ServerVariables[Ind];
    if S = ''
    then Continue;
    S:= S+'=';
    case Ind of
    0: S:= S + ECB.lpszMethod;
    3: S:= S + ECB.lpszQueryString;
    4: S:= S + ECB.lpszPathInfo;
    5: S:= S + ECB.lpszPathTranslated;
    1..2, 6..24, 26..28: S:= S + GetFieldByName(ServerVariables[Ind]);
    25: if ECB.cbAvailable > 0 then begin
        SetString(S, PChar(ECB.lpbData), ECB.cbAvailable);
        S:= ServerVariables[25] + '=' + S;
      end;
    else
      S:= '';
    end;
    Result.Add(S);
  end;
end;

function ReadStringSmallPortions(ARequest: TWebRequest; var S: String): Boolean;
const
  MAXREADSIZE1 = 8192;
var
  RSize, Bytes2Read, Tryes: Integer;
begin
  Result:= True;
  Bytes2Read:= ARequest.ContentLength - Length(S);
  Tryes:= Bytes2Read div MAXREADSIZE1 + 2;
  while Bytes2Read > 0 do begin
    RSize := MAXREADSIZE1;
    if RSize > Bytes2Read then RSize:= Bytes2Read;
    try
      S:= S + ARequest.ReadString(RSize);
    except
      Dec(Tryes);
      if Tryes <=0
      then Exit;
    end;
    Bytes2Read:= ARequest.ContentLength - Length(S);
  end;
end;

end.
