unit IpGridAux;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, StdCtrls, Db, DbTables;
type TBlobType = (btMemo, btFmtMemo, btImage);
type
  TfrmIpGridAux = class(TForm)
    Panel1: TPanel;
    btnVolta: TSpeedButton;
    btnConf: TSpeedButton;
    btnCanc: TSpeedButton;
    Memo1: TMemo;
    ScrollBox1: TScrollBox;
    Image1: TImage;
    procedure Memo1Change(Sender: TObject);
    procedure btnVoltaClick(Sender: TObject);
    procedure btnCancClick(Sender: TObject);
    procedure btnConfClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    FBlobCaption: String;
    FBlobField: TField;
    FDataSource: TDataSource;
  public
    { Public declarations }
    property BlobCaption: String read FBlobCaption write FBlobCaption;
    property BlobField: TField read FBlobField write FBlobField;
    property DataSource: TDataSource read FDataSource write FDataSource;
  end;

var
  frmIpGridAux: TfrmIpGridAux;

implementation
uses IpDbGrid;
{$R *.DFM}

procedure TfrmIpGridAux.Memo1Change(Sender: TObject);
begin
     btnVolta.Visible := False;
     btnConf.Visible := True;
     btnCanc.Visible := True;
end;

procedure TfrmIpGridAux.btnVoltaClick(Sender: TObject);
begin
     frmIpGridAux.ModalResult := mrOk;
end;

procedure TfrmIpGridAux.btnCancClick(Sender: TObject);
begin
     frmIpGridAux.ModalResult := mrCancel;
end;

procedure TfrmIpGridAux.btnConfClick(Sender: TObject);
begin
     If Assigned(FDataSource) then
     begin
        FDataSource.DataSet.Edit;
        FBlobField.AsString := Memo1.Lines.Text;
     end else Raise( Exception.Create('DataSource no assigned! (IpGrid)') );
     frmIpGridAux.ModalResult := mrYes;
end;

procedure TfrmIpGridAux.FormActivate(Sender: TObject);
begin
     frmIpGridAux.Caption := FBlobCaption;
     Case FBlobField.DataType of
          ftMemo: begin
                       Memo1.Lines.Text := FBlobField.AsString;
                       Memo1.Visible := True;
                       Memo1.OnChange := Memo1Change;
                  end;
          ftGraphic: begin
                          if Assigned(FBlobField) and FBlobField.IsBlob then
                          begin
                               Image1.Picture.Assign(FBlobField);
                          end;
                          ScrollBox1.Visible := True;
                     end;
     end;
end;
end.
