{Hello all, here we have a simple implementation of a DbGrid that can
show bitmaps and memos directly in the grid, like InfoPoewr DbGrid. It
also includes a small editor (for the bitmap it's only a viewer). Well
it's free, but as usual I dont give ANY warranties about it, so if your
dog bites you - don't blame me!

Some important things:
Know problems (be nice it's a 0.01 version!)
1) Still have a flicker showing '(MEMO)' and '(GRAPHIC)'
2) Try this: Click in a memo field, close the editor and click again in
the same record, now TRY to get the editor back (works if you click other
record and then click in the old record - ie change the record)
3) Somewhat slow
4) Can't handle the edition in place.

Some advices...
1) After your Table.Open USE IpGrid.DefaultRowHeight := <a bigger number,
like 60 - the default is 17!>
2) Let the Grid in ReadOnly Mode
3) DON'T use titles (if you issued a DefaultRowHeight command!), but instead
use something like THeader ou a series or TButtons...

Well, that's it. Any thing you can reach me at brunoj@venus.rdc.puc-rio.br,
and in the end of this unit there's a small snippet of using the component.
BTW, sorry for my english but I'm a portuquese speaker!
}

unit IpDbGrid;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, DBCtrls, Db, StdCtrls, DbTables;

type
  TIpDbGrid = class(TCustomDbGrid)
  private
    { Private declarations }
    FEditFormCaption: String;
    procedure MyWriteText( Canvas: TCanvas; Text: TStringList; Limitation: TRect);
  protected
    procedure DrawColumnCell(const Rect: TRect; DataCol: Integer;
      Column: TColumn; State: TGridDrawState); override;
    { Protected declarations }
    { Public declarations }
    property Canvas;
    property SelectedRows;
    property ColWidths;
    constructor Create(AOwner: TComponent); override;
    procedure CellClick(Column: TColumn); override;
    destructor Destroy; override;
    property RowHeights;
  published
    { Published declarations }
    property OnCellClick;
    property Align;
    property BorderStyle;
    property Color;
    property Columns stored False; //StoreColumns;
    property Ctl3D;
    property DataSource;
    property DefaultDrawing;
    property DragCursor;
    property DragMode;
    property Enabled;
    property FixedColor;
    property Font;
    property ImeMode;
    property ImeName;
    property Options;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property TitleFont;
    property Visible;
    property OnColEnter;
    property OnColExit;
    property OnColumnMoved;
    property OnDrawDataCell;  { obsolete }
    property OnDrawColumnCell;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEditButtonClick;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnStartDrag;
    property OnTitleClick;
    property DefaultColWidth;
    property DefaultRowHeight;
    property EditFormCaption: String read FEditFormCaption write FEditFormCaption;
  end;

procedure Register;

implementation
uses IpGridAux;

procedure Register;
begin
  RegisterComponents('Samples', [TIpDbGrid]);
end;

procedure TIpDbGrid.CellClick(Column: TColumn);
begin
     If DataSource = nil then begin inherited CellClick(Column); exit; end;
     Case Column.Field.DataType of
        ftMemo, ftFmtMemo: begin
                                Application.CreateForm( TfrmIpGridAux, frmIpGridAux);
                                frmIpGridAux.BlobCaption := FEditFormCaption;
                                frmIpGridAux.BlobField := Column.Field;
                                frmIpGridAux.DataSource := DataSource;
                                frmIpGridAux.ShowModal;
                                frmIpGridAux.Free;
                           end;
        ftGraphic: begin
                                Application.CreateForm( TfrmIpGridAux, frmIpGridAux);
                                frmIpGridAux.BlobCaption := 'teste';
                                frmIpGridAux.BlobField := Column.Field;
                                frmIpGridAux.ShowModal;
                                frmIpGridAux.Free;
                   end;
        else inherited CellClick(Column);
     end;
end;

constructor TIpDbGrid.Create(AOwner: TComponent);
begin
  inherited Create( AOwner );
end;

destructor TIpDbGrid.Destroy;
begin
  inherited Destroy;
end;

{Here we identify what is to be shown (Memo or Grafic?) To handle other
kinds on blobs, like richtext, I don't see any alternatives but create a
more memory eater control like TRichText itself and copying it's canvas.
But I am open to new ideas!}
procedure TIpDbGrid.DrawColumnCell(const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var HiddenLines: TStringList;
    DrawPict: TPicture;
begin
  if Assigned(Column.Field) then
  begin
       Case Column.Field.DataType of
            ftMemo, ftFmtMemo: begin
                                  HiddenLines := TStringList.Create;
                                  HiddenLines.Text := Column.Field.AsString;
                                  MyWriteText( Canvas, HiddenLines, Rect);
                                  HiddenLines.Free;
                               end;
            ftGraphic: begin
                            Try
                                 DrawPict := TPicture.Create;
                                 if Assigned(Column.Field) and Column.Field.IsBlob then
                                 begin
                                      DrawPict.Assign(Column.Field);
                                 end;
                               Canvas.StretchDraw( Rect, DrawPict.Graphic {(HiddenBitmap as TGraphic)});
                            finally
                                   DrawPict.Free;
                            end;
                       end;
       else
            inherited DrawColumnCell( Rect, DataCol, Column, State);
       end;
  end;

end;

{Here we do the wrap text stuff, I've decided do my own, in order to not
waste memory creating one TMemo or like just to do this...
I've used the TFont with all defaults, but if someone decide to add some
properties to handle the memo's font - go ahead, it isn't hard}
procedure TIpDbGrid.MyWriteText( Canvas: TCanvas; Text: TStringList; Limitation: TRect);
var XOffSet, YOffset, FontHeight, TextWidth, CurrentLine, MaxWidth, MaxHeigth: Integer;
    OneWord, Line: String;
begin
     If Text.Text = '' then Exit;
     FontHeight := Canvas.TextHeight( Text.Text );
     XOffSet := 2 + Limitation.Left;
     YOffset := 2 + Limitation.Top;
     MaxWidth := Limitation.Right;
     MaxHeigth := Limitation.Bottom - FontHeight;
     CurrentLine := 0;
     Canvas.FillRect(Limitation);
     While (MaxHeigth - (YOffSet + 2)) > 0 do
     begin
            Line := Text.Strings[CurrentLine];
            While Line <> '' do
            begin
                 If Pos(#32, Line) > 0 then
                 begin
                    OneWord := Copy(Line, 1, Pos(#32, Line));
                    Delete( Line, 1, Pos(#32, Line));
                 end
                 else begin
                      OneWord := Line;
                      Line := '';
                 end;
                 TextWidth := Canvas.TextWidth(OneWord);
                 If MaxWidth - (TextWidth+XOffSet) > 0 then
                 begin
                    Canvas.TextOut( XOffSet, YOffSet, OneWord );
                    Inc( XOffSet, TextWidth);
                 end
                 else begin
                      XOffSet := 2 + Limitation.Left;
                      Inc( YOffset, FontHeight);
                      If (MaxHeigth - (YOffSet + 2)) < 0 then exit;
                 end;
            end;
            XOffSet := 2+ Limitation.Left;
            Inc( CurrentLine, 1 );
            Inc( YOffset, FontHeight);
            If CurrentLine > Text.Count then Exit;
     end;
end;

end.

{fragment of use: It uses one TTable, pointing to DbDemos and table name
is BioLife.db

(Here is the unit fragment)
procedure TForm1.FormCreate(Sender: TObject);
begin
     Table1.open;
     IpDbGrid1.DefaultRowHeight := 60;
end;

(Here is the form fragment - just copy/paste)
object IpDbGrid1: TIpDbGrid
  Left = 0
  Top = 0
  Width = 427
  Height = 273
  Align = alClient
  DataSource = DataSource1
  Options = [dgEditing, dgIndicator, dgColumnResize, dgColLines, dgRowLines, dgTabs, dgConfirmDelete, dgCancelOnExit]
  TabOrder = 0
  TitleFont.Charset = DEFAULT_CHARSET
  TitleFont.Color = clWindowText
  TitleFont.Height = -11
  TitleFont.Name = 'MS Sans Serif'
  TitleFont.Style = []
  DefaultRowHeight = 17
  Columns = <
    item
      FieldName = 'Common_Name'
    end
    item
      FieldName = 'Notes'
      Width = 200
    end
    item
      FieldName = 'Graphic'
      Width = 200
    end>
end

}
