unit uPlugMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, gifimage,jpeg;

type
  TKindPlugin=(kiText,kiImg,kiInit);
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Image1: TImage;
    BOk: TButton;
    BEdit: TButton;
    procedure FormShow(Sender: TObject);
    procedure BOkClick(Sender: TObject);
    procedure BEditClick(Sender: TObject);
  private
    FFileName,
    FCaption:string;
    FKind:TKindPlugin;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses
  registry;
{$R *.DFM}


procedure WReg(sec,key,str:string);
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    with Reg do begin
      RootKey := HKEY_CURRENT_USER;
      if OpenKey('\SOFTWARE\VV\iper\'+sec+'\', true) then begin
          WriteString(key,str);
          CloseKey;
      end;
    end;
  finally
    Reg.Free;
  end;
end;


//---------------
procedure TForm1.FormShow(Sender: TObject);
var
  l:integer;
  s:string;
begin
  FFilename:='';
  FCaption:='no text in input';
  Fkind:=kiText;
  for l:=1 to paramcount do begin
    s:=lowercase(paramstr(l));
    //msg(s);
    if s='/init' then begin
      //a way to init the reg keys.
      //You might prefer to do this in the plugin install
      //routine....
      //
      Fkind:=kiInit;
      //do reg k stuff
      //Save in reg that plugin does text effect "My Plugin Text 1"
      Wreg('PluginText\MyPluginText','EffectName','My Plugin Text 1');
      Wreg('PluginText\MyPluginText','EffectPath',application.exename);
      Wreg('PluginText\MyPluginText','EffectPars','/text');
      //Save in reg that plugin does img effect "My Plugin Image 1"
      Wreg('PluginImage\MyPluginImg','EffectName','My Plugin Image 1');
      Wreg('PluginImage\MyPluginImg','EffectPath',application.exename);
      Wreg('PluginImage\MyPluginImg','EffectPars','/img');
      break;
    end else
    if s='/text' then begin
      Fkind:=kiText;
    end else
    if s='/img' then begin
      Fkind:=kiImg;
    end else
    if pos('/',s)<>1 then begin
      FFilename:=s;
    end else
    if pos('/icaption',s)=1 then begin
      FCaption:=copy(paramstr(l),11,length(paramstr(l))-10);
      //in fact you need to parse and convert "" to "...
    end else
    ;
    //you need to extend to all font parameters....
    //this is only a sample
  end;
  if FKind=kiInit then close;
  //
  //
  case Fkind of
    kiText:begin
        image1.canvas.textout(0,0,fcaption);
    end;
    kiImg:begin
      if FFileName<>'' then begin
        image1.picture.loadFromFile(FFileName);
      end;
    end;
  end;
end;


//---------------
procedure TForm1.BOkClick(Sender: TObject);
var
  g:TGifImage;
  j:TJpegImage;
  s:string;
begin
  //save edited images...
  //You must do something better!
  if FFileName<>'' then begin
    s:=lowercase(extractFileExt(ffilename));
    if s='.gif' then begin
      g:=TGifImage.create;
      g.assign(image1.picture.graphic);
      g.saveToFile(FFileName);
    end else begin
      j:=TJpegImage.create;
      j.assign(image1.picture.graphic);
      j.saveToFile(FFileName);
    end;
  end;
  close;
end;


//---------------
procedure TForm1.BEditClick(Sender: TObject);
var
  bit,bit2:Tbitmap;
  pic:TPicture;
begin
  //this isn't a true editing, it's only a sample
  //You must do something better!
  case Fkind of
    kiText:begin
        bit:=Tbitmap.create;
        bit2:=Tbitmap.create;
        with bit do begin
          width:=100;
          height:=30;
        end;
        with bit.canvas do begin
          font.color:=clBlue;
          TextOut(0,0,FCaption);
          pen.width:=5;
          pen.color:=clRed;
          MoveTo(0,15);
          LineTo(25,15);
        end;
        bit2.assign(bit);
        image1.picture.assign(bit2);
    end;
    kiImg:begin
      if FFileName<>'' then begin
        pic:=TPicture.create;
        pic.loadFromFile(FFileName);
        bit:=Tbitmap.create;
        bit2:=Tbitmap.create;
        with bit do begin
          width:=pic.width;
          height:=pic.height;
        end;
        with bit.canvas do begin
          font.color:=clBlue;
          TextOut(0,0,'elaboro');
          pen.width:=5;
          pen.color:=clRed;
          MoveTo(0,15);
          LineTo(25,15);
        end;
        bit.canvas.draw(0,0,pic.Graphic);
        bit2.assign(bit);
        image1.picture.assign(bit2);
      end;
    end;
  end;
end;

end.
