unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Interprt;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Memo1: TMemo;
    Label2: TLabel;
    ListBox1: TListBox;
    edData: TEdit;
    Button2: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Inter: TInterpreter;
    lbFormulas: TListBox;
    Label5: TLabel;
    StaticText1: TStaticText;
    procedure Button1Click(Sender: TObject);
    procedure edDataChange(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ListBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure InterUnknownFunction(Sender: TObject; NameFunc: String;
      FormParam: TIntParams; var Equal: Double);
    procedure lbFormulasDblClick(Sender: TObject);
  private
    { Private declarations }
    procedure SkipValue;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation


{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  Edit1.Text := FloatToStr(Inter.Equal);
end;

procedure TForm1.edDataChange(Sender: TObject);
var
  I : Integer;
begin
   for  I := 0 to ListBox1.Items.Count - 1 do begin
     if (ListBox1.Selected[I]) then begin
       Inter.InterParams.ParamByName(ListBox1.Items[I]).Data :=
                 StrToFloat(edData.Text);
       Exit;
     end;
   end;
end;

procedure TForm1.SkipValue;
var
  I : Integer;
begin
  I := ListBox1.ItemIndex;
  edData.Text :=
        FloatToStr(Inter.InterParams.ParamByName(ListBox1.Items[I]).Data);
end;

procedure TForm1.ListBox1Click(Sender: TObject);
begin
  SkipValue;
end;

procedure TForm1.ListBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  SkipValue;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  I : Integer;
begin
  Inter.Formula := Memo1.Text;
  ListBox1.Items.Clear;
  for I := 0 to Inter.InterParams.Count - 1 do begin
    ListBox1.Items.Add(Inter.InterParams.Items[I].Name);
  end;
  if Inter.InterParams.Count > 0 then begin
    edData.Text :=
    FloatToStr(Inter.InterParams.ParamByName(ListBox1.Items[0]).Data);
    ListBox1.ItemIndex := 0;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  lbFormulas.Items.Add('(a+d)*4/a-(d+r)');
  lbFormulas.Items.Add('IIF((a+e)/2 > d; f+e; d)');
  lbFormulas.Items.Add('NewFunction(a,b,(d+c)*3)');
  lbFormulas.Items.Add('NewFunction(a,(d+c)*3)');
end;

procedure TForm1.InterUnknownFunction(Sender: TObject; NameFunc: String;
  FormParam: TIntParams; var Equal: Double);
begin
  if (NameFunc = 'NewFunction') then begin
    case FormParam.Count of
      2 : Equal := FormParam.ParamByName('X1').Data *
          FormParam.ParamByName('X2').Data;
      3 : Equal := FormParam[0].Data +
          FormParam[1].Data + FormParam[2].Data;
    end;
  end;
end;

procedure TForm1.lbFormulasDblClick(Sender: TObject);
begin
  Memo1.Text := lbFormulas.Items.Strings[lbFormulas.ItemIndex];
  if (lbFormulas.ItemIndex = 2) or (lbFormulas.ItemIndex = 3) then
    Application.MessageBox('This formula apply event OnUnknownFunction','Information',
      MB_OK + MB_ICONINFORMATION);
end;

end.
