unit info;
{-----------------------------------------------------------------------------}
{ TEPInfoExe v 1.2                                                            }
{ Copyright 1999, Eric Pedrazzi.  All Rights Reserved.                        }
{-----------------------------------------------------------------------------}
{                                                                             }
{ A component to get version information of an exe file                       }
{                                                                             }
{-----------------------------------------------------------------------------}
{                                                                             }
{ This component can be freely used and distributed in commercial and private }
{ environments, provied this notice is not modified in any way and there is   }
{ no charge for it other than nomial handling fees.  Contact me directly for  }
{ modifications to this agreement.                                            }
{                                                                             }
{-----------------------------------------------------------------------------}
{ Feel free to contact me if you have any questions, comments or suggestions  }
{ at epedrazzi@chez.com                                                       }
{ The latest version will always be available on the web at:                  }
{   http://www.chez.com/epedrazzi                                             }
{ See info.txt for notes, known issues, and revision history.                 }
{-----------------------------------------------------------------------------}
{ Date last modified:  April 1999                                             }
{-----------------------------------------------------------------------------}
{ v1.0 : Initial release                                                      }
{                                                                             }                                                                             
{-----------------------------------------------------------------------------}

{ Properties
  ----------
  LangId         :  write ==> set the LangId to 040C for French, 0409 for English US
  ExeName        :  write ==> set the application exename (path included)


  CompanyName       : read
  FileDescription   : read
  FileVersion       : read
  InternalName      : read
  LegalCopyright    : read
  LegalTradeMarks   : read
  OriginalFilename  : read
  ProductName       : read
  ProductVersion    : read
  Comments          : read

  Methods
  -------
  Execute : retrieve informations and set properties values

}

interface

uses SysUtils, Windows, Classes;


type
  TEPInfoExe = class(TComponent)
  private
    { Dclarations prives }
    FLangId           : string;
    FExeName          : string;
    FCompanyName      : string;
    FFileDescription  : string;
    FFileVersion      : string;
    FInternalName     : string;
    FLegalCopyright   : string;
    FLegalTradeMarks  : string;
    FOriginalFilename : string;
    FProductName      : string;
    FProductVersion   : string;
    FComments         : string;
  protected
    { Dclarations protges }

  public
    { Dclarations publiques }
    constructor Create(AOwner: TComponent); override;
    procedure Execute;

  published
    { Dclarations publies }
    property LangId : string read FLangId write FLangId;
    property ExeName : string read FExeName write FExeName;
    property CompanyName : string read FCompanyName;
    property FileDescription : string read FFileDescription;
    property FileVersion : string read FFileVersion;
    property InternalName : string read FInternalName;
    property LegalCopyright : string read FLegalCopyright;
    property LegalTradeMarks : string read FLegalTradeMarks;
    property OriginalFilename : string read FOriginalFilename;
    property ProductName : string read FProductName;
    property ProductVersion : string read FProductVersion;
    property Comments : string read FComments;
  end;

procedure Register;

implementation


procedure TEPInfoExe.Execute;
var
  loc_InfoBufSize : integer;
  loc_InfoBuf     : PChar;
  loc_VerBufSize  : integer;
  loc_VerBuf      : PChar;
begin
  loc_InfoBufSize := GetFileVersionInfoSize(PChar(FExeName),DWORD(loc_InfoBufSize));
  if loc_InfoBufSize > 0 then
  begin
    loc_InfoBuf := AllocMem(loc_InfoBufSize);
    GetFileVersionInfo(PChar(FExeName),0,loc_InfoBufSize,loc_InfoBuf);

    VerQueryValue(loc_InfoBuf,PChar('StringFileInfo\'+FLangId+'04E4\CompanyName'),Pointer(loc_VerBuf),DWORD(loc_VerBufSize));
    FCompanyName := loc_VerBuf;

    VerQueryValue(loc_InfoBuf,PChar('StringFileInfo\'+FLangId+'04E4\FileDescription'),Pointer(loc_VerBuf),DWORD(loc_VerBufSize));
    FFileDescription := loc_VerBuf;

    VerQueryValue(loc_InfoBuf,PChar('StringFileInfo\'+FLangId+'04E4\FileVersion'),Pointer(loc_VerBuf),DWORD(loc_VerBufSize));
    FFileVersion := loc_VerBuf;

    VerQueryValue(loc_InfoBuf,PChar('StringFileInfo\'+FLangId+'04E4\InternalName'),Pointer(loc_VerBuf),DWORD(loc_VerBufSize));
    FInternalName := loc_VerBuf;

    VerQueryValue(loc_InfoBuf,PChar('StringFileInfo\'+FLangId+'04E4\LegalCopyright'),Pointer(loc_VerBuf),DWORD(loc_VerBufSize));
    FLegalCopyright := loc_VerBuf;

    VerQueryValue(loc_InfoBuf,PChar('StringFileInfo\'+FLangId+'04E4\LegalTradeMarks'),Pointer(loc_VerBuf),DWORD(loc_VerBufSize));
    FLegalTradeMarks := loc_VerBuf;

    VerQueryValue(loc_InfoBuf,PChar('StringFileInfo\'+FLangId+'04E4\OriginalFilename'),Pointer(loc_VerBuf),DWORD(loc_VerBufSize));
    FOriginalFilename := loc_VerBuf;

    VerQueryValue(loc_InfoBuf,PChar('StringFileInfo\'+FLangId+'04E4\ProductName'),Pointer(loc_VerBuf),DWORD(loc_VerBufSize));
    FProductName := loc_VerBuf;

    VerQueryValue(loc_InfoBuf,PChar('StringFileInfo\'+FLangId+'04E4\ProductVersion'),Pointer(loc_VerBuf),DWORD(loc_VerBufSize));
    FProductVersion := loc_VerBuf;

    VerQueryValue(loc_InfoBuf,PChar('StringFileInfo\'+FLangId+'04E4\Comments'),Pointer(loc_VerBuf),DWORD(loc_VerBufSize));
    FComments := loc_VerBuf;

    FreeMem(loc_InfoBuf, loc_InfoBufSize);
  end;
end;

constructor TEPInfoExe.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FLangId           := '040C';
  FExeName          := '';
  FCompanyName      := '';
  FFileDescription  := '';
  FFileVersion      := '';
  FInternalName     := '';
  FLegalCopyright   := '';
  FLegalTradeMarks  := '';
  FOriginalFilename := '';
  FProductName      := '';
  FProductVersion   := '';
  FComments         := '';

end;

procedure Register;
begin
  RegisterComponents('Eric Pedrazzi', [TEPInfoExe]);
end;

end.
