unit uSrvcMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, SvcMgr, Dialogs,
  msRasCmp;

type
  TSrvcInetLogger = class(TService)
    agRAS: TmsRas;
    procedure ServiceExecute(Sender: TService);
    procedure ServiceDestroy(Sender: TObject);
    procedure ServiceCreate(Sender: TObject);
  private
    Path : string;
    ActiveConsStartHour : TStringList;
  public
    function GetServiceController: TServiceController; override;
    { Public declarations }
  end;

var
  SrvcInetLogger: TSrvcInetLogger;

implementation

{$R *.DFM}

uses
  Registry;

type
  TStartHour = class
    StartHour : TDateTime;
    constructor Create;
  end;

constructor TStartHour.Create;
begin
  inherited;
  StartHour := Now;
end;

procedure ServiceController(CtrlCode: DWord); stdcall;
begin
  SrvcInetLogger.Controller(CtrlCode);
end;

function TSrvcInetLogger.GetServiceController: TServiceController;
begin
  Result := ServiceController;
end;

procedure TSrvcInetLogger.ServiceExecute(Sender: TService);
var
  i, j, h : Integer;
  a, m, d : Word;
  Hs, ht : Double;
  FName : string;
  LogList : TStringList;
  EntryName : string;
begin
  repeat
    if Status = csRunning
      then
      begin
        try
          for i := 0 to agRas.ActiveConnections.Count - 1 do
            if ActiveConsStartHour.IndexOf (agRas.ActiveConnections [i]) < 0
              then ActiveConsStartHour.AddObject (agRas.ActiveConnections [i], TStartHour.Create);
          i := 0;
          while i < ActiveConsStartHour.Count do
            if agRas.ActiveConnections.IndexOf (ActiveConsStartHour [i]) < 0
              then
              begin
                ActiveConsStartHour.Objects [i].Free;
                ActiveConsStartHour.Delete (i);
              end
              else Inc (i);
        except
          { No se hace nada, es un error del pedido de estado RAS }
        end;
        if ActiveConsStartHour.Count > 0
          then
          begin
            DecodeDate (Now, a, m, d);
            FName := Format ('%sRAS Log %d-%d.txt', [Path, m, a]);
            LogList := TStringList.Create;
            try
              if FileExists (FName)
                then LogList.LoadFromFile (FName);
              for i := 0 to ActiveConsStartHour.Count - 1 do
                begin
                  ht := Now;
                  for h := 1 to 2 do
                    begin
                      case h of
                        1 : EntryName := ActiveConsStartHour [i] + ' Month Total';
                        2 : EntryName := ActiveConsStartHour [i] + ' ' + DateToStr (ht);
                      end;
                      j := LogList.IndexOfName (EntryName);
                      if j < 0
                        then LogList.Add (Format ('%s=0', [EntryName]));
                      Hs := StrToFloat (LogList.Values [EntryName]);
                      Hs := Hs + (ht - (ActiveConsStartHour.Objects [i] as TStartHour).StartHour) * 24;
                      LogList.Values [EntryName] := FloatToStrF (Hs, ffFixed, 15, 5);
                    end;
                  (ActiveConsStartHour.Objects [i] as TStartHour).StartHour := ht;
                end;
              LogList.Sort;
              LogList.SaveToFile (FName);
            finally
              LogList.Free;
            end;
          end;
      end;
    ServiceThread.ProcessRequests (false);
    sleep (2500);
  until Terminated or (Status = csStopPending);
end;

procedure TSrvcInetLogger.ServiceDestroy(Sender: TObject);
begin
  ActiveConsStartHour.Free;
  ActiveConsStartHour := nil;
end;

procedure TSrvcInetLogger.ServiceCreate(Sender: TObject);
var
  Reg : TRegistry;
begin
  ActiveConsStartHour := TStringList.Create;
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    Reg.OpenKey ('\SOFTWARE\ABA\InetLog\', false);
    try
      Path := Reg.ReadString ('Path');
    except
      Exit;
    end;
  finally
    Reg.Free;
  end;
end;


end.
