unit RasMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  msRasCmp, ComCtrls, StdCtrls;

type
  TRasForm = class(TForm)
    Label1: TLabel;
    ServiceComboBox: TComboBox;
    DialButton: TButton;
    HangupButton: TButton;
    StatusBar: TStatusBar;
    msRas1: TmsRas;
    procedure FormCreate(Sender: TObject);
    procedure DialButtonClick(Sender: TObject);
    procedure HangupButtonClick(Sender: TObject);
    procedure msRas1Disconnected(Sender: TObject);
    procedure msRas1StatusChange(Sender: TObject; RASStatusStr: String);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  RasForm: TRasForm;

implementation

{$R *.DFM}

procedure TRasForm.FormCreate(Sender: TObject);
begin
  ServiceComboBox.Items:=msRas1.Entries;
  if ServiceComboBox.Items.Count>0 then
    ServiceComboBox.ItemIndex:=0;
end;

procedure TRasForm.DialButtonClick(Sender: TObject);
begin
  if ServiceComboBox.Text<>'' then
  begin
    msRas1.Service:=ServiceComboBox.Text;
    msRas1.Dial;
  end
  else
    MessageDlg('Please specify the service',mtError,[mbOk],0);
end;

procedure TRasForm.HangupButtonClick(Sender: TObject);
begin
  msRas1.Hangup;
end;

procedure TRasForm.msRas1Disconnected(Sender: TObject);
begin
  StatusBar.SimpleText:='Disconnected';
end;

procedure TRasForm.msRas1StatusChange(Sender: TObject;
  RASStatusStr: String);
begin
  StatusBar.SimpleText:=RASStatusStr;
end;

end.
