unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Db, DBTables, ImageEn, DBImageEn, ExtCtrls, Grids, DBGrids,
  ComCtrls, Mask, DBCtrls, ImageEnView, ImageEnProc, ImageEnIO;

type
  TMainForm = class(TForm)
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Table1: TTable;
    DataSource1: TDataSource;
    New: TButton;
    Del: TButton;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    TrackBar1: TTrackBar;
    Zoom: TLabel;
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Button4: TButton;
    Label2: TLabel;
    ComboBox1: TComboBox;
    Bevel1: TBevel;
    OpenDialog1: TOpenDialog;
    Button5: TButton;
    Button6: TButton;
    ImageEnDBView1: TImageEnDBView;
    ImageEnProc1: TImageEnProc;
    ImageEnIO1: TImageEnIO;
    Button7: TButton;
    procedure DBImageEn1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DBImageEn1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure NewClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure DelClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Table1AfterScroll(DataSet: TDataSet);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
  private
    { Private declarations }
    x1,y1:integer;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

// begin selection
procedure TMainForm.DBImageEn1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	if Button=mbLeft then
   	// begin select
		x1:=x; y1:=y;
end;

// moving selection
procedure TMainForm.DBImageEn1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
	if ImageEnDBView1.MouseCapture then
   	ImageEnDBView1.Select(x1,y1,X,Y);
end;

// Import...
procedure TMainForm.Button2Click(Sender: TObject);
begin
	if OpenDialog1.Execute then
   	ImageEnIO1.LoadFromFile(OpenDialog1.filename);
end;

// Effects...
procedure TMainForm.Button3Click(Sender: TObject);
begin
	ImageEnProc1.DoPreviews(ppeEffects);
end;

// Color adjust...
procedure TMainForm.Button7Click(Sender: TObject);
begin
	ImageEnProc1.DoPreviews(ppeColorAdjust);
end;

// zoom
procedure TMainForm.TrackBar1Change(Sender: TObject);
begin
	ImageEnDBView1.Zoom:=TrackBar1.Position;
end;

// New
procedure TMainForm.NewClick(Sender: TObject);
begin
	Table1.Append;
end;

// Post
procedure TMainForm.Button1Click(Sender: TObject);
begin
	if Table1.State<>dsBrowse then
		Table1.Post;
end;

// Del/Cancel
procedure TMainForm.DelClick(Sender: TObject);
begin
	if (Table1.State=dsEdit) or (Table1.State=dsInsert) then
   	Table1.Cancel
   else
	   Table1.Delete;
end;

// Modify
procedure TMainForm.Button4Click(Sender: TObject);
begin
	Table1.Edit;
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
	Table1.DatabaseName:=ExtractFilePath(application.exename);
   Table1.Open;
end;

// change combobox - store format
procedure TMainForm.ComboBox1Change(Sender: TObject);
begin
	if ComboBox1.ItemIndex=0 then	// Jpeg?
		ImageEnDBView1.DataFieldImageFormat:=ifJpeg
   else if ComboBox1.ItemIndex=01 then // Bitmap?
		ImageEnDBView1.DataFieldImageFormat:=ifBitmap;
end;

// update combobox - store format
procedure TMainForm.Table1AfterScroll(DataSet: TDataSet);
begin
	case ImageEnDBView1.LoadedFieldImageFormat of
   	ifJpeg:
      	ComboBox1.ItemIndex:=0;
      ifBitmap:
	      ComboBox1.ItemIndex:=1;
   end;
end;

// Copy
procedure TMainForm.Button5Click(Sender: TObject);
begin
	ImageEnProc1.SelCopyToClip;
end;

// Paste
procedure TMainForm.Button6Click(Sender: TObject);
begin
	ImageEnProc1.PasteFromClipboard;
end;



end.
