unit Main;

// Copyright 1998 Fabrizio Di Vittorio
// fdivitto@caerenet.it
// fdivitto@usa.net
// via Lisbona 16 - 00055 Ladispoli (RM) - ITALY
// tel. 0347/6265066 (speak italian please)


// Install ImageEn.dcu into "Delph User's Components" package.

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls, ToolWin, ImageEnProc;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    OpenDialog: TOpenDialog;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    SpeedPanel: TPanel;
    OpenBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    CutBtn: TSpeedButton;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    StatusBar: TStatusBar;
    SpeedButton1: TSpeedButton;
    PastetoRect1: TMenuItem;
    PopupMenu1: TPopupMenu;
    Unselect1: TMenuItem;
    N3: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    PasteRect1: TMenuItem;
    Bevel1: TBevel;
    TrackBar1: TTrackBar;
    ComboBox1: TComboBox;
    Bevel2: TBevel;
    Label1: TLabel;
    Tools1: TMenuItem;
    Effects1: TMenuItem;
    SaveDialog1: TSaveDialog;
    NewanimtedGif1: TMenuItem;
    Background1: TMenuItem;
    SpeedButton2: TSpeedButton;
    N2: TMenuItem;
    Negative1: TMenuItem;
    Grayscale1: TMenuItem;
    Rotate1: TMenuItem;
    N5: TMenuItem;
    Horizontalflip1: TMenuItem;
    Verticalflip1: TMenuItem;
    N6: TMenuItem;
    Undo1: TMenuItem;
    Image1: TMenuItem;
    N4: TMenuItem;
    N7: TMenuItem;
    Resize1: TMenuItem;
    Resample1: TMenuItem;
    Clear1: TMenuItem;
    SpeedButton3: TSpeedButton;
    Panel1: TPanel;
    ProgressBar1: TProgressBar;
    Label2: TLabel;
    Merge1: TMenuItem;
    ColorAdjust1: TMenuItem;
    Histogram1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FileNewItemClick(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure FileSaveItemClick(Sender: TObject);
    procedure FileSaveAsItemClick(Sender: TObject);
    procedure CutItemClick(Sender: TObject);
    procedure CopyItemClick(Sender: TObject);
    procedure PasteItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
    procedure PastetoRect1Click(Sender: TObject);
    procedure Unselect1Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Effects1Click(Sender: TObject);
    procedure NewanimtedGif1Click(Sender: TObject);
    procedure Background1Click(Sender: TObject);
    procedure Negative1Click(Sender: TObject);
    procedure Grayscale1Click(Sender: TObject);
    procedure Rotate1Click(Sender: TObject);
    procedure Verticalflip1Click(Sender: TObject);
    procedure Horizontalflip1Click(Sender: TObject);
    procedure Undo1Click(Sender: TObject);
    procedure Resize1Click(Sender: TObject);
    procedure Resample1Click(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
    procedure Merge1Click(Sender: TObject);
    procedure ColorAdjust1Click(Sender: TObject);
    procedure Histogram1Click(Sender: TObject);
  private
    { Private declarations }
    procedure CreateMDIChild(const Name: string; n:boolean);
    procedure CreateMDIChildAG(const Name: string; n:boolean);	// Create/load animated Gif
    procedure ShowHint(Sender: TObject);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses ChildWin, About, Unit1, Unit2, ImageEn, ChildWinAGif, ColorSel, Rotate,
  Unit3, MergeDialog, Histogram;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.FileNewItemClick(Sender: TObject);
begin
  CreateMDIChild('New' + IntToStr(MDIChildCount + 1)+'.jpg',true);
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.NewanimtedGif1Click(Sender: TObject);
begin
  CreateMDIChildAG('NewAni' + IntToStr(MDIChildCount + 1)+'.gif',true);
end;

////////////////////////////////////////////////////////////////////////////////////
// Open
procedure TMainForm.FileOpenItemClick(Sender: TObject);
begin
  if OpenDialog.Execute then
    CreateMDIChild(OpenDialog.FileName,false);
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.FileCloseItemClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
    ActiveMDIChild.Close;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
  Close;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.CutItemClick(Sender: TObject);
var
  Child: TMDIChild;
begin
  {cut selection to clipboard}
  Child := ActiveMDIChild as TMDIChild;
  if Child.ImageEn1.Selected then
		Child.ImageEn1.SelCutToClip		// cut selected area
  else begin
  		Child.ImageEn1.CopyToClipboard;	// copy all
      Child.ImageEn1.Clear;
  end;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.CopyItemClick(Sender: TObject);
var
  Child: TMDIChild;
begin
  {copy selection to clipboard}
  Child := ActiveMDIChild as TMDIChild;
  if Child.ImageEn1.Selected then
		Child.ImageEn1.SelCopyToClip		// copy selected area
  else
  		Child.ImageEn1.CopyToClipboard;	// copy all
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.PasteItemClick(Sender: TObject);
var
  Child: TMDIChild;
begin
  {paste from clipboard}
  Child := ActiveMDIChild as TMDIChild;
  if Child.ImageEn1.Selected then
  		Child.ImageEn1.PointPasteFromClip(Child.x1,Child.y1)	// paste to left,top of selection
  else
  		Child.ImageEn1.PasteFromClipboard;			// paste all
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.UpdateMenuItems(Sender: TObject);
var
  Child: TMDIChild;
begin
  Child := ActiveMDIChild as TMDIChild;
  //
  FileCloseItem.Enabled := MDIChildCount > 0;
  FileSaveItem.Enabled := MDIChildCount > 0;
  FileSaveAsItem.Enabled := MDIChildCount > 0;
  CutItem.Enabled := MDIChildCount > 0;
  CopyItem.Enabled := MDIChildCount > 0;
  PasteItem.Enabled := MDIChildCount > 0;
  PastetoRect1.Enabled := MDIChildCount > 0;
  SaveBtn.Enabled := MDIChildCount > 0;
  CutBtn.Enabled := MDIChildCount > 0;
  CopyBtn.Enabled := MDIChildCount > 0;
  PasteBtn.Enabled := MDIChildCount > 0;
  WindowCascadeItem.Enabled := MDIChildCount > 0;
  WindowTileItem.Enabled := MDIChildCount > 0;
  WindowArrangeItem.Enabled := MDIChildCount > 0;
  WindowMinimizeItem.Enabled := MDIChildCount > 0;
  ComboBox1.Enabled:=MDIChildCount > 0;
  TrackBar1.Enabled:=MDIChildCount > 0;
  Effects1.enabled:= MDIChildCount > 0;
  Background1.enabled:= MDIChildCount > 0;
  SpeedButton2.enabled:= MDIChildCount > 0;
  Negative1.enabled:= MDIChildCount > 0;
  Grayscale1.enabled:= MDIChildCount > 0;
  Rotate1.enabled:= MDIChildCount > 0;
  verticalflip1.enabled:= MDIChildCount > 0;
  horizontalflip1.enabled:= MDIChildCount > 0;
  undo1.enabled:= MDIChildCount > 0;
  resize1.enabled:= MDIChildCount > 0;
  resample1.enabled:= MDIChildCount > 0;
  clear1.enabled:= MDIChildCount > 0;
  SpeedButton3.enabled:= MDIChildCount > 0;
  Merge1.enabled:= MDIChildCount > 0;
  //
  if MDIChildCount > 0 then begin
	  ComboBox1.Text:=inttostr(Child.ImageEn1.Zoom);
     trackbar1.position:=Child.ImageEn1.Zoom;
  end;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.HelpAboutItemClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.PastetoRect1Click(Sender: TObject);
var
  Child: TMDIChild;
begin
  {paste from clipboard to rect}
  Child := ActiveMDIChild as TMDIChild;
  if Child.ImageEn1.Selected then
  		Child.ImageEn1.SelPasteFromClipStretch;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.Unselect1Click(Sender: TObject);
var
  Child: TMDIChild;
begin
  Child := ActiveMDIChild as TMDIChild;
  Child.ImageEn1.DeSelect;
end;

////////////////////////////////////////////////////////////////////////////////////
// Zoom
procedure TMainForm.TrackBar1Change(Sender: TObject);
var
  Child: TMDIChild;
begin
	Child := ActiveMDIChild as TMDIChild;
   Child.ImageEn1.Zoom:=trackbar1.Position;
   ComboBox1.Text:=inttostr(Child.ImageEn1.Zoom);
end;

////////////////////////////////////////////////////////////////////////////////////
// Zoom
procedure TMainForm.ComboBox1Change(Sender: TObject);
var
  Child: TMDIChild;
begin
	Child := ActiveMDIChild as TMDIChild;
	if ComboBox1.text='Fit' then begin
   	Child.ImageEn1.Fit;
      trackbar1.position:=Child.imageEn1.zoom;
   end else begin
      trackbar1.position:=strtointdef(ComboBox1.Text,100);
      Child.ImageEn1.Zoom:=trackbar1.Position;
   end;
end;

////////////////////////////////////////////////////////////////////////////////////
// Effects
procedure TMainForm.Effects1Click(Sender: TObject);
var
  Child: TMDIChild;
begin
	Child := ActiveMDIChild as TMDIChild;
	Child.ImageEn1.DoPreviews(ppeEffects);
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.FileSaveAsItemClick(Sender: TObject);
var
  Child: TMDIChild;
begin
  { save current file under new name }
  Child := ActiveMDIChild as TMDIChild;
  SaveDialog1.Filename:=Child.Caption;
  if SaveDialog1.Execute then begin
  		if (Child is TMDIChildAG) and (lowercase(ExtractFileExt(SaveDialog1.FileName))<>'.gif') then
         MessageDlg('Error! This is a GIF animation.',mtError,[mbOK],0)
      else begin
	  		Child.Caption:=SaveDialog1.FileName;
	      FileSaveItemClick(self);
      end;
  end;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMainForm.FileSaveItemClick(Sender: TObject);
var
  Child: TMDIChild;
  ex:string;
begin
  { save current file (ActiveMDIChild points to the window) }
  Child := ActiveMDIChild as TMDIChild;
  ex:=lowercase(ExtractFileExt(Child.Caption));
  if (ex='.jpg') or (ex='.jpeg') then begin
  		// jpeg
      fJpegSave.TrackBar1.Position:=30;
      if fJpegSave.ShowModal=mrOK then begin
      	Child.ImageEn1.SaveToFileJpeg(Child.Caption,fJpegSave.TrackBar1.Position);
         Child.Changed:=false;
      end;
  end else if (ex='.pcx') or (ex='.bmp') then begin
		// pcx,bmp
      Child.ImageEn1.SaveToFile(Child.Caption);
      Child.Changed:=false;
  end else if (ex='.gif') then begin
  		if Child is TMDIChildAG then begin
      	// Animated gif
         (Child as TMDIChildAG).Save;
         Child.Changed:=false;
      end else begin
	  		// normal gif
	      fGifSave.checkbox3.enabled:=fileexists(Child.Caption);
	      if fGifSave.ShowModal=mrOK then begin
				if fGifSave.checkbox3.checked then begin
	         	// Insert/overwrite image of animated gif (make animate)
	            if fGifSave.CheckBox4.Checked then
	            	Child.ImageEn1.DeleteGifIm(Child.Caption,strtointdef(fGifSave.edit1.text,0));
	            Child.ImageEn1.InsertToGif(Child.Caption,fGifSave.checkbox1.checked,
	            			strtointdef(fGifSave.edit1.text,0),strtointdef(fGifSave.edit2.text,0),
	                     fGifSave.checkbox2.checked,strtointdef(fGifSave.edit3.text,0),
	                     strtointdef(fGifSave.edit4.text,0),-1,-1);
	         end else begin
	         	// Save new non-animated gif
					Child.ImageEn1.SaveToFileGif(Child.Caption,fGifSave.checkbox1.checked,
	            			strtointdef(fGifSave.edit2.text,0),fGifSave.checkbox2.checked,
	                     strtointdef(fGifSave.edit3.text,0),strtointdef(fGifSave.edit4.text,0));
	         end;
            Child.Changed:=false;
         end;
      end;
  end;
end;

////////////////////////////////////////////////////////////////////////////////////
// Create/Load image
// n=true : new image (not load)
procedure TMainForm.CreateMDIChild(const Name: string; n:boolean);
var
  Child: TMDIChild;
begin
  { create a new MDI child window }
  if (not n) and (lowercase(ExtractFileExt(Name))='.gif') and fileexists(Name) and
  	  (timageen.CheckAniGif(Name) or (timageen.EnumGifIm(Name)>1)) then begin
     		// Animated Gif
     		CreateMDIChildAG(Name,false)
  end else begin
	  Child := TMDIChild.Create(Application);
	  Child.Caption := Name;
	  if (not n) and FileExists(Name) then begin
		  Child.ImageEn1.LoadFromFile(Name);
        if Child.WindowState=wsNormal then begin
		     Child.ClientWidth:=Child.ImageEn1.IdealComponentWidth;
		     Child.ClientHeight:=Child.ImageEn1.IdealComponentHeight;
		     if Child.width>ClientWidth then
					Child.Width:=ClientWidth;
		     if Child.Height>ClientHeight-SpeedPanel.height-StatusBar.height-15 then
		     		Child.Height:=ClientHeight-SpeedPanel.height-StatusBar.height-15;
        end;
	  end else
     		Child.ImageEn1.Resize(300,300);
     Child.Changed:=false;
  end;
end;

////////////////////////////////////////////////////////////////////////////////////
// Create/Load Gif animation
// n=true : new image (not load)
procedure TMainForm.CreateMDIChildAG(const Name: string; n:boolean);
var
  Child: TMDIChildAG;
  h,w:integer;
begin
  { create a new MDI child window }
  Child := TMDIChildAG.Create(Application);
  Child.Caption := Name;
  if (not n) and FileExists(Name) then begin
     Child.ScrollBar1.max:=timageen.EnumGifIm(Name)-1;
     Child.Load;
     Child.ScrollBar1Change(self);
     if Child.WindowState=wsNormal then begin
	     w:=Child.ImageEn1.IdealComponentWidth+Child.Panel1.Width+Child.ScrollBox1.Width;
	     h:=Child.ImageEn1.IdealComponentHeight;
	     if h<Child.Panel1.Height then
	     		h:=Child.Panel1.Height;
	     Child.ClientWidth:=w;
	     Child.ClientHeight:=h;
	     if Child.width>ClientWidth then
				Child.Width:=ClientWidth;
		     if Child.Height>ClientHeight-SpeedPanel.height-StatusBar.height-15 then
		     		Child.Height:=ClientHeight-SpeedPanel.height-StatusBar.height-15;
     end;
  end;
  Child.Changed:=false;
end;

////////////////////////////////////////////////////////////////////////////////////
// Select background
procedure TMainForm.Background1Click(Sender: TObject);
var
  Child: TMDIChild;
begin
	Child := ActiveMDIChild as TMDIChild;
   if Child is TMDIChildAG then
   	(Child as TMDIChildAG).ChangeBackground
   else begin
	   fColorSel.HSVBox1.SetColor(Child.imageen1.background);
	   fColorSel.HSVBox1Change(self);
		if fColorSel.ShowModal=mrOK then
			Child.imageen1.Background:=fColorSel.HSVBox1.color;
   end;
end;

////////////////////////////////////////////////////////////////////////////////////
// Negative
procedure TMainForm.Negative1Click(Sender: TObject);
begin
	(ActiveMDIChild as TMDIChild).ImageEn1.Negative;
   ProgressBar1.Position:=0;
end;

////////////////////////////////////////////////////////////////////////////////////
// Gray scale
procedure TMainForm.Grayscale1Click(Sender: TObject);
begin
	(ActiveMDIChild as TMDIChild).ImageEn1.ConvertToGray;
   ProgressBar1.Position:=0;
end;

////////////////////////////////////////////////////////////////////////////////////
// Rotate
procedure TMainForm.Rotate1Click(Sender: TObject);
begin
	with (ActiveMDIChild as TMDIChild) do begin
		fRotate.ImageEn1.Assign(ImageEn1);
      fRotate.ImageEn1.Resample( fRotate.ImageEn1.width, -1);
      fRotate.ImageEn1.Fit;
		if fRotate.ShowModal=mrOK then
			ImageEn1.Rotate( fRotate.updown1.position, fRotate.checkbox1.checked );
   end;
   ProgressBar1.Position:=0;
end;

////////////////////////////////////////////////////////////////////////////////////
// vertical flip
procedure TMainForm.Verticalflip1Click(Sender: TObject);
begin
	(ActiveMDIChild as TMDIChild).ImageEn1.Flip(fdVertical);
end;

////////////////////////////////////////////////////////////////////////////////////
// horizontal flip
procedure TMainForm.Horizontalflip1Click(Sender: TObject);
begin
	(ActiveMDIChild as TMDIChild).ImageEn1.Flip(fdHorizontal);
end;

////////////////////////////////////////////////////////////////////////////////////
// Undo
procedure TMainForm.Undo1Click(Sender: TObject);
begin
	(ActiveMDIChild as TMDIChild).ImageEn1.Undo;
end;

////////////////////////////////////////////////////////////////////////////////////
// Resize
procedure TMainForm.Resize1Click(Sender: TObject);
var
  Child: TMDIChild;
  w,h:integer;
begin
	Child := ActiveMDIChild as TMDIChild;
	fResize.OrgWidth:=Child.ImageEn1.Bitmap.Width;
	fResize.OrgHeight:=Child.ImageEn1.Bitmap.Height;
   fResize.caption:='Resize';
	if fresize.ShowModal=mrOK then begin
   	w:= strtointdef( fResize.edit1.text, 0 );
      h:= strtointdef( fResize.edit2.text, 0 );
      if (w>0) and (h>0) then
	   	Child.ImageEn1.Resize(w,h);
   end;
end;

////////////////////////////////////////////////////////////////////////////////////
// Resample
procedure TMainForm.Resample1Click(Sender: TObject);
var
  Child: TMDIChild;
  w,h:integer;
begin
	Child := ActiveMDIChild as TMDIChild;
	fResize.OrgWidth:=Child.ImageEn1.Bitmap.Width;
	fResize.OrgHeight:=Child.ImageEn1.Bitmap.Height;
   fResize.caption:='Resample';
	if fresize.ShowModal=mrOK then begin
   	w:= strtointdef( fResize.edit1.text, 0 );
      h:= strtointdef( fResize.edit2.text, 0 );
      if (w>0) and (h>0) then
	   	Child.ImageEn1.Resample(w,h);
   end;
end;

////////////////////////////////////////////////////////////////////////////////////
// Clear
procedure TMainForm.Clear1Click(Sender: TObject);
begin
	(ActiveMDIChild as TMDIChild).ImageEn1.Clear;
end;

////////////////////////////////////////////////////////////////////////////////////
// Merge
procedure TMainForm.Merge1Click(Sender: TObject);
begin
	if fMergeDialog.ShowModal=mrOK then
		if fMergeDialog.ListBox1.ItemIndex>=0 then begin
			(ActiveMDIChild as TMDIChild).ImageEn1.Merge((MDIChildren[fMergeDialog.ListBox1.ItemIndex] as TMDIChild).ImageEn1.Bitmap,
               100-fMergeDialog.TrackBar1.Position
         		);
	   end;
   ProgressBar1.Position:=0;
end;

////////////////////////////////////////////////////////////////////////////////////
// Color adjust...
procedure TMainForm.ColorAdjust1Click(Sender: TObject);
var
  Child: TMDIChild;
begin
	Child := ActiveMDIChild as TMDIChild;
	Child.ImageEn1.DoPreviews(ppeColorAdjust);
end;

////////////////////////////////////////////////////////////////////////////////////
// Histogram
procedure TMainForm.Histogram1Click(Sender: TObject);
var
  Child: TMDIChild;
begin
	Child := ActiveMDIChild as TMDIChild;
	fHistogram.ImageEnProc1.AttachedImageEn:=Child.ImageEn1;
   fHistogram.HistogramBox1.Update;
	fHistogram.ShowModal;
end;

end.
