unit ChildWinAGif;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CHILDWIN, ImageEn, ExtCtrls, StdCtrls, ComCtrls, ImageEnProc, ImageEnView, ImageEnIO,
  RulerBox;

type
  TMDIChildAG = class(TMDIChild)
    Panel1: TPanel;
    Label1: TLabel;
    ScrollBar1: TScrollBar;
    Label2: TLabel;
    Label3: TLabel;
    Edit2: TEdit;
    UpDown2: TUpDown;
    Label4: TLabel;
    Edit3: TEdit;
    Label5: TLabel;
    Edit4: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Panel2: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label6: TLabel;
    Label7: TLabel;
    Edit1: TEdit;
    Edit5: TEdit;
    ScrollBox1: TScrollBox;
    procedure ScrollBar1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ImageEn1ImageChange(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    GifInfoList:TList;
    DontChange:boolean;
    procedure ImClick(Sender:TObject);
    procedure EditTOGifInfo;
    procedure GifInfoTOEdit;
  public
    { Public declarations }
    procedure Load;
    procedure Save;
    procedure ChangeBackGround;
  end;

var
  MDIChildAG: TMDIChildAG;

implementation

uses ColorSel, Main;

{$R *.DFM}

////////////////////////////////////////////////////////////////////////////////////
// Current GifInfo to Edits
procedure TMDIChildAG.GifInfoTOEdit;
var
	GifInfo:pGifInfo;
begin
  if GifInfoList.count>0 then begin
	  DontChange:=true;
	  Label2.caption:=inttostr(ScrollBar1.Position);
	  GifInfo:=pGifInfo(GifInfoList[ScrollBar1.Position]);
	  edit2.text:=inttostr( GifInfo^.DelayTime );
	  edit3.text:=inttostr( GifInfo^.PosX );
	  edit4.text:=inttostr( GifInfo^.PosY );
	  checkbox1.checked:= GifInfo^.Interlaced;
	  checkbox2.checked:= GifInfo^.FlagTranspColor;
	  edit1.text:=inttostr( GifInfo^.Width );
	  edit5.text:=inttostr( GifInfo^.Height );
	  DontChange:=false;
  end;
end;

////////////////////////////////////////////////////////////////////////////////////
// Current GifInfo to Edits
procedure TMDIChildAG.EditTOGifInfo;
var
	GifInfo:pGifInfo;
begin
	if GifInfoList.count>0 then begin
		GifInfo:=pGifInfo(GifInfoList[ScrollBar1.Position]);
	   GifInfo^.DelayTime:=strtointdef(edit2.text,0);
	   GifInfo^.PosX:=strtointdef(edit3.text,0);
	   GifInfo^.PosY:=strtointdef(edit4.text,0);
	   GifInfo^.Interlaced:=checkbox1.checked;
	   GifInfo^.FlagTranspColor:=checkbox2.checked;
   end;
end;

////////////////////////////////////////////////////////////////////////////////////
// Image list - imageen1
procedure TMDIChildAG.ScrollBar1Change(Sender: TObject);
var
   SourceImage:TImageEn;
begin
  inherited;
  GifInfoTOEdit;
  DontChange:=true;
  SourceImage:=TImageEn(ScrollBox1.Controls[ScrollBar1.Position]);
  imageen1.assign( SourceImage );
  DontChange:=false;
  MainForm.ComboBox1Change(self);	// Adjust zoom
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMDIChildAG.Load;
var
	q,numim,t,w:integer;
   GifInfo:pGifInfo;
   GlobGifInfo:TGlobGifInfo;
begin
  // free pred images
  for q:=0 to ScrollBox1.ControlCount-1 do
  		ScrollBox1.controls[q].free;
  for q:=0 to GifInfoList.count-1 do
  		dispose(GifInfoList[q]);
  GifInfoList.Clear;
  // images in scrollbox1
  numim:=timageen.EnumGifIm(Caption);
  scrollbox1.vertscrollbar.range:=scrollbox1.height-3;
  t:=0;
  w:=ScrollBox1.ClientWidth;
  for q:=0 to numim-1 do begin
  		with TImageEn.Create(ScrollBox1) do begin
         hide;
      	Left:=0;
         Top:=t;
			Width:=w;
         Height:=w;
         Tag:=q;
         OnClick:=ImClick;
      	Parent:=ScrollBox1;
         new(GifInfo);
         LoadFromFileGif(self.caption,q,GifInfo^,GlobGifInfo);
         GifInfoList.Add(GifInfo);
         Fit;
         Height:=IdealComponentHeight;
         inc(t,Height+1);
         show;
      end;
  end;
  if t>scrollbox1.vertscrollbar.range then
	  scrollbox1.vertscrollbar.range:=t;
  ScrollBar1.max:=numim-1;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMDIChildAG.ImClick(Sender:TObject);
begin
	scrollbar1.Position:=(Sender as TImageEn).Tag;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMDIChildAG.FormCreate(Sender: TObject);
begin
  inherited;
  GifInfoList:=TList.Create;
  DontChange:=false;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMDIChildAG.FormClose(Sender: TObject; var Action: TCloseAction);
var
	q:integer;
begin
  inherited;
  for q:=0 to GifInfoList.count-1 do
  		dispose(GifInfoList[q]);
  GifInfoList.free;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMDIChildAG.Save;
var
	SourceImage:TImageEn;
   q:integer;
begin
	for q:=0 to scrollbox1.ControlCount-1 do begin
   	SourceImage:=scrollbox1.Controls[q] as TImageEn;
      with pGifInfo(GifInfolist[q])^ do
	      if q=0 then
           	SourceImage.SaveToFileGif(Caption,Interlaced,DelayTime,FlagTranspColor,PosX,PosY)
			else
         	SourceImage.InsertToGif(Caption,Interlaced,q,DelayTime,FlagTranspColor,PosX,PosY,-1,-1);
   end;
end;

////////////////////////////////////////////////////////////////////////////////////
// Copy ImageEn1 -->> Active image
procedure TMDIChildAG.ImageEn1ImageChange(Sender: TObject);
var
	DestImage:TImageEn;
   GifInfo:pGifInfo;
begin
  inherited;
  if not DontChange then begin
	  DestImage:=TImageEn(ScrollBox1.Controls[ScrollBar1.Position]);
	  DestImage.Assign(ImageEn1);
     DestImage.Fit;
     GifInfo:=pGifInfo(GifInfoList[ScrollBar1.Position]);
     GifInfo^.Width:=DestImage.Bitmap.Width;
     GifInfo^.Height:=DestImage.bitmap.Height;
     GifInfo^.TranspColor:=TCOLOR2TRGB(DestImage.background);
     GifInfoTOEdit;
  end;
end;

////////////////////////////////////////////////////////////////////////////////////
// Change controls
procedure TMDIChildAG.Edit2Change(Sender: TObject);
begin
  inherited;
  if not DontChange then
	  EditTOGifInfo;
end;

////////////////////////////////////////////////////////////////////////////////////
// Delete
procedure TMDIChildAG.Button2Click(Sender: TObject);
var
	t,w,q:integer;
   max,numim,todel:integer;
   lp:integer;
begin
  inherited;
  if scrollbox1.ControlCount>1 then begin
	  todel:=scrollbar1.Position;
     lp:=scrollbox1.VertScrollBar.Position;
     scrollbox1.VertScrollBar.Position:=0;
	  t:=(scrollbox1.Controls[todel] as TImageEn).Top;
	  scrollbox1.Controls[todel].free;
	  numim:=scrollbox1.ControlCount;
	  scrollbox1.vertscrollbar.range:=scrollbox1.height-3;
	  scrollbar1.max:=numim-1;
	  w:=ScrollBox1.ClientWidth;
     // move up
	  for q:=todel to scrollbox1.ControlCount-1 do
	  		with (ScrollBox1.Controls[q] as TImageEn) do begin
	         Top:=t;
	         Tag:=q;
	         inc(t,Height+1);
	      end;
	  dispose(GifInfoList[todel]);
	  GifInfoList.Delete(todel);
	  if t>scrollbox1.vertscrollbar.range then
		  scrollbox1.vertscrollbar.range:=t;
     scrollbox1.VertScrollBar.Position:=lp;
  end else
     imageen1.clear;
  ScrollBar1Change(self);
end;

////////////////////////////////////////////////////////////////////////////////////
// Insert blank
procedure TMDIChildAG.Button1Click(Sender: TObject);
var
	GifInfo:pGifInfo;
 	t,w,q,lp:integer;
   max,numim,toadd:integer;
	ls:TList;
begin
  inherited;
  toadd:=ScrollBar1.Position;
  numim:=scrollbox1.ControlCount;
  lp:=scrollbox1.VertScrollBar.Position;
  scrollbox1.VertScrollBar.Position:=0;
  // Create GifInfo
  new(GifInfo);
  GifInfo^:=pGifInfo(GifInfoList[toadd])^;
  GifInfoList.Insert(toadd,GifInfo);
  //
  t:=(scrollbox1.Controls[toadd] as TImageEn).Top;
  // get list of created controls
  ls:=TList.Create;
  for q:=toadd to numim-1 do begin
  		ls.add(ScrollBox1.Controls[toadd]);  // add to ls
      ScrollBox1.RemoveControl(ScrollBox1.Controls[toadd]);	// remove from ScrollBox1
  end;
  // Add new blank image to ScrollBox1
  inc(numim);
  scrollbox1.vertscrollbar.range:=scrollbox1.height-3;
  scrollbar1.max:=numim-1;
  w:=ScrollBox1.ClientWidth;
  with TImageEn.Create(ScrollBox1) do begin
     	Left:=0;
      Top:=t;
   	Width:=w;
      Height:=w;
      Tag:=toadd;
      OnClick:=ImClick;
     	Parent:=ScrollBox1;
      dontchange:=true;
      resize(pGifInfo(GifInfoList[toadd])^.width,pGifInfo(GifInfoList[toadd])^.Height);
      background:=TRGB2TCOLOR(pGifInfo(GifInfoList[toadd])^.TranspColor);
      dontchange:=false;
      clear;
      Fit;
      Height:=IdealComponentHeight;
      inc(t,Height+1);
  end;
  // Add other images
  for q:=0 to ls.count-1 do begin
  		scrollbox1.InsertControl( TControl(ls[q]) );
      with (scrollbox1.controls[toadd+q+1] as TImageEn) do begin
      	Top:=t;
			Tag:=toadd+q+1;
			Parent:=ScrollBox1;
      	inc(t,Height+1);
      end;
  end;
  if t>scrollbox1.vertscrollbar.range then
	  scrollbox1.vertscrollbar.range:=t;
  scrollbox1.VertScrollBar.Position:=lp;
  ScrollBar1.max:=numim-1;
  ScrollBar1Change(self);
  //
  ls.free;
end;

////////////////////////////////////////////////////////////////////////////////////
// Append blank
procedure TMDIChildAG.Button3Click(Sender: TObject);
var
	t,w,q,lp:integer;
   numim:integer;
   GifInfo:pGifInfo;
begin
  inherited;
  numim:=scrollbox1.ControlCount;
  lp:=scrollbox1.VertScrollBar.Position;
  scrollbox1.VertScrollBar.Position:=0;
  scrollbox1.vertscrollbar.range:=scrollbox1.height-3;
  //
  new(GifInfo);
  if numim>0 then begin
	  GifInfo^:=pGifInfo(GifInfoList[numim-1])^;	// copy last GifInfo
	  with (scrollbox1.Controls[numim-1] as TImageEn) do
		  t:=Top+Height+1;
  end else begin
  	  // Create blank GifInfo
     GifInfo^.PosX:=0;
     GifInfo^.PosY:=0;
     GifInfo^.Width:=50;
     GifInfo^.Height:=50;
     Gifinfo^.DelayTime:=65;
     GifInfo^.FlagTranspColor:=true;
     GifInfo^.TranspColor:=TColor2TRGB(clBlack);
     GifInfo^.Interlaced:=true;
     t:=0;
  end;
  GifInfoList.Add(GifInfo);
  //
  w:=ScrollBox1.ClientWidth;
  with TImageEn.Create(ScrollBox1) do begin
     	Left:=0;
      Top:=t;
   	Width:=w;
      Height:=w;
      Tag:=numim;
      OnClick:=ImClick;
    	Parent:=ScrollBox1;
      dontchange:=true;
      if numim>0 then begin
	      resize(pGifInfo(GifInfoList[numim-1])^.width,pGifInfo(GifInfoList[numim-1])^.Height);
	      background:=TRGB2TCOLOR(pGifInfo(GifInfoList[numim-1])^.TranspColor);
      end else begin
      	resize(pGifInfo(GifInfoList[numim])^.width,pGifInfo(GifInfoList[numim])^.Height);
         background:=TRGB2TCOLOR(pGifInfo(GifInfoList[numim])^.TranspColor);
      end;
      dontchange:=false;
      clear;
      Fit;
      Height:=IdealComponentHeight;
      inc(t,Height+1);
  end;
  if t>scrollbox1.vertscrollbar.range then
	  scrollbox1.vertscrollbar.range:=t;
  scrollbox1.VertScrollBar.Position:=lp;
  ScrollBar1.max:=numim;
  ScrollBar1.position:=numim;
  ScrollBar1Change(self);
end;

////////////////////////////////////////////////////////////////////////////////////
// Activate
procedure TMDIChildAG.FormActivate(Sender: TObject);
begin
  inherited;
  if scrollbox1.ControlCount=0 then
  		// create new blank image
      Button3Click(self);	// append blank
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMDIChildAG.ChangeBackGround;
var
  lback:TRGB;
begin
   lback:=TCOLOR2TRGB(imageen1.background);
   fColorSel.HSVBox1.SetColor(imageen1.background);
   fColorSel.HSVBox1Change(self);
	if fColorSel.ShowModal=mrOK then begin
		imageen1.Background:=fColorSel.HSVBox1.color;
      imageen1.CastColorRange(lback,lback,TCOLOR2TRGB(imageen1.background));
   end;
end;

end.
