unit Childwin;

interface

uses Windows, Classes, Graphics, Forms, Controls, ImageEn, Menus,
  ImageEnView, RulerBox, ExtCtrls;

type
  TMDIChild = class(TForm)
    ImageEn1: TImageEn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ImageEn1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImageEn1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ImageEn1ImageChange(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ImageEn1Progress(Sender: TObject; per: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    x1,y1:integer;	// begin select
    Changed:boolean;
  end;

implementation

uses Main, Dialogs;

{$R *.DFM}

////////////////////////////////////////////////////////////////////////////////////
procedure TMDIChild.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action:=caFree;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMDIChild.ImageEn1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	if Button=mbLeft then begin
   	// begin select
		x1:=x; y1:=y;
   end;
end;

////////////////////////////////////////////////////////////////////////////////////
// move select
procedure TMDIChild.ImageEn1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
	if ImageEn1.MouseCapture then
   	ImageEn1.Select(x1,y1,x,y);
end;

////////////////////////////////////////////////////////////////////////////////////
// Imaged changed
procedure TMDIChild.ImageEn1ImageChange(Sender: TObject);
begin
	Changed:=true;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMDIChild.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose:=true;
  if Changed then
	  case MessageDlg('Save Changes to '+Caption+'?',mtConfirmation,[mbYes,mbNo,mbCancel],0) of
	  		mrYes:
	      	MainForm.FileSaveItemClick(self);
	      mrCancel:
	      	CanClose:=false;
	  end;
end;

////////////////////////////////////////////////////////////////////////////////////
procedure TMDIChild.ImageEn1Progress(Sender: TObject; per: Integer);
begin
	MainForm.ProgressBar1.Position:=per;
end;

end.
