unit umain;

// 1998 - by Fabrizio Di Vittorio
// email: fdivitto@caerenet.it
// tel. 0347/6562077   -  06/9948218
// via Lisbona 16
// 00055 Ladispoli (Roma) Italy

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtDlgs, ComCtrls, ToolWin, ImageEn, ExtCtrls, Menus, StdCtrls;

type
  TForm1 = class(TForm)
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ImageList1: TImageList;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    OpenPictureDialog1: TOpenPictureDialog;
    SavePictureDialog1: TSavePictureDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Apri1: TMenuItem;
    Apri2: TMenuItem;
    Salva1: TMenuItem;
    N1: TMenuItem;
    Esci1: TMenuItem;
    TrackBar1: TTrackBar;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    Panel2: TPanel;
    ImageEn1: TImageEn;
    ComboBox1: TComboBox;
    Label1: TLabel;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    Modifica1: TMenuItem;
    Annulla1: TMenuItem;
    N2: TMenuItem;
    Copia1: TMenuItem;
    Taglia1: TMenuItem;
    Incolla1: TMenuItem;
    Incollanellaselezione1: TMenuItem;
    Effetti1: TMenuItem;
    Ribaltaorizzontale1: TMenuItem;
    Ribaltaverticale1: TMenuItem;
    Ruota1: TMenuItem;
    N3: TMenuItem;
    Scaladigrigi1: TMenuItem;
    Negativo1: TMenuItem;
    N4: TMenuItem;
    Contrasto1: TMenuItem;
    HueSaturationLightness1: TMenuItem;
    ComponentiRGB1: TMenuItem;
    PopupMenu1: TPopupMenu;
    Copia2: TMenuItem;
    Taglia2: TMenuItem;
    Incolla2: TMenuItem;
    Incollaselezione1: TMenuItem;
    N5: TMenuItem;
    Annulla2: TMenuItem;
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure ImageEn1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImageEn1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Esci1Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure ToolButton7Click(Sender: TObject);
    procedure ToolButton8Click(Sender: TObject);
    procedure ToolButton9Click(Sender: TObject);
    procedure ToolButton10Click(Sender: TObject);
    procedure Ribaltaorizzontale1Click(Sender: TObject);
    procedure Ribaltaverticale1Click(Sender: TObject);
    procedure Ruota1Click(Sender: TObject);
    procedure Scaladigrigi1Click(Sender: TObject);
    procedure Negativo1Click(Sender: TObject);
    procedure Contrasto1Click(Sender: TObject);
    procedure HueSaturationLightness1Click(Sender: TObject);
    procedure ComponentiRGB1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    x1,y1:integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// Apri
procedure TForm1.ToolButton3Click(Sender: TObject);
begin
	if OpenPictureDialog1.Execute then
   	ImageEn1.LoadFromFile(OpenPictureDialog1.FileName);
end;

// Salva
procedure TForm1.ToolButton2Click(Sender: TObject);
begin
	if SavePictureDialog1.Execute then
   	ImageEn1.SaveToFile(SavePictureDialog1.FileName);
end;

// Nuovo
procedure TForm1.ToolButton1Click(Sender: TObject);
begin
	ImageEn1.Clear;
end;

// Click mouse (inizia selezione)
procedure TForm1.ImageEn1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
	x1:=x; y1:=y;  
end;

// movimento mouse (varia selezione)
procedure TForm1.ImageEn1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
   if ImageEn1.MouseCapture then 
   	ImageEn1.Select(x1,y1,x,y);
end;

// Esci
procedure TForm1.Esci1Click(Sender: TObject);
begin
	close;
end;

// Zoom (trackbar)
procedure TForm1.TrackBar1Change(Sender: TObject);
begin
   ImageEn1.Zoom:=trackbar1.Position;
   ComboBox1.Text:=inttostr(ImageEn1.Zoom)+'%';
end;

// Zoom (combobox1)
procedure TForm1.ComboBox1Change(Sender: TObject);
begin
	if ComboBox1.ItemIndex=0 then
   	ImageEn1.Fit
   else begin
      trackbar1.position:=strtointdef(ComboBox1.Text,100);
      ImageEn1.Zoom:=trackbar1.Position;
   end;
end;

// Copia
procedure TForm1.ToolButton6Click(Sender: TObject);
begin
	ImageEn1.SelCopyToClip;
end;

// Taglia
procedure TForm1.ToolButton7Click(Sender: TObject);
begin
	ImageEn1.SelCutToClip;
end;

// Incolla
procedure TForm1.ToolButton8Click(Sender: TObject);
begin
	ImageEn1.PointPasteFromClip(x1,y1);
end;

// Incolla nel rettangolo
procedure TForm1.ToolButton9Click(Sender: TObject);
begin
	ImageEn1.SelPasteFromClipStretch;
end;

// Annulla (undo)
procedure TForm1.ToolButton10Click(Sender: TObject);
begin
	ImageEn1.Undo;
end;

// Ribalta in orizzontale
procedure TForm1.Ribaltaorizzontale1Click(Sender: TObject);
begin
	ImageEn1.Flip(fdHorizontal);
end;

// Ribalta in verticale
procedure TForm1.Ribaltaverticale1Click(Sender: TObject);
begin
	ImageEn1.Flip(fdVertical);
end;

// Ruota
procedure TForm1.Ruota1Click(Sender: TObject);
var
	gg:string;
begin
	InputQuery('Ruota','Gradi rotazione:',gg);
   ImageEn1.Rotate(strtointdef(gg,0),false);
end;

// Converte in scala di grigi
procedure TForm1.Scaladigrigi1Click(Sender: TObject);
begin
	ImageEn1.ConvertToGray;
end;

// Negativo
procedure TForm1.Negativo1Click(Sender: TObject);
begin
	ImageEn1.Negative;
end;

// Contrasto
procedure TForm1.Contrasto1Click(Sender: TObject);
var
	vv:integer;
begin
	if ImageEn1.DoPreviewContrast(vv) then
	   ImageEn1.Contrast(vv);
end;

// HSL
procedure TForm1.HueSaturationLightness1Click(Sender: TObject);
var
	Hue, Sat, Lum:integer;
begin
	if ImageEn1.DoPreviewHSLvar(Hue,Sat,Lum) then
	   ImageEn1.HSLvar(Hue,Sat,Lum);
end;

// RGB
procedure TForm1.ComponentiRGB1Click(Sender: TObject);
var
	r,g,b:integer;
begin
	if ImageEn1.DoPreviewIntensityRGB(r,g,b) then
	   ImageEn1.IntensityRGBall(r,g,b);
end;

end.
