unit PreviewIntensityRGB;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImageEn, ExtCtrls, StdCtrls, ComCtrls;

type
  TfPreviewIntensityRGB = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    Button2: TButton;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    TrackBar1: TTrackBar;
    Edit1: TEdit;
    TrackBar2: TTrackBar;
    Edit2: TEdit;
    TrackBar3: TTrackBar;
    Edit3: TEdit;
    Panel1: TPanel;
    ImageEn1: TImageEn;
    Panel2: TPanel;
    ImageEn2: TImageEn;
    GroupBox2: TGroupBox;
    TrackBar4: TTrackBar;
    Button4: TButton;
    procedure Button4Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure TrackBar4Change(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    r,g,b:integer;
  end;

var
  fPreviewIntensityRGB: TfPreviewIntensityRGB;

implementation

{$R *.DFM}

procedure TfPreviewIntensityRGB.Button4Click(Sender: TObject);
begin
	imageen2.ClearUndo;
	imageen2.Bitmap.width:=imageen2.width;
   imageen2.bitmap.height:=imageen2.height;
	imageen2.bitmap.canvas.copyrect(
   			rect(0,0,imageen2.width-1,imageen2.height-1), imageen1.GetCanvas,
            rect(0,0,imageen2.width-1,imageen2.height-1));
	imageen2.IntensityRGBall(r,g,b);
end;

procedure TfPreviewIntensityRGB.Edit1Change(Sender: TObject);
var
	rr,gg,bb:integer;
begin
	rr:=strtointdef(edit1.text,0);
	gg:=strtointdef(edit2.text,0);
   bb:=strtointdef(edit3.text,0);
   if (r<>rr) or (g<>gg) or (b<>bb) then begin
		trackbar1.position:=rr;
      trackbar2.position:=gg;
      trackbar3.position:=bb;
      edit2change(self);
   end;
end;

procedure TfPreviewIntensityRGB.Edit2Change(Sender: TObject);
begin
   if (r<>trackbar1.position) or (g<>trackbar2.position) or (b<>trackbar3.position) then begin
      r:=trackbar1.position; g:=trackbar2.position; b:=trackbar3.position;
		edit1.text:=inttostr(r);
		edit2.text:=inttostr(g);
	   edit3.text:=inttostr(b);
		imageen2.undo;
		imageen2.IntensityRGBall(r,g,b);
      imageen2.paint;
   end;
end;

procedure TfPreviewIntensityRGB.TrackBar4Change(Sender: TObject);
begin
   imageen1.Zoom:=trackbar4.Position;
   GroupBox2.caption:=' Zoom '+inttostr(imageen1.zoom)+'% ';
end;

procedure TfPreviewIntensityRGB.FormActivate(Sender: TObject);
begin
	trackbar1.Position:=r;
	trackbar2.Position:=g;
   trackbar3.Position:=b;
	application.processmessages;
	Button4Click(self);
end;

end.
