unit PreviewContrast;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImageEn, ExtCtrls, StdCtrls, ComCtrls;

type
  TfPreviewContrast = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    Button2: TButton;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    TrackBar1: TTrackBar;
    Edit1: TEdit;
    Panel1: TPanel;
    ImageEn1: TImageEn;
    Panel2: TPanel;
    ImageEn2: TImageEn;
    GroupBox2: TGroupBox;
    TrackBar4: TTrackBar;
    Button4: TButton;
    procedure TrackBar4Change(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    mm:integer;		// media contrast
  public
    { Public declarations }
    vv:integer;
  end;

var
  fPreviewContrast: TfPreviewContrast;

implementation

{$R *.DFM}


/////////////////////////////////////////////////////////////////////////////////////
// Zoom
procedure TfPreviewContrast.TrackBar4Change(Sender: TObject);
begin
   imageen1.Zoom:=trackbar4.Position;
   GroupBox2.caption:=' Zoom '+inttostr(imageen1.zoom)+'% ';
end;

/////////////////////////////////////////////////////////////////////////////////////
// Change per trackbar
procedure TfPreviewContrast.TrackBar1Change(Sender: TObject);
begin
	if vv<>trackbar1.position then begin
   	vv:=trackbar1.position;
      edit1.text:=inttostr(vv);
		imageen2.undo;
		imageen2._Contrast(imageen2.bitmap,vv,mm);
      imageen2.paint;
   end;
end;

/////////////////////////////////////////////////////////////////////////////////////
// Change per edit
procedure TfPreviewContrast.Edit1Change(Sender: TObject);
var
	v:integer;
begin
	v:=strtointdef(edit1.text,0);
   if (v<>vv) then begin
		trackbar1.position:=v;
      trackbar1change(self);
   end;
end;

/////////////////////////////////////////////////////////////////////////////////////
// Copia zona originale in elaborata
procedure TfPreviewContrast.Button4Click(Sender: TObject);
begin
	imageen2.ClearUndo;
	imageen2.Bitmap.width:=imageen2.width;
   imageen2.bitmap.height:=imageen2.height;
	imageen2.bitmap.canvas.copyrect(
   			rect(0,0,imageen2.width-1,imageen2.height-1), imageen1.GetCanvas,
            rect(0,0,imageen2.width-1,imageen2.height-1));
   imageen2.SaveUndo;
	imageen2._Contrast(imageen2.bitmap,vv,mm);
   imageen2.Update;
end;

procedure TfPreviewContrast.FormActivate(Sender: TObject);
begin
	mm:=imageen1._getmediacontrast(imageen1.Bitmap);
 	trackbar1.Position:=vv;
  	application.processmessages;
	Button4Click(self);
end;

end.
