unit PreviewHSL;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImageEn, ExtCtrls, StdCtrls, ComCtrls;

type
  TfPreviewHSL = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    Button2: TButton;
    GroupBox1: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    TrackBar1: TTrackBar;
    Edit1: TEdit;
    TrackBar2: TTrackBar;
    Edit2: TEdit;
    TrackBar3: TTrackBar;
    Edit3: TEdit;
    Panel1: TPanel;
    ImageEn1: TImageEn;
    Panel2: TPanel;
    ImageEn2: TImageEn;
    GroupBox2: TGroupBox;
    TrackBar4: TTrackBar;
    Button4: TButton;
    procedure TrackBar4Change(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Hue,Sat,Lum:integer;
  end;

var
  fPreviewHSL: TfPreviewHSL;

implementation

{$R *.DFM}



/////////////////////////////////////////////////////////////////////////////////////
// Zoom
procedure TfPreviewHSL.TrackBar4Change(Sender: TObject);
begin
   imageen1.Zoom:=trackbar4.Position;
   GroupBox2.caption:=' Zoom '+inttostr(imageen1.zoom)+'% ';
end;

/////////////////////////////////////////////////////////////////////////////////////
// Copia zona originale in elaborata
procedure TfPreviewHSL.Button4Click(Sender: TObject);
begin
	imageen2.ClearUndo;
	imageen2.Bitmap.width:=imageen2.width;
   imageen2.bitmap.height:=imageen2.height;
	imageen2.bitmap.canvas.copyrect(
   			rect(0,0,imageen2.width-1,imageen2.height-1), imageen1.GetCanvas,
            rect(0,0,imageen2.width-1,imageen2.height-1));
	imageen2.HSLvar(Hue,Sat,Lum);
end;

procedure TfPreviewHSL.FormCreate(Sender: TObject);
begin

end;

/////////////////////////////////////////////////////////////////////////////////////
// Change per trackbar
procedure TfPreviewHSL.Edit2Change(Sender: TObject);
begin
   if (Hue<>trackbar1.position) or (Sat<>trackbar2.position) or (Lum<>trackbar3.position) then begin
      Hue:=trackbar1.position; Sat:=trackbar2.position; Lum:=trackbar3.position;
		edit1.text:=inttostr(Hue);
		edit2.text:=inttostr(Sat);
	   edit3.text:=inttostr(Lum);
		imageen2.undo;
		imageen2.HSLvar(Hue,Sat,Lum);
      imageen2.paint;
   end;
end;

/////////////////////////////////////////////////////////////////////////////////////
// Change per edit
procedure TfPreviewHSL.Edit1Change(Sender: TObject);
var
	h,s,l:integer;
begin
	h:=strtointdef(edit1.text,0);
	s:=strtointdef(edit2.text,0);
   l:=strtointdef(edit3.text,0);
   if (Hue<>h) or (Sat<>s) or (Lum<>l) then begin
		trackbar1.position:=h;
      trackbar2.position:=s;
      trackbar3.position:=l;
      edit2change(self);
   end;
end;

/////////////////////////////////////////////////////////////////////////////////////
procedure TfPreviewHSL.FormActivate(Sender: TObject);
begin
	trackbar1.Position:=Hue;
	trackbar2.Position:=Sat;
   trackbar3.Position:=Lum;
	application.processmessages;
	Button4Click(self);
end;

end.
