/* this file was written by: Sergio Freue <freue@ccurq.uba.ar> */
unit ID3;

interface

{$A+} { Honor packed }
{$Z1} { Byte storage for small enumerated types }
type
  ID3Genre = (
    id3gBlues, id3gClassicRock, id3gCountry, id3gDance, id3gDisco,
    id3gFunk, id3gGrunge, id3gHipHop, id3gJazz, id3gMetal, id3gNewAge,
    id3gOldies, id3gOther, id3gPop, id3gRNB, id3gRap, id3gReggae,
    id3gRock, id3gTechno, id3gIndustrial, id3gAlternative, id3gSka,
    id3gDeathMetal, id3gPranks, id3gSoundtrack, id3gEuroTechno,
    id3gAmbient, id3gTripHop, id3gVocal, id3gJazzFunk, id3gFusion,
    id3gTrance, id3gClassical, id3gInstrumental, id3gAcid, id3gHouse,
    id3gGame, id3gSoundClip, id3gGospel, id3gNoise, id3gAlternRock,
    id3gBass, id3gSoul, id3gPunk, id3gSpace, id3gMeditative,
    id3gInstrumentalPop, id3gInstrumentalRock, id3gEthnic, id3gGothic,
    id3gDarkwave, id3gTechnoIndustrial, id3gElectronic, id3gPopFolk,
    id3gEurodance, id3gDream, id3gSouthernRock, id3gComedy, id3gCult,
    id3gGangsta, id3gTop40, id3gChristianRap, id3gPopFunk, id3gJungle,
    id3gNativeAmerican, id3gCabaret, id3gNewWave, id3gPsychadelic,
    id3gRave, id3gShowtunes, id3gTrailer, id3gLoFi, id3gTribal,
    id3gAcidPunk, id3gAcidJazz, id3gPolka, id3gRetro, id3gMusical,
    id3gRockNRoll, id3gHardRock, id3gFolk, id3gFolkRock,
    id3gNationalFolk, id3gSwing, id3gFastFusion, id3gBebob, id3gLatin,
    id3gRevival, id3gCeltic, id3gBluegrass, id3gAvantgarde,
    id3gGothicRock, id3gProgressiveRock, id3gPsychedelicRock,
    id3gSymphonicRock, id3gSlowRock, id3gBigBand, id3gChorus,
    id3gEasyListening, id3gAcoustic, id3gHumour, id3gSpeech,
    id3gChanson, id3gOpera, id3gChamberMusic, id3gSonata, id3gSymphony,
    id3gBootyBass, id3gPrimus, id3gPornGroove, id3gSatire, id3gSlowJam,
    id3gClub, id3gTango, id3gSamba, id3gFolklore, id3gBallad,
    id3gPowerBallad, id3gRhythmicSoul, id3gFreestyle, id3gDuet,
    id3gPunkRock, id3gDrumSolo, id3gAcapella, id3gEuroHouse,
    id3gDanceHall
  );

  ID3Struct = packed record
    Magic:   Array [0..2 ] of Char;
    Title:   Array [0..29] of Char;
    Artist:  Array [0..29] of Char;
    Album:   Array [0..29] of Char;
    Year:    Array [0..3 ] of Char;
    Comment: Array [0..29] of Char;
    Genre:   ID3Genre;
  end;

const
  ID3Magic = 'TAG';
  ID3OffsetFromEnd = 128;
  ID3UnknowGenre = ID3Genre(255);
  ID3GenreName: Array [ID3Genre] of PChar = (
    'Blues', 'Classic Rock', 'Country', 'Dance', 'Disco', 'Funk', 'Grunge',
    'Hip-Hop', 'Jazz', 'Metal', 'New Age', 'Oldies', 'Other', 'Pop', 'R&B',
    'Rap', 'Reggae', 'Rock', 'Techno', 'Industrial', 'Alternative', 'Ska',
    'Death Metal', 'Pranks', 'Soundtrack', 'Euro-Techno', 'Ambient',
    'Trip-Hop', 'Vocal', 'Jazz+Funk', 'Fusion', 'Trance', 'Classical',
    'Instrumental', 'Acid', 'House', 'Game', 'Sound Clip', 'Gospel',
    'Noise', 'AlternRock', 'Bass', 'Soul', 'Punk', 'Space', 'Meditative',
    'Instrumental Pop', 'Instrumental Rock', 'Ethnic', 'Gothic',
    'Darkwave', 'Techno-Industrial', 'Electronic', 'Pop-Folk',
    'Eurodance', 'Dream', 'Southern Rock', 'Comedy', 'Cult', 'Gangsta',
    'Top 40', 'Christian Rap', 'Pop/Funk', 'Jungle', 'Native American',
    'Cabaret', 'New Wave', 'Psychadelic', 'Rave', 'Showtunes', 'Trailer',
    'Lo-Fi', 'Tribal', 'Acid Punk', 'Acid Jazz', 'Polka', 'Retro',
    'Musical', 'Rock & Roll', 'Hard Rock', 'Folk', 'Folk-Rock',
    'National Folk', 'Swing', 'Fast Fusion', 'Bebob', 'Latin', 'Revival',
    'Celtic', 'Bluegrass', 'Avantgarde', 'Gothic Rock', 'Progressive Rock',
    'Psychedelic Rock', 'Symphonic Rock', 'Slow Rock', 'Big Band',
    'Chorus', 'Easy Listening', 'Acoustic', 'Humour', 'Speech', 'Chanson',
    'Opera', 'Chamber Music', 'Sonata', 'Symphony', 'Booty Bass', 'Primus',
    'Porn Groove', 'Satire', 'Slow Jam', 'Club', 'Tango', 'Samba',
    'Folklore', 'Ballad', 'Power Ballad', 'Rhythmic Soul', 'Freestyle',
    'Duet', 'Punk Rock', 'Drum Solo', 'Acapella', 'Euro-House', 'Dance Hall'
  );

implementation

end.
