{ Copyright (C) 1998 BPG, Tivo Leedjrv               }
{ Autori e-mail: toivo@kuusalu.edu.ee                  }
{ All rights reserved. Kik igused reserveeritud.     }
{ Koodi ei tohi mitte mingil kujul ilma autori loata   }
{ kasutada ei kommertslikel ega ka muudel eesmrkidel. }
{                                                      }
{ THyperLink - Hperlinkide komponent                  }
{                                                      }
{                                                      }
{ Version Kuup.     Kirj.                              }
{ 0.1.1   6.05.98   Esimene versioon. Ttab kah isegi }
{                   Nitab HREFi StatusBaril ja puha.  }
{ 0.2.2   5.06.98   Fixed a nasty bug...pressing Enter }
{                   while THyperLink had focus did nth }
unit HyperLink;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, ComCtrls;

const BPGcopyr : string = '(C) 1998 Tivo Leedjrv, BPG';
//8bit international
//const BPGcopyr : string = '(C) 1998 Toivo Leedjrv, BPG';
//7bit international
//const BPGcopyr : string = '(C) 1998 Toivo Leedjarv, BPG';

type
  THyperLink = class(TCustomStaticText)
  private
    FAutoSize, FActive : Boolean;
    FHREF : String;
    FOld : String;
    FCopyr, FDummy : String;
    FNotPressedColor : TColor;
    FPressedColor : TColor;
    FDown : boolean;
    FCursor, FStatusNr : integer;
    FStatusBar : TStatusBar;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure CMFocusChanged(var Message: TCMFocusChanged); message CM_FOCUSCHANGED;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure SetNotPressedColor(NewColor : TColor);
    procedure AdjustBounds;
//    procedure SetAutoSize(Value: Boolean);
  protected
    procedure Loaded; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure DoEnter; override;
    procedure DoExit; override;
    procedure KeyPress(var Key: Char); override;
    procedure SetHLinkStyle(AActive : boolean);
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Author : string read FCopyr write FDummy;
    property Height default 14;
    property Width default 55;
//    property AutoSize: Boolean read FAutoSize write SetAutoSize default True;
    property BorderStyle;
    property Caption;
    property Color default clSilver;
    property PressedColor : TColor read FPressedColor write FPressedColor default clRed;
    property Enabled;
    property Font;
    property HREF : String read FHREF write FHREF;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property StatusBar : TStatusBar read FStatusBar write FStatusBar;
    property StatusPanelNo : integer read FStatusNr write FStatusNr;
    property TabOrder;
    property TabStop default True;
    property NotPressedColor : TColor read FNotPressedColor write SetNotPressedColor default clBlue;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragOver;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

uses ShellApi;

{$R cursor.res}

procedure Register;
begin
  RegisterComponents('BPG', [THyperLink]);
end;

constructor THyperLink.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ShowAccelChar:= false;
  Width:= 55;
  Height:= 14;
  FCopyr:= BPGcopyr;
  FAutoSize:= True;
  FActive:= False;
  FCursor:= crHandPoint;
  FDown:= false;
  FNotPressedColor:= clBlue;
  FPressedColor:= clRed;
  Color:= clSilver;
  Font.Color:= FNotPressedColor;
  Font.Style:= Font.Style + [fsUnderline];
  TabStop:= true;
  Screen.Cursors[FCursor]:= LoadCursor(hInstance, 'NETSCCUR');
  Cursor:= FCursor;
  AdjustBounds;
end;

procedure THyperLink.CMFontChanged(var Message: TMessage);
begin
  inherited;
  if (Font.Color <> FNotPressedColor) and (not FDown)then NotPressedColor:= Font.Color;
  AdjustBounds;
end;

procedure THyperLink.CMTextChanged(var Message: TMessage);
begin
  inherited;
  AdjustBounds;
end;

procedure THyperLink.CMFocusChanged(var Message: TCMFocusChanged);
begin
{  with Message do
    if Sender is THyperLink then
      FActive := Sender = Self
    else
      FActive := False;
  SetHLinkStyle(FActive); }
  inherited;
end;

procedure THyperLink.WMPaint(var Message: TWMPaint);
var h : HWND;
    hari : HBRUSH;
begin
  inherited;
  h:= Handle;
  if Focused then
  begin
    hari:= CreateSolidBrush(Color);
    FrameRect(GetDeviceContext(h), GetClientRect, hari);
    DrawFocusRect(GetDeviceContext(h), GetClientRect);
  end else
  begin
    hari:= CreateSolidBrush(Color);
    FrameRect(GetDeviceContext(h), GetClientRect, hari);
  end;
end;

procedure THyperLink.SetNotPressedColor(NewColor : TColor);
begin
  FNotPressedColor:= NewColor;
  if not FDown then Font.Color:= NewColor;
end;

procedure THyperLink.AdjustBounds;
var
  DC: HDC;
  SaveFont: HFont;
  TextSize: TSize;
begin
  if not (csReading in ComponentState) and FAutoSize then
  begin
    DC:= GetDC(0);
    SaveFont:= SelectObject(DC, Font.Handle);
    GetTextExtentPoint32(DC, PChar(Caption), Length(Caption), TextSize);
    if Font.Name <> 'MS Sans Serif' then
      if (fsItalic in Font.Style){ and (fsBold in Font.Style)} then
        GetTextExtentPoint32(DC, PChar(Caption + ','), Length(Caption) + 1, TextSize);
    SelectObject(DC, SaveFont);
    ReleaseDC(0, DC);
    if BorderStyle <> sbsNone then
      SetBounds(Left, Top,
        TextSize.cx + (GetSystemMetrics(SM_CXBORDER) * 4),
        TextSize.cy + (GetSystemMetrics(SM_CYBORDER) * 4))
    else
      SetBounds(Left, Top,
        TextSize.cx + (GetSystemMetrics(SM_CXBORDER) * 1),
        TextSize.cy + (GetSystemMetrics(SM_CYBORDER) * 1));
  end;
end;

{procedure THyperLink.SetAutoSize(Value: Boolean);
begin
  if FAutoSize <> Value then
  begin
    FAutoSize := Value;
    if Value then AdjustBounds;
  end;
end; }

procedure THyperLink.Loaded;
begin
  inherited Loaded;
  AdjustBounds;
end;

procedure THyperLink.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
  if Button = mbLeft then
  begin
    FDown:= true;
    Font.Color:= FPressedColor;
  end;
  inherited;
end;

procedure THyperLink.MouseUp(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
  FDown:= false;
  Font.Color:= FNotPressedColor;
  inherited;
  Refresh;
  Application.ProcessMessages;
  if (X in [0..Width]) and (Y in [0..Height]) then
    if (FHREF <> '') and (Button = mbLeft) then
      ShellExecute($80, 'open', PChar(FHREF), '', '', SW_SHOWDEFAULT);
end;

procedure THyperLink.MouseMove(Shift: TShiftState; X, Y: Integer);
var s : string;
begin
  inherited;
  if (FStatusBar <> nil) and ((X <= Width) and (Y <= Height)) then
  begin
    s:= FStatusBar.Panels[FStatusNr].Text;
    FStatusBar.Panels[FStatusNr].Text:= FHREF;
  end;
  if (ssLeft in Shift) or (ssMiddle in Shift) then
    if not ((X in [0..Width]) and (Y in [0..Height])) then
    begin
      if FActive <> false then
      begin
        FActive:= false;
        SetHLinkStyle(FActive);
      end;
    end else
      if FActive <> true then
      begin
        FActive:= true;
        SetHLinkStyle(FActive);
      end;
end;

procedure THyperLink.DoEnter;
begin
  if FStatusBar <> nil then
  begin
    FOld:= FStatusBar.Panels[FStatusNr].Text;
    FStatusBar.Panels[FStatusNr].Text:= FHREF;
  end;
  Perform(WM_PAINT, 0, 0);
  inherited;
end;

procedure THyperLink.DoExit;
begin
  if FStatusBar <> nil then
    if FStatusBar.Panels[FStatusNr].Text = FHREF then
      FStatusBar.Panels[FStatusNr].Text:= FOld;
  Perform(WM_PAINT, 0, 0);
  inherited;
end;

procedure THyperLink.KeyPress(var Key: Char);
begin
  inherited;
  if Key = #13 then
  begin
    MouseUp(mbLeft, [], 1, 1);
  end;
end;

procedure THyperLink.SetHLinkStyle(AActive : boolean);
begin
  case AActive of
    True : begin
             FDown:= true;
             Font.Color:= FPressedColor;
           end;
    False : begin
              FDown:= false;
              Font.Color:= FNotPressedColor;
            end;
  end;
  Perform(WM_PAINT, 0, 0);
end;

end.
