unit _Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBCtrls, Db, DBTables, Grids, DBGrids, html_template,
  activex_shell, ComObj, shellapi, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    Button2: TButton;
    RadioGroup1: TRadioGroup;
    DataSource1: TDataSource;
    Query1: TQuery;
    DataSource2: TDataSource;
    Query2: TQuery;
    HTML_Template1: THTML_Template;
    SaveDialog1: TSaveDialog;
    Button1: TButton;
    Memo1: TMemo;
    procedure Button2Click(Sender: TObject);
    procedure HTML_Template1OpenURLError(Sender: TObject; URL,
      ErrorMessage: String);
    procedure HTML_Template1ExecuteError(Sender: TObject;
      ErrorMessage: String);
    procedure HTML_Template1OpenURL(Sender: TObject; URL: String;
      var PageText: String);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }                    
  end;

var
  Form1: TForm1;

implementation


{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
  var PageText : AnsiString;
begin

  // this method checks default URL open routine

  // changing working folder to make sure the correct path to report templates
  ChDir( ExtractFilePath(ParamStr(0)) );

  HTML_Template1.DefaultOpenURL(RadioGroup1.Items[RadioGroup1.ItemIndex], PageText);
  Memo1.Lines.Text := PageText;


end;

procedure TForm1.Button2Click(Sender: TObject);
begin

  // changing working folder to make sure the correct path to report templates
  ChDir( ExtractFilePath(ParamStr(0)) );

  // Set report template
  html_template1.URL := RadioGroup1.Items[RadioGroup1.ItemIndex];

  Query2.DisableControls;

  html_template1.Execute();

  Query2.EnableControls;

  if html_template1.Ready then begin

    Memo1.Lines.Text := html_template1.ReportText;

    if SaveDialog1.Execute() then begin

      // saving to file

      with TFileStream.Create(SaveDialog1.FileName, fmCreate) do begin
        Write(PChar(html_template1.ReportText)^,length(html_template1.ReportText));
        Free;
      end;

      // opening the file with report

      ShellExecute(Application.Handle,
                   PChar('open'),
                   PChar(SaveDialog1.FileName),
                   nil,nil,SW_SHOWNORMAL
                   );


    end;

  end;

end;


procedure TForm1.HTML_Template1OpenURLError(Sender: TObject; URL, ErrorMessage: String);
begin
  ShowMessage('Cannot load from URL: ' + URL);
end;

procedure TForm1.HTML_Template1ExecuteError(Sender: TObject;
  ErrorMessage: String);
begin
  ShowMessage('Report execution error: ' +  ErrorMessage);
end;

procedure TForm1.HTML_Template1OpenURL(Sender: TObject; URL: String;
  var PageText: String);
begin

  // checking that URL starts with 'database://'
  if ( copy(URL, 1, length('database://')) = 'database://' ) then begin

   with TQuery.Create(nil) do begin

     // the rest part of the URL is SQL
     SQL.Add( copy(URL, length('database://') + 1, length(URL)) );

     try
       Open();
       if FieldCount > 0 then PageText := Fields[0].AsString;
     except
       PageText := '';
     end;

     Close();
     Free;

   end;

  end
  else begin
    // default URL open routine
    (Sender as THTML_Template).DefaultOpenURL(URL, PageText);
  end;

end;



end.
