unit Demo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Memo1: TMemo;
    Memo2: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Panel2: TPanel;
    Label4: TLabel;
    Button1: TButton;
    Memo3: TMemo;
    Label3: TLabel;
    procedure FormResize(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses HTMLParser;

{$R *.DFM}

procedure TForm1.FormResize(Sender: TObject);
begin
  Memo1.Width:= Width div 3;
  Memo3.Width:= Width div 3;
  Label2.Left:= Memo2.Left+10;
  Label3.Left:= Memo3.Left+10;
end;

procedure TForm1.Button1Click(Sender: TObject);
var p: THtmlParser;
    i: Integer;
    bold: Boolean;
    boldtext: string;
    t: TTag;
  procedure NewLine(const s:string);
  begin
    memo3.Lines.Add(s);
  end;
begin
  bold:= False;
  p:= THtmlParser.Create;
  try
    p.Text:= Memo1.Text;

    // let's show what do we have in the TParser object
    memo3.Lines.Clear;
    while p.NextTag do
     with p.Tag do begin
       if p.TextBetween<>'' then begin
         NewLine(Format('text: "%s"', [p.TextBetween]));
         NewLine('');
       end;
       NewLine(Format('tag: "%s"', [Text]));
       NewLine(Format('-name: "%s"', [Name]));
       for i:= 0 to Params.Count-1 do
         NewLine(Format('-param %d: "%s"', [i, Params[i]]));
       NewLine('');
     end;
    if p.TextBetween<>'' then NewLine(Format('text: "%s"', [p.TextBetween]));


    // and now the real processing
    p.GotoBeginning;
    while p.NextTag do begin               // parsing from the beginning to the end

      // looking for bold text
      if (not bold) and (p.Tag.Name='B') then
        begin
          bold:= True;
          boldtext:= '';
        end
      else
      if (bold) and (p.Tag.Name='/B') then
        begin
          bold:= False;
          boldtext:= boldtext + p.TextBetween;
          ShowMessage(boldtext);
        end
      else
      if bold then
        boldtext:= boldtext + p.TextBetween;

      // adding some stuff at the end
      if p.Tag.Name='/BODY' then begin
        t:= TTag.Create;
        try
          p.InsertText(#13#10#13#10'<BR>'#13#10);
          t.Name:= 'font';
          t.Params.Add('name=serif');
          t.Params.Add('size=10pt');
          p.InsertTag(t);
          p.InsertText('Some new text');
          t.Name:= '/font';
          t.Params.Clear;
          p.InsertTag(t);
          p.InsertText(#13#10);
        finally
          t.Free;
        end;
      end;

      // removing the title
      if p.Tag.Name='TITLE' then p.RemoveTag else
      if p.Tag.Name='/TITLE' then begin
        p.TextBetween:= '';
        p.RemoveTag;
      end;
    end;

    while p.PrevTag do                // we can always go back toward the beginning
      with p.Tag do begin
        (*** MAKING UPPERCASE ***)

        Name:= Name;      // this is a tricky way to uppercase the tag's name
                          // Name property always returns uppercase
                          // but it will be changed in the original text
                          // only if you WRITE to this property
                          // (reading makes NO changes in the original text)

        for i:= 0 to Params.Count-1 do
          Params[i]:= AnsiUpperCase(Params[i]);
        // everything above could be done also with one line:
        //   Text:= AnsiUpperCase(Text)
        // but I wanted to show you how to access the parameters

        p.TextBetween:= AnsiUpperCase(p.TextBetween);
      end;
    p.TextBetween:= AnsiUpperCase(p.TextBetween);

    Memo2.Text:= p.Text;

  finally
    p.Free;
  end;
end;

end.
