unit MainFrm;

{
  HKProgressBar v1.5
   By Harry Kakoulidis 11/1999

  kcm@mailbox.gr
  http://kakoulidis.homepage.com

  This is Freeware. Please copy the file unchanged.
  If you find bugs, have options etc. Please send at my e-mail.

  The use of this component is at your own risk.
  I do not take any responsibility for any damages.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, HKProgressBr;

type
  TMainForm = class(TForm)
    btnWait: TButton;
    btnProgress: TButton;
    Label1: TLabel;
    Label2: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    Edit1: TEdit;
    Label5: TLabel;
    HKProgr: THKProgressBar;
    HKWait: THKProgressBar;
    CheckBox4: TCheckBox;
    procedure HKProgrProcessItem;
    procedure HKWaitProcessItem;
    procedure btnProgressClick(Sender: TObject);
    procedure HKProgrEnd(Cancelled: Boolean);
    procedure btnWaitClick(Sender: TObject);
    procedure HKWaitEnd(Cancelled: Boolean);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.HKProgrProcessItem;
var a:array[1..30000] of byte;
 b:integer;
begin
 for b:=1 to 10000 do begin
  Fillchar(a,sizeof(a),0);     // Doing an important job
  HKProgr.SetPosition(b,10000);
  if hkprogr.UserCanceled then exit;
    {Note that if we exit, OnEnd is called with it's Canceled var = true}
 end;
end;

procedure TMainForm.HKWaitProcessItem;
var a:array[1..30000] of byte;
b:integer;
begin
 for b:=1 to 50000 do begin
  Fillchar(a,sizeof(a),0);     // Doing an important job.
  HKWait.SetPosition(b,0);     // The second var not important}
  if b=10000 then break;
 { Here we discover that our loop is finished. OnEnd is called with
   Canceled=false}
  if hkwait.UserCanceled then Exit;
 { If the user presses cancel, exit and OnEnd is called with
   Canceled=true}
 end;
{ On this case, no progress bar is shown, because we don't know
  how many items we have to process. (let's say we didn't know that
  it was 10000)        }
end;

procedure TMainForm.btnProgressClick(Sender: TObject);
begin
 btnProgress.Enabled:=false;
 HKProgr.StartProgress(true);
end;

procedure TMainForm.btnWaitClick(Sender: TObject);
begin
 btnWait.Enabled:=false;
 HKWait.StartProgress(false);
end;

procedure TMainForm.HKProgrEnd(Cancelled: Boolean);
begin
 if cancelled then showmessage('Cancelled') else showmessage('Finished!');
 btnProgress.Enabled:=true;
end;

procedure TMainForm.HKWaitEnd(Cancelled: Boolean);
begin
 if cancelled then showmessage('Cancelled') else showmessage('Finished!');
 btnWait.Enabled:=true;
end;

procedure TMainForm.CheckBox1Click(Sender: TObject);
begin
 HkWait.WaitTillFinish:=CheckBox1.Checked;
 HkProgr.WaitTillFinish:=CheckBox1.Checked;
end;

procedure TMainForm.CheckBox2Click(Sender: TObject);
begin
 HkWait.CanCancel:=CheckBox2.Checked;
 HkProgr.CanCancel:=CheckBox2.Checked;
end;

procedure TMainForm.CheckBox3Click(Sender: TObject);
begin
 HkWait.ShowDialog:=CheckBox3.Checked;
 HkProgr.ShowDialog:=CheckBox3.Checked;
end;

procedure TMainForm.CheckBox4Click(Sender: TObject);
begin
 HkWait.InThread:=CheckBox4.Checked;
 HkProgr.InThread:=CheckBox4.Checked;
end;

end.
