unit sample1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, HexEditor, StdCtrls, ExtCtrls, Buttons, ComCtrls, Menus , clipbrd , Printers;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    MainMenu1: TMainMenu;
    Datei1: TMenuItem;
    Neu1: TMenuItem;
    ffnen1: TMenuItem;
    Speichern1: TMenuItem;
    Speichernunter1: TMenuItem;
    N1: TMenuItem;
    Beenden1: TMenuItem;
    Bearbeiten1: TMenuItem;
    Rckgngig1: TMenuItem;
    N3: TMenuItem;
    Ausschneiden1: TMenuItem;
    Kopieren1: TMenuItem;
    Einfgen1: TMenuItem;
    Hilfe1: TMenuItem;
    Info1: TMenuItem;
    View1: TMenuItem;
    _16: TMenuItem;
    _32: TMenuItem;
    _64: TMenuItem;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    N2: TMenuItem;
    Blocksize1: TMenuItem;
    N2Bytesperblock1: TMenuItem;
    N4Bytesperblock1: TMenuItem;
    N1Byteperblock1: TMenuItem;
    N5: TMenuItem;
    Goto1: TMenuItem;
    Caretstyle1: TMenuItem;
    Fullblock1: TMenuItem;
    Leftline1: TMenuItem;
    Bottomline1: TMenuItem;
    Linesize1: TMenuItem;
    Grid1: TMenuItem;
    Offsetdisplay1: TMenuItem;
    Hex1: TMenuItem;
    Dec1: TMenuItem;
    None1: TMenuItem;
    Showmarkers1: TMenuItem;
    Find1: TMenuItem;
    FindNext1: TMenuItem;
    Jump1: TMenuItem;
    Amount40001: TMenuItem;
    N4: TMenuItem;
    Jumpforward1: TMenuItem;
    Jumpbackward1: TMenuItem;
    HexToCanvas1: THexToCanvas;
    HexEditor1: THexEditor;
    N6: TMenuItem;
    Printpreview1: TMenuItem;
    PrinterSetupDialog1: TPrinterSetupDialog;
    Printsetup1: TMenuItem;
    Print1: TMenuItem;
    N7: TMenuItem;
    Translation1: TMenuItem;
    Ansi1: TMenuItem;
    ASCII7Bit1: TMenuItem;
    DOS8Bit1: TMenuItem;
    Mac1: TMenuItem;
    IBMEBCDICcp381: TMenuItem;
    SwapNibbles1: TMenuItem;
    InsertNibble1: TMenuItem;
    DeleteNibble1: TMenuItem;
    N8: TMenuItem;
    Convertfile1: TMenuItem;
    MaskWhitespaces1: TMenuItem;
    AnyFile1: TMenuItem;
    HexText1: TMenuItem;
    ImportfromHexText1: TMenuItem;
    FixedFilesize1: TMenuItem;
    Test1: TMenuItem;
    variablelinelength1: TMenuItem;
    changelinelengths1: TMenuItem;
    SetAsHex1: TMenuItem;
    SetAsText1: TMenuItem;
    Octal1: TMenuItem;
    PasteText1: TMenuItem;
    N9: TMenuItem;
    Auto1: TMenuItem;
    Printlayout1: TMenuItem;
    Hex2: TMenuItem;
    Decimal1: TMenuItem;
    Octal2: TMenuItem;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Bearbeiten1Click(Sender: TObject);
    procedure Datei1Click(Sender: TObject);
    procedure Einfgen1Click(Sender: TObject);
    procedure Rckgngig1Click(Sender: TObject);
    procedure HexEditor1StateChanged(Sender: TObject);
    procedure Kopieren1Click(Sender: TObject);
    procedure Ausschneiden1Click(Sender: TObject);
    procedure _64Click(Sender: TObject);
    procedure View1Click(Sender: TObject);
    procedure Neu1Click(Sender: TObject);
    procedure ffnen1Click(Sender: TObject);
    procedure Beenden1Click(Sender: TObject);
    procedure Speichern1Click(Sender: TObject);
    procedure HexEditor1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormActivate(Sender: TObject);
    procedure Blocksize1Click(Sender: TObject);
    procedure N4Bytesperblock1Click(Sender: TObject);
    procedure Goto1Click(Sender: TObject);
    procedure Caretstyle1Click(Sender: TObject);
    procedure Bottomline1Click(Sender: TObject);
    procedure Grid1Click(Sender: TObject);
    procedure Offsetdisplay1Click(Sender: TObject);
    procedure None1Click(Sender: TObject);
    procedure Showmarkers1Click(Sender: TObject);
    procedure FindNext1Click(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Jumpforward1Click(Sender: TObject);
    procedure Jumpbackward1Click(Sender: TObject);
    procedure Amount40001Click(Sender: TObject);
    procedure Jump1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure Printpreview1Click(Sender: TObject);
    procedure Printsetup1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Ansi1Click(Sender: TObject);
    procedure SwapNibbles1Click(Sender: TObject);
    procedure InsertNibble1Click(Sender: TObject);
    procedure DeleteNibble1Click(Sender: TObject);
    procedure Convertfile1Click(Sender: TObject);
    procedure MaskWhitespaces1Click(Sender: TObject);
    procedure AnyFile1Click(Sender: TObject);
    procedure HexText1Click(Sender: TObject);
    procedure ImportfromHexText1Click(Sender: TObject);
    procedure FixedFilesize1Click(Sender: TObject);
    procedure variablelinelength1Click(Sender: TObject);
    procedure Test1Click(Sender: TObject);
    procedure changelinelengths1Click(Sender: TObject);
    procedure SetAsHex1Click(Sender: TObject);
    procedure SetAsText1Click(Sender: TObject);
    procedure PasteText1Click(Sender: TObject);
    procedure Auto1Click(Sender: TObject);
    procedure Printlayout1Click(Sender: TObject);
    procedure Hex2Click(Sender: TObject);
    procedure Decimal1Click(Sender: TObject);
    procedure Octal2Click(Sender: TObject);
  private
    { Private-Deklarationen }
    function CheckChanges : Boolean;
    function SaveFile : Boolean;
    procedure Error ( aMsg : string );
    procedure AppendByte;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  FindPos : Integer = -1;
  FindBuf : PChar = nil;
  FindLen : Integer = 0;
  FindStr : string = '';
  FindICase : Boolean = False;
  JumpOffs : Integer = 4000;
  CanvasDisplay : TOffsetDisplayStyle = odHex;

implementation

uses sample2,sample3;



{$R *.DFM}

const
     cCaption = 'MP THexEditor sample app';


(* utility routines *)
function SaveText ( const aText , aName : string ) : Boolean;
var
   f : System.Text;
begin
     {$I-}
     AssignFile ( f , aName );
     Rewrite ( f );
     write ( f , aText );
     CloseFile ( f );
     Result := IOResult = 0;
     {$I+}
end;

function LoadText ( const aName : string ) : string;
var
   fST : TMemoryStream;
begin
     Result := '';
     if not FileExists ( aName )
     then
         Exit;
     fST := TMemoryStream.Create;
     try
        fST.LoadFromFile ( aName );
        SetLength ( Result , fST.Size );
        fST. Position := 0;
        fST.Read ( Result[1] , fST.Size );
     finally
            fST.Free;
     end;
end;

(* form1 routines *)
procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
     CanClose := CheckChanges;
end;

procedure TForm1.Bearbeiten1Click(Sender: TObject);
begin
     with Rckgngig1
     do begin
        Enabled := HexEditor1.CanUndo;
        Caption := 'Undo : '+HexEditor1.UndoDescription;
     end;
     Ausschneiden1.Enabled := HexEditor1.SelCount > 0;
     Kopieren1.Enabled := HexEditor1.SelCount > 0;
     Einfgen1.Enabled := Clipboard.HasFormat ( CF_TEXT );
     PasteText1.Enabled := Einfgen1.Enabled;
     Goto1.Enabled := HexEditor1.DataSize > 0;
     Find1.Enabled := HexEditor1.DataSize > 0;
     FindNext1.Enabled := HexEditor1.DataSize > 0;
     InsertNibble1.Enabled := HexEditor1.DataSize > 0;
     DeleteNibble1.Enabled := HexEditor1.DataSize > 0;
     ConvertFile1.Enabled := HexEditor1.DataSize > 0;
     if HexEditor1.SelCount = 0
     then
         ConvertFile1.Caption := 'Convert File'
     else
         ConvertFile1.Caption := 'Convert Selection'
end;

procedure TForm1.Datei1Click(Sender: TObject);
begin
     Speichern1.Enabled := HexEditor1.Modified and (not HexEditor1.ReadOnly);
     Speichernunter1.Enabled := HexEditor1.DataSize > 0;
     PrintPreview1.Enabled := HexEditor1.DataSize > 0;
     Print1.Enabled := HexEditor1.DataSize > 0;
end;

procedure TForm1.Einfgen1Click(Sender: TObject);
var
   sr : string;
   BT : Integer;
begin
     Bearbeiten1Click ( Sender );
     if Einfgen1.Enabled
     then begin
          // paste clipboard
          sr := Clipboard.AsText;
          HexEditor1.ReplaceSelection ( ConvertHexToBin ( @sr[1] , @sr[1] , Length ( sr ) , False , bt ) , bt);
     end;
end;

procedure TForm1.Rckgngig1Click(Sender: TObject);
begin
     if HexEditor1.CanUndo
     then
         HexEditor1.Undo;
end;

procedure TForm1.HexEditor1StateChanged(Sender: TObject);
var
   pSS , pSE : Integer;
begin
     with HexEditor1,StatusBar1
     do begin
        Panels[0].Text := 'Pos : '+IntToStr ( GetCursorPos );
        if SelCount <> 0
        then begin
             pSS := SelStart;
             pSE := SelEnd;
             Panels[1].Text := 'Sel : '+IntToStr ( Min ( pSS , pSE)) +' - '+IntToStr(Max ( pSS , pSE));
        end
        else
            Panels[1].Text := '';

        if Modified
        then
            Panels[2].Text := '*'
        else
            Panels[2].Text := '';

        if ReadOnly
        then
            Panels[3].Text := 'R'
        else
            Panels[3].Text := '';

        if IsInsertMode
        then
            Panels[4].Text := 'INS'
        else
            Panels[4].Text := 'OVW';

        Panels[5].Text := 'Size : '+IntToStr ( DataSize );
        Self.Caption := cCaption+'['+FileName+']';
     end;
end;

procedure SetCBText ( aP : PChar ; aCount : Integer );
var
   sr : string;
begin
     SetLength ( sr , aCount * 2 );
     ConvertBinToHex ( aP , @sr[1] , aCount , False );
     ClipBoard.AsText := sr;
     SetLength ( sr , 0 );
end;

procedure TForm1.Kopieren1Click(Sender: TObject);
var
   pct : Integer;
   pPC : PChar;
begin
     Bearbeiten1Click ( Sender );
     if Kopieren1.Enabled
     then
         with HexEditor1
         do begin
            pCT := SelCount;
            pPC := BufferFromFile ( Min ( SelStart , SelEnd ) , pCT );
            SetCBText ( pPC , pCT );
            FreeMem ( pPC , pCT );
         end;

end;

procedure TForm1.Ausschneiden1Click(Sender: TObject);
var
   pct : Integer;
   pPC : PChar;
begin
     Bearbeiten1Click ( Sender );
     if Ausschneiden1.Enabled
     then
         with HexEditor1
         do begin
            pCT := SelCount;
            pPC := BufferFromFile ( Min ( SelStart , SelEnd ) , pCT );
            SetCBText ( pPC , pCT );
            FreeMem ( pPC , pCT );
            DeleteSelection;
         end;

end;

procedure TForm1._64Click(Sender: TObject);
begin
     HexEditor1.BytesPerLine := TMenuItem ( Sender).Tag;
end;

procedure TForm1.View1Click(Sender: TObject);
begin
     Case HexEditor1.BytesPerLine
     of
       16 : _16.Checked := True;
       32 : _32.Checked := True;
       64 : _64.Checked := True;
     end;
     Grid1.Checked := HexEditor1.GridLineWidth = 1;
     ShowMarkers1.Checked := HexEditor1.ShowMarkerColumn;
     SwapNibbles1.Checked := HexEditor1.SwapNibbles;
     MaskWhiteSpaces1.Checked := HexEditor1.MaskWhiteSpaces;
     Case HexEditor1.Translation
     of
       ttAnsi : Ansi1.Checked := True;
       ttASCII : ASCII7Bit1.Checked := True;
       ttDOS8 : Dos8Bit1.Checked := True;
       ttMac  : Mac1.Checked := True;
       ttEBCDIC : IBMEBCDICCP381.Checked := True;
     end;
     FixedFileSize1.Checked := HexEditor1.NoSizeChange;
end;

procedure TForm1.Neu1Click(Sender: TObject);
begin
     if CheckChanges
     then
         HexEditor1.CreateEmptyFile ( 'Untitled' );
end;

function TForm1.CheckChanges : Boolean;
var
   psr : string;
begin
     Result := True;
     if not HexEditor1.Modified
     then
         Exit;
     Result := False;
     pSR := HexEditor1.FileName;
     if not FileExists ( pSR )
     then
         pSR := 'Unnamed File';

     Case MessageDlg ( 'Save changes to'#13#10+psr+' ?' , mtConfirmation , [mbNo , mbYes , mbCancel] , 0 )
     of
       IDNo     : Result := True;
       IDYES    : Result := SaveFile;
     end;
end;


procedure TForm1.ffnen1Click(Sender: TObject);
begin
     if CheckChanges
     then
         if Opendialog1.Execute
         then begin
              HexEditor1.LoadfromFile(OpenDialog1.FileName);
              if ofReadOnly in OpenDialog1.Options
              then
                  HexEditor1.ReadOnly := True;
         end;

end;

procedure TForm1.Beenden1Click(Sender: TObject);
begin
     Close;
end;

procedure TForm1.Speichern1Click(Sender: TObject);
begin
     SaveFile ;
end;

function TForm1.SaveFile : Boolean;
begin
     Result := False;
     if ( not FileExists ( HexEditor1.FileName )) or HexEditor1.ReadOnly
     then begin
          if SaveDialog1.Execute
          then begin
               if HexEditor1.SaveToFile ( SaveDialog1.FileName )
               then
                   Result := True
               else begin
                    Error ( 'Cannot save file'#13#10+HexEditor1.FileName );
               end;
          end
     end
     else
         if HexEditor1.SaveToFile ( HexEditor1.FileName )
         then
             Result := True
         else
             Error ( 'Cannot save file'#13#10+HexEditor1.FileName );


end;

procedure TForm1.Error ( aMsg : string );
begin
     Windows.MessageBox ( Handle , PChar ( aMsg ) , nil , MB_ICONHAND);
end;


procedure TForm1.HexEditor1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     if (Shift = [ssCTRL] ) and ( KEY = Ord('A') )
     then begin
          Key := 0;
          AppendByte ;
     end;
end;


procedure TForm1.AppendByte;
var
   pBY : Byte;
begin
     pBY := 255;
     HexEditor1.AppendBuffer ( @pBY , 1 );
end;

procedure TForm1.FormActivate(Sender: TObject);
const
     flFirst : Boolean = True;
begin
     if flFirst
     then begin
          flFirst := False;
          if ParamCount > 0
          then
              if FileExists ( ParamStr(1))
              then begin
                   Application.ProcessMessages;
                   HexEditor1.LoadFromFile ( ParamStr ( 1 ) );
              end;
     end;
end;

procedure TForm1.Blocksize1Click(Sender: TObject);
begin
     case HexEditor1.BytesPerColumn
     of
       1 : N1Byteperblock1.Checked := True;
       2 : N2Bytesperblock1.Checked := True;
       4 : N4Bytesperblock1.Checked := True;
     end;

end;

procedure TForm1.N4Bytesperblock1Click(Sender: TObject);
begin
     HexEditor1.BytesPerColumn := TMenuItem ( Sender) . Tag;
end;

procedure TForm1.Goto1Click(Sender: TObject);
var
   sr : string;
   s1 : LongInt;
begin
     if HexEditor1.DataSize < 1
     then
         Exit;
         
     s1 := HexEditor1.GetCursorPos;
     sr := IntToStr ( s1 );
     if InputQuery ( 'Goto file position...' ,
                     '(prefix "0x" or "$" means hex)', sr )
     then begin
          if Pos ( '0x' , AnsiLowerCase ( sr ) ) = 1
          then
              sr := '$'+Copy ( sr , 3 , MaxInt );

          s1 :=  StrToIntDef ( sr , -1 );
          if not HexEditor1.Seek ( s1 , soFromBeginning , True )
          then
              Error ( 'Invalid position' )
     end;

end;

procedure TForm1.Caretstyle1Click(Sender: TObject);
begin
     case HexEditor1.CaretStyle
     of
       csFull       : FullBlock1.Checked := True;
       csLeftLine   : LeftLine1.Checked := True;
       csBottomLine : BottomLine1.Checked := True;
     end;


end;

procedure TForm1.Bottomline1Click(Sender: TObject);
begin
     HexEditor1.CaretStyle := TCaretStyle(TMenuItem(Sender).Tag);
end;

procedure TForm1.Grid1Click(Sender: TObject);
begin
      HexEditor1.GridLineWidth := 1 - HexEditor1.GridLineWidth;
end;

procedure TForm1.Offsetdisplay1Click(Sender: TObject);
begin
     case HexEditor1.OffsetDisplay
     of
       odHex       : Hex1.Checked := True;
       odDec       : Dec1.Checked := True;
       odOctal     : Octal1.Checked := True;
       odNone      : None1.Checked := True;
     end;
     Auto1.Checked := HexEditor1.AutoCaretMode;
end;

procedure TForm1.None1Click(Sender: TObject);
begin
     HexEditor1.OffsetDisplay := TOffsetDisplayStyle(TMenuItem(Sender).Tag);

end;

procedure TForm1.Showmarkers1Click(Sender: TObject);
begin
     HexEditor1.ShowMarkerColumn := not HexEditor1.ShowMarkerColumn;
end;

procedure TForm1.FindNext1Click(Sender: TObject);
begin
     if HexEditor1.DataSize < 1
     then
         Exit;

     if FindStr = ''
     then
         Find1.Click
     else begin
          if FindPos = HexEditor1.SelEnd
          then
              Inc ( FindPos , 1 );

         FindPos := HexEditor1.Find ( FindBuf , FindLen , FindPos , HexEditor1.DataSize -1 , FindICase , False);
         if FindPos = -1
         then
             ShowMessage ( 'Data not found.' )
         else begin
              HexEditor1.SelStart := FindPos+FindLen-1;
              HexEditor1.SelEnd := FindPos ;
         end;
     end;
end;

procedure TForm1.Find1Click(Sender: TObject);
const
     cHexChars = '0123456789abcdef';
var
   pSTR,pTMP : String;
   pCT,pCT1 : Integer;
begin
     if HexEditor1.DataSize < 1
     then
         Exit;

     FindPos := -1;
     FindICase := False;
     if FindBuf <> nil
     then begin
          FreeMem ( FindBuf );
          FindBuf := nil;
     end;
     if not InputQuery ( 'Find Data' , '"t.." ascii, "T.." + ignore case, else search hex' , FindStr )
     then
         Exit;

     // make a search string
     if FindStr = ''
     then
         Exit;

     pStr := '';

     if UpCase(FindStr[1]) = 'T'
     then begin
          pStr := Copy ( FindStr , 2 , MaxInt );
          pCT1 := Length ( pStr );
     end
     else begin
          // calculate Data from input
          pTMP := AnsiLowerCase ( FindStr);

          for pCT := Length ( pTMP ) downto 1
          do
            if Pos( pTMP[pCT] , cHexChars ) = 0
            then
                Delete ( pTMP , pCT , 1 );

          while (Length(pTMP) mod 2) <> 0
          do
            pTMP := '0'+pTMP;

          if pTMP = ''
          then
              Exit;

          pSTR := '';
          pCT1 := Length ( pTMP ) div 2;
          for pCT := 0 to (Length ( pTMP ) div 2) -1
          do
            pStr := pStr + Char ( (Pos ( pTMP[pCt*2+1] , cHexChars ) -1) * 16 + (Pos ( pTMP[pCt*2+2] , cHexChars ) -1));
     end;

     if pCT1 = 0
     then
         Exit;

     GetMem ( FindBuf , pCT1 );
     try
        if FindStr[1] = 'T'
        then
            FindICase := True;

        FindLen := pCT1;

        Move ( pStr[1] , FindBuf^, pCt1 );

        FindPos := HexEditor1.Find ( FindBuf , FindLen , HexEditor1.GetCursorPos , HexEditor1.DataSize -1 , FindICase , UpCase(FindStr[1]) = 'T' );
        if FindPos = -1
        then
            ShowMessage ( 'Data not found.' )
        else begin
             HexEditor1.SelStart := FindPos+FindLen-1;
             HexEditor1.SelEnd := FindPos ;
        end;

     finally
     end;


end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
     if FindBuf <> nil
     then begin
          FreeMem ( FindBuf );
          FindBuf := nil;
     end;

end;

procedure TForm1.Jumpforward1Click(Sender: TObject);
begin
     HexEditor1.Seek ( JumpOffs , soFromCurrent , False );
end;

procedure TForm1.Jumpbackward1Click(Sender: TObject);
begin
     HexEditor1.Seek ( -JumpOffs , soFromCurrent , False );

end;

procedure TForm1.Amount40001Click(Sender: TObject);
var
   sr : string;
begin
     sr := IntToStr ( JumpOffs );
     if InputQuery ( 'Jump amount' , 'Enter new value:' , sr )
     then
         JumpOffs := StrToIntDef ( sr , JumpOffs );
end;

procedure TForm1.Jump1Click(Sender: TObject);
begin
     Amount40001.Caption := 'Amount : '+IntToStr ( JumpOffs );
     JumpForward1.Enabled := HexEditor1.DataSize > 0;
     JumpBackWard1.Enabled := HexEditor1.DataSize > 0;
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
     ShowMessage ( 'Sample application for THexEditor (V1.14)'+#13#10+#13#10+
                   '(C) 1998 by Markus Stephany,'+#13#10+
                   ' mailto:mirbir.st@t-online.de,'+#13#10+
                   ' http://home.t-online.de/home/mirbir.st'+#13#10+#13#10+
                   'Credits to :'+#13#13#10+
                   ' John Hamm John@TEMPUS.COM'+#13#10+
                   ' Christophe LE CORFEC CLC@khalif.com'+#13#10+
                   ' Philippe Chessa Philippe_Chessa@compuserve.com'+#13#10+
                   ' Eric Grange egrange@hotmail.com');

end;

procedure TForm1.Printpreview1Click(Sender: TObject);
var
   pBMP : TBitMap;
   l1 : Integer;
begin
     pBMP := TBitmap.Create;
     try
        pBMP.Width := 1000 ;
        pBMP.Height := Round ( Printer.PageHeight / Printer.PageWidth * 1000 );
        with pBMP
        do begin
           Canvas.Brush.Color := clWhite;
           Canvas.Brush.Style := bsSolid;
           Canvas.FillRect ( Rect ( 0 , 0 , Width , Height ) );
           // nun rnder berechnen
           HexToCanvas1.GetLayout;
           HexToCanvas1.MemFieldDisplay := CanvasDisplay;
           HexToCanvas1.StretchToFit := False;
           HexToCanvas1.TopMargin := Height div 20;
           HexToCanvas1.BottomMargin := Height - (Height div 20);
           HexToCanvas1.LeftMargin := Width div 20;
           HexToCanvas1.RightMargin := Width - (Width div 20);
           HexToCanvas1.Draw ( Canvas , 0 , HexEditor1.DataSize -1 , 'MP THexEditor-Sample:'+ExtractFileName(HexEditor1.FileName),'Page 1' );
        end;
        with tfmPreview.Create ( Application )
        do try
           Image1.Width := ClientWidth;
           l1 := Round ( Image1.Width / pBMP.Width * pBMP.Height );
           if l1 > ClientHeight
           then begin
                Image1.Height := ClientHeight;
                Image1.Width := Round ( Image1.Height / pBMP.Height * pBMP.Width );
           end
           else
               Image1.Height := l1;
           Image1.Picture.Bitmap.Assign ( pBMP );
           ShowModal;
        finally
               Free;
        end;
     finally
            pBMP.Free;
     end;
end;

procedure TForm1.Printsetup1Click(Sender: TObject);
begin
     PrinterSetupDialog1.Execute;
end;

procedure TForm1.Print1Click(Sender: TObject);
var
   l1,l2 : Integer;
begin
     if HexEditor1.DataSize < 1
     then
         Exit;

     l1 := 0;

     with Printer
     do begin
        // nun rnder berechnen
        HexToCanvas1.StretchToFit := False;
        HexToCanvas1.GetLayout;
        HexToCanvas1.MemFieldDisplay := CanvasDisplay;
        HexToCanvas1.TopMargin := PageHeight div 20;
        HexToCanvas1.BottomMargin := PageHeight - (PageHeight div 20);
        HexToCanvas1.LeftMargin := PageWidth div 20;
        HexToCanvas1.RightMargin := PageWidth - (PageWidth div 20);
        l2 := 1;
        BeginDoc;
        repeat
              Canvas.Brush.Color := clWhite;
              Canvas.Brush.Style := bsSolid;
              Canvas.FillRect ( Rect ( 0 , 0 , PageWidth , PageHeight ) );
              l1 := HexToCanvas1.Draw ( Canvas , l1 , HexEditor1.DataSize -1 ,
              'MP THexEditor-Sample:'+ExtractFileName(HexEditor1.FileName),'Page '+IntToStr(l2) );
              if l1 < HexEditor1.DataSize
              then
                  NewPage;
              l2 := l2+1;
        until l1 >= HexEditor1.DataSize;
        EndDoc;
     end;
end;

procedure TForm1.Ansi1Click(Sender: TObject);
begin
     HexEditor1.Translation := TTranslationType ( TMenuItem ( Sender ) . Tag ) ;
end;

procedure TForm1.SwapNibbles1Click(Sender: TObject);
begin
     HexEditor1.SwapNibbles := not HexEditor1.SwapNibbles;
end;

procedure TForm1.InsertNibble1Click(Sender: TObject);
begin
     HexEditor1.InsertNibble ( HexEditor1.GetCursorPos , HexEditor1.InCharField or ((HexEditor1.Col mod 2) = 0 ));
end;

procedure TForm1.DeleteNibble1Click(Sender: TObject);
begin
     HexEditor1.DeleteNibble ( HexEditor1.GetCursorPos , HexEditor1.InCharField or ((HexEditor1.Col mod 2) = 0 ));

end;

procedure TForm1.Convertfile1Click(Sender: TObject);
var
   pFrom , pTo : Integer;
begin
     pFrom := 0;
     pTO := HexEditor1.DataSize-1;
     if HexEditor1.SelCount <> 0
     then begin
          pFrom := Min ( HexEditor1.SelStart , HexEditor1.SelEnd );
          pTo := Max ( HexEditor1.SelStart , HexEditor1.SelEnd );
     end;
     with TForm2.Create ( Application )
     do try
        Caption := ConvertFile1.Caption;
        if ShowModal = IDOK
        then
            HexEditor1.ConvertRange ( pFrom , pTo , TTranslationType(ListBox1.ItemIndex) ,
                                      TTranslationType(ListBox2.ItemIndex) );
     finally
            Free;
     end;

end;

procedure TForm1.MaskWhitespaces1Click(Sender: TObject);
begin
     HexEditor1.MaskWhiteSpaces := not HexEditor1.MaskWhiteSpaces;
end;

procedure TForm1.AnyFile1Click(Sender: TObject);
begin
     if SaveDialog1.Execute
     then
          if not HexEditor1.SaveToFile ( SaveDialog1.FileName )
          then
               Error ( 'Cannot save file'#13#10+SaveDialog1.FileName );

end;

procedure TForm1.HexText1Click(Sender: TObject);
begin
     if SaveDialog1.Execute
     then
          if not SaveText ( HexEditor1.AsHex , SaveDialog1.FileName )
          then
               Error ( 'Cannot save file'#13#10+SaveDialog1.FileName );


end;

procedure TForm1.ImportfromHexText1Click(Sender: TObject);
begin
     if Opendialog1.Execute
     then begin
          HexEditor1.AsHex := LoadText(OpenDialog1.FileName);
          if ofReadOnly in OpenDialog1.Options
          then
              HexEditor1.ReadOnly := True;
     end;
end;

procedure TForm1.FixedFilesize1Click(Sender: TObject);
begin
     HexEditor1.NoSizeChange := not HexEditor1.NoSizeChange;

end;

procedure TForm1.variablelinelength1Click(Sender: TObject);
var
   pCT : Integer;
   pCU : Integer;
   pLL : TList;
begin
     if variablelinelength1.checked
     then
         HexEditor1.VariableLineLength := False
     else begin
          pLL := TList.Create;
          try
             pCT := HexEditor1.BytesPerLine;
             for pCU := 0 to 1000
             do
               pLL.Add ( Pointer ( Random(pCT)+1));

             HexEditor1.SetLineLengths ( pLL );
          finally
                 pLL.Free;
          end;
          HexEditor1.VariableLineLength := True;
     end;
end;

procedure TForm1.Test1Click(Sender: TObject);
begin
     variablelinelength1.checked := hexeditor1.VariableLineLength;
     changelinelengths1.enabled := HexEditor1.VariableLineLength;
end;

procedure TForm1.changelinelengths1Click(Sender: TObject);
var
   pCT : Integer;
   pCU : Integer;
   pLL : TList;
begin
     pLL := TList.Create;
     try
        pCT := HexEditor1.BytesPerLine;
        for pCU := 0 to 1000
        do
          pLL.Add ( Pointer ( Random(pCT)+1));

        HexEditor1.SetLineLengths ( pLL );
     finally
            pLL.Free;
     end;
end;

procedure TForm1.SetAsHex1Click(Sender: TObject);
var
   lSR : String;
begin
     lSR := '001020ff';
     if InputQuery ( 'SetAsHex' , 'Please type some hex values :' , lSR )
     then
         HexEditor1.AsHex := lSR;
end;

procedure TForm1.SetAsText1Click(Sender: TObject);
var
   lSR : String;
begin
     lSR := 'Test';
     if InputQuery ( 'SetAsText' , 'Please type some text :' , lSR )
     then
         HexEditor1.AsText := lSR;
end;

procedure TForm1.PasteText1Click(Sender: TObject);
var
   sr : string;
begin
     Bearbeiten1Click ( Sender );
     if Einfgen1.Enabled
     then begin
          // paste clipboard
          sr := Clipboard.AsText;
          HexEditor1.ReplaceSelection ( @sr[1] , Length ( sr ) );
     end;
end;

procedure TForm1.Auto1Click(Sender: TObject);
begin
     HexEditor1.AutoCaretMode := not HexEditor1.AutoCaretMode;
end;

procedure TForm1.Printlayout1Click(Sender: TObject);
begin
     case CanvasDisplay
     of
       odHex : Hex2.Checked := True;
       odDec : Decimal1.Checked := True;
       odOctal : Octal2.Checked := True;
     end;
end;

procedure TForm1.Hex2Click(Sender: TObject);
begin
     CanvasDisplay := odHex;
end;

procedure TForm1.Decimal1Click(Sender: TObject);
begin
     CanvasDisplay := odDec;

end;

procedure TForm1.Octal2Click(Sender: TObject);
begin
     CanvasDisplay := odOctal;

end;

end.
