unit MakeGUIDMain;

//*----------------------------------------------------------------------------*
//| Copyright (c) Andre Belokon, Grani Ltd. 1997-1998                          |
//| WWW:   http://www.geocities.com/SiliconValley/Lab/4877/                    |
//| EMail: delphi@grani.odessa.net                                             |
//| Freeware with source                                                       |
//*----------------------------------------------------------------------------*

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, XDKMain, XDKMenu, XDKExpt, XDKNotif;

type
  TMakeGUIDDataModule = class(TDataModule)
    MakeGUIDAddInMenu1: TxdkAddInMenu;
    MakeGUIDAddInMenuItem1: TxdkAddInMenuItem;
    MakeGUIDAddInMenuItem2: TxdkAddInMenuItem;
    procedure MakeGUIDAddInMenuItem1Click(Sender: TObject);
    procedure MakeGUIDAddInMenuItem2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MakeGUIDDataModule: TMakeGUIDDataModule;

implementation

{$R *.DFM}

uses  ComObj, ActiveX, ExptIntf, ToolIntf, EditIntf, ExpertTools;

function CreateUniqueClassID: string;
var  GUID: TGUID;
     WCLID: array[0..127] of WideChar;
begin
  OleCheck(CoCreateGUID(GUID));
  StringFromGuid2(GUID,WCLID,SizeOf(WCLID) div 2);
  Result:=WideCharToString(WCLID)
end;

procedure TMakeGUIDDataModule.MakeGUIDAddInMenuItem1Click(Sender: TObject);
begin
  InsertInCurrentEdit(Chr($27)+CreateUniqueClassID+Chr($27));
end;

procedure TMakeGUIDDataModule.MakeGUIDAddInMenuItem2Click(Sender: TObject);
const IntfDecl =
  '  ISample = Interface(IUnknown)'+#13#10+
  '  ['+#39+'%s'+#39+']'+#13#10+#13#10+
  '  end;';
begin
  InsertInCurrentEdit(Format(IntfDecl,[CreateUniqueClassID]));
end;

initialization
  xdkInitModule(TMakeGUIDDataModule,MakeGUIDDataModule); // container initialization
finalization
  xdkDoneModule(MakeGUIDDataModule); // container deinitialization
end.
