unit ExpertTools;

//*----------------------------------------------------------------------------*
//| Copyright (c) Andre Belokon, Grani Ltd. 1997-1998                          |
//| WWW:   http://www.geocities.com/SiliconValley/Lab/4877/                    |
//| EMail: delphi@grani.odessa.net                                             |
//| Freeware with source                                                       |
//*----------------------------------------------------------------------------*

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExptIntf, ToolIntf, EditIntf;

procedure SaveIfModify(const FileName: string);
procedure InsertInCurrentEdit(const Text: string);

implementation

//------------------------------------------------------------------------------

procedure InsertInCurrentEdit(const Text: string);
var  CurrentFile: string;
     ModuleInterface: TIModuleInterface;
     EditorInterface: TIEditorInterface;
     EditWriter: TIEditWriter;
     EditView: TIEditView;
     EditPos: TEditPos;
     CharPos: TCharPos;
     lPos: longint;
begin
  CurrentFile:=ToolServices.GetCurrentFile;
  if CurrentFile <> '' then begin
    ModuleInterface:=ToolServices.GetModuleInterface(CurrentFile);
    if ModuleInterface <> nil then try
      EditorInterface:=ModuleInterface.GetEditorInterface;
      if EditorInterface <> nil then try
        if EditorInterface.GetViewCount > 0 then begin
          EditView:=EditorInterface.GetView(0);
          EditWriter:=EditorInterface.CreateWriter;
          if EditWriter <> nil then try
            EditPos:=EditView.CursorPos;
            EditView.ConvertPos(True,EditPos,CharPos);
            lPos:=EditView.CharPosToPos(CharPos);
            EditWriter.CopyTo(lPos);
            EditWriter.Insert(PChar(Text));
          finally
            EditView.Free;
            EditWriter.Free;
          end;
        end;
      finally
        EditorInterface.Free;
      end;
    finally
      ModuleInterface.Free;
    end;
  end;
end;

procedure SaveIfModify(const FileName: string);
var  ModuleInterface: TIModuleInterface;
     EditorInterface: TIEditorInterface;
begin
  with ToolServices do begin
    ModuleInterface:=GetModuleInterface(FileName);
    if ModuleInterface <> nil then try
      EditorInterface:=ModuleInterface.GetEditorInterface;
      if EditorInterface <> nil then try
        if EditorInterface.BufferModified then
          ModuleInterface.Save(True);
      finally
        EditorInterface.Free;
      end;
    finally
      ModuleInterface.Free;
    end;
  end;
end;

end.
