{**************************************************}
{                                                  }
{                   TGrEdit 0.1                    }
{                                                  }
{            Copyright (c) 1999 GrMikeD            }
{                                                  }
{**************************************************}


{---------------------------------------------------
 STATE: Freeware
        No restrictions,
        No guaranties
        Use it at your own risk!
----------------------------------------------------}


{----------------------------------------------------------------------------------------
                                     HISTORY
-----------------------------------------------------------------------------------------
 Version   Date          Changes - Additions                                   Added by
-----------------------------------------------------------------------------------------

 0.1      23.08.1999    Initial Version                                    

-----------------------------------------------------------------------------------------}

unit GrEdit;

interface

uses
   SysUtils,stdctrls,classes,Dialogs;
type
  TTextType=(All, Letters, Numbers);
  
  TGrEdit = class(TEdit)
  private
    fTextType: TTextType;
    fOnlyPositive: Boolean;
    fIncDecSeparator: Boolean;
    fMessage: String;
    fBeep: Boolean;
    fError: TNotifyEvent;
    PreviousText: string;
    procedure SetTextType(const Value: TTextType);
    procedure SetOnlyPositive(const Value: Boolean);
    procedure SetIncDecSeparator(const Value: Boolean);
    procedure SetMessage(const Value: String);
    procedure SetBeep(const Value: Boolean);
  public
    HasValidNumber: boolean;
    RealValue: real;
    constructor Create(AOwner: TComponent); override;
    procedure Change; override;
    procedure KeyPress(var Key: Char); override;
  protected  
    procedure Error;
  published
    property GrTextType: TTextType read fTextType write SetTextType default All;
    property GrOnlyPositive: Boolean read fOnlyPositive write SetOnlyPositive default false;
    property GrIncDecSeparator: Boolean read fIncDecSeparator write SetIncDecSeparator default true;
    property GrMessage: String read fMessage write SetMessage;
    property GrBeep: Boolean read fBeep write SetBeep default True;
    property OnGrError: TNotifyEvent read fError write fError;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TGrEdit]);
end;

{ TGrEdit }

procedure TGrEdit.SetOnlyPositive(const Value: Boolean);
begin
  fOnlyPositive := Value;
end;

procedure TGrEdit.SetTextType(const Value: TTextType);
begin
  fTextType := Value;
end;

procedure TGrEdit.SetIncDecSeparator(const Value: Boolean);
begin
  fIncDecSeparator := Value;
end;

procedure TGrEdit.SetMessage(const Value: String);
begin
  fMessage := Value;
end; 

procedure TGrEdit.SetBeep(const Value: Boolean);
begin
  fBeep := Value;
end; 

constructor TGrEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  RealValue:= 0;
  HasValidNumber:=  False;
  fTextType:= All;
  fOnlyPositive:= false;
  fIncDecSeparator:= true;
  fMessage:= '';
  fBeep:= true;
  Text:= '';
  PreviousText:= '';
end;

procedure TGrEdit.Change;
begin
   HasValidNumber:=  True;
   try
     RealValue:= StrToFloat(Text);
   except
     RealValue:= 0;
     HasValidNumber:=  False;
     if (fTextType= Numbers) and (fOnlyPositive= False) then
     if (Text <> '-') and (Length(Text) > 0) then
       Text:= PreviousText;
   end;
   inherited Change;
end;

procedure TGrEdit.KeyPress(var Key: Char);
Var S: Set of Char;

begin
  S:= ['0'..'9'];
  case fTextType of
    Letters: if key in S then
             begin
                key:= #0;
                if fBeep then SysUtils.Beep;
                if length(fMessage)>0 then MessageDlg(fMessage,mtError,[mbOK],0);
                Error;
             end;
    Numbers: begin
               S:= S + [#8];
               if GrIncDecSeparator then S:= S + [DecimalSeparator];
               if not(GrOnlyPositive) then S:= S + ['-'];
               if not(key in S) then
                  begin
                     key:= #0;
                     if fBeep then SysUtils.Beep;
                     if length(fMessage)>0 then MessageDlg(fMessage,mtError,[mbOK],0);
                     Error;
                   end;
             end;
  end;
  PreviousText:= Text;
  inherited KeyPress(Key);
end;

procedure TGrEdit.Error;
begin
  if Assigned(fError) then
     fError(self);
end;

end.