unit Main;

interface

uses
  Windows, Messages, SysUtils, GraphicEx, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ExtDlgs, StdCtrls, JPEG;

type
  TMainForm = class(TForm)
    Button1: TButton;
    OPD: TOpenDialog;
    Image1: TImage;
    Image2: TImage;
    Button2: TButton;
    Label1: TLabel;
    FilterBox: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    procedure WMDropFiles(var Msg: TWMDropFiles); message WM_DROPFILES;
    procedure DoLoad(const FileName: String);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses
  MMSystem, ShellAPI;

{$R *.DFM}                               


procedure TMainForm.DoLoad(const FileName: String);

var
  Start: DWORD;
  BM: TBitmap;

begin
  Screen.Cursor := crHourGlass;
  try
    Start := timeGetTime;
    Image1.Picture.LoadFromFile(FileName);
    // JPG files need an extra step
    // although the jpgdemo shows that also jpg images need only a "LoadFromFile" there's nothing displayed
    // on my machine (NT4 and W2K), so I do explicitly convert JPEG's TGraphics into normal TBitmaps
    if Image1.Picture.Graphic is TJPEGImage then
    begin
      BM := TBitmap.Create;
      BM.Assign(Image1.Picture.Graphic);
      // Access to TImage.TPicture.TBitmap will actually throw away all content which is not a
      // bitmap (icons, other TGraphics like TJPEGImage etc.) and create a new, empty bitmap
      // So what I'm doing here is to create a temporary bitmap and assign it back to the picture class.
      // Whatever the programmer of this class had in mind, it was not thought through very well.
      Image1.Picture.Bitmap.Assign(BM);
      BM.Free;
    end;
    Label3.Caption := Format('%d x %d', [Image1.Picture.Width, Image1.Picture.Height]);
    Label1.Caption := 'load time: ' + IntToStr(timeGetTime - Start) + 'ms';
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
  if OPD.Execute then DoLoad(OPD.FileName);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  OPD.Filter := GraphicFilter(TGraphic);
  FilterBox.ItemIndex := 5;
  DragAcceptFiles(Handle, True);
end;

procedure TMainForm.Button2Click(Sender: TObject);

var
  Start: DWORD;
  dX, dY: Integer;

begin
  Screen.Cursor := crHourGlass;
  Image1.Picture.Bitmap.PixelFormat := pf24Bit;
  Start := timeGetTime;
  if Image1.Picture.Width > Image1.Picture.Height then
  begin
    dX := 800;
    dY := Round(dX * Image1.Picture.Height / Image1.Picture.Width);
  end
  else
  begin
    dY := 800;
    dX := Round(dY * Image1.Picture.Width / Image1.Picture.Height);
  end;

  Label4.Caption := Format('%d x %d', [dX, dY]);
  Stretch(dX, dY, TResamplingFilter(FilterBox.ItemIndex), 0, Image1.Picture.Bitmap, Image2.Picture.Bitmap);
  Image2.Refresh;
  Label1.Caption := 'stretch time: ' + IntToStr(timeGetTime - Start) + 'ms';
  Screen.Cursor := crDefault;
end;

procedure TMainForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #27 then Close;
end;

procedure TMainForm.WMDropFiles(var Msg: TWMDropFiles);

var
  Buffer: array[0..MAX_PATH] of Char;
  Count: Cardinal;

begin
  Count := DragQueryFile(Msg.Drop, DWORD(-1), nil, 0);
  if Count > 0 then
  begin
    DragQueryFile(Msg.Drop, 0, Buffer, MAX_PATH);
    DoLoad(Buffer);
    DragFinish(Msg.Drop);
    Msg.Result := 0;                                                
  end;
end;                                     

end.


