{$I param.inc}

 ############################################################################
 ## Graph64 unit for Delphi 2/3/4/5 and WDosX 0.95/96, DirectX, GDI,       ##
 ##                                        and Free Pascal Compiler        ##
 ## Version 0.4                                                            ##
 ##                                                                        ##
 ## Copyright (c)1999-2001 Pavol Stugel                                    ##
 ## Homepage: www.graph64.miesto.sk                                        ##
 ## This unit is free. e-mail: pstugel@pobox.sk                            ##
 ############################################################################

  ------------------------------
  Last updated: 17. January 2001
  ------------------------------

  Warning: !this is not english! :-)
  What you need?: Delphi 3/4/5 (5 or better recomended, only about 100$ for standart version),
                  For DOS:  WDOSX 0.96 alpha 2, units from WDOSX : VBE,FBUFFERS,CRT
                            http://www.geocities.com/siliconvalley/park/4493
                            http://www.wuschel.demon.co.uk
                  For Windows: DirectX 7 units from Erik Unger
                            http://www.bigfoot.com/~ungerik/
                  For GDI:  nothing only Delphi :-)
                  For Free Pascal:
                           you need version at least 1.0.4 (maybe 0.99.4) and enabled
                           Delphi compatibility, Delphi 2 extensions and Intel assembler syntax
                           in FP editor, or -Sd from command line.
                           DOS and Win32 platform tested.



  NOTE: 1. Many functions isn't now optimised for maximum performance, because I haven't
           time for do that.
        2. Now, DirectX isn't supported from this version, I plan to add TDXScreen64 for DirectX
           compability and for maximum easy to use. Will be maybe in next version only (0.5) You can
           try to use included Direct64 unit but I can't guaranty that will be work well.


   --------
   History:
   --------
   17.01.2001 - v 0.4
                + added support for Free Pascal Compiler (FPC), you can enable it by define apFPC
                  note: TScreen64 is not supported under FPC,
                + added overload Create() for TBitmap64
                + added DrawBrightness
                + added LoadFromBMPStream,LoadFromTGAStream
                + added DrawGlyph (well for Icons, or font painting...)
                * Loading/saving functions (include Stream) were completed changed (less memory usage)
                * SwapRGB is now realtime
                * fixed LensHLine/LensBar (for clipping and 32bpp) and speed increased
                * better code organization
                ~ color conversion is now little diferent and more usable
                ~ changed all loading functions (now without big temporary buffer)
                ~ automatically setting clipper to full size after loading bitmaps
                ~ fixed SetClipper (clipping clipper)
                ~ fixed LoadFromBMPFile (I hope definitive), DrawLens
                ~ fixed color overflow bug

   18.11.2000 - + added Clipping support (uf, ;-) but not for "FullScreen" functions like Antialiasing,MotionBlur...
                + added RefreshRect (for apGDI only), refresh only part of screen
                + added DrawAlpha /alpha must be same size as bitmap (now)
                + added TAlpha64 class for DrawAlpha()
                / cleanup code
                + bit DrawLens speedup

   10.10.2000 - ~ fixed LoadFromBMPFile
                ~ fixed DrawGrayscale,DrawColorize ;)
                + added DrawLight, for lighting effects ...

   24.09.2000 - ~ fixed WinColor function
                ~ fixed SwapRGB for 32bpp
                ~ fixed DrawLens (with transparent=true) for 32bpp
                - Triangle "bug" removed (always was only LensTriangle...)
                + added PixelPtr property
                + added DrawColorize effect  (see example for more info)
                + changed ConvertToGrayscale into DrawGrayscale (with speed increased to realtime)
                ! Don't use LoadFromBMPFile nor LoadFromTGAFile in TScreen64!!!

   31.08.2000 - + New Direct64 unit for DirectX 7. Note: You must have DirectX 7 installed!
                + added 32bit(bpp) rendering; without these: MotionBlur,Antialiasing,LoadFromRSBFile,TextureMap,
                  ;-)
                ~ Corrected SwapRGB,Refresh,ClearSurface for GDI,
                ~ corrected LensHLine
                ~ corrected UnpackRGB
                + added ConvertToGrayScale
                + added overload TScreen.Create
                + added Triangle

   16.06.2000 - ~ Corrected bug in TScreen with WDosX, any optimizations.
                  SaveToTGAFile now works with TScreen64
                - Ops, in previous release stupid error was in SetSize procedure (changed width with height),
                  now all is OK
   12.06.2000 - ~ TBitmap64.AssignData updated,
                v 0.3 alpha
                  Note: This is Alpha release of graph64 --> many functions like:
                  LoadFromBMP/TGA/RSBFile, SaveToTGAFile,MotionBlur,SetSize,SetWidth,SetHeight,ConverXXtoYY
                  are not stable after using AssignData...
   06.06.2000 - + added support for internal transparent compression.
   31.05.2000 - ~ Bug: Don't use LoadFromTGAFile/LoadFromBMPFile with TScreen64 !!!
                  (it doesn't work with all cards)
                + added Rectangle.
                ~ Corrected bug in LensBar,
                + added manual (not perfect but IS) see www.graph64.miesto.sk/manual.htm
   28.05.2000 - ? Antialiasing now works OK (but it's extremly slow)
   23.05.2000 - + added support for TBitmap64/TScreen64 resizing: Width,Height, SetSize(x,y)
                  TScreen64 resizing work only in GDI applications not in DirectX nor WDosX
                  !!!DON'T USE MOTION BLUR OR ANTIALIASING FUNCTIONS IN GDI APPLICATIONS NOW!!!
   17.05.2000 - + Port to Free Pascal Compiler started, but compiler crash on 508 line of code.
                  Changed: Integer>>Longint (for FPC compability, because in FPC Integer is -32768 .. 32767)
   06.05.2000 - + added: LensHLine, LensBar
   05.05.2000 - + screen.create( YourCanvas: TImage) changed to screen.create( YourScreen: TPaintBox;Auto: Boolean)
                  more info see in source code for this constructor
                * corrected bug in GDI with exclusive graphics cards like: 3DLabs Permedia1/2, S3 Trio3D...
   14.04.2000 - + added new Constructor AssignData
                + added Animation support(Beta)!!! To create animations use my editor!!!
                  TAnim64.Create, Destroy,DrawFrame,NextFrame,FirstFrame,GotoFrame
   04.04.2000 - * Vesa 1.2+ ,DirectX 6+ and GDI works fine on all graphics cards, now!!!(report me if not)
   27.03.2000 - + added UnpackRGB(), fixed problem in TBitmap64.Destroy()
                * LoadFromBMPfile now works perfectly :-) without RLE compression
   19.03.2000 - + added func. Antialiasing, SwapRGB
   20.02.2000 - + added support for uncompressed BMP files,
                + added conversion procedure g64ConvertBitmap ()
   09.02.2000 - ~ Removed all OVERLOAD declarations for Delphi 3 compatibility!
                + added Ellipse, Circle
                  What else? Only cosmetic decorations.
   20.01.2000 - * Many correction for GDI support, clear up code (hints), now it's faster
                  replaced all Longint to Longint :-)
                + added LensLine, LensPixels[ x,y]
   12.01.2000 - * Ehm, GDI idea.
                  M$ Windows DIB is reverse!
                  Changed TBitmap to TBitmap64, TScreen to TScreen64 ...
                  for GDI application use something like this:

                  MyScreen:= TScreen64. Create( Image1);  (where Image1 is standart TImage)
                  MyScreen. BackBuffer.Canvas.Draw(0,0, YourWindowsBitmap); (backbuffer is standart TBitmap)
                  MyScreen. Line(0,0, MyScreen. Width, MyScreen. Height, 0);
                  MyScreen. Refresh;                      (screen is TScreen64 type)

   04.01.2000 - * New homepage http://www.graph64.miesto.sk
   26.12.1999 - * Any correction (perfomace, clear...)
                + added new overload DrawBlend
   12.12.1999 - Now DrawBlend works well for bitmaps
   11.12.1999 - + added Perspective correct texture mapping. Original cpp code: REDOX, e-mail: redox@bbs.infima.cz
                  TBitmap. TexTriangle ()
   03.12.1999 - * DirectX bug corrected : diferent size of BackSurface (on Savage4 always 1024)
                * DirectX slow bug fixed (DDSCAPS_SYSTEMMEMORY, this is in 99% fastest than VIDEOMEMORY)
   22.11.1999 - * Any bugs fixed in 15bpp resolutions
                + antialiasing for fonts,
   21.11.1999 - + added TBitmap. MotionBlur - realtime effects -> low quality
                + added TBitmap. FlipVertical (for all bpp)
   19.11.1999 - * Nothing in Graph64 but Input64 added for keyboard support
   12.11.1999 - Now Pixels[ x,y] works OK (write/read)
   06.11.1999 - Added support for fonts with unit FONTS,
                * font convertor /from Windows fonts to Bitmap
   27.10.1999 - Added TBitmap. DrawBlend
                Added TBitmap. SaveToTGAFile
                ~ problems with DrawLens,DrawBlend in DirectX, WDosX: 21 fps and DirectX: 2 fps!!
                / removed DrawAlpha
   11.10.1999 - Added support for Red Storm Bitmaps, TBitmap. LoadFromRSBFile
   20.09.1999 - Added TBitmap. DrawLens (15/16bit)- it's like blending but only
                50% from SourceRGB + 50% from DestRGB = DestationColor ... and FASTER!
   09.09.1999 - * correct bug in TBitmap. Draw, Alpha don't work now,
   08.09.1999 - In directX you have two pages (FrontSurface,BackSurface)!
                + added support for 15bpp, updated: LoadFromTgaFile,RGB,Line,Bar...
                + added TBitmap.FlipHorizontal (only 15bpp and 16bpp)

   07.09.1999 - * First release which works under Win9x with DirectX 6
                + added unit Direct64 for DirectX control
                + added Lock , Unlock for TScreen
                 For details see TScreen. Lock

                + add '$define win9x'(in param.inc) if you can DirectX application!
                ~ problems with Directx, 16bpp is 15bpp...
   06.09.1999 - DirectX idea ;-)
   25.08.1999 - Noname OS (TM)(r) destroy me one partition on my HDD, two weeks of my work was lost

   01.08.1999 - added CleanSurface (),Line ()...
   11.07.1999 - added DrawAlpha; support for Transparent mode in Draw,
   23.06.1999 - added LoadFromTGAFile for 15,16,24,32 bit uncopressed TGA files for 16bpp bitmaps,
                added Draw procedure (ala canvas. draw in Windows(TM)(R)(C)(..))
   10.06.1999 - First version, now without any ASM Code ;)
                all functions is very slow without any optimization
                only 16bpp
}

unit graph64;

interface

uses
     {$IFDEF win9x}
      Direct64,  {unit for control DirectX functions}
     {$ENDIF}
     {$IFDEF apGDI}
      Windows,Graphics,ExtCtrls,Dialogs,Classes,
     {$ENDIF}
     {$IFDEF wdosx}
      vbe,       {cool Tippach unit for vesa support}
      fbuffers,  {memory for offscreen drawing ,TDDSurface...}
      crt,
     {$ENDIF}

      SysUtils;  {standart Delphi unit for all platforms}

{$IFNDEF apGDI}
{$IFNDEF win9x}
//this is only for non GDI/DirectX targets
type
  TPoint = record
    X: Longint;
    Y: Longint;
  end;

type
  TRect = record
  case Longint of
    0: (Left, Top, Right, Bottom: Longint);
    1: (TopLeft, BottomRight: TPoint);
  end;
{$ENDIF}
{$ENDIF}

type
  PWord= ^Word;
  PByte= ^Byte;
  PLongint= ^Longint;
  PDWord= ^Longint;

  TRGB= packed record
    b,g,r: byte;
  end;

  TRGB24= packed record
    R,G,B: byte;
  end;

  TRGB32= packed record
    b,g,r,A: byte;
  end;

  TRGB16= Word;
  TRGB8=  Byte;
  PRGB=   ^TRGB;
  PRGB24= ^Trgb24;
  PRGB32= ^Trgb32;

const pf1bit= 1;     {pixel format}
      pf4bit= 4;
      pf8bit= 8;
      pf15bit= 15;
      pf16bit= 16;
      pf24bit= 24;
      pf32bit= 32;
      pfCustom= $ff;

      g64DefaultPixelFormat = pf15bit;
      tmDisabled= -1;
      tmAuto=     -2;
type

  T2DPixel = record
    x,y: single;
  end;

  T3DPixel = record
    x,y,z: single;
  end;

  g64Error = word;

  TCLine=array[0..0]of word;

  PPalette64=^TPalette64;
  TPalette64=array[0..255]of TRGB;
  //end;  {enable this for total compiler DEATH! he ;-) }
  TPixelFormat = word;

  TFilter64= record
    Factor: Longint;
    Matrix: array[0..8] of Longint;
  end;

type
  TCompressBitmap= Class
    FLines,FData: Pointer;
    LineSize: ^TCLine;
    Height,Width: Longint;

    constructor Create( filename: string);
    destructor Destroy;override;
    function GetScanLine( row: Longint): pointer;

    property ScanLine[ Row: Longint]: pointer read GetScanLine;
  end;

type
  TBitmap64= Class;

  TAlpha64= class    //always only 8bpp, and doesn't supported well, now :-(

    private
      Data: Pointer;
      function GetPixelPtr( x,y: Longint): Pointer;

    public

      Width,Height: Longint;

      constructor Create;
      destructor Free;
      procedure SetFromBitmap( b:TBitmap64);
      procedure SetSize( NewWidth, NewHeight: Longint);
      property PixelPtr[x,y: Longint]: Pointer read GetPixelPtr;

  end;


    TBitmap64= Class{( TObject)}    {Main class for all drawing functions...}
      private

        bmWidth,
        bmHeight,                  {how many bytes we need for one pixel (16bpp= 2, 24bpp= 3 ...)}
        bmBpp: Longint;
        bmBitsPixel: TPixelFormat; {color depth : pf8bit,pf16bit,pf32bit... }
        bmBits: Pointer;           {pointer for bits}


        RBitMask,GBitMask,BBitMask: Cardinal; {for DirectX compability, and for VBE !!!}
        RStart,GStart,BStart:Byte;

        bmLeftStart: Longint;
        linePitch: Longint;
        WasAssigned: boolean;
        Palette :PPalette64; //only for 8bpp
        Clipper :TRect;

        function    GetPixelFormat: TPixelFormat;virtual;
        procedure   SetPixelFormat( value: TPixelFormat);virtual;
        function    GetScanLine( row: Longint): pointer;virtual;
        procedure   SetWidth( value: Longint);virtual;
        procedure   SetHeight( value: Longint);virtual;
        procedure   PutPixel( x,y,color: Longint);virtual; {draw one pixel on x,y coordinates}
        function    GetPixel( x,y: Longint): Longint;virtual; {get color from x,y coordinates}
        function    GetPixelPtr( x,y: Longint): Pointer;virtual; {get pointer to pixel on x,y coordinates}
        procedure   PutLensPixel( x,y,color: Longint);virtual;
        procedure   GrayscaleMem( source, target: Pointer;size: Longint;pf: TPixelFormat);virtual;
        procedure   BuildColors;virtual;
        function    Clip( const bitmap: TBitmap64; var x,y, SizeX, SizeY, StartX, StartY: Longint): boolean;virtual;
        procedure   SetupBits;

      public

        TransparentColor: Longint;
        Transparent: boolean;

      //constructors and others
      constructor  Create;overload;
      constructor  Create( xres:Longint; yres:Longint; pixf: TPixelFormat);overload;
      constructor  AssignData( xres,yres: Longint; pixf: TPixelFormat;data: pointer;LineSize: longint);
      destructor   Destroy;override;
      procedure    SetSize( NewWidth, NewHeight: Longint);virtual; {set new size for bitmap, Picture data (pixmap) will be destroyed}

      //standart drawing functions
      procedure  HLine( x,y,x1,color: Longint);virtual; {draw horizontal line from x,y to x1,y }
      procedure  VLine( x,y,y1,color: Longint);virtual;{draw vertical line from x,y to x,y1   }
      procedure  Circle( x,y, size, color: Longint);virtual;
      procedure  Triangle( x1,y1, x2,y2, x3,y3,color:Longint);virtual;
      procedure  LensLine( x,y, x1,y1, color: Longint);virtual;
      procedure  LensHLine(x,y,x1,color: Longint);virtual; {draw horizontal line with lens}
      procedure  Bar( x,y,x1,y1,color: Longint);virtual;{draw filled rectangle from x,y, to x1,y1 with color}
      procedure  Rectangle( x,y, x1,y1,color: Longint);virtual;
      procedure  LensBar( x,y,x1,y1,color: Longint);virtual; {draw Lens rectangle from x,y to x1,y1 with color}
      procedure  SetClipper( x,y, x1,y1: Longint);overload;
      {$ifndef apFPC}
      procedure  SetClipper( rect: TRect);overload;
      procedure  SetClipper;overload;
      {$endif}

      //files manipulation
      {$ifdef apGDI}  //only for GDI, but if your compiler support TStream and TFileStream you can remove it
      procedure   LoadFromBMPStream(f: TStream);virtual;
      procedure   LoadFromTGAStream(f: TStream);virtual;
      {$endif}
      procedure   LoadFromTGAFile( s: string);virtual;
      procedure   LoadFromBMPFile( s: string);virtual;
      procedure   LoadFromRSBFile( s: string);virtual;
      procedure   SaveToTGAFile( s: string);virtual;
      //any effects

      function    UnpackRGB ( what: Longint): TRGB;virtual;
      function    RGB( r,g,b: byte): Longint;virtual;
      {$ifdef apGDI}
      function    WinColor( color: TColor): Longint;virtual;
      {$endif}

      procedure   DoFilter( filter: TFilter64); // non-supported yet
      procedure   Draw( x,y: Longint; b:TBitmap64);virtual;
      procedure   DrawAlpha( x,y: Longint; b:TBitmap64;Alpha: TAlpha64);virtual;
      procedure   DrawBlend( x,y: Longint; b:TBitmap64; sfactor,dfactor: single);virtual;
      procedure   DrawBlendRGB( x,y: Longint; b:TBitmap64; rfactor,gfactor,bfactor: single);virtual;
      procedure   DrawBrightness( x,y: Longint; b: TBitmap64; Intensity: Longint);virtual;
      procedure   DrawColorize( x,y: Longint; b:TBitmap64; RFactor,GFactor,BFactor: Longint;Light:Byte);virtual;
      procedure   DrawCompressed( x,y: Longint; b: TCompressBitmap);// non-supported yet
      procedure   DrawGrayscale(x,y: Longint; b:TBitmap64);virtual;
      procedure   DrawLens( x,y: Longint; b:TBitmap64);virtual; {}
      procedure   DrawLight( x,y: Longint; bitmap:TBitmap64; r,g,b: byte);virtual;
      procedure   DrawGlyph( x,y: Longint; bitmap:TBitmap64; PartNumber, Parts: Longint);virtual;

      procedure   DrawResize( x,y, NewWidth, NewHeight: Longint; b: TBitmap64);virtual;// non-supported yet

      procedure   Ellipse ( x, y, xsize, ysize, color: Longint);virtual;
      procedure   FlipHorizontal;virtual;
      procedure   FlipVertical;virtual;

      procedure   Line( x,y, x1,y1, color: Longint);virtual;  {draw normal line from x,y to x1,y1 with color}

      procedure   MotionBlur;virtual;
      procedure   Antialiasing;virtual;
      procedure   Antialiasing2;virtual;
      procedure   SwapRGB;virtual;  //swap windows BGR format to normal RGB format
      procedure   Scan_line( xl,xr,ul,ur,vl,vr,zl,zr: single; y: Longint;texture: TBitmap64);virtual;
      procedure   TextureMap( p1,p2,p3: T3DPixel;t1,t2,t3: T2DPixel;textura: TBitmap64);virtual;

      //experimental only
      function  CompressToFile( filename: string):boolean;

      //property ...
      property Height: Longint read bmHeight write SetHeight;
      property Width: Longint read bmWidth write SetWidth;
      property PixelFormat: TPixelFormat read GetPixelFormat write SetPixelFormat;
      property ScanLine[ Row: Longint]: pointer read GetScanLine; {ala Delphi, see delphi help in TBitmap...}
      property Pixels[ X,Y: Longint]: Longint read GetPixel write PutPixel;
      property PixelPtr[ x,y: Longint]: Pointer read GetPixelPtr;
      property LensPixels[ X,Y: Longint]: Longint read GetPixel write PutLensPixel;

     end;

    {screen drawing function}
    TScreen64= class( TBitmap64)

    private
        RefreshRate: Longint;

    public
    {$IFDEF wdosx}
        Surface: TDDSurface;
        MyScreen: TVbeInterface;   {manipulation with vesa functions}
    {$ENDIF}

    {$IFDEF apGDI}
        BackBuffer: TBitmap;  {This is back buffer bitmap (from standart graphics unit)
                               In windows GDI I use system bitmap...}
        gCanvas:    TCanvas;
    {$ENDIF}

     {$IFDEF apGDI}
      constructor Create( YourScreen: TPaintBox;MaxSize,AutoHandle: boolean;pixf:TPixelFormat);overload;
      constructor Create( YourCanvas: TCanvas; xres,yres: Longint;pixf:TPixelFormat);overload;
      constructor Create( xres,yres: Longint;pixf:TPixelFormat);overload;
      procedure   OnPaint( Sender: TObject);
      procedure   SetSize( ValueX, ValueY: Longint);override;
      procedure   SetWidth( value: Longint);override;
      procedure   SetHeight( value: Longint);override;

      property    Height: Longint read bmHeight write SetHeight;
      property    Width: Longint read bmWidth write SetWidth;
      {$ELSE}
      constructor Create( xres,yres: Longint; pixf: TPixelFormat;_refresh: Longint);
     {$ENDIF}
      procedure   Refresh;
      procedure   RefreshRect( x1,y1,x2,y2: Longint);

      procedure   ClearSurface( color: Longint);
      procedure   Lock;  {for DirectX comp.}
      procedure   UnLock;{    - II -   }
      destructor  Destroy;override;
     end;

    //conversion functions between supported color depht
    procedure g64ConvertBitmap( source, destation: Pointer; size: cardinal; fromBits, toBits: byte);
    procedure g64Convert24to16( source, destation: Pointer; size: cardinal);
    procedure g64Convert24to15( source, destation: Pointer; size: cardinal);
    procedure g64Convert24to32( source, destation: Pointer; size: cardinal);
    procedure g64Convert32to15( source, destation: Pointer; size: cardinal);
    procedure g64Convert32to16( source, destation: Pointer; size: cardinal);
    procedure g64Convert15to16( source, destation: Pointer; size: cardinal);
    procedure g64Convert15to32( source, destation: Pointer; size: cardinal);
    procedure g64Convert16to32( source, destation: Pointer; size: cardinal);
    procedure g64Convert16to15( source, destation: Pointer; size: cardinal);


//here is Animation support
type PAnimImage= ^TAnimImage;
     TAnimImage= record
       Data: Pointer;
       Width,Height: Longint;
       Transparent: boolean;
       TransparentColor: word;
       next: PAnimImage;
     end;


type PSprite= ^TSprite;  //This is for Delphi 2/3 compatibility instead of dynamic arrays
     TSprite= record
       ImageIndex: Longint;
       DImageIndex: PAnimImage; //pointer to Image
       PosX,PosY: Longint;
       Blend: boolean;
       SFactor,DFactor: single;
       next: PSprite;   //pointer to next sprite
     end;

type PAnimFrame= ^TAnimFrame;
     TAnimFrame= record
       FSprite: PSprite;  //first sprite
       Sprites: Longint;
       next: PAnimFrame;
     end;

Type TAnim64= class{(TObject)}
       AFrame,             //active image
       FFrame: PAnimFrame; //first frame
       FImage: PAnimImage; //first image
       CurFrame,           //current frame
       Frames,
       Images: Longint;
       pixelformat: Graph64.TPixelFormat;
       constructor Create( filename: string; pixelFormat1: Graph64.TPixelFormat);
       destructor Destroy;override;
       procedure DrawFrame( where: TBitmap64;x,y: Longint);
       procedure FirstFrame;
       procedure LastFrame;
       procedure NextFrame;
       procedure GotoFrame( whichframe: Longint);

     end;

{$IFDEF debug}
var
  DebugFile: text;
{$ENDIF}

implementation

Procedure SwapL( var a,b: Longint);
var c: Longint;
begin
  c:=a;
  a:= b;
  b:= c;
end;

Procedure SwapW( var a,b: word);
var c: word;
begin
  c:=a;
  a:= b;
  b:= c;
end;

constructor TCompressBitmap. Create( filename: string);
var f: file;
begin
  AssignFile( f, filename);
  reset (f,1);
  BlockRead( f, Width, 4);
  BlockRead( f, Height, 4);
  GetMem( FLines, Height*2);
  BlockRead( f, FLines^, Height*2);
  GetMem( FData, FileSize( f) -FilePos(f));
  BlockRead(f, FData^, FileSize( f) -FilePos(f));
  LineSize:= FLines;
{$IFDEF debug}
  writeln( debugfile, Byte(FData^));
{$ENDIF}
  CloseFile( f);
end;

destructor TCompressBitmap. Destroy;
begin
  FreeMem( FData);
  FreeMem( FLines);
  FData:= nil;
  FLines:= nil;
  FData:= nil
end;

function TCompressBitmap. GetScanLine( row: Longint): pointer;
var xx,size: Longint;
    temp: pointer;
begin
  if row=0 then result:= FData else
  begin
    size:= 0;
    for xx:=0 to row-1 do Inc( size, LineSize^[xx]);
    temp:= FData;
    asm
      mov eax, temp
      add eax, size
      mov temp, eax
    end;
    result:= temp;
  end;
end;

constructor TAlpha64.Create;
begin
  Inherited create;
  Width:= 0;
  Height:= 0;
  Data:= nil;
end;

destructor TAlpha64.Free;
begin
  if Assigned( Data) then
    FreeMem( Data);
  Data:= nil;

end;

procedure TAlpha64.SetSize( NewWidth, NewHeight: Longint);
begin
  if (NewWidth=Width)and(NewHeight=Height) then exit; //nothing to change

  if data<>nil then FreeMem( Data);   //free up memory
  Width:= NewWidth;
  Height:= NewHeight;
  GetMem( Data, Width*Height);

end;

procedure TAlpha64.SetFromBitmap( b:TBitmap64);
var xx,yy: Longint;
    p: PByte;
    tmp: TBitmap64;
begin
  tmp:= TBitmap64.Create( width, height, b.PixelFormat);
  tmp.Bar(0,0, Width,Height, 0);
  tmp.DrawGrayscale(0,0, b);

  for yy:= 0 to Height-1 do
  begin
    p:= PixelPtr[0,yy];
    for xx:= 0 to Width-1 do
    begin
      p^:= tmp.UnpackRGB( tmp.Pixels[xx,yy]).b;
      inc( p);
    end;
  end;

  tmp.Destroy;
end;

function TAlpha64.GetPixelPtr( x,y: Longint): Pointer;
var p: PByte;
begin

  if not Assigned( Data) then
  begin
    result:= nil;
    exit;
  end;
  p:= Data;
  inc( p, x+y*Width);
  result:= p;

end;

{ ------------------------ Start code for TBitmap64 ------------------ }

procedure TBitmap64.SetupBits;
begin
  bmLeftStart:= 0;
  case PixelFormat of
  pf15bit: begin       {normal 555 format for 15bpp resolutions}
             RBitMask:= $7c00;
             GBitMask:= $03e0;
             BBitMask:= $001f;
             RStart:= 10;
             GStart:= 5;
             BStart:= 0;
            end;
   pf16bit: begin       {normal 565 format for 16bpp resolutions}
             RBitMask:= $f800;
             GBitMask:= $07e0;
             BBitMask:= $001f;
             RStart:= 11;
             GStart:= 5;
             BStart:= 0;
            end;
   pf24bit,pf32bit: begin        { 888 format for 24bpp, a888 format for 32bit, a-alpha,not used yet}
             RBitMask:= $ff0000;
             GBitMask:= $00ff00;
             BBitMask:= $0000ff;
             RStart:= 16;
             GStart:= 8;
             BStart:= 0;
            end;
  end;
end;

Constructor TBitmap64. Create;
begin
  WasAssigned:= False;
  WasAssigned:= false;
  Palette:= nil;
  bmWidth:=  0;
  bmHeight:= 0;
  PixelFormat:= g64DefaultPixelFormat;
  transparent:= false;
  transparentColor:= 0;
  bmBpp:= (PixelFormat + 7) shr 3;
  bmBits:= nil;
  SetSize( 0, 0);
  linePitch:= bmBpp*bmWidth; //set default line pitch
  SetupBits;
  {$ifdef apFPC}
    SetClipper(0,0,bmWidth,bmHeight);
  {$else}
    SetClipper;
  {$endif}


end;

Constructor TBitmap64. Create( xres:Longint; yres:Longint; pixf: TPixelFormat);
begin
  WasAssigned:= false;
  Palette:= nil;
  bmWidth:=  0;
  bmHeight:= 0;
  PixelFormat:= pixf;
  transparent:= false;
  transparentColor:= 0;
  bmBpp:= (PixelFormat + 7) shr 3;
  bmBits:= nil;
  SetSize( xres, yres);
  linePitch:= bmBpp*bmWidth; //set default line pitch
  SetupBits;
  {$ifdef apFPC}
    SetClipper(0,0,bmWidth,bmHeight);
  {$else}
    SetClipper;
  {$endif}

end;

Constructor TBitmap64.AssignData( xres,yres: Longint; pixf: TPixelFormat;data: pointer;LineSize: longint);
begin
  WasAssigned:= true;
  bmWidth:=  xres;
  bmHeight:= yres;
  PixelFormat:= pixf;
  transparent:= false;
  transparentColor:= 0;
  bmBpp:= (bmBitsPixel + 7) shr 3;
  linePitch:= LineSize;
  bmBits:= data;
  SetupBits;
end;

Destructor TBitmap64. Destroy;
begin

  if not WasAssigned then  //only when TBitmap was created
  begin
    if bmBits<>nil then FreeMem( bmBits);
    bmBits:= nil;
  end;

  inherited destroy;
end;

procedure TBitmap64. SetClipper( x,y, x1,y1: Longint);
begin
  if x>x1 then SwapL( x,x1);
  if y>y1 then SwapL( y,y1);

  // Clip the clipper first
  if x1>Width-1 then x1:= Width-1;
  if y1>Height-1 then y1:= Height-1;

  if y<0 then y:= 0;
  if x<0 then x:= 0;

  with Clipper do
  begin
    Left:= x;
    Top:=  y;
    Right:= x1;
    Bottom:= y1;
  end;

end;

{$ifndef apFPC}
procedure TBitmap64.SetClipper;
//set clipper to maximum viewport
begin
  with Clipper do
  begin
    Left:= 0;
    Top:= 0;
    Right:= Width-1;
    Bottom:= Height-1;
  end;
end;

procedure  TBitmap64. SetClipper( rect: TRect);
begin
  Clipper:= rect;
end;
{$endif}

procedure TBitmap64. BuildColors;
{NEED funct}
var i: Longint;
    f: file of byte;
begin

  if Not Assigned(Palette) then New( Palette);

  AssignFile( f,'default.pal'); //this is not ideal way
  Reset( f);
  for i:= 0 to 255 do
  with Palette^[i] do
  begin
     Read( f, r);
     Read( f, g);
     Read( f, b);
//     r:= r*4;
//     g:= g*8;
//     r:= r*4;
     r:= r*4;
     g:= g*4;
     b:= b*4;
  end;
  CloseFile( f);

{  for i:= 0 to 255 do  //this one create "universal" 3-3-2 palette
  with Palette^[i] do
    begin
      r:= (i shr 5) *36;
      g:= ((i shr 2) and 7) * 36;
      b:= ( i and 3) *85;
    end;
}
end;

procedure TBitmap64. DrawCompressed( x,y: Longint; b: TCompressBitmap);
var xx,yy: Longint;
    p: PWord;
    pb: PByte;
begin

for yy:= 0 to b.height-1 do
begin
  xx:= 0;
  pb:= b.ScanLine[yy];     //source
  p:= ScanLine[yy+y];    //destation
  inc( p, x);
  repeat
    if (pb^ and 128)=128 then
    begin
      inc( p, pb^ and 127);
      inc( xx, pb^ and 127);
      inc( pb);
    end
    else
    begin
      inc( xx, pb^);
       asm
         push esi
         push edi

         mov esi, pb
         mov edi, p
         xor ecx, ecx
         mov cl, [esi]
         inc esi
         rep movsw

         pop edi
         pop esi
       end;
       inc( p, pb^);
       inc( pb, pb^*2);
       inc( pb);
    end;

  until xx>=b.Width;
end;

end;

function TBitmap64. CompressToFile( filename: string):boolean;
{This function is not supported!!!!}
type
  PLine=^TLine;
  TLine=array[0..0]of Word;

var temp: Pointer;
    Line: PLine;
    P,P1: PWord;
    xx,yy,x: Longint;
    z: byte;
    counter: word;
    Start: longint;
    f: File;
{
 0 -transparent color
 12 0 0 0 0 0 12 12 12 0 0 0 3
 b   w   b           w  b   w  w  w
 1, 12,  5 and  127, 0, 3, 12,12,12,
}
begin
 if (not transparent) or (height<1) then begin result:= false;exit;end;
 result:= true;

 AssignFile( f, filename);
 rewrite(f,1);

 GetMem( temp, Height*2);  //memory for line offsets
 Line:= temp;

 BlockWrite( f, bmWidth, 4);
BlockWrite( f, bmHeight, 4);
start:= FilePos(f);
BlockWrite( f, temp^, Height*2);
for yy:= 0 to height-1 do
begin
  p:= ScanLine[yy];
  x:= 0;
  counter:= 0;
  repeat
    If p^= TransparentColor then
    begin
      z:= 0;
      while (p^=TransparentColor)and(x<Width)and(z<127) do begin Inc( p);inc(z);inc(x);end;
      Inc( counter, 1);
      z:= z or 128;
      BlockWrite( f, z, 1);
    end
    else
    begin
      z:= 0;
      p1:= p;
      while (p^<>TransparentColor)and(x+z<Width)and(z<127) do begin Inc(p);inc(z);end;
      Inc( counter, z*2+1);
      BlockWrite( f, z, 1);
      p:= p1;
      for xx:=1 to z do
      begin
        BlockWrite( f, p^, 2);
        inc( p);inc(x);
      end;
    end;
  until x>=Width;
  Line^[yy]:= counter;
end;

  Seek(f, start);
  BlockWrite( f, temp^, height*2);
  FreeMem( temp);
  CloseFile(f);
end;

procedure TBitmap64. FlipVertical; {only for pf15bit or pf16bit or pf32bit or pf8bit}
var s,d: PWord;
    yy: Longint;
    temp: pointer;
begin

GetMem( temp, width*bmbpp);
for yy:=0 to (height-1)div 2 do
begin
  s:= scanline[yy];
  d:= scanline[height-1-yy];
  move( s^, temp^, width*bmBpp);
  move( d^, s^, width*bmBpp);
  move( temp^, d^, width*bmBpp);
end;

FreeMem( temp);
end;


procedure TBitmap64. FlipHorizontal; {only for pf15bit or pf16bit or pf32bit}
{Flip image horizontal (mirror)}
var s,d: PWord;
    s1,d1:PLongint;
    xx,yy: Longint;
begin

if (bmBitsPixel=pf15bit)or(bmBitsPixel=pf16bit)then
  begin
    for yy:= 0 to height-1 do
      begin
        s:= ScanLine[yy];
        d:= ScanLine[yy];
        Inc( d, width-1);
        for xx:= 0 to  (width-1) div 2 do
          begin
            SwapW( s^,d^);
            inc( s);dec( d);
          end;
      end;
  end;

if bmBitsPixel=pf32bit then
  begin
    for yy:= 0 to Height-1 do
      begin
        s1:= ScanLine[yy];
        d1:= ScanLine[yy];
        Inc( d1, Width-1);
        For xx:= 0 to (Width-1) div 2 do
          begin
            SwapL( s1^,d1^);
            Inc( s1);Dec(d1);
          end;
      end;

  end;

end;

procedure TBitmap64. LoadFromRSBFile( s: string);
{RSB - Red Storm Bitmap}
var f: file;
    lx,ly: Longint;

begin
  if self is TScreen64 then
   begin
     raise exception.create('You can''t load images into TScreen64!!!');
     exit;
   end;

if (bmBitsPixel= pf16bit)or(bmBitsPixel= pf15bit) then else exit;

  assignFile( f, s);
  FileMode:= 0;  {read only}
  reset( f ,1);
  seek( f, 4);
  BlockRead( f, lx, 4);
  BlockRead( f, ly, 4);
  seek( f, 32); {to start data}
  bmWidth:= lx;
  bmHeight:= ly;
  ReAllocMem( bmBits, Longint( bmBpp*bmWidth*bmHeight) );  {for new resolution of bitmap}
  BlockRead( f, bmBits^, bmWidth*bmHeight*bmBpp);
  CloseFile( f);
  {$ifdef apFPC}
    SetClipper(0,0,bmWidth,bmHeight);
  {$else}
    SetClipper;
  {$endif}

end;

procedure TBitmap64. SaveToTGAFile( s: string);
var f: file;
    r,g,b: Byte;
    w,wx,wy: word;
    xx,yy: Longint;
    TempData: pointer;
    target,p: PWord;
    p1:PRGB32;

begin
  AssignFile( f, s);
  Rewrite( f,1); {file exists? WHAT now??!?! exception??}
  w:= 0;
  BlockWrite( f, w, 2);
  w:= 2;  {uncompressed tgaformat}
  BlockWrite( f, w, 2);
  w:= 0;
  for xx:= 0 to 3 do BlockWrite( f, w, 2); {fill header with zero's}
  wx:= bmWidth;
  wy:= bmHeight;
  BlockWrite( f ,wx, 2);
  BlockWrite( f, wy, 2);
  w:= 16;
  BlockWrite( f, w, 2); {16 bit tga format}
  b:= 0;
  BlockWrite( f, b, 0);

  FlipVertical;
  GetMem( TempData, bmWidth*bmHeight*2{bmbpp});
  target:= TempData;

  if bmBpp=2 then //for 15/16 bit bpp
  begin
    if pixelFormat=pf16bit then w:= GStart +1 else w:= GStart;
    for yy:= 0 to bmHeight-1 do
      begin
        p:= scanline[yy];
        for xx:= 0 to bmWidth-1 do
          begin
            r:= (p^ and RBitMask) shr RStart;
            g:= (p^ and GBitMask) shr w;
            b:= p^ and BBitMask;
            target^:= (r shl 10) or (g shl 5) or b;
            Inc( target);
            Inc( p);
          end;
      end;
  end;

  if bmBpp=4 then  //for 32bit bpp
  begin
    for yy:= 0 to bmHeight-1 do
      begin
        p1:= scanline[yy];
        for xx:= 0 to bmWidth-1 do
          begin
            r:= p1^.r shr 3;
            g:= p1^.g shr 3;
            b:= p1^.b shr 3;
            target^:= (r shl 10) or (g shl 5) or b;
            Inc( target);
            Inc( p1);
          end;
      end;
  end;

  BlockWrite( f, TempData^, 2*(bmWidth)*(bmHeight));
  FreeMem ( TempData);

  CloseFile( f);
  FlipVertical;
end;

{$ifdef apGDI}
procedure TBitmap64. LoadFromBMPStream(f: TStream);
type BitmapHeader= packed record
       Info: word;
       FileSize: cardinal;
       Res1,Res2: word;
       OffsetBits: cardinal;
     end;

type BitmapInformationHeader= packed record
       HeaderSize,
       Width,
       Height: cardinal;
       Row,  { always zero}
       BitCount: word; {1,4,8,24 (bits per pixel)}
       CompresionType,
       ImageSize,
       XPelsPerMeter,
       YPelsPerMeter,
       ColorsUsed,
       ColorsImportant: cardinal
     end;

var BHeader: BitmapHeader;
    BInformation: BitmapInformationHeader;
    xx,space,BMPbpp: Longint;
    Data: Pointer;
begin

  if self is TScreen64 then
  begin
    raise exception.create('Now, you can''t load images into TScreen64!!!');
    exit;
  end;

  if not Assigned(f) then exit;
  f.ReadBuffer(BHeader, SizeOf(BHeader));
  f.ReadBuffer( BInformation, SizeOf(BInformation));

  f.seek( -(SizeOf(BHeader)+SizeOf(BInformation))+BHeader.OffsetBits, soFromCurrent);
  SetSize( BInformation.Width, BInformation.Height);

  if BInformation.BitCount=16 then BInformation.BitCount:= 15;

  BMPbpp:= ((BInformation.BitCount + 7) shr 3);
  GetMem( Data, Width * BMPbpp); //temporary buffer for one line

  Space:= BInformation. Width mod 4;
  if Height>1 then
    for xx:=0 to Height-1 do
    begin
      f.Read( Data^, Width*BMPbpp);
      f.Seek( Space, soFromCurrent);//skip unused bytes
      g64ConvertBitmap( data, ScanLine[(Height-1)-xx], Width, BInformation.BitCount, PixelFormat);
    end;
  FreeMem( Data);

  if BInformation.BitCount<>15 then SwapRGB;
  SetClipper;

end;

procedure TBitmap64. LoadFromTGAStream(f: TStream);
var
    xx,yy: Longint;
    wx,wy: Word;
    TGAbpp,TGAFormat,TGAColors,AnyByte: Byte;
    Data: Pointer; //temporary memory

begin

  f.seek( 2, soFromCurrent);   //tga header
  f.ReadBuffer( TGAFormat, 1); //compressed or normal
  f.seek( 9, soFromCurrent);   //skip 9 unknown bytes
  f.ReadBuffer( wx, 2);        //width
  f.ReadBuffer( wy, 2);        //height
  f.ReadBuffer( TGAColors, 1); //TGA color format
  f.ReadBuffer( AnyByte, 1);   //stupid Byte (if image is bottom up orientation?)

  xx:= wx;
  yy:= wy;

  if TGAFormat = 2 then  {only uncompressed RGB}
  begin
    TGAbpp:= ((TGAColors + 7) shr 3); //how much bytes per pixel we have
    SetSize( xx,yy);                  //set new bitmap resolution
    If TGAColors= 16 then TGAColors:= 15; //no diference between this two formats in TGA

    GetMem( Data, TGAbpp*Width); //temporary memory for one line
    for yy:= 0 to Height-1 do    //for each line
    begin
      f.ReadBuffer( Data^, TGAbpp*Width); //read one line
      g64ConvertBitmap( Data, ScanLine[(Height-1)-yy], Width, TGAColors, PixelFormat); //convert into bitmap PixelFormat
    end;
    FreeMem( Data);             //free up used memory

    // note: this version use less memory than previous, but it's two handed weapon: when you loading bitmap from
    //       slow streams (as CDROM,FLOPPY) it's bit slow than load full image at once.

    if AnyByte and 32= 32 then FlipVertical; //if image is 'bottom up' orientation
    if TGAColors=24 then SwapRGB;           //24 bit TGA is BGR
  end; // end of uncompressed TGA

  SetClipper; //set clipper to fullscreen
end;

procedure TBitmap64. LoadFromTGAFile( s: string);
var f:TFileStream;
begin
  f:= TFileStream.Create(s, fmShareDenyNone);//we doesn't need full access
  try
    LoadFromTGAStream( f);
  finally
    f.Free;
  end;
end;

procedure TBitmap64. LoadFromBMPFile( s: string); //we save some line of code :-)
var f:TFileStream;
begin
  f:= TFileStream.Create(s, fmShareDenyNone);
  try
    LoadFromBMPStream( f);
  finally
    f.Free;
  end;
end;
{$endif}


{$ifndef apGDI}
{-------------------------------Platform without TStream support------------------------------}
procedure TBitmap64. LoadFromTGAFile( s: string);
{for comment see LoadFromTGAStream}
var f: file;
    xx,yy: Longint;
    wx,wy: word;
    TGAbpp,TGAFormat,TGAColors,AnyByte: byte;
    Data: pointer;

begin
  assignFile( f, s);
  reset( f,1);
  seek( f, 2);
  BlockRead( f, TGAFormat, 1);
  seek( f, 12);
  BlockRead( f, wx, 2);
  BlockRead( f, wy, 2);
  BlockRead( f, TGAColors, 1);
  Blockread( f, AnyByte, 1);
  xx:= wx;
  yy:= wy;

  if TGAFormat = 2 then  {only uncompressed RGB}
  begin
    TGAbpp:= ((TGAColors + 7) shr 3);
    SetSize( xx,yy);
    If TGAColors= 16 then TGAColors:= 15;

    GetMem( Data, TGAbpp*Width);
    for yy:= 0 to Height-1 do
    begin
      BlockRead( f, Data^, TGAbpp*Width);
      g64ConvertBitmap( Data, ScanLine[(Height-1)-yy], Width, TGAColors, PixelFormat);
    end;
    FreeMem( Data);

    if AnyByte and 32= 32 then FlipVertical;
    if TGAColors=24 then SwapRGB;
  end; // end of uncompressed TGA

  CloseFile( f);

  {$ifdef apFPC}
    SetClipper(0,0,bmWidth,bmHeight);
  {$else}
    SetClipper;
  {$endif}

end;

procedure TBitmap64. LoadFromBMPFile( s: string);//This is for Dos platform where unit classes doesn't exists
{Only 15 and 24 bpp BMP files are supported, now!!}
type BitmapHeader= packed record
       Info: word;
       FileSize: cardinal;
       Res1,Res2: word;
       OffsetBits: cardinal;
     end;

type BitmapInformationHeader= packed record
       HeaderSize,
       Width,
       Height: cardinal;
       Row,  { always zero}
       BitCount: word; {1,4,8,24 (bits per pixel)}
       CompresionType,
       ImageSize,
       XPelsPerMeter,
       YPelsPerMeter,
       ColorsUsed,
       ColorsImportant: cardinal
     end;

var f: file;
    BHeader: BitmapHeader;
    BInformation: BitmapInformationHeader;
    xx,space,BMPbpp: Longint;
    Data: Pointer;

begin

  if self is TScreen64 then
   begin
     raise exception.create('You can''t load images into TScreen64!!!');
     exit;
   end;

  if not FileExists( s) then exit;
  AssignFile( f, s);
  Reset(f, 1);
  BlockRead( f, BHeader, SizeOf(BHeader));

  BlockRead( f, BInformation, SizeOf(BInformation));
  seek( f, BHeader.OffsetBits);
  SetSize( BInformation.Width, BInformation.Height); //set new Bitmap size

  if BInformation.BitCount=16 then BInformation.BitCount:= 15; //this is for non standart 15 bpp BMP files
  BMPbpp:= ((BInformation.BitCount+ 7) shr 3);
  GetMem( Data, Width * BMPbpp); //temporary buffer for one line

  Space:= BInformation. Width mod 4;
  if Height>1 then
    for xx:=0 to Height-1 do
    begin
      BlockRead( f, Data^, Width*BMPbpp);
      Seek( f, FilePos(f)+Space);//skip unused bytes
      g64ConvertBitmap( data, ScanLine[xx], Width, BInformation.BitCount, PixelFormat);
    end;
  FreeMem( Data);

  if (BInformation.BitCount<>15) then SwapRGB;

  FlipVertical;

  CloseFile( f);

  {$ifdef apFPC}
    SetClipper(0,0,bmWidth,bmHeight);
  {$else}
    SetClipper;
  {$endif}

end;
{$ENDIF}
{----------------------------end of platform without TStream upport--------------------------}


{ -------------------------------------------------------------------------}
{ ------------------------- Conversion functions --------------------------}
{ -------------------------------------------------------------------------}

procedure g64Convert24to16( source, destation: Pointer; size: cardinal);
{convert 24 bit to 16 bit}
var s: ^TRGB24;
    d: PWord;
    xx: cardinal;
begin
 s:=  source;d:= destation;
 for xx:= 0 to size-1 do
 begin
   d^:= Word( ((s^.r div 8) shl 11)+((s^.g div 4)shl 5)+(s^.b div 8));
   inc( s);
   inc( d);
 end;
end;

procedure g64Convert24to15( source, destation: Pointer; size: cardinal);
{convert 24 bit to 15 bit}
var s: ^TRGB24;
    d: PWord;
    xx: cardinal;

begin
 s:= source;d:= destation;
 for xx:= 0 to size-1 do
 begin
   d^:= ((s^.r div 8) shl 10)+((s^.g div 8)shl 5)+(s^.b div 8);
   inc( s);
   inc( d);
 end;
end;

procedure g64Convert32to16( source, destation: Pointer; size: cardinal);
{convert 32 bit to 16 bit}
var s: PByte;
    d: PWord;
    r,g,b: byte;
    xx: cardinal;

begin
 s:= source;d:=  destation;
 for xx:= 0 to size-1 do
   begin
     b:= s^;Inc( s);
     g:= s^;Inc( s);
     r:= s^;Inc( s);
     Inc( s);  {skip alpha}
     d^:= ((r div 8) shl 11)+((g div 4)shl 5)+(b div 8);
     inc( d);
   end;
end;

procedure g64Convert32to15( source, destation: Pointer; size: cardinal);
{convert 32 bit to 15 bit}
var s: PByte;
    d: PWord;
    r,g,b: byte;
    xx: cardinal;

begin
 s:= source;d:=  destation;
 for xx:= 0 to size-1 do
   begin
     b:= s^;Inc( s);
     g:= s^;Inc( s);
     r:= s^;Inc( s);
     Inc( s);  {skip alpha}
     d^:= ((r div 8) shl 10)+((g div 8)shl 5)+(b div 8);
     inc( d);
   end;
end;

procedure g64Convert15to16( source, destation: Pointer; size: cardinal);
{convert 15 bit to 16 bit}
var s,d: PWord;
    r,g,b: byte;
    xx: cardinal;
begin
 s:=  source;d:=  destation;
 for xx:= 0 to size-1 do {convert 15 bit to 16 bit}
  begin
    r:= (s^ shr 10) and 31;  {shr 10}
    g:= ((s^ shr 5) and 31);  {shr 5}
    b:= s^ and 31;
//    d^:= (r shl 10) or (g shl 5) or b;
    d^:= (r shl 11) or (g shl 6) or b;
    Inc( s);
    inc( d);
 end;
end;

procedure g64Convert16to15( source, destation: Pointer; size: cardinal);
{convert 16 bit to 15 bit}
var s,d: PWord;
    r,g,b: byte;
    xx: cardinal;
begin
  s:=  source; d:= destation;
  for xx:= 0 to size-1 do {convert 16 bit to 15 bit}
    begin
      r:= (s^ shr 11) and 31;  {shr 10}
      g:= ((s^ shr 5) and 31);  {shr 5}
      b:= s^ and 31;
      d^:= (r shl 10) or (g shl 5) or b;
      Inc( s);
      inc( d);
    end;
end;

procedure g64Convert24to32( source,destation: Pointer; size: cardinal);
{Convert 24 bit to 32 bit}
var s: PRGB24;
    d: PLongint;
    xx: Cardinal;
begin
  s:= Source; d:= destation;
  for xx:= 0 to size-1 do
    begin
      d^:=(s^.r shl 16) or (s^.g shl 8) or (s^.b);
      Inc( s);
      Inc( d);
    end;
end;

procedure g64Convert15to32( source,destation:Pointer; size: cardinal);
{Convert 15 bit to 32 bit}
var s: PWord;
    d: PLongint;
    r,g,b: byte;
    xx: Cardinal;
begin
  s:= Source; d:= destation;
  for xx:= 0 to size-1 do
    begin
      r:= (s^ shr 10) and 31;
      g:= ((s^ shr 5) and 31);
      b:= s^ and 31;
      d^:= (r shl 19) or (g shl 11) or (b shl 3);
      Inc( s);
      Inc( d);
    end;
end;

procedure g64Convert16to32( source,destation:Pointer; size: cardinal);
{Convert 16 bit to 32 bit}
var s: PWord;
    d: PLongint;
    r,g,b: byte;
    xx: Cardinal;
begin
  s:= Source; d:= destation;
  for xx:= 0 to size-1 do
    begin
      r:= (s^ shr 11) and 31;
      g:= ((s^ shr 5) and 31);
      b:= s^ and 31;
      d^:= (r shl 19) or (g shl 11) or (b shl 3);
      Inc( s);
      Inc( d);
    end;
end;


procedure g64ConvertBitmap( source, destation: Pointer; size: cardinal; fromBits, toBits: byte);
begin

  if (fromBits= 32) then
    case toBits of
      pf15bit: g64Convert32to15( source, destation, size);
      pf16bit: g64Convert32to16( source, destation, size);
      pf32bit:
        asm
          push esi
          push edi
          mov esi, source
          mov edi, destation
          mov ecx, size
          rep movsd
          pop edi
          pop esi
        end;
    end;
  if (fromBits= 24) then
    case toBits of
      pf15bit: g64Convert24to15( source, destation, size);
      pf16bit: g64Convert24to16( source, destation, size);
      pf32bit: g64Convert24to32( source, destation, size);
    end;
  if (fromBits= 16) then
    case toBits of
      pf15bit: g64Convert16to15( source, destation, size);
      pf16bit:
        asm
          push esi
          push edi
          mov esi, source
          mov edi, destation
          mov ecx, size
          rep movsw
          pop edi
          pop esi
        end;
      pf32bit: g64Convert16to32( source, destation, size);
    end;
  if (fromBits= 15) then
    case toBits of
      pf15bit:
        asm
          push esi
          push edi
          mov esi, source
          mov edi, destation
          mov ecx, size
          rep movsw
          pop edi
          pop esi
        end;
      pf16bit: g64Convert15to16( source, destation, size);
      pf32bit: g64Convert15to32( source, destation, size);
    end;
end;


procedure TBitmap64. SetPixelFormat;
var temp: Longint;
begin
 bmBitsPixel:= value;
 temp:= (bmBitsPixel + 7) shr 3;
 if temp<>bmBpp then
    begin
     ReAllocMem( bmBits, temp*bmWidth*bmHeight)
     {now we must convert from actual to new format (e.g: 24 to 16 bits...)}
    end;
 bmBpp:= temp;
end;

function TBitmap64. GetPixelFormat;
begin
  result:= bmBitsPixel
end;

function TBitmap64. GetScanLine( row: Longint): pointer;
begin
{$IFDEF apGDI}
  if self is TScreen64 then
    with self as TScreen64 do
    begin
      result:= BackBuffer.ScanLine[row];
    end
    else
      result:= pointer( bmLeftStart*bmBpp + Longint( bmBits) + (bmHeight-1-row)*linePitch{bmWidth});
{$ELSE}

//this is for other platforms
  result:= pointer( bmLeftStart*bmBpp + Longint( bmBits) + row*linePitch);
{$ENDIF}
end;

procedure TBitmap64. SetSize( NewWidth, NewHeight: Longint);
begin
  if (NewWidth=bmWidth)and(NewHeight=bmHeight) then exit; //nothing to change

  if bmBits<>nil then FreeMem( bmBits);   //release old picture data
  bmWidth:= NewWidth;
  bmHeight:= NewHeight;
  linePitch:= bmBpp*bmWidth;
  GetMem( bmBits, bmWidth*bmHeight*bmBpp); //new size

end;

procedure TBitmap64. SetWidth( value: Longint);
//use this when you changing ONLY bitmap width
//if you changing width and height use SetSize() function
begin
  if (WasAssigned)or(value=bmWidth) then exit; //You can't do it with assigned data...
  SetSize( value, bmHeight);
end;

procedure TBitmap64. SetHeight( value: Longint);
begin
  if (WasAssigned)or(value=bmHeight) then exit;
  SetSize( bmHeight, value);
end;

function TBitmap64. UnpackRGB ( what: Longint):TRGB;
begin
 case bmBitsPixel of
   pf15bit:with result do
           begin
             r:= (what shr 10)shl 3;
             g:= ((what shr 5)and 31)shl 3;
             b:= (what and 31) shl 3;
           end;
   pf16bit:with result do
           begin
             r:= (what shr 11)shl 3;
             g:= ((what shr 5)and 63)shl 2;
             b:= (what and 31) shl 3;
           end;
   pf24bit,pf32bit:
           with result do
           begin
             r:= what shr 16;
             g:= (what shr 8) and 255;
             b:= what and 255;
           end;
 else
   begin
     result.r:= 0;result.g:= 0;result.b:= 0;
   end;
 end; //case

end; //function

function FindColor(r,g,b: Longint;pal:PPalette64): Byte;
{Finds the color (8bit) number for a given  color(RGB format)}
var l,i: Longint;
    n: longint;
begin
  l:=10000;
  result:= 0;
  for i:=0 to 255 do
  begin
    n:= (r-pal^[i].r)*(r-pal^[i].r) + (g-pal^[i].g)*(g-pal^[i].g) + (b-pal^[i].b)*(b-pal^[i].b);
    if n<l then
    begin
      result:=i;
      l:=n;
    end;
  end;
end;

Function TBitmap64. RGB( r,g,b: byte): Longint;
begin
  case bmBitsPixel of
          pf8bit:  result:= FindColor( r,g,b, Palette);
          pf15bit: result:= ((r div 8) shl 10)+((g div 8)shl 5)+((b div 8));
          pf16bit: result:= ((r div 8) shl 11)+((g div 4)shl 5)+((b div 8));
    pf24bit,pf32bit: result:= (r shl 16) + (g shl 8) + b;
  else
    result:= 0;
  end;
end;

{$ifdef apGDI}
function  TBitmap64.WinColor( color: TColor): Longint;
begin
  result:= RGB( (Color mod $100) , ((color div $100) mod $100) , (color div $10000));
end;
{$endif}


Function TBitmap64. GetPixelPtr( x,y: Longint): Pointer;
var p:Pointer;
    start: Longint;
begin
  result:= nil;  //zero if pixel is out of space
  start:= x;
  if (x<0)or(y<0)or(x>=bmWidth)or(y>=bmHeight) then
  else
  begin
    case bmBitsPixel of
      pf8bit:
        begin
          p:= ScanLine[y];
          asm
            mov eax, p
            add eax, start
            mov p, eax
          end;
        end;
      pf16bit,pf15bit:
        begin
          p:= ScanLine[y];
          asm
            mov eax, p
            mov edx, start
            shl edx, 1
            add eax, edx
            mov p, eax
          end;
        end;
      pf32bit:
        begin
          p:= ScanLine[y];
          asm
            mov eax, p
            mov edx, start
            shl edx, 2
            add eax, edx
            mov p, eax
          end;
        end;

    end;  //case
    result:= p;
  end;

end;

Function TBitmap64. GetPixel( x,y: Longint): Longint;
{GetPixel from [x,y] position.
 If position out of region result is zero }
var p:PWord;
    p1: PLongint;
    p2: PByte;
begin
  result:= 0;  //zero if pixel is out of space
  if (x<Clipper.Left)or(y<Clipper.Top)or(x>Clipper.Right)or(y>Clipper.Bottom) then
  else
  case bmBitsPixel of
    pf8bit:
      begin
        p2:= ScanLine[y];
        inc( p2, x);
        result:= p2^;
      end;
    pf16bit,pf15bit:
      begin
        p:= ScanLine[y];
        Inc( p, x); result:= p^;
      end;
    pf32bit:
      begin
        p1:= ScanLine[y];
        Inc( p1, x); result:= p1^;
      end;
  end;

end;

procedure TBitmap64. PutPixel( x,y,color: Longint);
var p: PWord;
    p1: PLongint;
    p2: PByte;
begin
  if (x<Clipper.Left)or(y<Clipper.Top)or(x>Clipper.Right)or(y>Clipper.Bottom) then  {only if we are "on Screen"}
  else
  case bmBitsPixel of
    pf8bit:
      begin
        p2:= ScanLine[y];
        Inc( p2, x);
        p2^:= color;
      end;
    pf16bit,pf15bit:
      begin
        p:=  ScanLine[y];
        Inc(p,x);
        p^:= color;
      end;
    pf32bit:
      begin
        p1:=  ScanLine[y];
        Inc( p1, x);
        p1^:= color;
      end;
  end;
end;

procedure TBitmap64. PutLensPixel( x,y,color: Longint);
{Draw Blended pixel to [x,y]}
var andmask: word;
    AndMask32: Longint;
    M:PWord;
    M1:PLongint;
begin
  if (x<Clipper.Left)or(y<Clipper.Top)or(x>Clipper.Right)or(y>Clipper.Bottom) then
  else
  begin
    case pixelformat of
      pf15bit:
        asm mov andmask, 0011110111101111b {}end;
      pf16bit:
        asm mov andmask, 1111101111101111b {}end;
      pf32bit:
        asm mov andmask32, 011111110111111101111111b end;
    end;

    if pixelformat= pf32bit then
      begin
        m1:= ScanLine[y];
        inc(m1,x);
        m1^:= ((Color shr 1)and AndMask32)+(m1^ shr 1) and AndMask32;
      end
      else
      begin
        m:= scanline[y];
        inc(m,x);
        m^:= ((Color shr 1)and andMask)+(m^ shr 1)and andMask;
      end;
  end;

end;

procedure TBitmap64.LensHLine(x,y,x1,color: Longint);
var p: PWord;
    andmask: Word;
    AndMask32: Longint;
begin
 if x>x1 then swapL( x,x1);   {x is on left, x1 is on right}
 if (x1<Clipper.Left)or(x>=Clipper.Right)or(y>Clipper.Bottom)or(y<Clipper.Top) then exit;

 if x<Clipper.Left then x:= Clipper.Left;
 if x1>=Clipper.Right then x1:= Clipper.Right;

 Inc( x1);
   case pixelformat of
     pf15bit:
       asm
         xor edx, edx
         mov eax, 0011110111101111b
         mov edx, eax
         shl eax, 16
         or  eax, edx
         mov andmask, ax
         mov AndMask32, eax
       end;
     pf16bit:
       asm
         xor edx, edx
         mov eax, 1111101111101111b
         mov edx, eax
         shl eax, 16
         or  eax, edx
         mov andmask, ax
         mov AndMask32, eax
       end;
     pf32bit:asm mov AndMask32,011111110111111101111111b end
   end;

  if (bmBpp=2) then
  begin
    p:= ScanLine[y];
    asm
      push edi
      mov edi, p
      mov ecx, x1
      mov eax, x
      sub ecx, eax
      cmp ecx, 0
      je @NoDraw   //exit if nothing to draw
      shl eax, 1
      add edi, eax //seek to start

      mov dx, word ptr color
      shr dx, 1
      and dx, andmask  //compute this color only once

      mov ax, dx
      shl edx, 16
      mov dx, ax

      test ecx, 1
      jnz @OnlyOne  //if width can't be divided by 2

      shr ecx, 1

  @Twice:                //work with two pixels in one loop
      mov eax, [edi]     //main loop
      shr eax, 1
      and eax, AndMask32
      add eax, edx
      stosd
      loop @Twice
      jmp @NoDraw

  @OnlyOne:
      mov ax, [edi]
      shr ax, 1        //multiply color by 2
      and ax, andmask  //prevent overflow
      add ax, dx       //add precalculated color
      stosw
      loop @OnlyOne

  @NoDraw:
      pop edi
    end; //asm
  end; //15/16 bit

  if (bmBpp=4)then
  begin
    p:= ScanLine[ y];
    asm
      push edi
      mov edi, p
      mov ecx, x1
      mov eax, x
      sub ecx, eax
      cmp ecx, 0
      je @NoDraw   //exit if nothing to draw
      shl eax, 2
      add edi, eax //seek to start

      mov edx, dword ptr color
      shr edx, 1
      and edx, AndMask32  //compute this color only once

  @Loop1:
      mov eax, [edi]
      shr eax, 1
      and eax, AndMask32
      add eax, edx
      stosd
      loop @Loop1

  @NoDraw:
      pop edi

    end;
  end;

end;

procedure TBitmap64. HLine( x,y,x1,color: Longint);
{This procedure draw horizontal line from [x,y] to [x1,y] with specific color}
{Need MMX}
var P: Pointer;
begin
 if x>x1 then swapL( x,x1);   {x is on left, x1 is on right}
 if (x1<Clipper.Left)or(x>=Clipper.Right)or(y>Clipper.Bottom)or(y<Clipper.Top) then exit;

 if x<Clipper.Left then x:= Clipper.Left;
 if x1>=Clipper.Right then x1:= Clipper.Right;

 Inc( x1);
 case bmBitsPixel of
   pf8bit:
     begin
       p:= ScanLine[y];
       asm
         push edi
         mov edi, p
         mov ecx, x1
         mov eax, x
         sub ecx, eax
         add edi, eax
         mov eax, color
         rep stosb
         pop edi
       end;
     end;

   pf16bit,pf15bit:
     begin
       p:= ScanLine[y];
       asm
         push edi
         mov edi, p
         mov ecx, x1
         mov eax, x
         sub ecx, eax
         shl eax, 1
         add edi, eax
         mov eax, color
         rep stosw
         pop edi
       end;
     end;
   pf32bit:
     begin
       p:= ScanLine[y];
       asm
         push edi
         mov edi, p
         mov ecx, x1
         mov eax, x
         sub ecx, eax
         shl eax, 2
         add edi, eax
         mov eax, color
         rep stosd
         pop edi
       end;
     end;
 end;//end of case

end;

procedure TBitmap64. VLine( x,y,y1,color: Longint);
{Draw vertical line from [x,y] to [x,y1] with specific color}
var p:PWord;
    p1: PLongint;
    p2: PByte;
    yy: Longint;

begin
  if y>y1 then SwapL( y,y1);
  if (x<Clipper.Left)or(x>Clipper.Right)or(y>Clipper.Bottom)or(y1<Clipper.Top) then exit;
  if y<Clipper.Top then y:= Clipper.Top;
  if y1>Clipper.Bottom then y1:= Clipper.Bottom;

  case bmBitsPixel of
    pf8bit:
      begin
        for yy:= y to y1 do
          begin
            p2:=  ScanLine[yy];
            inc( p2, x);
            p2^:= color;
          end;
      end;

    pf16bit,pf15bit:
      begin
        for yy:= y to y1 do
          begin
            p:=  ScanLine[yy];
            inc( p, x);
            p^:= color;
          end;
      end;
    pf32bit:
      begin
        for yy:=  y to y1 do
          begin
            p1:= ScanLine[yy];
            inc( p1, x);
            p1^:= color;
          end;
        end;
  end; //end of case

end;

function sgn(a:Longint):Longint;
begin
  if a>0 then result:=+1 else
  if a<0 then result:=-1 else result:=0;
end;


procedure TBitmap64. Circle( x,y, size, color: Longint);
begin
  Ellipse( x,y, size, size, color);
end;

procedure TBitmap64. Ellipse ( x, y, xsize, ysize, color: Longint);
var xx,  mx1,mx2,  my1,my2: Longint;
    aq,bq, dx,dy, r,rx,ry: Longint;
begin
  PutPixel (x + xsize, y, color);
  PutPixel (x - xsize, y, color);
  mx1 := x - xsize;
  mx2 := x + xsize;
  my1 := y;
  my2 := y;

  aq := xsize * xsize;
  bq := ysize * ysize;
  dx := aq shl 1;
  dy := bq shl 1;
  r  := xsize * bq;
  rx := r shl 1;
  ry := 0;
  xx := xsize;

  while xx > 0
  do begin
    if r > 0
    then begin
      inc (my1);
      dec (my2);
      inc (ry, dx);
      dec (r, ry);
    end;
    if r <= 0
    then begin
      dec (xx);
      inc (mx1);
      dec (mx2);
      dec (rx, dy);
      inc (r, rx);
    end;
    PutPixel (mx1, my1, color);
    PutPixel (mx1, my2, color);
    PutPixel (mx2, my1, color);
    PutPixel (mx2, my2, color);
  end;
end;


procedure TBitmap64. Line( x,y,x1,y1,color: Longint);
{Slow putpixel used!}
var i,s,d1x,d1y,d2x,d2y,u,v,m,n:Longint;
begin
  u:= x1 - x;
  v:= y1 - y;
     d1x:= SGN(u);
     d1y:= SGN(v);
     d2x:= SGN(u);
     d2y:= 0;
     m:= ABS(u);
     n := ABS(v);
     IF NOT (M>N) then
     BEGIN
          d2x := 0 ;
          d2y := SGN(v);
          m := ABS(v);
          n := ABS(u);
     END;
     s := m shr 1;
     FOR i := 0 TO m DO
     BEGIN
          putpixel(x,y,color);
          s := s + n;
          IF not (s<m) THEN
          BEGIN
               s := s - m;
               x:= x + d1x;
               y := y + d1y;
          END
          ELSE
          BEGIN
               x := x + d2x;
               y := y + d2y;
          END;
     end;
end;

procedure TBitmap64. LensLine( x,y,x1,y1,color: Longint);
var i,s,d1x,d1y,d2x,d2y,u,v,m,n:Longint;
begin
  u:= x1 - x;
  v:= y1 - y;
     d1x:= SGN(u);
     d1y:= SGN(v);
     d2x:= SGN(u);
     d2y:= 0;
     m:= ABS(u);
     n := ABS(v);
     IF NOT (M>N) then
     BEGIN
          d2x := 0 ;
          d2y := SGN(v);
          m := ABS(v);
          n := ABS(u);
     END;
     s := m shr 1;
     FOR i := 0 TO m DO
     BEGIN
          PutLensPixel(x,y,color);
          s := s + n;
          IF not (s<m) THEN
          BEGIN
               s := s - m;
               x:= x + d1x;
               y := y + d1y;
          END
          ELSE
          BEGIN
               x := x + d2x;
               y := y + d2y;
          END;
     end;
end;

procedure TBitmap64. Rectangle( x,y, x1,y1,color: Longint);
begin
  Hline(x,y,x1,color);
  Hline(x,y1,x1,color);
  Vline(x,y,y1,color);
  Vline(x1,y,y1,color);

end;

procedure TBitmap64.Triangle( x1,y1, x2,y2, x3,y3,color:Longint);
var
  First,Last,xx,ax,bx,yy,p1,q1,p2,q2,p3,q3:Longint;
begin
  {First we must find first and last line}
  First:= y1; Last:= y1;
  if y2<First then First:=y2;
  if y2>Last then Last:=y2;
  if y3<First then First:=y3;
  if y3>Last then Last:=y3;

  p1:=x1-x3; q1:=y1-y3;
  p2:=x2-x1; q2:=y2-y1;
  p3:=x3-x2; q3:=y3-y2;
  for yy:=First to Last do
    begin
      ax:= Width;
      bx:=-1;
      if (y3>=yy) or (y1>=yy) then
        if (y3<=yy) or (y1<=yy) then
          if not(y3=y1) then
            begin
              xx:=(yy-y3)*p1 div q1+x3;
              if xx<ax then ax:=xx;
              if xx>bx then bx:=xx;
            end;
      if (y1>=yy) or (y2>=yy) then
        if (y1<=yy) or (y2<=yy) then
          if not(y1=y2) then
            begin
              xx:=(yy-y1)*p2 div q2+x1;
              if xx<ax then ax:=xx;
              if xx>bx then bx:=xx;
            end;
      if (y2>=yy) or (y3>=yy) then
        if (y2<=yy) or (y3<=yy) then
          if not(y2=y3) then
            begin
              xx:=(yy-y2)*p3 div q3+x2;
              if xx<ax then ax:=xx;
              if xx>bx then bx:=xx;
            end;
      if ax<=bx then HLine(ax,yy,bx,color);
    end;
end;

procedure TBitmap64. Bar( x,y,x1,y1,color: Longint);
{Draw filled rectangle from [x,y] to [x1,y1] with specific color}
{NEED MMX Hline}
var yy: Longint;
begin
  if x>x1 then SwapL( x,x1);
  if y>y1 then SwapL( y,y1);
  for yy:= y to y1 do
    HLine( x,yy,x1, color);
end;

procedure   TBitmap64.LensBar( x,y,x1,y1,color: Longint);
{Maybe faster, so what?}
var yy: Longint;
begin
  if x>x1 then SwapL( x,x1);
  if y>y1 then SwapL( y,y1);

  for yy:= y to y1 do
    LensHLine( x,yy,x1, color);
end;

procedure   TBitmap64. MotionBlur;
{Work in progress...}
var mnemonic: PWord;
    CxSize,
    SizeX: Longint;
    andmask: word;

begin
 mnemonic:= bmBits;
 CxSize:= bmWidth*(bmHeight-1);
 SizeX:= bmWidth;
 case pixelformat of
   pf15bit:asm mov andmask, 0011110111101111b end;
   pf16bit:asm mov andmask, 1111101111101111b end;
 end;

asm
     push edi
     push ebx
      mov edi, mnemonic

      mov ecx, CxSize
      mov ebx, SizeX
      shl ebx, 1

@lp1:   xor     edx,edx
        xor     eax,eax

        mov     ax,word ptr [edi]
        mov     dx,word ptr [edi+2]
        shr     eax,1
        shr     edx,1
        and     ax, andmask
        and     dx, andmask
        add     eax,edx

        mov     dx,word ptr [edi-2] // This is bug
        shr     eax,1
        shr     edx,1
        and     ax, andmask
        and     dx, andmask
        add     eax,edx

        mov     dx,word ptr [edi+ebx]  {+SizeX}
        shr     eax,1
        shr     edx,1
        and     ax, andmask
        and     dx, andmask
        add     eax, edx

@lp2:   stosw
        dec     ecx
        jnz     @lp1

     pop ebx
     pop edi
end;
end;

procedure TBitmap64.DoFilter( filter: TFilter64);
var t: TBitmap64;
    r,g,b,
    r1,g1,b1,
    xx,yy,zz,aa: Longint;
    p,p1:PLongint;
begin

  t:= TBitmap64.Create( Width, Height, PixelFormat);

  try

    for yy:= 1 to (Height-2) div 2 do
      begin
        for xx:= 1 to (Width-2) do
        begin
          r1:= 0;
          g1:= 0;
          b1:= 0;
        for aa:= -1 to 1 do
          for zz:= -1 to 1 do
          begin
            p:= PixelPtr[xx+zz, yy+aa];
            r:= filter.Matrix[(aa+1)*3+(zz+1)]*((p^ and RBitMask) shr RStart);
            g:= filter.Matrix[(aa+1)*3+(zz+1)]*((p^ and GBitMask) shr GStart);
            b:= filter.Matrix[(aa+1)*3+(zz+1)]*(p^ and BBitMask);
            r1:= r1+r;
            g1:= g1+g;
            b1:= b1+b;
          end;
           p1:= PixelPtr[xx,yy];
           r1:= r1 div filter.Factor;
           g1:= g1 div filter.Factor;
           b1:= b1 div filter.Factor;
           if r1>32 then r1:=32;
           if g1>32 then g1:=32;
           if b1>32 then b1:=32;

           p1^:= (r1 shl RStart) or ( g1 shl GStart) or b1;
        end;
      end;

   finally
//     Draw(0,0, t);
     t.Destroy;
   end;

end;

procedure   TBitmap64. SwapRGB;
// swap RGB format to BGR format
// Now It's realtime! ASM and CPU cycles optimization ;-)
var yy,
    r1: Longint;
    s:PWord;
begin
  case pixelformat of
    //------------------------15 bit--
    pf15bit:
      for yy:= 0 to height-1 do
      begin
        s:= PixelPtr[0,yy]; r1:= Width;
        asm
          push edi
          push ebx
          mov edi, s
          mov ecx, r1

        @1:
          mov ax, [edi]  //load pixel from memory
          mov bx, ax
          mov dx, ax

          shr bx, 10
          and dx, 992   //dx = Green Value 992 = 31 shl 5
          and ax, 31    //ax = Red Value

          and bx, 31    //bx = Blue Value
          shl ax, 10

          or ax, bx
          or ax, dx

          stosw
          loop @1

          pop ebx
          pop edi
        end;
      end; // end of pf15bit
    //------------------------16 bit--
    pf16bit:
      for yy:= 0 to height-1 do
      begin
        s:= PixelPtr[0,yy]; r1:= Width;
        asm
          push edi
          push ebx
          mov edi, s
          mov ecx, r1

        @1:
          mov ax, [edi]  //load pixel from memory
          mov bx, ax
          mov dx, ax

          shr bx, 11
          and dx, 2016   //dx = Green Value 992 = 63 shl 5
          and ax, 31    //ax = Red Value

          and bx, 31    //bx = Blue Value
          shl ax, 11

          or ax, bx
          or ax, dx

          stosw
          loop @1

          pop ebx
          pop edi
        end;
      end; // end of pf16bit

    //------------------------32 bit--
    pf32bit:
      for yy:= 0 to height-1 do
      begin
        s:= PixelPtr[0,yy]; r1:= Width;
        asm
          push edi
          push ebx
          mov edi, s
          mov ecx, r1

        @1:
          mov eax, [edi]  //load pixel from memory
          mov ebx, eax
          mov edx, eax

          shr ebx, 16
          and edx, 65280   //dx = Green Value 992 = 255 shl 8
          and eax, $ff    //ax = Red Value

          and ebx, $ff    //bx = Blue Value
          shl eax, 16

          or eax, ebx
          or eax, edx

          stosd
          loop @1

          pop ebx
          pop edi
        end;
      end; // end of pf32bit
end; //case

end;

procedure   TBitmap64. Antialiasing;
{this is pixel precision anitaliasing => slow, not for real-time effects}
{ Work in progress...}
var yy,xx: Longint;
    s1,s2,s3,s4,d: TRGB;
Function PackRGB( what: TRGB): word;
begin
 result:= (what.r shl 11)or (what.g shl 5) or (what.b);
end;

Function AddRGB( s1,s2: TRGB): TRGB;
begin
 result.r:= s1.r + s2.r;
 result.g:= s1.g + s2.g;
 result.b:= s1.b + s2.b;
end;
Procedure ClearRGB(var s: TRGB);
begin
with s do
 begin
  r:=0;
  g:=0;
  b:=0;
 end;
end;
begin
 if PixelFormat<>pf16bit then exit; //say good bye
 for yy:= 1 to bmHeight-1 do
   begin
     for xx:= 1 to bmWidth-1 do
       begin
         s1:= UnpackRGB( GetPixel( xx,yy));
         s2:= UnpackRGB( GetPixel( xx-1,yy));
         s3:= UnpackRGB( GetPixel( xx+1,yy));
         s4:= UnpackRGB( GetPixel( xx, yy-1));
//         s5:= UnpackRGB( GetPixel( xx, yy+1));
         d:=  AddRGB( AddRGB( s1,s2), AddRGB( s3,s4));
//          d:= AddRGB( AddRGB( s1,s2), s3);

         with d do
           begin
             r:= r div 4;
             g:= g div 4;
             b:= b div 4;
             if r>31 then r:= 31;
             if g>63 then g:= 63;
             if b>31 then b:= 31;
           end;
         PutPixel( xx,yy, PackRGB( d));
       end;
   end;

end;

procedure   TBitmap64. Antialiasing2;
var yy,sizex: Longint;
    s1,s2: PWord;
    AndMask: Word;
    AndMask32: Cardinal;
begin
 if bmbpp<>2 then exit; //say good bye
  case pixelformat of
    pf15bit:
      begin
        asm
          mov andmask,  0011110111101111b
          mov AndMask32, 0111101111011110011110111101111b
        end;
      end;
    pf16bit:
      begin
        asm
          mov andmask, 1111101111101111b
          mov AndMask32, 1111011111011111111101111101111b //stupid delphi!!
        end;
      end;
    pf32bit:
      asm mov AndMask32, 011111110111111101111111b;end
    else exit
  end;

 for yy:= 1 to bmHeight-1 do
   begin
     s1:= PixelPtr[0,yy-1];
     s2:= PixelPtr[1,yy];
     sizex:= bmWidth-2;
{     for xx:= 1 to bmWidth-1 do}
       begin
         asm
           push ebx
           push edi
           push esi  //save registers

           //      -Midle pixel is target pixel "s2+1"
           //     *** -pointer to fist pixel in row is "s2"
           //      *  -pointer to this pixel is in "s1"
           //
           //
           mov edi, s1
           mov esi, s2

           mov ecx, SizeX
//           xor eax, eax
         @1:
           mov edx,[edi+2]
           mov ax, [esi]


           shr edx, 1  //operate with two pixels at once
           shr ax, 1
//           shr bx, 1

           and edx, AndMask32
//           and bx, andmask
           and ax, andmask
           add ax, dx
//           add ax, bx

{           shr ax, 1
           and ax, andmask
           add ax, dx
 }
           shr edx, 16
           shr ax, 1
           and ax, andmask
           add ax, dx

           mov [edi], ax
           inc edi
           inc edi

           inc esi
           inc esi

           loop @1

           pop esi
           pop edi
           pop ebx
         end;

       end;
   end;

end;

procedure TBitmap64. DrawResize( x,y, NewWidth, NewHeight: Longint; b: TBitmap64);
var yp,xp,sx,sy: Longint;
    source,target: PWord; xx,yy: Longint;
begin
  if (bmBpp<>2)or(b.bmBpp<>2) then exit; //sorry, only 15/16 bpp
  if (Width=b.Width)and(Height=b.Height) then //if target resolution is same as source
  begin
    Draw(x,y,b);
    exit;
  end;
  sx:=NewWidth  div b.Width;
  sy:=NewHeight div b.Height;

  yp:=0;target:= bmBits;
    for yy:=0 to NewHeight-1 do
    begin
      source:= b.ScanLine[yp]; xp:=0;
      target:= ScanLine[yy];
      for xx:=0 to NewWidth-1 do
      begin
        asm
          push edi;push esi;push ebx;
          mov edi,target
          mov esi,source
          mov ebx,xp
          mov ax, [esi+ebx]
          mov [edi],ax
          pop ebx;pop esi;pop edi;
        end;
        Inc(target); Inc(xp,sx);
      end;
//      pc:=Ptr(Longint(pc)+Dst.Gap);
      Inc(yp,sy);
    end;

end;

function TBitmap64. Clip( const bitmap: TBitmap64; var x,y, SizeX, SizeY, StartX, StartY: Longint): boolean;
{
  Clipping function.
}
begin

  if (x >= Clipper.Right) or ( x+bitmap.Width<Clipper.Left) or (y>=Clipper.Bottom) or ( y+bitmap.Height<Clipper.Top) then
  begin  //nothing to draw -> nothing to clip
    result:= false;
    exit;
  end;

  result:= true;
  if (X + bitmap.Width) > Clipper.Right then SizeX:=  1+Clipper.Right- x else SizeX:= bitmap.Width;
  if (Y + bitmap.Height) > Clipper.Bottom then SizeY:= 1+Clipper.Bottom - y else SizeY:= bitmap.Height;

  if X < Clipper.Left then   //clip x start
  begin
    StartX:= Clipper.Left-x;
    X:= Clipper.Left;
  end
  else StartX:= 0;

  if Y < Clipper.Top then   //clip y start
  begin
    StartY:= Clipper.Top-y;
    Y:= Clipper.Top;
  end
  else StartY:= 0;

  SizeX:= SizeX- StartX;
  SizeY:= SizeY- StartY;
  if SizeX = 0 then result:= false;

end;


procedure TBitmap64.DrawBrightness( x,y: Longint; b: TBitmap64; Intensity: Longint);
{ Intensity from -255 to 255 }
var p,p1: PWord;
    p2,p3: PDWord;
    rr,gg,bb: Longint;
    xx,yy,SizeX,SizeY,StartX,StartY: Longint;

{Need ASM,MMX}
var t,t1: Longint;
begin

  if not Clip( b, x,y, SizeX, SizeY, StartX, StartY) then exit;
  if Intensity >  255 then Intensity:=  255;
  if Intensity < -255 then Intensity:= -255;

  // 15/16 bit rendering
  if bmBpp=2 then
  begin
    Intensity:= Intensity div 8; //div 8, because we have only 5bit value for each color

    if PixelFormat= pf16bit then
      begin t:= 2;t1:= 63;end
    else
      begin t:= 1;t1:= 31;end;

    for yy:= 0 to SizeY-1 do
    begin
      p:= b.PixelPtr[ StartX, StartY+yy];
      p1:= PixelPtr[ X, y+yy];
      for xx:= 0 to SizeX-1 do
      begin

        if (b.Transparent)and(p^= b.TransparentColor) then else
        begin
          rr:= p^ shr RStart + Intensity;
          if rr>31 then rr:= 31 else if rr<0 then rr:= 0;

          gg:= ((p^ and GBitMask) shr GStart) +  t*Intensity;
          if gg>t1 then gg:= t1 else if gg<0 then gg:= 0;

          bb:= (p^ and BBitMask) + Intensity;
          if bb>31 then bb:= 31 else if bb<0 then bb:= 0;

          p1^:= (rr shl RStart) or (gg shl GStart) or (bb);
        end;
        inc( p);   //next pixel in source pixel
        inc( p1);  //next pixel in destation image
      end;
    end;

  end;

  // 32bit rendering
  if PixelFormat= pf32bit then
  begin

    for yy:= 0 to SizeY-1 do
    begin

      p2:= b.PixelPtr[ StartX, StartY+yy];
      p3:= PixelPtr[ X, y+yy];
      for xx:= 0 to SizeX-1 do
      begin
        if (b.Transparent)and(p2^= b.TransparentColor) then else
        begin
          rr:= p2^ shr RStart + Intensity;
          if rr>255 then rr:= 255 else if rr<0 then rr:= 0;

          gg:= ((p2^ and GBitMask) shr GStart) + Intensity;
          if gg>255 then gg:= 255 else if gg<0 then gg:= 0;

          bb:= (p2^ and BBitMask) +Intensity;
          if bb>255 then bb:= 255 else if bb<0 then bb:= 0;

          p3^:= (rr shl RStart) or (gg shl GStart) or (bb);
        end;
        inc( p2);
        inc( p3);
      end;
    end;
  end;

end;

procedure TBitmap64. DrawAlpha( x,y: Longint; b:TBitmap64;Alpha: TAlpha64);
{ This is not optimised code, now
  NEED ASM/MMX
}
var StartX,StartY,
    SizeX,SizeY: Longint;
    xx,yy: Longint;
    s1,d1: PWord;
    s2,d2: PRGB32;
    p: PByte; //for alpha
    zz,RS,GS,BS,RD,GD,BD: Longint;
    sfact,dfact: Longint;
    rr,gg,bb: word;//byte;
begin

  if  not Clip( b, x,y, SizeX, SizeY, StartX, StartY) then exit;


if (bmBitsPixel <> b. bmBitsPixel) then
  begin
    raise exception.create('Can''t DrawAlpha with diferent color depth');exit;
  end;

if (Alpha.Width<>b.Width)or( Alpha.Height<>b.Height) then
  begin
    raise exception.Create('Can''t DrawAlpha with diferent alpha size from Bitmap');exit;
  end;

if bmBpp=2 then  //for 15/16bit bpp
  begin
    for yy:= 0 to (SizeY-1) do
      begin
        d1:=    ScanLine[yy+y];
        s1:= b. ScanLine[yy+StartY];
        p:= alpha.PixelPtr[startx,yy+starty];
        inc( s1, StartX);
        inc( d1, x);
        for zz := 0 to (SizeX-1) do
          begin
            if (b.transparent)and(b.transparentcolor=s1^) then else
              begin
                sfact:= p^ shr 1;
                dfact:= 128 - sfact;

                Rs:= s1^ shr RStart;
                Gs:= (s1^ and GBitMask) shr GStart;
                Bs:= (s1^ and BBitMask);

                Rd:= d1^ shr RStart;
                Gd:= (d1^ and GBitMask) shr GStart;
                Bd:= (d1^ and BBitMask);

                rr:= (rS *sfact +rD*dfact)shr 7;
                gg:= (gS *sfact +gD*dfact)shr 7;
                bb:= (bS *sfact +bD*dfact)shr 7;

                if rr>31 then rr:= 31;
                if gg>GBitMask shr GStart then gg:= GBitMask shr GStart;
                if bb>31 then bb:= 31;
                d1^:= (rr shl RStart) + (gg shl GStart) + bb;
              end;
            inc( d1);inc( s1); inc( p);
          end; {zz loop}
      end; { yy loop}
  end
  else
  if bmBpp=4 then  //for 32bit bpp
    begin
    for yy:= 0 to (SizeY-1) do
      begin
        d2:=    ScanLine[yy+y];
        s2:= b. ScanLine[yy+StartY];
        p:= alpha.PixelPtr[startx,yy+starty];

        inc( s2, StartX);
        inc( d2, x);
        for zz := 0 to (SizeX-1) do
          begin
            if (b.transparent)and(b.transparentcolor=Longint(s2^)) then else
              begin
                sfact:= p^ shr 1;
                dfact:= 128 - sfact;

                rr:= (s2^.r *sfact +d2^.r*dfact)shr 7; // div 128
                gg:= (s2^.g *sfact +d2^.g*dfact)shr 7;
                bb:= (s2^.b *sfact +d2^.b*dfact)shr 7;

                if rr>255 then rr:= 255;
                if gg>255 then gg:= 255;
                if bb>255 then bb:= 255;
                Longint(d2^):= (rr shl RStart) + (gg shl GStart) + bb;
              end;
            inc( d2);inc( s2);inc( p);
          end; {zz loop}
      end; { yy loop}

    end;

end; { procedure }

procedure TBitmap64. DrawBlend( x,y: Longint; b:TBitmap64; sfactor,dfactor: single);
{ This is not optimised code, now
  NEED ASM/MMX
}
var StartX,StartY,
    SizeX,SizeY: Longint;
    xx,yy: Longint;
    s1,d1: PWord;
    s2,d2: PRGB32;
    zz,RS,GS,BS,RD,GD,BD: Longint;
    sfact,dfact: Longint;
    rr,gg,bb: word;//byte;
begin

  if  not Clip( b, x,y, SizeX, SizeY, StartX, StartY) then exit;

  sfact:= trunc(sfactor*128);
  dfact:= trunc(dfactor*128);

if (bmBitsPixel <> b. bmBitsPixel) then
  begin
    raise exception.create('Can''t DrawBlend with diferent color depth');exit;
  end;

if bmBpp=2 then  //for 15/16bit bpp
  begin
    for yy:= 0 to (SizeY-1) do
      begin
        d1:=    ScanLine[yy+y];
        s1:= b. ScanLine[yy+StartY];
        inc( s1, StartX);
        inc( d1, x);
        for zz := 0 to (SizeX-1) do
          begin
            if (b.transparent)and(b.transparentcolor=s1^) then else
              begin
                Rs:= s1^ shr RStart;
                Gs:= (s1^ and GBitMask) shr GStart;
                Bs:= (s1^ and BBitMask);

                Rd:= d1^ shr RStart;
                Gd:= (d1^ and GBitMask) shr GStart;
                Bd:= (d1^ and BBitMask);

                rr:= (rS *sfact +rD*dfact)shr 7;
                gg:= (gS *sfact +gD*dfact)shr 7;
                bb:= (bS *sfact +bD*dfact)shr 7;

                if rr>31 then rr:= 31;
                if gg>GBitMask shr GStart then gg:= GBitMask shr GStart;
                if bb>31 then bb:= 31;
                d1^:= (rr shl RStart) + (gg shl GStart) + bb;
              end;
            inc( d1);inc( s1);
          end; {zz loop}
      end; { yy loop}
  end
  else
  if bmBpp=4 then  //for 32bit bpp
    begin
    for yy:= 0 to (SizeY-1) do
      begin
        d2:=    ScanLine[yy+y];
        s2:= b. ScanLine[yy+StartY];
        inc( s2, StartX);
        inc( d2, x);
        for zz := 0 to (SizeX-1) do
          begin
            if (b.transparent)and(b.transparentcolor=Longint(s2^)) then else
              begin
                rr:= (s2^.r *sfact +d2^.r*dfact)shr 7; // div 128
                gg:= (s2^.g *sfact +d2^.g*dfact)shr 7;
                bb:= (s2^.b *sfact +d2^.b*dfact)shr 7;

                if rr>255 then rr:= 255;
                if gg>255 then gg:= 255;
                if bb>255 then bb:= 255;
                Longint(d2^):= (rr shl RStart) + (gg shl GStart) + bb;
              end;
            inc( d2);inc( s2);
          end; {zz loop}
      end; { yy loop}

    end;

end; { procedure }

procedure TBitmap64. DrawBlendRGB( x,y: Longint; b:TBitmap64; rfactor,gfactor,bfactor: single);
{It's same as DrawBlend with sourcefactor and destation factor, but here
 is destation factor set to 1 and you can control each value of RGB, RedFactor, GreenFactor and BlueFactor

 This is not optimised code, now
 }
var StartX,StartY,
    SizeX,SizeY: Longint;
    xx,yy: Longint;
    s1,d1: PWord;
    s2,d2: PRGB32;
    zz,RS,GS,BS,RD,GD,BD: Longint;
    rfact,gfact,bfact: Longint;
    rr,gg,bb: word;
begin

if not Clip(b,x,y,SizeX,SizeY,StartX,StartY) then exit;
rfact:= trunc(rfactor*128); {no thank's FPU}
gfact:= trunc(gfactor*128);
bfact:= trunc(bfactor*128);

if (bmBitsPixel <> b. bmBitsPixel) then
  begin
    raise exception.create('Sorry, can''t ....');exit;
  end;

if (bmBpp=2)then //15/16bit bpp
  begin
    for yy:= 0 to (SizeY-1) do
      begin
        d1:=    ScanLine[yy+y];
        s1:= b. ScanLine[yy+StartY];
        inc( s1, StartX);
        inc( d1, x);

        for zz := 0 to (SizeX-1) do
          begin
            if (b.transparent)and(b.transparentcolor=s1^) then else
            begin
              Rs:= s1^ shr RStart;
              Gs:= (s1^ and GBitMask) shr GStart;
              Bs:= (s1^ and BBitMask);

              Rd:= d1^ shr RStart;
              Gd:= (d1^ and GBitMask) shr GStart;
              Bd:= (d1^ and BBitMask);
              rr:= (rS *rfact) shr 7 + rD;
              gg:= (gS *gfact) shr 7 + gD;
              bb:= (bS *bfact) shr 7 + bD;

              if rr>31 then rr:= 31;  { min( rr, 31) }
              if gg>GBitMask shr GStart then gg:= GBitMask shr GStart;
              if bb>31 then bb:= 31;

              d1^:= rr shl RStart + gg shl GStart + bb;
            end;
            inc( d1);inc( s1);
          end;
      end; { yy loop}
  end
  else
  if bmBpp=4 then  //32bit bpp
  begin
    for yy:= 0 to (SizeY-1) do
      begin
        d2:=    ScanLine[yy+y];
        s2:= b. ScanLine[yy+StartY];
        inc( s2, StartX);
        inc( d2, x);
        for zz := 0 to (SizeX-1) do
          begin
            if (b.transparent)and(b.transparentcolor=Longint(s2^)) then else
            begin
              rr:= (s2^.r *rfact) shr 7 + d2^.r;
              gg:= (s2^.g *gfact) shr 7 + d2^.g;
              bb:= (s2^.b *bfact) shr 7 + d2^.b;

              if rr>255 then rr:= 255;
              if gg>255 then gg:= 255;
              if bb>255 then bb:= 255;
              Longint(d2^):= rr shl RStart + gg shl GStart + bb;
            end;
            inc( d2);inc( s2);
          end;
      end; { yy loop}


  end;

end;  { procedure }

procedure TBitmap64. DrawLens( x,y: Longint; b:TBitmap64);
var StartX,StartY,yy,
    SizeX,SizeY: Longint;  {in Bitmap}
    s1,d1: PWord;
    s2,d2: PLongint;
    Tcol,andmask: word;
    TCol32: Longint;
    AndMask32: Longint;
begin
  if  not Clip( b, x,y, SizeX, SizeY, StartX, StartY) then exit;

  TCol:= Word( b. TransparentColor);
  TCol32:= b. TransparentColor;

{ if source or target bitmap are pf16bit or pf15bit}
if (bmBpp<> b. bmBpp)then
  begin
    raise exception.create('Can''t DrawLens with diferent bpp');exit;
  end;

  case pixelformat of
    pf15bit:
      asm mov andmask, 0011110111101111b{} end;
    pf16bit:
      asm mov andmask, 1111101111101111b{} end;
    pf32bit:
      asm mov AndMask32, 011111110111111101111111b;end
    else exit
  end;

  if bmBpp=2 then  // for 15/16 bits per pixel
  begin
    if not b. Transparent then
      begin
        for yy:= 0 to (SizeY-1) do
          begin
            d1:=    ScanLine[yy+y];
            s1:= b. ScanLine[yy+StartY];
            inc( s1, StartX);
            inc( d1, x);
            asm
              push edi
              push esi
              mov edi, d1
              mov esi, s1
              mov ecx, SizeX
              xor eax, eax
            @1:
              mov ax, [esi]
              mov dx, [edi]
              shr ax, 1
              shr dx, 1          {divide all values by 2}
              and ax, andmask
              and dx, andmask
              add ax, dx
              stosw
              inc esi
              inc esi
              loop @1
              pop esi
              pop edi
            end; {end of asm}
          end;
        end  //end of non-transparent code
      else
        for yy:= 0 to (SizeY-1) do //if transparent value is set
          begin
            d1:=    ScanLine[yy+y];
            s1:= b. ScanLine[yy+StartY];
            inc( s1, StartX);
            inc( d1, x);
            asm
              push edi
              push esi
              mov edi, d1
              mov esi, s1
              mov ecx, SizeX
              xor eax, eax
            @1:
              mov ax, [esi]
              cmp ax, TCol
              jz @skip
              mov dx, [edi]
              shr ax, 1
              shr dx, 1          //divide all values by 2
              and ax, andmask
              and dx, andmask
              add dx, ax
              mov [edi], dx
            @skip:
              inc esi
              inc esi
              inc edi
              inc edi
              loop @1
              pop esi
              pop edi
            end;
          end;
  end
  else
  begin  //for 32bit bpp
    if not b. Transparent then
      begin
        for yy:= 0 to (SizeY-1) do
          begin
            d2:=    ScanLine[yy+y];
            s2:= b. ScanLine[yy+StartY];
            inc( s2, StartX);
            inc( d2, x);
            asm
              push edi
              push esi
              mov edi, d2
              mov esi, s2
              mov ecx, SizeX
              xor eax, eax
            @1:
              mov eax, [esi]
              mov edx, [edi]
              shr eax, 1
              shr edx, 1          {divide all values by 2}
              and eax, AndMask32
              and edx, AndMask32
              add eax, edx
              stosd
              add esi, 4
              loop @1
              pop esi
              pop edi
            end; {end of asm}
          end;
        end  //end of non-transparent code
      else
        for yy:= 0 to (SizeY-1) do //if transparent value is set
          begin
            d2:=    ScanLine[yy+y];
            s2:= b. ScanLine[yy+StartY];
            inc( s2, StartX);
            inc( d2, x);
            asm
              push edi
              push esi
              mov edi, d2
              mov esi, s2
              mov ecx, SizeX
              xor eax, eax
            @1:
              mov eax, [esi]
              cmp eax, TCol32
              jz @skip
              mov edx, [edi]
              shr eax, 1
              shr edx, 1          //divide all values by 2
              and eax, AndMask32
              and edx, AndMask32
              add edx, eax
              mov [edi], edx
            @skip:
              add edi, 4
              add esi, 4
              loop @1
              pop esi
              pop edi
            end;
          end;

  end;

end;  {end procedure}


procedure TBitmap64. DrawLight( x,y: Longint; bitmap:TBitmap64; r,g,b: byte);
{
  This is powerfull in games like UFO...
  It is same effect like in Win98 when you selects icons on the desktop

  NEED ASM,MMX
}

var StartX,StartY,yy,
    SizeX,SizeY: Longint;
    s1,d1: PWord;
    s2,d2: PLongint;
    LightColor16,
    Tcol,andmask: word;

    TCol32: Longint;
    LightColor32,
    AndMask32: Longint;

begin

  if  not Clip( bitmap, x,y, SizeX, SizeY, StartX, StartY) then exit;
  TCol:= Word( bitmap. TransparentColor);
  TCol32:= bitmap. TransparentColor;

  LightColor16:= Word( bitmap.RGB( r,g,b));
  LightColor32:= bitmap.RGB( r,g,b);

{ if source or target bitmap are pf16bit or pf15bit}
if (bmBpp<> bitmap. bmBpp)then
  begin
    raise exception.create('Can''t DrawLens with diferent bpp');exit;
  end;

  case pixelformat of
    pf15bit:
      asm mov andmask, 0011110111101111b{} end;
    pf16bit:
      asm mov andmask, 1111101111101111b{} end;
    pf32bit:
      asm mov AndMask32, 011111110111111101111111b;{}end
    else exit
  end;

  asm
    mov ax, LightColor16
    shr ax, 1
    and ax, andmask
    mov LightColor16, ax

    mov eax, LightColor32
    shr eax, 1
    and eax, AndMask32
    mov LightColor32, eax
  end;

  if bmBpp=2 then  // for 15/16 bits per pixel
  begin
    if not bitmap. Transparent then
      begin
        for yy:= 0 to (SizeY-1) do
          begin
            d1:=    ScanLine[yy+y];
            s1:= bitmap. ScanLine[yy+StartY];
            inc( s1, StartX);
            inc( d1, x);
            asm
              push edi
              push esi
              mov edi, d1
              mov esi, s1
              mov ecx, SizeX
              xor eax, eax
              mov dx, LightColor16
            @1:
              mov ax, [esi]
              shr ax, 1
              and ax, andmask
              add ax, dx
              stosw
              inc esi
              inc esi
              loop @1
              pop esi
              pop edi
            end; {end of asm}
          end;
        end  //end of non-transparent code
      else
        for yy:= 0 to (SizeY-1) do //if transparent value is set
          begin
            d1:=    ScanLine[yy+y];
            s1:= bitmap. ScanLine[yy+StartY];
            inc( s1, StartX);
            inc( d1, x);
            asm
              push edi
              push esi
              mov edi, d1
              mov esi, s1
              mov ecx, SizeX
              xor eax, eax
              mov dx, LightColor16
            @1:
              mov ax, [esi]
              cmp ax, TCol
              jz @skip
              shr ax, 1
              and ax, andmask
              add ax, dx
              mov [edi], ax
            @skip:
              inc esi
              inc esi
              inc edi
              inc edi
              loop @1
              pop esi
              pop edi
            end;
          end;
  end
  else
  begin  //for 32bit bpp
    if not bitmap. Transparent then
      begin
        for yy:= 0 to (SizeY-1) do
          begin
            d2:=    ScanLine[yy+y];
            s2:= bitmap. ScanLine[yy+StartY];
            inc( s2, StartX);
            inc( d2, x);
            asm
              push edi
              push esi
              mov edi, d2
              mov esi, s2
              mov ecx, SizeX
              xor eax, eax
              mov edx, LightColor32
            @1:
              mov eax, [esi]
              shr eax, 1
              and eax, AndMask32
              add eax, edx
              stosd
              add esi, 4
              loop @1
              pop esi
              pop edi
            end; {end of asm}
          end;
        end  //end of non-transparent code
      else
        for yy:= 0 to (SizeY-1) do //if transparent value is set
          begin
            d2:=    ScanLine[yy+y];
            s2:= bitmap. ScanLine[yy+StartY];
            inc( s2, StartX);
            inc( d2, x);
            asm
              push edi
              push esi
              mov edi, d2
              mov esi, s2
              mov ecx, SizeX
              xor eax, eax
              mov edx, LightColor32
            @1:
              mov eax, [esi]
              cmp eax, TCol32
              jz @skip
              shr eax, 1
              and eax, AndMask32
              add eax, edx
              mov [edi], eax
            @skip:
              add edi, 4
              add esi, 4
              loop @1
              pop esi
              pop edi
            end;
          end;

  end;

end;  {end procedure}

procedure TBitmap64. DrawGlyph( x,y: Longint; bitmap:TBitmap64; PartNumber, Parts: Longint);
{
  This is demonstration of how to divide image into parts, you can do this
  with all supported functions in graph64 (drawblend...)
}
var back1,OldWidth: Longint;
begin
  back1:= bitmap.bmLeftStart;
  OldWidth:= bitmap.Width;
  bitmap.bmLeftStart:= (OldWidth div Parts)* PartNumber;
  bitmap.bmWidth:= (OldWidth div Parts);

  Draw( x,y, bitmap);

  bitmap.bmLeftStart:= back1;  //restore saved variables
  bitmap.bmWidth:= OldWidth;
end;

procedure TBitmap64. DrawColorize( x,y: Longint; b:TBitmap64; RFactor,GFactor,BFactor: Longint;Light:Byte);
{
  Note: Factors are supported only ONE or ZERO!!!
}
var xx,yy: Longint;
    s1,d1: PWord;
    r: byte;
    t: Word;
    t1:Longint;

    AndMask32,
    StartX,StartY,
    SizeX,SizeY: Longint;
    AndMask16:Word;


begin
  if not Clip(b,x,y,SizeX,SizeY,StartX,StartY) then exit;
  if (sizex<2)or(sizey<1) then exit;

  AndMask16:= 0;
  AndMask32:= 0;

  case pixelformat of
    pf15bit: AndMask16:= (RFactor*$7c00) or (GFactor*$3e0) or (BFactor*$1f);
    pf16bit: AndMask16:= (RFactor*$f800) or (GFactor*$7e0) or (BFactor*$1f);
    pf32bit: AndMask32:= (RFactor*$ff0000) or (GFactor*$ff00) or (BFactor*$ff);
  end;

  if (bmBitsPixel <> b. bmBitsPixel) then
  begin
    raise exception.create('Sorry, can''t ....');exit;
  end;

  if bmbpp=2 then  //for 15/16 color's
  begin
    if b.Transparent then
      for yy:= 0 to SizeY-1 do
        begin
          s1:= b.PixelPtr[StartX, yy+Starty];
          d1:= PixelPtr[x,yy+y];
          xx:= SizeX-1;
          r:=  RStart-8;
          t:= b.TransparentColor;
          asm
            push ebx
            push edi
            push esi

            mov esi, s1
            mov edi, d1
            mov ebx, xx
         @1:
            //******** Pixel cycle ***********
            mov ax, [esi]  //get one pixel from buffer
            cmp ax, t
            jz @Skip
            //separate all values into ah=Red, al=Green, dl=Blue
            mov dl, al
            and dl, BBitMask   //now blue is in DL

            mov cl, r
            shr ax, cl       //operate two pixels at once
            shr al, 3        //al=Green , ah= Red

            shl ax, 3        // convert into Intensity= G*4+R*4+B*16
            shl dl, 4
                          // al= r
            add al,ah     // al= al+g
            add al,dl     // al= al+b

            shr al, 3     //Intensity div 8
            xor dx, dx
            xor ah, ah

            add al, light   //some ligtness because effect isn't perfect without this
            cmp al, 31

            jle @nothing
            mov al, 31

   @nothing:
            mov dl, al    //intensity into dl

            add cl, 3     //pack intensity into 15/16 bpp  (r,g,b=I)
            shl dx, cl
            or  ax, dx
            shl dx, 5
            or ax, dx
            and ax, AndMask16
            mov [edi], ax
      @Skip:
            inc edi
            inc edi
            inc esi
            inc esi

            dec ebx
            jnz @1

            pop esi
            pop edi
            pop ebx
          end;
        end
      else
      for yy:= 0 to SizeY-1 do
        begin
          s1:= b.PixelPtr[StartX, yy+Starty];
          d1:= PixelPtr[x,yy+y];
          xx:= SizeX-1;
          r:=  RStart-8;
          asm
            push ebx
            push edi
            push esi

            mov esi, s1
            mov edi, d1
            mov ebx, xx

         @1:
            mov ax, [esi]
            mov dl, al
            and dl, BBitMask

            mov cl, r

            shr ax, cl
            shr al, 3
            shl ax, 2
            shl dl, 4
            add al,ah
            add al,dl

            shr al, 3
            xor dx, dx
            xor ah, ah
            mov dl, al

            add al, light   //some ligtness because effect isn't perfect without this
            cmp al, 31

            jle @nothing
            mov al, 31

   @nothing:
            add cl, 3
            shl dx, cl
            or  ax, dx
            shl dx, 5
            or ax, dx
            and ax, AndMask16

            stosw
            inc esi
            inc esi

            dec ebx
            jnz @1

            pop esi
            pop edi
            pop ebx
          end;
        end;
  end;
  if bmbpp=4 then //for 32 bit color's
  begin
    if b.transparent then
    for yy:= 0 to SizeY-1 do
      begin
        s1:= b.PixelPtr[StartX, yy+Starty];
        d1:= PixelPtr[x,yy+y];
        xx:= SizeX-1;
        t1:= b.TransparentColor;
          asm
            push ebx
            push edi
            push esi

            mov esi, s1
            mov edi, d1
            mov ebx, xx

         @1:mov eax, [esi]
            cmp eax, t1
            jz @skip

            xor edx, edx
            shr eax, 1
            and eax, 011111110111111101111111b
            shr al, 6

            mov dl, al

            shr eax, 8
            add dl, al
            add dl, ah

            xor eax,eax

            add dl, light   //some ligtness because effect isn't perfect without this
            cmp dl, 100

            jle @nothing
            mov dl, 100

   @nothing:
            mov al, dl

            shl edx, 8
            or eax, edx
            shl edx, 8
            or eax, edx
            and eax, AndMask32
            mov [edi], eax

      @skip:
            add edi, 4
            add esi, 4
            dec ebx
            jnz @1

            pop esi
            pop edi
            pop ebx
          end;
        end
    else
    for yy:= 0 to SizeY-1 do
      begin
        s1:= b.PixelPtr[StartX, yy+Starty];
        d1:= PixelPtr[x,yy+y];
        xx:= SizeX-1;
          asm
            push ebx
            push edi
            push esi
            mov esi, s1
            mov edi, d1
            mov ebx, xx

         @1:mov eax, [esi]
            xor edx, edx
            shr eax, 1
            and eax, 011111110111111101111111b
            shr al, 6

            mov dl, al

            shr eax, 8
            add dl, al
            add dl, ah

            xor eax,eax
            mov al, dl   //in DL we have Intensity for all colors

            add al, light   //some ligtness because effect isn't perfect without this
            cmp al, 255
            jle @nothing
            mov al, 255
   @nothing:

            shl edx, 8
            or eax, edx
            shl edx, 8
            or eax, edx
            and eax, AndMask32

            stosd
            add esi, 4

            dec ebx
            jnz @1

            pop esi
            pop edi
            pop ebx
          end;
        end

  end;
end;


procedure TBitmap64. Draw( x,y: Longint; b:TBitmap64);
var StartX,StartY,
    SizeX,SizeY: Longint;  {in Bitmap}
    yy: Longint;
    s1,d1: PWord;
    s2,d2: PLongint;
    Tcol: word;
    TCol2: Longint;
begin
  if  not Clip( b, x,y, SizeX, SizeY, StartX, StartY) then exit;
  TCol:= Word( b. TransparentColor);  //transparent color for 15/16bpp
  TCol2:= b. TransparentColor; //transparent color for 32bpp

{ if source or target bitmap are pf16bit or pf15bit}
if (bmBpp<> b. bmBpp) then
  begin
    raise exception.create('Can''t draw into bitmap with diferent color depth');
  end;

  if bmBpp=2 then //for 15 and 15 bpp
    begin
      if not b. Transparent then
        begin
          for yy:= 0 to (SizeY-1) do
            begin
              d1:=    ScanLine[yy+y];
              s1:= b. ScanLine[yy+StartY];
              inc( s1, StartX);
              inc( d1, x);
              move ( s1^, d1^, SizeX*bmBpp);
            end;
        end
        else  //for bitmaps with transparent color
          for yy:= 0 to (SizeY-1) do  {this is only for 15bpp,16bpp}
            begin
              d1:=    ScanLine[yy+y];
              s1:= b. ScanLine[yy+StartY];
              inc( s1, StartX);
              inc( d1, x);
              asm
                push edi
                push esi
                mov edi, d1
                mov esi, s1

                mov ecx, SizeX
                xor eax, eax
             @1:
                mov ax, [esi]
                cmp ax, TCol
                jz @skip
                mov [edi], ax
          @skip:
                inc esi
                inc esi
                inc edi
                inc edi
                loop @1;
                pop esi
                pop edi
              end;
            end;
    end
    else
    if bmBpp=4 then  //for 32bit bpp
      begin
        if not b. Transparent then
          begin
            for yy:= 0 to (SizeY-1) do
              begin
                d2:=    ScanLine[yy+y];
                s2:= b. ScanLine[yy+StartY];
                inc( s2, StartX);
                inc( d2, x);
                move ( s2^, d2^, SizeX*bmBpp);
              end;
          end
        else  //for bitmaps with transparent color
          for yy:= 0 to (SizeY-1) do  //this is for 32bit bpp
            begin
              d2:=    ScanLine[yy+y];   //seek to start for data transfers
              s2:= b. ScanLine[yy+StartY];
              inc( s2, StartX);
              inc( d2, x);
              asm
                push edi
                push esi
                mov edi, d2
                mov esi, s2

                mov ecx, SizeX
                xor eax, eax
             @1:
                mov eax, [esi]
                cmp eax, TCol2
                jz @skip
                mov [edi], eax
          @skip:
                add esi,4
                add edi,4
                loop @1  // Note: Loop is faster than: "dec ecx;jnz @skip;" on AMD CPUs, I haven't tested this with INTEL CPUs
                pop esi
                pop edi
              end;
            end;
      end;

end;

Procedure TBitmap64. Scan_line( xl,xr,ul,ur,vl,vr,zl,zr: single; y: Longint;texture: TBitmap64);
{ Original Cpp code: REDOX }
var dest: PWord;
    xx,xsize,tu,tv: Longint;
    xres,
    dist,u_step,v_step,z_step,u,v,z,j: single;

begin
{it's only for 15 or 16bpp!!! bitmaps}
 xres:= bmWidth;

 {if left is < than right}
 if (xl>xr) then
  begin
   j:=xr;xr:=xl;xl:=j;
   j:=ur;ur:=ul;ul:=j;
   j:=vr;vr:=vl;vl:=j;
   j:=zr;zr:=zl;zl:=j;
  end;

  if ( ((xr-xl)>0) and (xr>0) and (xl<xres) ) then {if we can draw anything}
   begin
    dist:= xr-xl;       {dist is distance between first and last pixels}
    u_step:=(ur-ul)/dist;
    v_step:=(vr-vl)/dist;
    z_step:=(zr-zl)/dist;
    dest:= bmBits;     {where we start drawing}
    inc( dest, y+Round(xl));

    xsize:= Round( dist)+1;

    u:=ul;v:=vl;z:=zl;

    {clip left page}
    if (xl<0) then
     begin
      dest:= bmBits;
      inc( dest, y);   {set first pixel to left page, BTW: y is offset in bitmap}
      u:=u-xl*u_step;
      v:=v-xl*v_step;
      z:=z-xl*z_step;
      xl:= 0;
      xsize:= Round(xr);
     end;

    {Clip right page}
     if Round(xr)>=xres then{( Trunc(xl)+y > y+ Trunc( xres))}
     begin
      xsize:= Round(xres-(xl));
     end;
    for xx:= 0 to xsize-1 do
      begin
       tu:=Round( u/z);
       tv:=Round( v/z);
(*       source:= Texture. ScanLine[0]; {seek to first pixel}
       inc( source, tu+tv*Texture. BmWidth);*)
       dest^:={Source^ }Texture. Pixels[tu,tv];
       inc( dest);
//             *dest++=texture[(tu&255)+(tv&255)*256];
       u:=u+u_step;
       v:=v+v_step;
       z:=z+z_step;
      end;
   end;{end of drawing}
end;

procedure TBitmap64.GrayscaleMem( source, target: Pointer;size: Longint;pf: TPixelFormat);
begin
//
end;

procedure TBitmap64.DrawGrayscale(x,y: Longint; b:TBitmap64);
{ Draw bitmap (b) with grayscale to specific coordinates,
  If you want convert image into grayscale you can use Image.DrawGrayScale(0,0, Image);
}

var xx,yy: Longint;
    s1,d1: PWord;
    r: byte;
    t: Word;
    t1:Longint;
    StartX,StartY,
    SizeX,SizeY: Longint;

begin
  if not Clip(b,x,y,SizeX,SizeY,StartX,StartY) then exit;

  if (sizex<2)or(sizey<1) then exit;

  if (bmBitsPixel <> b. bmBitsPixel) then
  begin
    raise exception.create('Sorry, can''t ....');exit;
  end;

  if bmbpp=2 then  //for 15/16 color's
  begin
    if b.Transparent then
      for yy:= 0 to SizeY-1 do
        begin
          s1:= b.PixelPtr[StartX, yy+Starty];
          d1:= PixelPtr[x,yy+y];
          xx:= SizeX-1;
          r:=  RStart-8;
          t:= b.TransparentColor;
          asm
            push ebx
            push edi
            push esi

            mov esi, s1
            mov edi, d1
            mov ebx, xx
         @1:
            //******** Pixel cycle ***********
            mov ax, [esi]  //get one pixel from buffer
            cmp ax, t
            jz @Skip
            //separate all values into ah=Red, al=Green, dl=Blue
            mov dl, al
            and dl, BBitMask   //now blue is in DL

            mov cl, r
            shr ax, cl       //operate two pixels at once
            shr al, 3        //al=Green , ah= Red

            shl ax, 2        // convert into Intensity= G*4+R*4+B*16
            shl dl, 4
                          // al= r
            add al,ah     // al= al+g
            add al,dl     // al= al+b

            shr al, 3     //Intensity div 8
            xor dx, dx
            xor ah, ah
            mov dl, al    //intensity into dl

            add cl, 3     //pack intensity into 15/16 bpp  (r,g,b=I)
            shl dx, cl
            or  ax, dx
            shl dx, 5
            or ax, dx
            mov [edi], ax
      @Skip:
            inc edi
            inc edi
            inc esi
            inc esi

            dec ebx
            jnz @1

            pop esi
            pop edi
            pop ebx
          end;
        end
      else
      for yy:= 0 to SizeY-1 do
        begin
          s1:= b.PixelPtr[StartX, yy+Starty];
          d1:= PixelPtr[x,yy+y];
          xx:= SizeX-1;
          r:=  RStart-8;
          asm
            push ebx
            push edi
            push esi

            mov esi, s1
            mov edi, d1
            mov ebx, xx

         @1:
            mov ax, [esi]
            mov dl, al
            and dl, BBitMask

            mov cl, r

            shr ax, cl
            shr al, 3
            shl ax, 2
            shl dl, 4
            add al,ah
            add al,dl

            shr al, 3
            xor dx, dx
            xor ah, ah
            mov dl, al
            add cl, 3
            shl dx, cl
            or  ax, dx
            shl dx, 5
            or ax, dx
            stosw

            inc esi
            inc esi

            dec ebx
            jnz @1

            pop esi
            pop edi
            pop ebx
          end;
        end;
  end;
  if bmbpp=4 then //for 32 bit color's
  begin
    if b.transparent then
    for yy:= 0 to SizeY-1 do
      begin
        s1:= b.PixelPtr[StartX, yy+Starty];
        d1:= PixelPtr[x,yy+y];
        xx:= SizeX-1;
        t1:= b.TransparentColor;
          asm
            push ebx
            push edi
            push esi

            mov esi, s1
            mov edi, d1
            mov ebx, xx

         @1:mov eax, [esi]
            cmp eax, t1
            jz @skip

            xor edx, edx
            shr eax, 1
            and eax, 011111110111111101111111b
            shr al, 6

            mov dl, al

            shr eax, 8
            add dl, al
            add dl, ah

            xor eax,eax
            mov al, dl
            shl edx, 8
            or eax, edx
            shl edx, 8
            or eax, edx
            mov [edi], eax

      @skip:
            add edi, 4
            add esi, 4
            dec ebx
            jnz @1

            pop esi
            pop edi
            pop ebx
          end;
        end
    else
    for yy:= 0 to SizeY-1 do
      begin
        s1:= b.PixelPtr[StartX, yy+Starty];
        d1:= PixelPtr[x,yy+y];
        xx:= SizeX-1;
          asm
            push ebx
            push edi
            push esi
            mov esi, s1
            mov edi, d1
            mov ebx, xx

         @1:mov eax, [esi]
            xor edx, edx
            shr eax, 1
            and eax, 011111110111111101111111b
            shr al, 6

            mov dl, al

            shr eax, 8
            add dl, al
            add dl, ah

            xor eax,eax
            mov al, dl   //in DL we have Intensity for all colors
            shl edx, 8
            or eax, edx
            shl edx, 8
            or eax, edx

            stosd
            add esi, 4

            dec ebx
            jnz @1

            pop esi
            pop edi
            pop ebx
          end;
        end

  end;
end;

procedure   TBitmap64. TextureMap( p1,p2,p3: T3DPixel;t1,t2,t3: T2DPixel;textura: TBitmap64);
{ Original Cpp code: REDOX }
var            j,x,y,x1,x2,x3,y1,y2,y3,
               z1,z2,z3,u1,u2,u3,v1,v2,v3,
               dy,x_1,x_2,u_1,u_2,v_1,v_2,z_1,z_2,
               xlu_step,ulu_step,vlu_step,zlu_step,
               xld_step,uld_step,vld_step,zld_step,
               xru_step,uru_step,vru_step,zru_step,
               xrd_step,urd_step,vrd_step,zrd_step,
               xres,yres: single;

const  eye_z: single= 90;

begin
xres:= bmWidth;
yres:= bmHeight;

  x1:= p1.x; x2:= p2.x; x3:= p3.x;
  y1:= p1.y; y2:= p2.y; y3:= p3.y;

  z1:= 1/(p1.z+eye_z);
  z2:= 1/(p2.z+eye_z);
  z3:= 1/(p3.z+eye_z);

  u1:= t1.x*z1; u2:= t2.x*z2; u3:= t3.x*z3;
  v1:= t1.y*z1; v2:= t2.y*z2; v3:= t3.y*z3;

  ulu_step:= 0;  // this is only for compiler, be free to remove it
  vlu_step:= 0;
  zlu_step:= 0;
  xlu_step:= 0;
  xru_step:= 0;

   // prohazuje hodnoty tak, aby vertex s nejmen Y
   // souadnic ml index 1, prostedn 2 a nejvt 3

        if (y1>y2) then
        begin
         j:=y2;y2:=y1;y1:=j;j:=x2;x2:=x1;x1:=j;
         j:=u2;u2:=u1;u1:=j;j:=v2;v2:=v1;v1:=j;
         j:=z2;z2:=z1;z1:=j;
        end;

        if (y2>y3) then
        begin
         j:=y3;y3:=y2;y2:=j;j:=x3;x3:=x2;x2:=j;
         j:=u3;u3:=u2;u2:=j;j:=v3;v3:=v2;v2:=j;
         j:=z3;z3:=z2;z2:=j;
        end;

        if (y1>y2) then
        begin
         j:=y2;y2:=y1;y1:=j;j:=x2;x2:=x1;x1:=j;
         j:=u2;u2:=u1;u1:=j;j:=v2;v2:=v1;v1:=j;
         j:=z2;z2:=z1;z1:=j;
        end;

        // spote prsek scan-line vedouc prostednm
        // vertexem s protilehlou hranou facu

        if (abs(y2-y1)>=1) then x:=((x3-x1)/(y2-y1))*y2+x1  else x:= x1;

        if (x2<x) then
        begin

(*          // face typu LLR

          //      1
          //     /|
          //   2/ |
          //    \ |
          //     \|
          //      3
          // spote intrpolan DDA konstanty pro hranu 1-2
*)
          dy:= y2-y1;

          if (abs(dy)>=1) then
          begin
             xlu_step := (x2-x1)/dy;
             ulu_step := (u2-u1)/dy;
             vlu_step := (v2-v1)/dy;
             zlu_step := (z2-z1)/dy;
          end;

          // spote intrpolan DDA konstanty pro hranu 2-3

          dy:= y3-y2;

          if (abs(dy)>=1) then
          begin
             xld_step:= (x3-x2)/dy;
             uld_step:= (u3-u2)/dy;
             vld_step:= (v3-v2)/dy;
             zld_step:= (z3-z2)/dy;
          end;

          // spote intrpolan DDA konstanty pro hranu 1-3

          dy:= y3-y1;

          if (abs(dy)>=1) then
          begin
             xru_step := (x3-x1)/dy;
             uru_step := (u3-u1)/dy;
             vru_step := (v3-v1)/dy;
             zru_step := (z3-z1)/dy;

             xrd_step := xru_step;
             urd_step := uru_step;
             vrd_step := vru_step;
             zrd_step := zru_step;
          end;

        end {x2<x} else
        begin

(*          // face typu LRR

          //    1
          //    |\
          //    | \2
          //    | /
          //    |/
          //    3

          // spote intrpolan DDA konstanty pro hranu 1-2
*)
          dy:= y2-y1;

          if (abs(dy)>=1) then
          begin
             xru_step := (x2-x1)/dy;
             uru_step := (u2-u1)/dy;
             vru_step := (v2-v1)/dy;
             zru_step := (z2-z1)/dy;
          end;

          // spote intrpolan DDA konstanty pro hranu 2-3

          dy:= y3-y2;

          if (abs(dy)>=1) then
          begin
             xrd_step := (x3-x2)/dy;
             urd_step := (u3-u2)/dy;
             vrd_step := (v3-v2)/dy;
             zrd_step := (z3-z2)/dy;
          end;

          // spote intrpolan DDA konstanty pro hranu 1-3

          dy:= y3-y1;

          if (abs(dy)>=1) then
          begin
             xlu_step := (x3-x1)/dy;
             ulu_step := (u3-u1)/dy;
             vlu_step := (v3-v1)/dy;
             zlu_step := (z3-z1)/dy;

             xld_step := xlu_step;
             uld_step := ulu_step;
             vld_step := vlu_step;
             zld_step := zlu_step;
         end;

        end;

          // napln interpolan promnn pro pravou a levou hranu facu
          // hodnotamy z bodu 1 a zrove provede prevenci zaokrouhlovacch
          // chyby pitenm 0.5 k souadnicm texelu a x

          x_1:=x1+0.5;
          u_1:=u1+0.5*z1;
          v_1:=v1+0.5*z1;
          z_1:=z1;

          x_2:=x_1;
          u_2:=u_1;
          v_2:=v_1;
          z_2:=z_1;

          // spote linern adresu v textue
          // xres je ka a yres vka rozlien grafickho reimu

          y:= y1*xres;

          // cyklus vykreslujc jednotlive scan-line z bodu 1 do body 2

          while (y<y2*xres) {&&}and (y<xres*yres) do
          begin

                // interpolace

                x_1:=x_1+xlu_step; {               x_1+=xlu_step;}
                u_1:=u_1+ulu_step;
                v_1:=v_1+vlu_step;
                z_1:=z_1+zlu_step;

                x_2:=x_2+xru_step;
                u_2:=u_2+uru_step;
                v_2:=v_2+vru_step;
                z_2:=z_2+zru_step;

                // vykresl jednu scan-line

                if (y>=0) then scan_line(x_1,x_2,u_1,u_2,v_1,v_2,z_1,z_2,Round(y),textura);
                y:=y+xres;
          end;


          if (y1=y2) then
          begin

          // pokud je trojhlenk pravohl napln interpolan promnn
          // pro pravou hranu hodnotami z bodu 1 a pro levou hranu hodnotami
          // z bodu 2 a zrove provede prevenci zaokrouhlovacch
          // chyby pitenm 0.5 k souadnicm texelu a x

          x_1:=x1+0.5;
          u_1:=u1+0.5*z1;
          v_1:=v1+0.5*z1;
          z_1:=z1;

          x_2:=x2+0.5;
          u_2:=u2+0.5*z2;
          v_2:=v2+0.5*z2;
          z_2:=z2;

          if (x2<x) then
           begin
             j:=x_1;x_1:=x_2;x_2:=j;
             j:=u_1;u_1:=u_2;u_2:=j;
             j:=v_1;v_1:=v_2;v_2:=j;
             j:=z_1;z_1:=z_2;z_2:=j;
           end;

          end;

          // spote linern adresu v textue
          // xres je ka a yres vka rozlien grafickho reimu

          y:= y2*xres;

          // cyklus vykreslujc jednotliv scan-line z bodu 2 do body 3

          while (y<y3*xres) and (y<xres*yres) do
          begin

                // interpolace

                x_1:=x_1+xld_step;
                u_1:=u_1+uld_step;
                v_1:=v_1+vld_step;
                z_1:=z_1+zld_step;

                x_2:=x_2+xrd_step;
                u_2:=u_2+urd_step;
                v_2:=v_2+vrd_step;
                z_2:=z_2+zrd_step;

                // vykresl jednu scan-line

                if (y>=0) then scan_line(x_1,x_2,u_1,u_2,v_1,v_2,z_1,z_2,Round(y), textura);

                y:=y+xres;

                end;

end;
{ ************************ End of code for TBitmap64 ***************** }


{ ------------------------ Start code for TScreen64 ------------------ }

{$IFDEF apGDI}
procedure TScreen64. OnPaint( Sender: TObject);
begin
  gCanvas.Draw(0,0, BackBuffer);
end;

constructor TScreen64. Create( YourScreen: TPaintBox; MaxSize,AutoHandle: boolean;pixf:TPixelFormat);
begin
  WasAssigned:= False;
  gCanvas:= yourScreen. canvas;
  if MaxSize then
  begin
    bmWidth:= yourScreen. width;
    bmHeight:= yourScreen. height;
  end
  else
  begin
    bmWidth:= 0;
    bmHeight:= 0;
  end;

  bmBitsPixel:= pixf;
  bmBpp:= (bmBitsPixel + 7) shr 3;

  if AutoHandle then //automatic handle OnPaint
  begin
    YourScreen.onpaint:= OnPaint;
  end;
  BackBuffer:= TBitmap. Create;   {new back buffer}
  BackBuffer. Width:= bmWidth;
  BackBuffer. Height:= bmHeight;

  case pixelformat of
    pf8bit: BackBuffer. PixelFormat:= Graphics.pf8bit;
    pf15bit: BackBuffer. PixelFormat:= Graphics.pf15bit;
    pf16bit: BackBuffer. PixelFormat:= Graphics.pf16bit;
    pf32bit: BackBuffer. PixelFormat:= Graphics.pf32bit;
  end;

  bmBits:= BackBuffer.ScanLine[ BackBuffer.Height];
  Longint( bmBits):= Longint( bmBits) + bmBpp* (BackBuffer.width);  {seek to end of DIB}
  SetupBits;
  SetClipper();
end;

constructor TScreen64. Create( xres,yres: Longint;pixf:TPixelFormat);
var
  pal: PLogPalette;
  hpal: HPALETTE;
  i: Longint;

begin

  WasAssigned:= False;
  gCanvas:= Nil;
  bmWidth:= xres;
  bmHeight:=yres;
  bmBitsPixel:= pixf;
  bmBpp:= (bmBitsPixel + 7) shr 3;

  BackBuffer:= TBitmap. Create;   {new back buffer}
  BackBuffer. Width:= bmWidth;
  BackBuffer. Height:= bmHeight;

  case bmBitsPixel of
    pf8bit:  BackBuffer. PixelFormat:=  Graphics.pf8bit;
    pf16bit: BackBuffer. PixelFormat:= Graphics.pf16bit;
    pf15bit: BackBuffer. PixelFormat:= Graphics.pf15bit;
    pf32bit: BackBuffer. PixelFormat:= Graphics.pf32bit;
    else
      raise exception.Create('Unsupported pixel format!');
  end;

  if PixelFormat= pf8bit then
  begin
    BuildColors;
    pal := nil;
    try
      GetMem(pal, sizeof(TLogPalette) + sizeof(TPaletteEntry) * 255);
      pal.palVersion := $300;
      pal.palNumEntries := 256;
      for i := 0 to 255 do
        begin
          pal.palPalEntry[i].peRed := Palette^[i].r;
          pal.palPalEntry[i].peGreen := Palette^[i].g;
          pal.palPalEntry[i].peBlue := Palette^[i].b;
        end;
      hpal := CreatePalette(pal^);
      if hpal <> 0 then
        BackBuffer.Palette := hpal;

    finally
      FreeMem(pal);
    end;

  end;


  bmBits:= BackBuffer.ScanLine[ BackBuffer.Height];
  Longint( bmBits):= Longint( bmBits) + bmBpp* (BackBuffer.width);  {seek to end of DIB}

  SetupBits;
  SetClipper();
end;

constructor TScreen64. Create( YourCanvas: TCanvas; xres,yres: Longint;pixf:TPixelFormat);
begin
  WasAssigned:= False;
  gCanvas:= YourCanvas;
  bmWidth:= xres;
  bmHeight:=yres;

  bmBitsPixel:= pixf;
  bmBpp:= (bmBitsPixel + 7) shr 3;

  BackBuffer:= TBitmap. Create;   {new back buffer}
  BackBuffer. Width:= bmWidth;
  BackBuffer. Height:= bmHeight;


  case bmBitsPixel of
    pf8bit:  BackBuffer. PixelFormat:= Graphics.pf8bit;
    pf15bit: BackBuffer. PixelFormat:= Graphics.pf15bit;
    pf16bit:  BackBuffer. PixelFormat:= Graphics.pf16bit;
    pf32bit: BackBuffer. PixelFormat:= Graphics.pf32bit;
    else
      raise exception.Create('Unsupported pixel format!');
  end;

  bmBits:= BackBuffer.ScanLine[ BackBuffer.Height];
  Longint( bmBits):= Longint( bmBits) + bmBpp* (BackBuffer.width);  {seek to end of DIB}
  SetupBits;
  SetClipper();
end;
{$ENDIF}

{$IFNDEF apGDI}
constructor TScreen64. Create( xres,yres: Longint; pixf: TPixelFormat;_refresh: Longint);
{ _refresh is only for Vesa 3.0 cards or DirectX 6.x, not supported yet}
var RSize,GSize,BSize:Byte;
function SetMaskForColor( ColorSize,ColorStart: word): Longint;
var t,b: Longint;
begin
t:= 0;
for b:= 0 to ColorSize-1 do
 begin
  t:= (t shl 1) or 1;
 end;
result:= t shl ColorStart;
end;

begin
  WasAssigned:= false;
  bmWidth:= xres;
  bmHeight:= yres;
  bmBitsPixel:= pixf;
  bmBpp:= (bmBitsPixel + 7) shr 3;
  linePitch:= bmBpp*bmWidth;
  {$IFDEF win9x}
     DxInitAll( bmWidth, bmHeight, bmBitsPixel, RBitMask, GBitMask, BBitMask,RStart,GStart,BStart);
   bmBits:= nil;   {first you must use LOCK}
  {$ENDIF}

  {$IFDEF wdosx}
   Surface:= TDDSurface. Create( Xres, Yres, pixf);  {'create' video mode}
   MyScreen:= TVbeInterface. Create;
   MyScreen. ScreenMode( Xres, Yres, pixf);
   bmBits:= Surface. Buffer;
   {$ifdef debug}
     writeln( debugfile, 'Graphics vendor:',MyScreen.VendorString,' ',MyScreen.MajorVersion,'.',MyScreen.MinorVersion);
     writeln( debugfile, 'Current video mode:', MyScreen.FindMode(Xres,Yres,pixf) );
   {$endif}
    with MyScreen.VbeModeInfo[ MyScreen.FindMode(Xres,Yres,pixf)]^ do
    begin
      RStart:= RedFieldPosition;
      GStart:= GreenFieldPosition;
      BStart:= BlueFieldPosition;
      RSize:= RedMaskSize;
      GSize:= GreenMaskSize;
      BSIze:= BlueMaskSize;
    end;

  RBitMask:= SetMaskForColor( RSize,RStart);
  GBitMask:= SetMaskForColor( GSize,GStart);
  BBitMask:= SetMaskForColor( BSize,BStart);
 {$ENDIF}

{$IFDEF Debug}
  Writeln( debugfile, format( 'Video information. RStart: %d, GStart: %d, BStart: %d',[Rstart,Gstart,Bstart]));
  Writeln( debugfile, format( 'Color information. RMask:%d, GMask:%d, BMask: %d',[RBitMask shr RStart,GBitMask shr GStart,BBitMask shr BStart]));
{$ENDIF}

  Case RStart of  //set true video mode for resolution
    10: bmBitsPixel:= pf15bit;
    11: bmBitsPixel:= pf16bit;
  end;
  {$ifdef apFPC}
    SetClipper(0,0,bmWidth,bmHeight);
  {$else}
    SetClipper;
  {$endif}

end;
{$ENDIF}

{$IFDEF apGDI}

procedure TScreen64. SetSize( ValueX, ValueY: Longint);
begin
  bmWidth:= ValueX;
  bmHeight:= ValueY;
  BackBuffer.Width:= bmWidth;
  BackBuffer.Height:= bmHeight;
end;

procedure TScreen64. SetWidth( value: Longint);
begin
  bmWidth:= value;
  BackBuffer.Width:= bmWidth;
end;

procedure TScreen64. SetHeight( value: Longint);
begin
  bmHeight:= value;
  BackBuffer.Height:= bmHeight;
end;

{$ENDIF}

destructor TScreen64. Destroy;
begin
 {$IFDEF win9x}
   DxDoneAll;

 {$ENDIF}

 {$IFDEF wdosx}
   Surface. Destroy;
   MyScreen. Destroy;
 {$ENDIF}

 {$IFDEF apGDI}
    If not WasAssigned then BackBuffer. Free;
    if (PixelFormat=pf8bit)and( Assigned (Palette)) then Dispose( Palette);
    Palette:= nil;
 {$ENDIF}
end;

procedure TScreen64. Lock;
begin
{ Lock,
  You must use it when You can access to lpSurface in Windows,
  this func. lock memory for use ONLY you in one time.
  After all operation done, you must Unlock memory for other process, if you can
  flip it to screen or do any accelerated function like clearsurface, write text, DC.....
  BTW. Direct64. DxLock return pointer to memory where is Surface located.
}
 {$IFDEF win9x}
  bmBits:= Direct64. DxLock;
 {$ENDIF}
end;

procedure TScreen64. UnLock;
begin
 {$IFDEF win9x}
  Direct64. DxUnlock;
 {$ENDIF}
end;

procedure TScreen64. ClearSurface( color: Longint);
{$IFDEF wdosx}
var size: Longint;
    kde: pointer;
{$ENDIF}

begin

{$IFDEF win9x}
 Unlock;
//  DxClearSurface( color);
 Lock;
// bmBits:= DxLock;

{$ENDIF}

{$IFDEF wdosx}
kde:= bmBits;

if bmBpp= 2 then
begin
size:= (bmWidth*bmHeight*bmBpp) div 4;
asm
 cld
 push edi
  mov edi, kde
  mov ecx, size
  mov eax, color
  push ax
  push ax
  pop eax
  rep stosd
 pop edi
end;
end;
{$ENDIF}

{$IFDEF apGDI}
  Bar(0,0, Width,Height, color);
{$ENDIF}

end;

procedure TScreen64.RefreshRect( x1,y1,x2,y2: Longint);
begin
{$IFDEF apGDI}
  if x1>x2 then swapL( x1,x2);
  if y1>y2 then swapL( y1,y2);
  if Assigned( gCanvas) then BitBlt( gCanvas.Handle, x1,y1, 1+x2-x1, 1+y2-y1, BackBuffer.Canvas.Handle,x1,y1,SRCCOPY);
{$ENDIF}

end;

procedure TScreen64. Refresh;
begin
{$IFDEF win9x}
 DxRefresh;
{$ENDIF}
{$IFDEF wdosx}
 MyScreen. Content:= Surface;
{$ENDIF}

{$IFDEF apGDI}
  if Assigned( gCanvas) then BitBlt( gCanvas.Handle,0,0, Width, height, BackBuffer.Canvas.Handle,0,0,SRCCOPY);
{$ENDIF}
end;

constructor TAnim64.Create( filename: string; pixelformat1: Graph64.TPixelFormat);
var f: file;
    x,y,
    HeaderInfo: Longint;
    Frame,LastFrame:PAnimFrame;
    Image,LastImage:PAnimImage;
    Sprite,LastSprite: PSprite;
begin
  CurFrame:= 1; //set to first frame
  AssignFile( f, filename);
  try
    Reset( f,1);
  except
    raise exception.create(Format('Can''t open %s',[filename]));
    exit;
  end;

  PixelFormat:= PixelFormat1;
  BlockRead(f, HeaderInfo,4);
  if HeaderInfo<>64000 then begin raise exception.create('Unsupported file!!!');exit;end;

  BlockRead(f, Images, 4);
  BlockRead(f, Frames, 4);
  FFrame:= nil;
  LastFrame:= nil;LastSprite:= nil; //this is only for Delphi Hint
  for x:= 1 to Frames do
  begin
    new(Frame);Frame^.next:= nil;
    BlockRead(f, Frame^.Sprites,4);
    if Frame^.Sprites>0 then
    begin
      Frame^.FSprite:= nil;
      Sprite:= nil;
      for y:= 1 to Frame^.Sprites do
      begin
        new( Sprite);Sprite^.next:=nil;
        with Sprite^ do
        begin
          BlockRead( f, ImageIndex,4);
          BlockRead( f, PosX,4);
          BlockRead( f, PosY,4);
          BlockRead( f, Blend, 1);
          BlockRead( f, SFactor, 4);
          BlockRead( f, DFactor, 4);
        end;
         if Frame^.FSprite=nil then Frame^.FSprite:= Sprite else LastSprite^.next:= sprite;
         LastSprite:= Sprite;
      end;
    end; // end of loading sprites

    if FFrame=nil then FFrame:=Frame else LastFrame^.next:= frame;
    LastFrame:=Frame
  end; //end of loading frames
  AFrame:= FFrame;
  CurFrame:= 1;

  {$HINTS off}  //no thank's
  FImage:= nil;
  Image:= nil;
  LastImage:= nil;
  for x:= 1 to Images do
  begin
    New( Image);Image^.Next:= nil;
    BlockRead( f, Image^.Width, 4);
    BlockRead( f, Image^.Height, 4);
    BlockRead( f, Image^.transparent,1);
    BlockRead( f, Image^.TransparentColor, 2);
    GetMem( Image^.Data, Image^.Width*Image^.Height*2);
    BlockRead( f, Image^.Data^,Image^.WIdth*Image^.Height*2);
    if PixelFormat=graph64.pf15bit then
    g64ConvertBitmap( Image^.Data, Image^.Data, Image^.Width*Image^.Height,16,15);
    if FImage=nil then FImage:= Image else LastImage^.Next:= Image;
    LastImage:= Image;
  end;
  CloseFile( f);
end;
{$HINTS on}

destructor TAnim64.Destroy;
var Frame: PAnimFrame;
    Sprite: PSprite;
    Image: PAnimImage;
begin

while FImage<>nil do
begin
  FreeMem( FImage^.Data,SizeOf( FImage^.Data^));
  Image:= FImage^.Next;
  Dispose( FImage);
  FImage:= Image;
end;

  while FFrame<>nil do
    begin
      while FFrame^.FSprite<>nil do
        begin
          Sprite:= FFrame^.FSprite^.next;
          dispose( FFrame^.FSprite);
          FFrame^.FSprite:= Sprite;
        end;
          Frame:=FFrame^.next;
          dispose(FFrame);
          FFrame:=Frame;
       end;
end;

Procedure TAnim64.DrawFrame( where:TBitmap64; x,y: Longint);
var sprite: PSprite;
    Image: PAnimImage;
    HelpBitmap: TBitmap64;
    xx: Longint;
begin
  with AFrame^ do
    begin
      sprite:= FSprite;
      while Sprite<>nil do
        begin
          with Sprite^ do
            begin
              Image:= FImage;
              if imageIndex>1 then
              for xx:= 1 to (ImageIndex-1) do Image:=Image^.next;

              HelpBitmap:=TBitmap64.AssignData(Image^.Width,Image^.Height,pixelformat,Image^.data,Image^.Width*2);
              HelpBitmap.TransparentColor:= Image^.TransparentColor;
              HelpBitmap.Transparent:= Image^.Transparent;
              try
                Where.Draw(x+posx,y+posy,HelpBitmap); //not finished yet!!!
              finally
                HelpBitmap.Destroy;
              end;
            end;
          Sprite:= Sprite^.Next;
        end;
    end;
end;

procedure TAnim64.FirstFrame;
begin
  AFrame:= FFrame;
  CurFrame:= 1;
end;

procedure TAnim64.LastFrame;
begin
  AFrame:= FFrame;
  while AFrame^.Next<>nil do AFrame:= AFrame^.next;
end;

procedure TAnim64.NextFrame;
begin
  if AFrame^.Next=nil then AFrame:= FFrame   //if we are on last frame go to first
    else
      AFrame:= AFrame^.Next;
end;

procedure TAnim64.GotoFrame( whichframe: Longint);
var x: Longint;
begin
 x:=1;
 AFrame:= FFrame;
 while (x<whichframe)and(AFrame^.Next<>Nil) do
   begin
     AFrame:= AFrame^.next;
     inc( x);
   end;
end;



initialization
{$IFDEF debug}
  assignFile( DebugFile,'report');
  rewrite( DebugFile);
{$ENDIF}

finalization
{$IFDEF debug}
  CloseFile( DebugFile);
{$ENDIF}
{ ************************ End of code for TScreen64 ***************** }
end.


