unit Unit1;
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  Graph64,  
  Jpeg, ComCtrls, ExtCtrls;

const DefaultPixelFormat: TPixelFormat = pf15bit;

const gravity= 9.81;
type
  TParticle = record
    x,y,speed,angle: integer;
    dt,t,
    r,b,g //color
    : single;
    free: boolean;
  end;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure WMEraseBkgnd(var m: TWMEraseBkgnd); message WM_ERASEBKGND;
  public
    { Public declarations }
    mx,my: Integer; //mouse coordinates
    FX,Back: TBitmap64;
    Scr: TScreen64;
    star:array[1..1000]of TParticle;
    procedure AddParticle( _x,_y,_speed,_angle: integer; _r,_g,_b: single);
    procedure UpdateMe;
  end;


var
  Form1: TForm1;

implementation

{$R *.DFM}
function rad(alpha:integer):single;
begin
  result:=(alpha/180)*pi;
end;

procedure TForm1.AddParticle( _x,_y,_speed,_angle: integer; _r,_g,_b: single);
var xx: integer;
begin
  xx:= 1; while not star[xx].free do inc(xx); //this is quite slow, because we must always start from first record
  if xx>=high(star) then exit; //sorry can't add next
  with star[xx] do
  begin
    x:= _x;
    y:= _y;
    speed:= _speed;
    angle:= _angle;
    r:= _r;
    g:= _g;
    b:= _b;
    t:= 0;
    dt:= 0.5;
    free:= false;
  end;
end;

procedure TForm1.UpdateMe;
var xx,yy: integer; Painted: integer;
    xt,yt:integer;
begin

  for yy:= 0 to 1+Form1.Height div Back.height do
    for xx:= 0 to 1+Form1.Width div Back.width do
      Scr.DrawLens((xx)*Back.Width,(yy)*Back.Height, Back); //this is nice effect (like true motion blur)

  Painted:= 0;
  for xx:= low(star) to high(star) do
  if not star[xx].free then
  with star[xx] do
  begin
    xt:=x+ trunc( speed*cos( rad(angle))*t);
    yt:=y+ trunc( speed*sin( rad(angle))*t+0.5*gravity*t*t); //calculate new position with time t
    Scr.DrawBlendRGB(xt,yt, FX, r,g,b);
    Inc( painted);
    t:=t+dt;
    if t>=15 then free:= true;
  end;

  Scr.LensBar(0,0, Scr.Width,15, Scr.rgb(100,100,100));

end;

procedure TForm1.WMEraseBkgnd(var m : TWMEraseBkgnd); //flicker free
begin
  m.Result := LRESULT(False);
end;

procedure TForm1.FormCreate(Sender: TObject);
var xx: integer;
    jpg: TJpegImage;
begin
  Scr:= TScreen64.Create( Canvas,Width, Height, DefaultPixelFormat);
  Scr.ClearSurface( Scr.WinColor( clWhite));

  for xx:= low(star) to High(star) do
    with star[xx] do free:= true; //set all stars 'free'

  FX:= TBitmap64.Create(0,0, DefaultPixelFormat);
  FX.LoadFromBMPFile('star.bmp');

  Back:= TBitmap64.Create(0,0, DefaultPixelFormat);
  Back.LoadFromBMPFile('back2.bmp');

  Timer1.Enabled:= true;

end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  Canvas.Draw(0,0, Scr.BackBuffer);
end;


procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  mx:= x;
  my:= y;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var xx: integer;
begin

  for xx:= 0 to 5 do  //paint fountain
    AddParticle( 100+xx,200, 50, 240+random(60), random(10)/10, random(10)/10, random(10)/10);

  UpdateMe;
  Scr.Refresh;
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var xx: integer;
    r,g,b:byte;
begin

  for xx:= 1 to 30 do //add 30 particles to screen
  begin
    g:= random(10);
    r:= g;
    b:= random(r);
    AddParticle( x,y, random(20)+10, random(360), r/10, g/10, b/10);
  end;
end;

end.

