{
 ############################################################################
 "transparent" background effect with Graph64
 Code: Pavol Stugel
 Graph64 homepage: www.graph64.miesto.sk
 ############################################################################
 This unit DOESN'T work correctly with ACTIVE DESKTOP feature enabled.
 YOU MUST HAVE IMAGE ON THE DESKTOP TO SEE EFECT
}

First convert "dog.jpg" into "dog.bmp" with your favorite image viewer...

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls,
  Registry,//for registry manipulation
  Graph64, //graphics unit
  ComCtrls, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    Image1: TImage;
    TrackBar1: TTrackBar;
    Button1: TButton;
    Button2: TButton;
    ColorDialog1: TColorDialog;
    Button3: TButton;
    Button4: TButton;
    procedure FormCreate(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TrackBar1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
    Tile:Integer;
    BackColor: TColor;
    FileName: String;
    StartPoint: TPoint;
    Stretch: Boolean;
    Pic1: TBitmap64;
    Image: TBitmap;
    FullScreen,
    Back: TScreen64;

  public
    procedure UpdateBackground;
    { Public declarations }
  end;

var
  Form1: TForm1;
  const DefaultPixelFormat =pf15bit;

implementation

{$R *.DFM}

Procedure TForm1.UpdateBackground;
var xx,yy:Integer;
    rect:TRect;
begin

  Back.SetClipper;
  if Tile=1 then
  begin
    for yy:= 0 to (Screen.Height div Image.Height) do
      for xx:= 0 to (Screen.Width div Image.Width) do
          Back.BackBuffer.Canvas.Draw( -Left+xx*Image.Width, -PaintBox1.Top-Top+yy*Image.Height, Image);
  end
  else
  begin

    if Stretch then
      Back.Draw( -Left, -Top-PaintBox1.Top, FullScreen)
    else
    Back.BackBuffer.Canvas.Draw( -Left+ (Screen.Width - Image.Width)div 2 , -PaintBox1.Top-Top+(Screen.Height - Image.Height) div 2, Image);

  end;

  Back.Rectangle(0,0, Back.Width-1,Back.Height-1, Back.RGB(0,0,255));
  Back.Rectangle(1,1, Back.Width-2,Back.Height-2, Back.RGB(0,0,255));
  Back.LensBar( 0, 0, Back.Width, Back.Height, Back.WinColor( BackColor) );

//  Back.DrawGlyph( 0,0, Pic1, 2, 5);

  with Back.BackBuffer.Canvas do //write some waste texts
  begin
    brush.style := bsClear;
    Font.Color:= clYellow;
    textOut(10,0, Format('Screen resolution: %dx%d',[Screen.Width,Screen.Height]));
    textOut(10,15, Format('Background:"%s" %dx%d', [Filename,Image.Width,Image.Height]));
  end;

  Back.SetClipper( 10, 50, 150, 250);
  Back.DrawBrightness( -100, -40, Pic1, TrackBar1.Position);

  Back.SetClipper( 10+200, 50, 150+200, 250);
  If TrackBar1.Position>0 then  Back.DrawBlend( 100,-40, Pic1, TrackBar1.Position /255, 1- TrackBar1.Position/255);

end;

procedure TForm1.FormCreate(Sender: TObject);
var
  Registry: TRegistry;
  Rect: TRect;
  S: string;

begin

  Brush.Style:= bsClear;// this is faster than handle message WM_ERASEBKGND

  Pic1:= TBitmap64.Create(0,0, DefaultPixelFormat);
  Pic1.LoadFromBMPFile('dog.bmp');
  Pic1.SetClipper;

  Registry:= TRegistry.Create;
  Registry.RootKey:= HKEY_CURRENT_USER;
  Registry.OpenKey('CONTROL PANEL\DESKTOP', False);

  Tile:= StrToInt(Registry.ReadString('TILEWALLPAPER'));
  FileName:= Registry.ReadString('WALLPAPER');
  Stretch:= StrToInt(Registry.ReadString('WallPaperStyle')) = 2;
  Registry.Free;

  Image:= TBitmap.Create;
  Image.LoadFromFile( FileName);

  if Stretch then  //this is for faster drawing because on some graphics cards stretch function in 32bpp is extremly slow
  begin
    FullScreen:= TScreen64.Create( Screen.Width,Screen.Height, DefaultPixelFormat);
     with rect do
     begin
       left:= 0;
       top:= 0;
       right:= Screen.Width;
       bottom:= Screen.Height;
     end;
    FullScreen.BackBuffer.Canvas.StretchDraw( Rect, Image);
  end;

  Back:= TScreen64.Create( PaintBox1.Canvas, PaintBox1.Width, PaintBox1.Height, DefaultPixelFormat);
  BackColor:= clBlue;
  
  with Back.BackBuffer.Canvas do
  begin
    Font.Name:= 'Courier';
  end;

  UpdateBackground;
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
  Back.Refresh;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
 if (ssLeft in Shift) then
  begin
    Top:=  Top-(StartPoint.y-y);
    Left:= Left- (StartPoint.x-x);
    UpdateBackground;
    PaintBox1.Repaint;
  end;
end;

procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  StartPoint.x:= X;
  StartPoint.y:= Y;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  UpdateBackground;
  Back.Refresh;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Pic1.SwapRGB;
  UpdateBackground;
  Back.Refresh;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Pic1.SetClipper;
  Pic1.DrawBrightness(0,0, Pic1, TrackBar1.Position);
  UpdateBackground;
  Back.Refresh;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if ColorDialog1.Execute then
  begin
    BackColor:= ColorDialog1.Color;
  end;
  UpdateBackground;
  Back.Refresh;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  Close;
end;

end.
