unit tables;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, Menus, DB, DBTables, Buttons;

type
    TPrintType = (ptPrintAll, ptPrintThis);

type
  TfrmTables = class(TForm)
    panTables: TPanel;
    lvDetail: TListView;
    ImageList1: TImageList;
    lstTables: TListBox;
    tblInfo: TTable;
    Panel1: TPanel;
    btnPrintAllStruct: TBitBtn;
    chkOnTop: TCheckBox;
    BitBtn2: TBitBtn;
    dlgPrinterSetup: TPrinterSetupDialog;
    btnPrintThisStruct: TBitBtn;
    Panel2: TPanel;
    Splitter1: TSplitter;
    procedure FormShow(Sender: TObject);
    procedure lstTablesClick(Sender: TObject);
    procedure btnPrintAllStructClick(Sender: TObject);
    procedure chkOnTopClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure btnPrintThisStructClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    function BooltoStr(valin: boolean): string;
    procedure GetFieldsNew(tbl: TTable; printing: boolean);
  public
    { Public declarations }
    procedure SetupFields(printing: boolean);
    function GetFieldType(fld: TField): string;        
  end;

var
  frmTables: TfrmTables;
  gPrintType: TPrintType;

implementation

uses main, dbitypes, report;

{$R *.DFM}




procedure TfrmTables.FormShow(Sender: TObject);
begin
    if lstTables.Items.Count = 0 then exit;
    lstTables.Itemindex := 0;
    SetupFields(false);

    btnPrintAllStruct.Enabled := gPRINTER_OK;
    btnPrintThisStruct.Enabled := gPRINTER_OK;
end;

procedure TfrmTables.SetupFields(printing: boolean);
var ai: integer;
    tn: string;
begin
    tblInfo.Close;
    tn := lstTables.Items[lstTables.ItemIndex];
    ai := frmMain.lstAliases.ItemIndex;
    tblInfo.Databasename := frmMain.lstAliases.Items[ai];
    tblInfo.TableName := tn;
    tblInfo.Open;
    //GetFields(tblInfo);
    if not printing then GetFieldsNew(tblInfo, printing);
end;

procedure TfrmTables.GetFieldsNew(tbl: TTable; printing: boolean);
var counter: integer;
    li: TListItem;
begin
    lvDetail.Items.Clear;
    if not printing then
    begin
        for counter := 0 to tbl.Fieldcount-1 do
        begin
            li := lvDetail.Items.Add;
            li.Caption :=tbl.Fields[counter].FieldName;
            li.Subitems.Add(GetFieldType(tbl.Fields[counter]));
            li.Subitems.Add(InttoStr(tbl.Fields[counter].Size));
            li.Subitems.Add(BooltoStr(tbl.Fields[counter].Required));
            li.Subitems.Add(BooltoStr(tbl.Fields[counter].IsIndexfield));
        end;
    end;
end;

function TfrmTables.GetFieldType(fld: TField): string;
begin
    case fld.DataType of
        //ftUnkown: Result := 'Unknown';
        ftString: Result := 'String';
        ftSmallint: Result := '16-bit integer';
        ftInteger: Result := '32-bit integer';
        ftWord: Result := '16-bit unsigned integer';
        ftBoolean: Result := 'Boolean';
        ftFloat: Result := 'Float';
        ftCurrency: Result := 'Money';
        ftBCD: Result := 'BCD';
        ftDate: Result := 'Date';
        ftTime: Result := 'Time';
        ftDateTime: Result := 'DateTime';
        ftBytes: Result := 'Fixed bytes (binary)';
        ftVarBytes: Result := 'Variable bytes (binary)';
        ftAutoInc: Result := 'Auto-inc 32-bit integer';
        ftBlob: Result := 'BLOB';
        ftMemo: Result := 'Text memo';
        ftGraphic: Result := 'Bitmap';
        ftFmtMemo: Result := 'Formatted text memo';
        ftParadoxOle: Result := 'Paradox OLE';
        ftDBaseOle: Result := 'dBASE OLE';
        ftTypedBinary: Result := 'Typed binary';
    else
        Result := 'Unknown';
    end;
end;

procedure TfrmTables.lstTablesClick(Sender: TObject);
begin
    SetupFields(false);
end;

function TfrmTables.BooltoStr(valin: boolean): string;
begin
    if Valin then BooltoStr := 'Yes' else BooltoStr := 'No';
end;

procedure TfrmTables.btnPrintAllStructClick(Sender: TObject);
var OldIndex: integer;
begin
    gPrintType := ptPrintAll;
    Oldindex := lstTables.ItemIndex;
    frmReport.qrMain.Preview;
    lstTables.ItemIndex := OldIndex;
    SetupFields(false);
end;

procedure TfrmTables.chkOnTopClick(Sender: TObject);
begin
    if chkOnTop.Checked then frmTables.Formstyle := fsStayOnTop else
                                frmTables.FormStyle := fsNormal;
end;

procedure TfrmTables.FormActivate(Sender: TObject);
begin
    lstTables.SetFocus;
end;

procedure TfrmTables.BitBtn2Click(Sender: TObject);
begin
    dlgPrinterSetup.Execute;
end;

procedure TfrmTables.btnPrintThisStructClick(Sender: TObject);
begin
    gPrintType := ptPrintThis;
    frmReport.qrMain.Preview;
end;

procedure TfrmTables.FormCreate(Sender: TObject);
begin
    if chkOnTop.Checked then frmTables.FormStyle := fsStayOnTop else
        frmTables.FormStyle := fsNormal;
end;

end.
