{This report works by assigining the field and index detail to sub-detail
bands off a QRDetailLink. All the code to print the data is in the various
event handlers of the QRLabels. The OnNeedData event of the main report and
the two detail link bands sets up the data ready to be pulled out in the label
onPrint events}

unit report;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, bde, quickrpt, Qrctrls, db, dbtables;


type
  TfrmReport = class(TForm)
    qrMain: TQuickRep;
    qrbPageHeader: TQRBand;
    QRShape1: TQRShape;
    QRLabel3: TQRLabel;
    QRSysData1: TQRSysData;
    QRLabel4: TQRLabel;
    QRSysData2: TQRSysData;
    QRLabel5: TQRLabel;
    QRLabel2: TQRLabel;
    labTableName: TQRLabel;
    labDatabase: TQRLabel;
    qrbFieldHeader: TQRBand;
    QRShape2: TQRShape;
    QRLabel1: TQRLabel;
    QRLabel6: TQRLabel;
    Required: TQRLabel;
    QRLabel8: TQRLabel;
    QRLabel7: TQRLabel;
    qrbFieldDetail: TQRSubDetail;
    labFieldname: TQRLabel;
    labType: TQRLabel;
    labSize: TQRLabel;
    qrbIndexDetail: TQRSubDetail;
    labIndexName: TQRLabel;
    QRLabel11: TQRLabel;
    QRLabel12: TQRLabel;
    labIndexOptions: TQRLabel;
    QRLabel13: TQRLabel;
    labIndexFields: TQRLabel;
    QRLabel14: TQRLabel;
    QRLabel15: TQRLabel;
    QRLabel16: TQRLabel;
    labFilterExpression: TQRLabel;
    grpIndexHeader: TQRBand;
    QRLabel9: TQRLabel;
    imgRequired: TQRImage;
    imgIndexed: TQRImage;
    imgTick: TImage;
    imgCross: TImage;
    GroupFooterBand1: TQRBand;
    QRShape3: TQRShape;
    procedure qrMainBeforePrint(Sender: TQuickRep;
      var PrintReport: Boolean);
    procedure qrbFieldDetailBeforePrint(Sender: TQRCustomBand;
      var PrintBand: Boolean);
    procedure grpIndexHeaderBeforePrint(Sender: TQRCustomBand;
      var PrintBand: Boolean);
    procedure qrbFieldDetailNeedData(Sender: TObject;
      var MoreData: Boolean);
    procedure qrbIndexDetailNeedData(Sender: TObject;
      var MoreData: Boolean);
    procedure qrMainNeedData(Sender: TObject; var MoreData: Boolean);
    procedure labTableNamePrint(sender: TObject; var Value: string);
    procedure labFieldnamePrint(sender: TObject; var Value: string);
    procedure labTypePrint(sender: TObject; var Value: string);
    procedure labSizePrint(sender: TObject; var Value: string);
    procedure labIndexNamePrint(sender: TObject; var Value: string);
    procedure labIndexOptionsPrint(sender: TObject; var Value: string);
    procedure labIndexFieldsPrint(sender: TObject;  var Value: string);
    procedure QRLabel15Print(sender: TObject; var Value: string);
    function GetIndexDesc(T: TTable; IndexName: String): IDXDesc;
    procedure labFilterExpressionPrint(sender: TObject; var Value: string);
  private
    { Private declarations }

  public
    { Public declarations }
  end;

var
  frmReport: TfrmReport;
  gCurrentField: integer;
  gCurrentTable: integer;
  gCurrentIndex: Integer;
  gFirstin: boolean;

implementation

uses tables;

{$R *.DFM}


procedure TfrmReport.qrMainBeforePrint(Sender: TQuickRep;
  var PrintReport: Boolean);
begin
    case gPrintType of
        ptPrintAll:
        begin
            gCurrentTable := 0;
            gCurrentField := -1;
            gCurrentIndex := -1;
            frmTables.lstTables.Itemindex := gCurrentTable;
            frmTables.SetupFields(true);
        end;
        ptPrintThis:
        begin
            gCurrentTable := frmTables.lstTables.Itemindex;
            gCurrentField := -1;
            gCurrentIndex := -1;
        end;
    end;
    gFirstin := true;
    labDatabase.Caption := 'Database: '+frmTables.tblInfo.DatabaseName;
    PrintReport := true;
end;

procedure TfrmReport.qrbFieldDetailBeforePrint(Sender: TQRCustomBand;
  var PrintBand: Boolean);
begin
    PrintBand := true;
    with frmTables.tblInfo do
    begin
        if fields[gCurrentField].Required then imgRequired.Picture := imgTick.Picture
            else imgRequired.Picture := nil;
        if fields[gCurrentField].IsIndexField then imgIndexed.Picture := imgTick.Picture
            else imgIndexed.Picture := nil;
    end;

end;

procedure TfrmReport.grpIndexHeaderBeforePrint(Sender: TQRCustomBand;
  var PrintBand: Boolean);
begin
end;

{Index detail - Increment index counter each time this handler is called}
procedure TfrmReport.qrbFieldDetailNeedData(Sender: TObject;
  var MoreData: Boolean);
begin
    inc(gCurrentField);
    if gCurrentField > frmTables.tblInfo.fieldcount-1 then
    begin
        {If last field then drop out}
        gCurrentField := -1;
        MoreData := false;
    end
    else
    begin
        MoreData := true;
    end;
end;

{Index detail - Increment index counter each time this handler is called}
procedure TfrmReport.qrbIndexDetailNeedData(Sender: TObject;
  var MoreData: Boolean);
begin
    {Before printing indexes, update the list thing as per the help}
    if (not frmTables.tblInfo.IndexDefs.Updated) then
    begin
        frmTables.tblInfo.Indexdefs.Update;
        gCurrentIndex := -1;
    end;

    Inc(gCurrentIndex);
    {If last index then start new table}
    if gCurrentIndex > frmTables.tblInfo.Indexdefs.Count-1 then
    begin
        {Last index, so drop out}
        gCurrentIndex := -1;
        Moredata := false;
    end
    else
    begin
        MoreData := true;
    end;
end;

{Main report increments the table count each time. The field and
indexes are set up on sub-groups}
procedure TfrmReport.qrMainNeedData(Sender: TObject;
  var MoreData: Boolean);
begin
    if gFirstin then
    begin
        {Need to do this to kick the sub-detail bands into life}
        gFirstin := false;
        Moredata := true;
        exit;
    end;

    {If only printing current table, drop out}
    if gPrintType = ptPrintThis then
    begin
        MoreData := false;
        exit;
    end;

    inc(gCurrentTable);
    if gCurrentTable > frmTables.lstTables.Items.Count -1 then
    begin
        {If last table, fall out of print}
        MoreData := false;
    end
    else
    begin
        {Still tables to go, so new page and keep going}
        MoreData := true;
        frmTables.lstTables.Itemindex := gCurrentTable;
        frmTables.SetupFields(true);
        qrMain.Newpage;
    end;
end;


procedure TfrmReport.labTableNamePrint(sender: TObject; var Value: string);
begin
    Value := frmTables.tblInfo.Tablename;
end;

procedure TfrmReport.labFieldnamePrint(sender: TObject; var Value: string);
begin
    Value := frmTables.tblInfo.Fields[gCurrentField].Fieldname;
end;

procedure TfrmReport.labTypePrint(sender: TObject; var Value: string);
begin
    Value := frmTables.GetFieldType(frmTables.tblInfo.Fields[gCurrentField]);
end;

procedure TfrmReport.labSizePrint(sender: TObject; var Value: string);
begin
    with frmTables.tblInfo do
    begin
        if fields[gCurrentField].Size = 0 then value := '---' else
            Value := InttoStr(fields[gCurrentField].Size);
    end;
end;

procedure TfrmReport.labIndexNamePrint(sender: TObject; var Value: string);
var op: TIndexOptions;
begin
    Value := frmTables.tblInfo.Indexdefs[gCurrentIndex].Name;
    op := frmTables.tblInfo.Indexdefs[gCurrentIndex].Options;
    if (Value = '') and (ixPrimary in op) then Value := '<Primary>';
end;

procedure TfrmReport.labIndexOptionsPrint(sender: TObject;
  var Value: string);
var op: TIndexOptions;
begin
    Value := '';
    op := frmTables.tblInfo.Indexdefs[gCurrentIndex].Options;
    if ixPrimary in op then Value := Value + 'Primary   ';
    if ixUnique in op then Value := Value + 'Unique   ';
    if ixDescending in op then Value := Value + 'Descending   ';
    if ixExpression in op then Value := Value + 'Expression   ';
    if ixCaseInsensitive in op then Value := Value + 'Case-Insensitive';
    If Value = '' then Value := '<None>';
end;

procedure TfrmReport.labIndexFieldsPrint(sender: TObject;
  var Value: string);
begin
    Value := frmTables.tblInfo.Indexdefs[gCurrentIndex].Fields;
end;

procedure TfrmReport.QRLabel15Print(sender: TObject; var Value: string);
begin
    Value := frmTables.tblInfo.Indexdefs[gCurrentIndex].Expression;
end;

function TfrmReport.GetIndexDesc(T: TTable; IndexName: String): IDXDesc;
begin
  try
    Check(DbiGetIndexDesc(T.Handle, gCurrentIndex+1, Result)); //'0' = current index, index id's start at 1
  finally
  end;
end;

procedure TfrmReport.labFilterExpressionPrint(sender: TObject;
  var Value: string);
var i: IDXDesc;
    IName: string;
begin
    IName  := frmTables.tblInfo.Indexdefs[gCurrentIndex].Name;
    i := GetIndexDesc(frmTables.tblInfo, IName);
    Value := i.szKeyCond;
end;







end.
