unit output;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, ExtCtrls, DB, StdCtrls, hexdump, ComCtrls;

const
    cHEX_SIZE   = 1024*32;

type
  TfrmOutput = class(TForm)
    Panel1: TPanel;
    srcOutput: TDataSource;
    Panel2: TPanel;
    Label1: TLabel;
    labQueryTime: TLabel;
    Button1: TButton;
    panBlob: TPanel;
    panGrid: TPanel;
    grdOutput: TDBGrid;
    Splitter1: TSplitter;
    Panel3: TPanel;
    pcData: TPageControl;
    tsText: TTabSheet;
    tsHex: TTabSheet;
    memBlob: TMemo;
    tsNoBlob: TTabSheet;
    Label2: TLabel;
    Label3: TLabel;
    chkShowBlob: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure grdOutputColEnter(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure srcOutputDataChange(Sender: TObject; Field: TField);
    procedure chkShowBlobClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    pHexDump: THexDump;
    pHexStream: TMemoryStream;
    procedure UpdateBLOBView;
    function  CheckforBLOBfields: boolean;
    procedure SetupViews;    
  public
    { Public declarations }
  end;

var
  frmOutput: TfrmOutput;

implementation

uses main;

{$R *.DFM}

procedure TfrmOutput.Button1Click(Sender: TObject);
begin
    frmOutput.Close;
end;

procedure TfrmOutput.FormCreate(Sender: TObject);
begin
    pHexDump := CreateHexDump(tsHex);
    pHexStream := TMemoryStream.Create;
end;

procedure TfrmOutput.grdOutputColEnter(Sender: TObject);
begin
    UpdateBLOBView;
end;

procedure TfrmOutput.FormShow(Sender: TObject);
begin
    grdOutput.SetFocus;
    if CheckforBLOBfields then
    begin
        chkShowBlob.Checked := true;
        chkShowBlob.Enabled := true;
    end
    else
    begin
        chkShowBlob.Checked := false;
        chkShowBlob.Enabled := false;
    end;
    panBlob.Visible := chkShowBlob.Checked;
    UpdateBLOBView;
end;

procedure TfrmOutput.srcOutputDataChange(Sender: TObject; Field: TField);
begin
    {Data change - control scrolled so update memo if needed}
    UpdateBLOBView;
end;

procedure TfrmOutput.UpdateBLOBView;
begin
    if grdOutput.SelectedField = nil then exit;
    if not(chkShowBlob.Checked) then exit;

    with grdOutput do
    begin
        case SelectedField.Datatype of
            ftBlob, ftBytes, ftVarBytes, ftTypedBinary, ftGraphic:
            begin
                pcData.ActivePage := tsHex;
                pcData.Enabled := true;
                Setupviews;
            end;
            ftMemo, ftFmtMemo:
            begin
                pcData.ActivePage := tsText;
                pcData.Enabled := true;
                Setupviews;
            end;
        else
            {not in blob field, disable controls}
            pcData.ActivePage := tsNoBlob;
            pcData.Enabled := false;
        end;
    end;
end;

procedure TfrmOutput.SetupViews;
begin
    memBlob.Clear;
    pHexStream.Clear;
    pHexDump.Datasize := 0;
    with grdOutput do
    begin
        if SelectedField.isnull then
        begin
            pcData.ActivePage := tsText;
            pcData.Enabled := false;
            memBlob.Text := '<No Value>';
        end
        else
        begin
            pcData.Enabled := true;
            memBlob.text := SelectedField.Value;
            TBlobField(SelectedField).SavetoStream(pHexStream);
            pHexDump.Address := pHexStream.Memory;
            pHexDump.Datasize := pHexStream.Size;
        end;
    end;
end;

procedure TfrmOutput.chkShowBlobClick(Sender: TObject);
begin
    panBlob.Visible := chkShowBlob.Checked;
    UpdateBLOBView;
end;

function TfrmOutput.CheckforBLOBfields: boolean;
var c: integer;
begin
    result := false;
    for c := 0 to grdOutput.fieldcount-1 do
    begin
        if grdOutput.Fields[c].Datatype in
            [ftBlob, ftBytes, ftVarBytes, ftTypedBinary, ftMemo, ftGraphic] then
        begin
            result := true;
            exit;
        end;
    end;
end;

procedure TfrmOutput.FormDestroy(Sender: TObject);
begin
    pHexStream.Free;
end;

end.
