unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, DBTables, Buttons, tables, dbitypes, Menus, ExtCtrls;

const
    cBUTTON_CONNECT     = '&Connect to database';
    cBUTTON_DISCONNECT  = '&Disconnect from database';

type
  TfrmMain = class(TForm)
    qryMain: TQuery;
    GroupBox1: TGroupBox;
    lstAliases: TListBox;
    GroupBox2: TGroupBox;
    memResultSQL: TMemo;
    btnExecSQLResult: TButton;
    btnQuit: TBitBtn;
    btnConnect: TButton;
    memUpdateSQL: TMemo;
    btnExecSQLUpdate: TButton;
    labUpdateTime: TLabel;
    PopupMenu1: TPopupMenu;
    LoadResultSQL1: TMenuItem;
    LoadUpdateSQL1: TMenuItem;
    N1: TMenuItem;
    SaveResultSQL1: TMenuItem;
    SaveUpdateSQL1: TMenuItem;
    dlgSave: TSaveDialog;
    dlgLoad: TOpenDialog;
    Panel1: TPanel;
    Label1: TLabel;
    procedure btnQuitClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnConnectClick(Sender: TObject);
    procedure btnExecResult(Sender: TObject);
    procedure btnExecSQLUpdateClick(Sender: TObject);
    procedure LoadResultSQL1Click(Sender: TObject);
    procedure LoadUpdateSQL1Click(Sender: TObject);
    procedure SaveResultSQL1Click(Sender: TObject);
    procedure SaveUpdateSQL1Click(Sender: TObject);
    procedure lstAliasesKeyPress(Sender: TObject; var Key: Char);
    procedure lstAliasesDblClick(Sender: TObject);
  private
    { Private declarations }
    procedure ToggleConnect;
    procedure ConnectDB(alias: string);
    procedure DisconnectDB;
    procedure SetupTableswindow(Alias: string);
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;
  gPRINTER_OK: boolean;

implementation

uses output;

{$R *.DFM}

procedure TfrmMain.btnQuitClick(Sender: TObject);
begin
    frmMain.Close;
end;

procedure TfrmMain.FormShow(Sender: TObject);
var aliases: TStringList;
begin
    aliases := TStringList.Create;
    lstAliases.Clear;
    Session.GetAliasNames(Aliases);
    lstAliases.Items := aliases;
    disconnectDB;

    memResultSQL.Clear;
    memUpdateSQL.Clear;
    labUpdatetime.Caption := '';
end;

procedure TfrmMain.btnConnectClick(Sender: TObject);
begin
    if not enabled then exit;
    if lstAliases.ItemIndex = -1 then exit;
    ToggleConnect;
end;

procedure TfrmMain.ToggleConnect;
var alias: string;
begin
    if btnConnect.Caption = cBUTTON_CONNECT then
    begin
        alias := lstAliases.Items[lstAliases.ItemIndex];
        ConnectDB(Alias);
        exit;
    end;

    if btnConnect.Caption = cBUTTON_DISCONNECT then
    begin
        DisconnectDB;
        exit;
    end;
end;

procedure TfrmMain.ConnectDB(alias: string);
begin
    try
        SetupTablesWindow(Alias);

        qryMain.DatabaseName := Alias;
        frmMain.Caption := 'Generic BDE SQL Chucker Thing - '+alias;
        btnConnect.Caption := cBUTTON_DISCONNECT;
        labUpdateTime.Caption := '';

        lstAliases.Enabled := false;
        memResultSQL.Enabled := true;
        btnExecSQLResult.Enabled := true;
        memUpdateSQL.Enabled := true;
        btnExecSQLUpdate.Enabled := true;

        memResultSQL.Clear;
        memUpdateSQL.Clear;
        memResultSQL.SetFocus;
    except
        on e:exception do
        begin
            lstAliases.Enabled := true;
            qryMain.Close;
            frmTables.tblInfo.Close;
            Messagedlg('Error connecting to database.'+#13+
                       'Error: '+e.message, mtError, [mbOK], 0);
            exit;
        end;
    end;
end;

procedure TfrmMain.DisconnectDB;
begin
    frmTables.Close;
    frmTables.tblInfo.Close;
    qryMain.Close;

    lstAliases.Enabled := true;
    memResultSQL.Enabled := false;
    btnExecSQLResult.Enabled := false;
    memUpdateSQL.Enabled := false;
    btnExecSQLUpdate.Enabled := false;

    frmMain.Caption := 'Generic BDE SQL Chucker Thing - No Database';
    btnConnect.Caption := cBUTTON_CONNECT;
end;

procedure TfrmMain.btnExecResult(Sender: TObject);
var tc, newtc: DWORD;
begin
    try
        qryMain.SQL.Clear;
        qryMain.SQL.Add(memResultSQL.Text);
        tc := GetTickCount;
        qryMain.Open;
        newtc := GetTickCount;
        frmOutput.labQueryTime.Caption := InttoStr(newtc-tc)+' ms';
        frmOutput.show;
    except
        on e:exception do
        begin
            {lstAliases.Enabled := true;}
            Messagedlg('Error executing SQL statement.'+#13+
                       'Error: '+e.message, mtError, [mbOK], 0);
            exit;
        end;
    end;
end;

procedure TfrmMain.SetupTableswindow(Alias: string);
var dbTables: TStringList;
begin
    dbTables := TStringList.Create;
    Session.GetTableNames(Alias, '*.*', true, false, dbTables);

    frmTables.lstTables.Clear;
    frmTables.lstTables.Items := dbTables;
    frmTables.Show;
end;



procedure TfrmMain.btnExecSQLUpdateClick(Sender: TObject);
var tc, newtc: DWORD;
begin
    try
        qryMain.SQL.Clear;
        qryMain.SQL.Add(memUpdateSQL.Text);
        tc := GetTickCount;
        qryMain.ExecSQL;
        newtc := GetTickCount;
        labUpdateTime.Caption := InttoStr(newtc-tc)+' ms';
    except
        on e:exception do
        begin
            {lstAliases.Enabled := true;}
            Messagedlg('Error executing SQL statement.'+#13+
                       'Error: '+e.message, mtError, [mbOK], 0);
            exit;
        end;
    end;
end;

procedure TfrmMain.LoadResultSQL1Click(Sender: TObject);
begin
    if dlgLoad.Execute then memResultSQL.Lines.LoadFromFile(dlgLoad.Filename);
end;

procedure TfrmMain.LoadUpdateSQL1Click(Sender: TObject);
begin
    if dlgLoad.Execute then memUpdateSQL.Lines.LoadFromFile(dlgLoad.Filename);
end;

procedure TfrmMain.SaveResultSQL1Click(Sender: TObject);
begin
    if dlgSave.execute then memResultSQL.Lines.SaveToFile(dlgSave.Filename);
end;

procedure TfrmMain.SaveUpdateSQL1Click(Sender: TObject);
begin
    if dlgSave.execute then memUpdateSQL.Lines.SaveToFile(dlgSave.Filename);
end;

procedure TfrmMain.lstAliasesKeyPress(Sender: TObject; var Key: Char);
begin
    if Key = #13 then
    begin
        btnConnect.Click;
    end;
end;

procedure TfrmMain.lstAliasesDblClick(Sender: TObject);
begin
    btnConnect.Click;
end;




end.

