// 235 RGB colors
unit PalImage;
interface
uses windows, extctrls;
const byVals : array[0..234,1..3] of byte = (
( 19,  12,   9),
( 22,  21,  35),
( 29,  34,  14),
( 14,  40,  45),
( 45,  22,  15),
( 42,  27,  37),
( 55,  36,  21),
( 51,  43,  46),
( 31,  26,  85),
( 12,  55,  82),
( 55,  52,  74),
( 56,  53, 112),
( 54,  69,  57),
( 10,  67, 101),
( 55,  76,  79),
( 54,  86, 104),
( 60, 101,  91),
( 54, 104, 107),
( 73,  22,  14),
( 81,  27,  40),
( 75,  44,  24),
( 81,  52,  42),
(106,  24,  15),
(101,  29,  36),
(107,  54,  26),
(105,  56,  43),
( 77,  56,  75),
( 71,  58, 106),
(105,  54,  72),
(111,  61,  99),
( 84,  73,  22),
( 85,  72,  50),
( 92, 100,  27),
( 89, 101,  51),
(111,  74,  25),
(111,  73,  50),
(112, 104,  23),
(112, 107,  50),
( 82,  76,  77),
( 81,  80, 108),
( 84, 102,  82),
( 83, 108, 111),
(111,  82,  76),
(107,  88, 105),
(112, 105,  80),
(113, 108, 110),
(  7,  63, 149),
( 54,  55, 137),
( 39,  50, 181),
( 14,  81, 153),
( 14,  89, 169),
( 13,  99, 157),
( 15, 103, 179),
( 54,  65, 137),
( 63,  67, 176),
( 51, 112, 134),
( 41, 116, 173),
(  9,  94, 196),
( 15, 109, 200),
( 14, 114, 225),
( 37, 124, 197),
( 70,  59, 132),
( 79,  77, 136),
( 81,  82, 165),
( 87, 111, 141),
( 88, 124, 168),
(101,  89, 134),
( 98,  82, 166),
(112, 116, 139),
(112, 121, 167),
( 59, 133, 123),
(116, 136,  54),
( 80, 132, 117),
(117, 138,  79),
(116, 138, 112),
(126, 171,  82),
(120, 168, 108),
( 21, 130, 190),
( 58, 136, 136),
( 50, 134, 185),
( 20, 130, 211),
( 49, 139, 206),
( 47, 143, 227),
( 55, 143, 227),
( 52, 144, 224),
( 53, 158, 232),
( 82, 139, 140),
( 81, 138, 179),
( 92, 160, 177),
(116, 139, 144),
(118, 142, 170),
(120, 164, 141),
(118, 166, 175),
( 72, 150, 207),
( 72, 155, 230),
( 83, 165, 215),
( 82, 169, 232),
(113, 152, 200),
(117, 176, 206),
(112, 184, 232),
(126, 192, 229),
(143,  22,  13),
(141,  52,  24),
(141,  57,  41),
(174,  27,  12),
(171,  49,  24),
(173,  57,  38),
(133,  63,  65),
(141,  73,  25),
(142,  79,  47),
(140, 109,  25),
(143, 109,  50),
(170,  80,  26),
(173,  86,  47),
(173, 107,  25),
(178, 101,  53),
(137,  87,  75),
(134,  90, 101),
(143, 107,  82),
(146, 114, 110),
(171,  89,  71),
(175, 109,  78),
(167, 122, 112),
(197,  50,  23),
(204,  61,  41),
(206,  89,  11),
(198,  88,  47),
(207, 111,  13),
(206, 106,  53),
(227,  93,  35),
(227, 117,  54),
(195,  89,  66),
(206, 116,  76),
(200, 125,  99),
(226, 122,  69),
(142, 121, 134),
(165, 124, 131),
(154, 128,  26),
(147, 137,  52),
(155, 170,  59),
(177, 137,  25),
(174, 140,  51),
(179, 166,  46),
(143, 138,  79),
(146, 137, 114),
(139, 165,  81),
(144, 172, 111),
(173, 141,  82),
(177, 135, 119),
(176, 169,  83),
(177, 171, 112),
(150, 197,  89),
(147, 200, 118),
(175, 196,  87),
(178, 203, 120),
(201, 141,  26),
(210, 142,  49),
(206, 169,  48),
(230, 140,  56),
(233, 169,  56),
(213, 136,  83),
(204, 144, 115),
(207, 171,  80),
(212, 167, 118),
(229, 144,  75),
(229, 151, 111),
(233, 173,  79),
(230, 177, 111),
(243, 196,  60),
(211, 193,  72),
(211, 200, 120),
(214, 228, 115),
(239, 204,  82),
(238, 209, 109),
(242, 226,  88),
(244, 228, 112),
(136, 134, 134),
(134, 135, 149),
(135, 148, 138),
(135, 150, 153),
(152, 133, 134),
(150, 138, 148),
(152, 150, 138),
(151, 150, 150),
(140, 149, 168),
(147, 169, 147),
(147, 170, 175),
(179, 143, 138),
(177, 154, 164),
(184, 165, 151),
(179, 175, 174),
(134, 153, 200),
(144, 176, 205),
(152, 182, 228),
(162, 157, 192),
(175, 185, 197),
(170, 188, 229),
(153, 206, 138),
(150, 198, 183),
(174, 204, 143),
(177, 199, 182),
(171, 229, 144),
(168, 236, 166),
(149, 200, 208),
(145, 205, 234),
(157, 226, 245),
(180, 203, 204),
(172, 215, 233),
(183, 226, 213),
(177, 230, 240),
(199, 152, 138),
(194, 158, 162),
(210, 170, 147),
(208, 180, 171),
(230, 156, 131),
(227, 178, 148),
(227, 185, 170),
(202, 187, 195),
(226, 189, 194),
(214, 200, 150),
(215, 197, 181),
(192, 227, 137),
(206, 231, 170),
(233, 206, 148),
(232, 204, 180),
(245, 231, 142),
(242, 231, 180),
(211, 208, 207),
(215, 218, 226),
(213, 227, 217),
(216, 229, 230),
(230, 216, 206),
(229, 220, 227),
(235, 228, 212),
(237, 237, 237));

function GeneratePalette : HPalette;
procedure AssignPalette( Image1 : TImage );
procedure DeletePalette( Image1 : TImage );
implementation
const nNumColors = 235;
// Code that you will need to call in the FormCreate or FormActivate 
 // function for PalGen to work

function GeneratePalette : HPalette;
var
iIndex, 
iLoop               : integer;
lp                  : TMaxLogPalette;
begin
  lp.palVersion := $300;
  lp.palNumEntries := nNumColors;
  for iLoop := 0 to nNumColors-1 do
  begin
	lp.palPalEntry[iLoop].peRed := byVals[iLoop,1];
	lp.palPalEntry[iLoop].peGreen := byVals[iLoop,2];
	lp.palPalEntry[iLoop].peBlue := byVals[iLoop,3];
	lp.palPalEntry[iLoop].peFlags := 0;
  end;

  Result := CreatePalette( PLogPalette(@lp)^ );
end;

procedure AssignPalette( Image1 : TImage );
var Hpal : HPalette;
begin
  hPal := GeneratePalette;
  Image1.Picture.Bitmap.Palette := hPal;
  Image1.Repaint;
end;

procedure DeletePalette( Image1 : TImage );
begin
    DeleteObject( Image1.Picture.Bitmap.Palette) ;
end;
end.