{:Windows utility functions.
@author Chiang Seng Chang <a href="mailto:cs@ctzen.com">cs@ctzen.com</a>
All freeware disclaimers applies.
}
unit zWindows;

interface

uses
  Windows;

function PointL(const x, y: LongInt): TPointL;

implementation

{:Creates a TPointL structure from a pair of coordinates.
Call PointL to create a TPointL structure that represents the specified
coordinates. Use PointL to construct parameters for functions
that require a TPointL, rather than setting up local variables
for each parameter.
@param  x    The X coordinate.
@param  y    The Y coordinate.
@return      A TPointL structure for coordinates X and Y.
@example        <code>
var
  p: TPointL;
begin
  p := PointL(100, 100);
end;
</code>
}
function PointL(const x, y: LongInt): TPointL;
begin
  Result.x := x;
  Result.y := y;
end;

end.
