{:Utility functions.
@author Chiang Seng Chang <a href="mailto:cs@ctzen.com">cs@ctzen.com</a>
All freeware disclaimers applies.
}
unit zUtils;

interface

function iif(const Test: Boolean; const True, False: Variant): Variant;
function BooleanAsString(const Test: Boolean): string;

implementation

{:Conditional assignment.
Returns the value in True or False depending on the condition Test.
@param  Test    The test condition.
@param  True    Returns this value if Test is True.
@param  False   Returns this value if Test is False.
@return         Value in True or False depending on Test.
@example        <code>
bar := iif(foo, 1, 0);
</code>
<br>has the same effects as:<br>
<code>
if foo then
  bar := 1
else
  bar := 0;
</code>
}
function iif(const Test: Boolean; const True, False: Variant): Variant;
begin
  if Test then
    Result := True
  else
    Result := False;
end;

{:Transforms Boolean to String.
Returns the string 'True' or 'False' depending on Test.
@param  Test    The test condition.
@return         'True' if Test is true, otherwise 'False'.
@example        <code>
ShowMessage('foo is ' + BooleanAsString(foo));
</code>
<br>has the same effects as:<br>
<code>
if foo then
  ShowMessage('foo is True')
else
  ShowMessage('foo is False');
</code>
}
function BooleanAsString(const Test: Boolean): string;
begin
  Result := iif(Test, 'True', 'False');
end;

end.
