unit zTrace;

interface

{$IFDEF Debug}

procedure zTraceLog(const S: String);

var
  TraceFile: TextFile;

{$ENDIF}

implementation

{$IFDEF Debug}

uses
  SysUtils;

const
  TRACE_FILE = 'c:\zTrace.txt';

procedure zTraceLog(const S: String);
begin
  WriteLn(TraceFile, S);
  Flush(TraceFile);
end;

initialization
  AssignFile(TraceFile, TRACE_FILE);
  if FileExists(TRACE_FILE) then
  begin
    Append(TraceFile);
    WriteLn(TraceFile, StringOfChar('-', 20));
  end
  else
  begin
    Rewrite(TraceFile);
  end;

finalization
  CloseFile(TraceFile);

{$ENDIF}  

end.
