{:zBandObject wizard form.
@author Chiang Seng Chang <a href="mailto:cs@ctzen.com">cs@ctzen.com</a>
All freeware disclaimers applies.
}
unit zBandObjectDLLWizardForm;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms;

type
  TzWizardForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    EditBandName: TEdit;
    RgBandType: TRadioGroup;
    Bevel1: TBevel;
    Label2: TLabel;
    EditBandDesc: TEdit;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  end;

implementation

{$R *.DFM}

procedure TzWizardForm.Button1Click(Sender: TObject);
begin
  with EditBandName do
  begin
    Text := Trim(Text);
    if not IsValidIdent(Text) then
    begin
      SetFocus;
      raise Exception.Create('Band name has to be a valid identifier  !');
    end;
  end;
  with EditBandDesc do
  begin
    Text := Trim(Text);
    if Text = '' then
    begin
      SetFocus;
      raise Exception.Create('Please enter band description !');
    end;
  end;
  ModalResult := mrOK;
end;

procedure TzWizardForm.Button3Click(Sender: TObject);
const
  CRLF = #13#10;
  CRLF2 = #13#10#13#10;
  HELP_TEXT = CRLF +
    'Band Name' + CRLF +
    'Enter a band name, e.g. MyBand.' + CRLF +
    'This will be the class name of the band object.' + CRLF +
    'No need to prefix it with ''T'' as it will be generated.' + CRLF2 +
    'Description' + CRLF +
    'Enter a menuitem text, e.g. &My Band' + CRLF +
    'This text will appear in the Explorer Bar or Toolbars menu.' + CRLF2 +
    'Band Type' + CRLF +
    'Select the type of band object to create.';


var
  HelpForm: TForm;
  HelpText: TMemo;
begin
  HelpForm := TForm.Create(Application);
  try
    with HelpForm do
    begin
      Caption := Self.Caption + ' Help';
      BorderStyle := bsDialog;
      Top := Self.Top + Self.Height div 2;
      Left := Self.Left + Self.Width div 2;
      Height := 260;
      Width := 350;
    end;
    HelpText := TMemo.Create(HelpForm);
    with HelpText do
    begin
      Parent := HelpForm;
      Align := alClient;
      ReadOnly := True;
      Text := HELP_TEXT;
    end;
    HelpForm.ShowModal;
  finally
    HelpForm.Free;
  end;
end;

end.
