{:zBandObject wizard.
@author Chiang Seng Chang <a href="mailto:cs@ctzen.com">cs@ctzen.com</a>
All freeware disclaimers applies.
}
unit zBandObjectDLLWizard;

interface

uses
  ToolsApi, Windows;

type
  TzBandObjectDLLWizard = class(TInterfacedObject,
    IOTANotifier,
    IOTAWizard,
    IOTARepositoryWizard,
    IOTAProjectWizard)
  public
    // IOTANotifier
    procedure AfterSave;
    procedure BeforeSave;
    procedure Destroyed;
    procedure Modified;
    // IOTAWizard
    function GetIDString: string;
    function GetName: string;
    function GetState: TWizardState;
    procedure Execute;
    // IOTARepositoryWizard
    function GetAuthor: string;
    function GetComment: string;
    function GetPage: string;
    function GetGlyph: HICON;
  end;

  TzBandObjectProjectCreator = class(TInterfacedObject,
    IOTACreator,
    IOTAProjectCreator)
  public
    // IOTACreator
    function GetCreatorType: string;
    function GetExisting: Boolean;
    function GetFileSystem: string;
    function GetOwner: IOTAModule;
    function GetUnnamed: Boolean;
    // IOTAProjectCreator
    function GetFileName: string;
    function GetOptionFileName: string;
    function GetShowSource: Boolean;
    procedure NewDefaultModule;
    function NewOptionSource(const ProjectName: string): IOTAFile;
    procedure NewProjectResource(const Project: IOTAProject);
    function NewProjectSource(const ProjectName: string): IOTAFile;
  end;

  TzBandObjectProjectSource = class(TInterfacedObject,
    IOTAFile)
  private
    FProjectName: string;
  public
    constructor Create(const ProjectName: string);
    // IOTAFile
    function GetSource: string;
    function GetAge: TDateTime;
  end;

  TzBandType = (zbtInfoBand, zbtCommBand, zbtToolBand, zbtDeskBand);

  TzBandObjectModuleCreator = class(TInterfacedObject,
    IOTACreator,
    IOTAModuleCreator)
  private
    FBandName: string;
    FBandDesc: string;
    FBandType: TzBandType;
  public
    constructor Create(const BandName, BandDesc: String;
      const BandType: TzBandType);
    // IOTACreator
    function GetCreatorType: string;
    function GetExisting: Boolean;
    function GetFileSystem: string;
    function GetOwner: IOTAModule;
    function GetUnnamed: Boolean;
    // IOTAModuleCreator
    function GetAncestorName: string;
    function GetImplFileName: string;
    function GetIntfFileName: string;
    function GetFormName: string;
    function GetMainForm: Boolean;
    function GetShowForm: Boolean;
    function GetShowSource: Boolean;
    function NewFormFile(const FormIdent, AncestorIdent: string): IOTAFile;
    function NewImplSource(const ModuleIdent, FormIdent, AncestorIdent: string): IOTAFile;
    function NewIntfSource(const ModuleIdent, FormIdent, AncestorIdent: string): IOTAFile;
    procedure FormCreated(const FormEditor: IOTAFormEditor);
  end;

  TzBandObjectModuleSource = class(TInterfacedObject,
    IOTAFile)
  private
    FBandName: string;
    FBandDesc: string;
    FBandType: TzBandType;
    FModuleIdent: string;
    FFormIdent: string;
    FAncestorIdent: string;
  public
    constructor Create(const BandName, BandDesc: string;
      const BandType: TzBandType;
      const ModuleIdent, FormIdent, AncestorIdent: string);
    // IOTAFile
    function GetSource: string;
    function GetAge: TDateTime;
  end;

implementation

uses
  SysUtils, Forms, Controls, ComObj,
  zBandObjectDLLWizardForm;

const
  CRLF = #13#10;
  CRLF2 = #13#10#13#10;
  BAND_TYPE_DESC: array [0..3] of string = ('Info', 'Comm', 'Tool', 'Desk');

var
  ProjectModule: IOTAModule;  


{ TzBandObjectDLLWizard }

procedure TzBandObjectDLLWizard.AfterSave;
begin
end;

procedure TzBandObjectDLLWizard.BeforeSave;
begin
end;

procedure TzBandObjectDLLWizard.Destroyed;
begin
end;

procedure TzBandObjectDLLWizard.Execute;
begin
  with TzWizardForm.Create(Application) do
  try
    if ShowModal <> mrOK then Exit;
    with (BorlandIDEServices as IOTAModuleServices) do
    begin
      ProjectModule := CreateModule(TzBandObjectProjectCreator.Create);
      CreateModule(TzBandObjectModuleCreator.Create(EditBandName.Text,
        EditBandDesc.Text, TzBandType(RgBandType.ItemIndex)));
    end;
  finally
    Free;
  end;
end;

function TzBandObjectDLLWizard.GetAuthor: string;
begin
  Result := 'Chiang Seng Chang <cs@ctzen.com>';
end;

function TzBandObjectDLLWizard.GetComment: string;
begin
  Result := 'Creates a Band Object DLL Project.';
end;

function TzBandObjectDLLWizard.GetGlyph: HICON;
begin
  Result := 0;
end;

function TzBandObjectDLLWizard.GetIDString: string;
begin
  Result := 'ctZen.zBandObjectDLLWizard';
end;

function TzBandObjectDLLWizard.GetName: string;
begin
  Result := 'Band Object DLL Wizard';
end;

function TzBandObjectDLLWizard.GetPage: string;
begin
  Result := '';
end;

function TzBandObjectDLLWizard.GetState: TWizardState;
begin
  Result := [];
end;

procedure TzBandObjectDLLWizard.Modified;
begin
end;

{ TzBandObjectProjectCreator }

function TzBandObjectProjectCreator.GetCreatorType: string;
begin
  Result := '';
end;

function TzBandObjectProjectCreator.GetExisting: Boolean;
begin
  Result := False;
end;

function TzBandObjectProjectCreator.GetFileName: string;
begin
  Result := '';
end;

function TzBandObjectProjectCreator.GetFileSystem: string;
begin
  Result := '';
end;

function TzBandObjectProjectCreator.GetOptionFileName: string;
begin
  Result := '';
end;

function TzBandObjectProjectCreator.GetOwner: IOTAModule;
begin
  Result := nil;
end;

function TzBandObjectProjectCreator.GetShowSource: Boolean;
begin
  Result := False;
end;

function TzBandObjectProjectCreator.GetUnnamed: Boolean;
begin
  Result := True;
end;

procedure TzBandObjectProjectCreator.NewDefaultModule;
begin
end;

function TzBandObjectProjectCreator.NewOptionSource(
  const ProjectName: string): IOTAFile;
begin
  Result := nil;
end;

procedure TzBandObjectProjectCreator.NewProjectResource(
  const Project: IOTAProject);
begin
end;

function TzBandObjectProjectCreator.NewProjectSource(
  const ProjectName: string): IOTAFile;
begin
  Result := TzBandObjectProjectSource.Create(ProjectName);
end;

{ TzBandObjectProjectSource }

constructor TzBandObjectProjectSource.Create(const ProjectName: string);
begin
  inherited Create;
  FProjectName := ProjectName;
end;

function TzBandObjectProjectSource.GetAge: TDateTime;
begin
  Result := -1;
end;

function TzBandObjectProjectSource.GetSource: string;
const
  SOURCE =
    'library %s;' + CRLF2 +
    'uses' + CRLF +
    '  ComServ;' + CRLF2 +
    'exports' + CRLF +
    '  DllGetClassObject,' + CRLF +
    '  DllCanUnloadNow,' + CRLF +
    '  DllRegisterServer,' + CRLF +
    '  DllUnregisterServer;' + CRLF2 +
    '{$R *.RES}' + CRLF2 +
    'begin' + CRLF +
    'end.';
begin
  Result := Format(SOURCE, [FProjectName]);
end;

{ TzBandObjectModuleCreator }

constructor TzBandObjectModuleCreator.Create(const BandName, BandDesc: String;
  const BandType: TzBandType);
begin
  inherited Create;
  FBandName := BandName;
  FBandDesc := BandDesc;
  FBandType := BandType;
end;

procedure TzBandObjectModuleCreator.FormCreated(
  const FormEditor: IOTAFormEditor);
begin
end;

function TzBandObjectModuleCreator.GetAncestorName: string;
begin
  Result := 'zBandForm';
end;

function TzBandObjectModuleCreator.GetCreatorType: string;
begin
  Result := sForm;
end;

function TzBandObjectModuleCreator.GetExisting: Boolean;
begin
  Result := False;
end;

function TzBandObjectModuleCreator.GetFileSystem: string;
begin
  Result := '';
end;

function TzBandObjectModuleCreator.GetFormName: string;
begin
  Result := FBandName + 'Form';
end;

function TzBandObjectModuleCreator.GetImplFileName: string;
begin
  Result := '';
end;

function TzBandObjectModuleCreator.GetIntfFileName: string;
begin
  Result := '';
end;

function TzBandObjectModuleCreator.GetMainForm: Boolean;
begin
  Result := False;
end;

function TzBandObjectModuleCreator.GetOwner: IOTAModule;
begin
  Result := ProjectModule;
end;

function TzBandObjectModuleCreator.GetShowForm: Boolean;
begin
  Result := True;
end;

function TzBandObjectModuleCreator.GetShowSource: Boolean;
begin
  Result := True;
end;

function TzBandObjectModuleCreator.GetUnnamed: Boolean;
begin
  Result := True;
end;

function TzBandObjectModuleCreator.NewFormFile(const FormIdent,
  AncestorIdent: string): IOTAFile;
begin
  Result := nil;
end;

function TzBandObjectModuleCreator.NewImplSource(const ModuleIdent,
  FormIdent, AncestorIdent: string): IOTAFile;
begin
  Result := TzBandObjectModuleSource.Create(FBandName, FBandDesc, FBandType,
    ModuleIdent, FormIdent, AncestorIdent);
end;

function TzBandObjectModuleCreator.NewIntfSource(const ModuleIdent,
  FormIdent, AncestorIdent: string): IOTAFile;
begin
  Result := nil;
end;

{ TzBandObjectModuleSource }

constructor TzBandObjectModuleSource.Create(const BandName, BandDesc: string;
  const BandType: TzBandType; const ModuleIdent, FormIdent, AncestorIdent: string);
begin
  inherited Create;
  FBandName := BandName;
  FBandDesc := BandDesc;
  FBandType := BandType;
  FModuleIdent := ModuleIdent;
  FFormIdent := FormIdent;
  FAncestorIdent := AncestorIdent;
end;

function TzBandObjectModuleSource.GetAge: TDateTime;
begin
  Result := -1;
end;

function TzBandObjectModuleSource.GetSource: string;
const
  SOURCE =
    'unit %3:s;' + CRLF2 +
    'interface' + CRLF2 +
    'uses' + CRLF +
    '  Windows,' + CRLF +
    '  zBandObject, zBandForms;' + CRLF2 +
    'type' + CRLF +
    '  // Band Object Factory' + CRLF +
    '  T%0:sFactory = class(Tz%2:sBandObjectFactory)' + CRLF +
    '  end;' + CRLF2 +
    '  // Band Object' + CRLF +
    '  T%0:s = class(Tz%2:sBandObject)' + CRLF +
    '  protected' + CRLF +
    '    function CreateBandForm(const ParentWnd: HWnd): TzBandForm; override;' + CRLF +
    '  end;' + CRLF2 +
    '  // Band Form' + CRLF +
    '  T%4:s = class(T%5:s)' + CRLF +
    '  private' + CRLF +
    '    function GetBandObject: T%0:s;' + CRLF +
    '  public' + CRLF +
    '    property BandObject: T%0:s read GetBandObject;' + CRLF +
    '  end;' + CRLF2 +
    'const' + CRLF +
    '  Class_%0:s: TGUID = ''%6:s'';' + CRLF2 +
    'implementation' + CRLF2 +
    '{$R *.DFM}' + CRLF2 +
    'uses' + CRLF +
    '  ComObj, ComServ;' + CRLF2 +
    '{ T%0:s }' + CRLF2 +
    'function T%0:s.CreateBandForm(const ParentWnd: HWnd): TzBandForm;' + CRLF +
    'begin' + CRLF +
    '  Result := T%4:s.CreateBandForm(ParentWnd, Self);' + CRLF +
    'end;' + CRLF2 +
    '{ T%4:s }' + CRLF2 +
    'function T%4:s.GetBandObject: T%0:s;' + CRLF +
    'begin' + CRLF +
    '  Result := T%0:s(_BandObject);' + CRLF +
    'end;' + CRLF2 +
    'initialization' + CRLF +
    '  T%0:sFactory.Create(ComServer, T%0:s, Class_%0:s,' + CRLF +
    '    ''%0:s'', ''%1:s'', ciMultiInstance, tmApartment);' + CRLF2 +
    'end.';

begin
  Result := Format(SOURCE, [FBandName, FBandDesc, BAND_TYPE_DESC[Ord(FBandType)],
    FModuleIdent, FFormIdent, FAncestorIdent,
    CreateClassID]);
end;

end.


