unit main;

interface

uses
  Windows,
  zBandObject, zBandForms,forms, Controls, ComCtrls, Classes, ToolWin,
  Menus, ImgList, graphics, contnrs,ShellApi,Dialogs,
  AlignPopupMenu, Buttons, StdCtrls, BarPopupMenu, Registry;


Type ItemRec = Record
      Name   : String [255];
      Path   : String [255];
      Dir    : String [255];
      Ico    : String [255];
      IcoIdx : Integer;
     End;


Type ConfigRec = Record
      LargeIcons : Boolean;
      Captions   : Boolean;
    End;


type
  // Band Object Factory
  TFusionBandFactory = class(TzDeskBandObjectFactory)
  end;

  // Band Object
  TFusionBand = class(TzDeskBandObject)
  protected
    function CreateBandForm(const ParentWnd: HWnd): TzBandForm; override;
  end;

  // Band Form
TFusionBandForm = class(TzBandForm)
// TFusionBandForm = class(TForm)
    Bar: TToolBar;
    MenuIcons: TImageList;
    ButIcons: TImageList;
    Menu_Config: TAlignPopupMenu;
    But_Config: TToolButton;
    Menu_Editor: TMenuItem;
    Menu_Icons: TMenuItem;
    Menu_Refresh: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Menu_ResetClick(Sender: TObject);
    procedure But_ConfigClick(Sender: TObject);
    procedure Menu_IconsClick(Sender: TObject);
    procedure Menu_EditorClick(Sender: TObject);
  private
    MenuDatFile : String;
    MenuList : TComponentList;
    function GetBandObject: TFusionBand;
    procedure MenuButtonClick(Sender: TObject);
    Procedure MenuItemClick(Sender: TObject);
  public
    Config : ConfigRec;
    property BandObject: TFusionBand read GetBandObject;
    procedure ReadMenuData;
    Function ReadRegistry: String;
    Procedure Initialize;
  end;



const
  Class_FusionBand: TGUID = '{5ECBDD20-AF4D-4F97-B869-7670865880F8}';

var FusionBandForm : TFusionBandForm;

implementation

{$R *.DFM}

uses
  ComObj, ComServ,icons;


{ TFusionBand }

function TFusionBand.CreateBandForm(const ParentWnd: HWnd): TzBandForm;
begin
 Result := TFusionBandForm.CreateBandForm(ParentWnd, Self);
end;

{ TFusionBandForm }

function TFusionBandForm.GetBandObject: TFusionBand;
begin
 Result := TFusionBand(_BandObject);
end;


function TaskbarHeight: Integer;
var
	TaskbarRect: TRect;
begin
   GetWindowRect(FindWindow('Shell_TrayWnd',nil),TaskbarRect);
   Result := TaskbarRect.Bottom-TaskbarRect.Top-2;
end;


//------------------------------------------------------------------------------
// Application Menu's and ToolBar Handlers

procedure TFusionBandForm.MenuButtonClick(Sender: TObject);
var x : tpoint;
    r: Trect;
    Extra : Integer;
begin
  x.x:=0;
  x.y:=0;
  extra:=0;
  If (MenuList.Items[(Sender As TToolButton).tag] As TPopUpMenu).Items.Count <= 1 Then
  Begin
    Extra:=25;
    If MenuIcons.Width=32 Then Extra:=Extra+16;
  End;
  SystemParametersInfo( SPI_GETWORKAREA, 0, @r, 0 );
  x:=(Sender As TToolButton).ClientToScreen(x);
  (MenuList.Items[(Sender As TToolButton).tag] As TPopUpMenu).popup(x.x-25,  r.Bottom-extra);
end;


Procedure TFusionBandForm.MenuItemClick(Sender: TObject);
Var Path : String;
Begin
  Path:=(Sender As TMenuItem).Hint;
  shellexecute(application.Handle,'open',PChar(Path), nil,nil,sw_show);
End;


//------------------------------------------------------------------------------
// Menu and Toolbar Creation Code .. Not very tidy :)


Function TFusionBandForm.ReadRegistry: String;
var Reg : TRegistry;
begin
 Reg:=TRegistry.Create;
 Try
  Reg.RootKey:=HKEY_CURRENT_USER;
  If Reg.OpenKey('\Software\Transpear\FusionBand',False) Then
  Begin
    Result:=Reg.ReadString('BandPath');
    If Result='' Then
    Begin
      ShowMessage('First time? You need to run the Fusion Band Editor to create a default menu setup');
    End;
  End;
  Except
      ShowMessage('You need to run the Fusion Band Editor to create a default menu setup');
  End;
    Reg.CloseKey;
    Reg.Free;
End;

procedure TFusionBandForm.ReadMenuData;
var f : file of ItemRec;
    i : ItemRec;
    But : TToolButton;
    Menu : TBarPopUpMenu;
    Icon : TIcon;
    MItem : TMenuItem;
    IcoIdx  : Integer;
    MenuCount : Integer;
    ButCount  : Integer; // Make less than previous but to Force insert on left
Begin
  MenuCount:=0;
  ButCount:=40;
  AssignFile(f,MenuDatFile);
{$I-}
  Reset(f);
{$I+}
 If IOResult<>0 Then
 Begin
      ShowMessage('Cannot menu data!! You need to run the Fusion Band Editor to '+
                  'create a default menu setup');
 End
 Else
 Begin
  While Not EOF(f) Do
  Begin
  Read(f,i);
  if i.Path='*MENU' Then
  Begin
    But:=TToolButton.create(bar);
    Menu:=TBarPopUpMenu.Create(Self);
    Icon:=ExtractIconFromFile(I.Ico,I.icoIdx, False);
    IcoIdx:=ButIcons.AddIcon(Icon);
    But.ImageIndex:=IcoIdx;                 //  Toolbar Button Settings ..
    But.Left:=ButCount;
    Butcount:=Butcount+40;
    But.Hint:=I.Name;
    But.ShowHint:=True;
    But.Parent:=Bar;
    But.Tag:=MenuCount;
    But.OnClick:=MenuButtonClick;
    MenuList.Add(Menu);                      // Add Menu to TList
    Menu.Images:=MenuIcons;                  // Menu Settings ..
    Menu.GradientStart:=clBtnFace;
    Menu.GradientEnd:=clBlack;
    Menu.Transparent:=false;
    Menu.VerticalText:=I.Name;
    ButIcons.GetBitmap(IcoIdx,Menu.Bitmap);
    Menu.VerticalTextOffsetY:=-8;
    Menu.BarWidth:=25;
    If Config.LargeIcons Then                // Font settings for Menu sidebar
    Begin                                    // Depending on Icon Size ..
      Menu.VerticalFont.name:='Arial Black';
      Menu.VerticalFont.Style:=[];
      Menu.VerticalFont.Size:=12;
    End
    Else                                 // if small icons for menu=small font
    Begin
      Menu.VerticalFont.name:='Arial';
      Menu.VerticalFont.Style:=[];
      Menu.VerticalFont.Size:=8;
    End;
    Menu.BitmapOffsetY:=-4;
    Menu.BitmapHorzAlignment:=bhaCenter;
    Inc(MenuCount);
  end
  else
  Begin
     MItem:=TMenuItem.Create(Menu);
     MItem.Caption:=i.Name;
     MItem.hint:=i.Path;
     Icon:=ExtractIconFromFile(I.Ico,I.icoIdx,config.LargeIcons);
     MItem.ImageIndex:=MenuIcons.AddIcon(Icon);
     MItem.Onclick:=MenuItemClick;
     Menu.Items.Add(MItem);
  End;
 End;
 End;
End;


//------------------------------------------------------------------------------
// Config Menu Event Handlers

procedure TFusionBandForm.Menu_ResetClick(Sender: TObject);
var count : Integer;
begin
 ButIcons.Clear;
 MenuIcons.Clear;
 For count:=MenuList.Count-1 DownTo 0 Do
    (MenuList.Items[count] As TPopUpMenu).Free;
 For count:=Bar.ComponentCount-1 DownTo 0 Do
    (Bar.components[count] As TControl).Free;
 ReadMenuData;
end;

procedure TFusionBandForm.But_ConfigClick(Sender: TObject);
var x : tpoint;
    r: Trect;
begin
 x.x:=0;
 x.y:=0;
 SystemParametersInfo( SPI_GETWORKAREA, 0, @r, 0 );
 x:=(Sender As TToolButton).ClientToScreen(x);
 Menu_Config.ExcludeAlignment := eaHorizontal;
 Menu_Config.ExcludeRect := Rect(0,Screen.Height-TaskbarHeight,Screen.Width,Screen.Height);
 Menu_Config.Popup(x.x,Screen.Height);
end;

procedure TFusionBandForm.Menu_IconsClick(Sender: TObject);
begin
 Menu_Icons.checked:= Not Menu_Icons.checked;
 If Menu_Icons.checked Then
 Begin
   MenuIcons.Width:=32;
   MenuIcons.Height:=32;
   Config.LargeIcons:=True;
 End
 Else
 Begin
  MenuIcons.Width:=16;
  MenuIcons.Height:=16;
  Config.LargeIcons:=False;
 End;
 Menu_ResetClick(self);
end;

procedure TFusionBandForm.Menu_EditorClick(Sender: TObject);
var Path : String;
begin
{    Path:='D:\Prog\Delphi\Mine\Fusion Band\FB_Editor.exe';
    shellexecute(application.Handle,'open',PChar(Path), nil,nil,sw_show); }
    ShowMessage('Please run the Editor via the Start Menu, then choose Refresh (below)')
end;


//------------------------------------------------------------------------------
// Initialization and Creation Code ..

Procedure TFusionBandForm.Initialize;
Begin
  Config.LargeIcons:=True;
  Config.Captions:=False;
  If Not Config.LargeIcons Then
  Begin
    MenuIcons.Height:=16;
    MenuIcons.Width:=16;
    Menu_Icons.Checked:=False;
  End
  Else
  Begin
    MenuIcons.Height:=32;
    MenuIcons.Width:=32;
    Menu_Icons.Checked:=True;
  End
End;


procedure TFusionBandForm.FormCreate(Sender: TObject);
begin
  MenuDatFile:=ReadRegistry+'\Menus.dat';
  Initialize;
  MenuList:=TComponentList.Create;
  ReadMenuData;
end;


initialization
  TFusionBandFactory.Create(ComServer, TFusionBand, Class_FusionBand,
  'FusionBand', '&Fusion', ciMultiInstance, tmApartment);
end.

