unit demomain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FScanner, ComCtrls, ExtCtrls, Spin;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ODlg: TOpenDialog;
    edtString: TEdit;
    Progress: TProgressBar;
    Memo: TMemo;
    Label1: TLabel;
    edtFiles: TEdit;
    Label2: TLabel;
    lblCurrent: TLabel;
    lblTime: TLabel;
    Scanner: TContextScanner;
    edtBufSize: TSpinEdit;
    lblBufSize: TLabel;
    cbxFirstEntry: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure ScannerFileFound(AName, APath: String; AAttr, ASize: Integer;
      ADateTime: TDateTime);
    procedure edtStringChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure edtFilesDblClick(Sender: TObject);
    procedure ScannerProcessDone(ACount, ASize: Cardinal);
    procedure ScannerContextFound(AFileName: String; ASize, APos: Integer);
    procedure ScannerProcess(ACount, ASize: Cardinal; ACurrent: String;
      ACurrentSize, ACurrentPos: Cardinal);
  private
    { Private declarations }
    TimeTicks : TDateTime;
    procedure InitTimer;
    procedure DoneTimer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  if Scanner.InProcess then
  begin
    Scanner.Stop;
    Exit;
  end;
  Memo.Lines.Clear;
  if not FileExists(edtFiles.text) then
  begin
    Scanner.Files := edtFiles.Text;
    Scanner.ScanStrategy := ssGlobal;
    Scanner.Recursive := true;
  end else
  begin
    Scanner.Files := ExtractFileName(edtFiles.text);
    Scanner.Directory := ExtractFilePath(edtFiles.text);
    Scanner.Recursive := false;
    Scanner.ScanStrategy := ssGlobal;
  end;
  Scanner.Context.ContextAsString := edtString.Text;
  Scanner.Context.BufferSizeKb := edtBufSize.Value;
  Scanner.Context.FirstEntryOnly := cbxFirstEntry.Checked;
  Button1.Caption := '&Stop';
  InitTimer;
  Scanner.Scan;
end;

procedure TForm1.ScannerFileFound(AName, APath: String; AAttr,
  ASize: Integer; ADateTime: TDateTime);
begin
  lblCurrent.Caption := 'Current : '+SlashSep(APath, AName);
  Progress.Max := ASize;
end;

procedure TForm1.edtStringChange(Sender: TObject);
begin
  Button1.Enabled := true {TEdit(Sender).text <> ''};
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  edtStringChange(edtString);
  edtBufSize.Value := Scanner.Context.BufferSizeKB;
  edtBufSize.MinValue := MIN_BUFFER_SIZE;
  edtBufSize.MaxValue := MAX_BUFFER_SIZE;
  cbxFirstEntry.Checked := Scanner.Context.FirstEntryOnly;
end;

procedure TForm1.edtFilesDblClick(Sender: TObject);
begin
  if ODlg.Execute then
     edtFiles.text := ODlg.FileName;
end;

procedure TForm1.ScannerProcessDone(ACount, ASize: Cardinal);
begin
  DoneTimer;
  Progress.Position := 0;
  lblCurrent.Caption := Format('Done... Total %d files %d bytes',
                    [ACount, ASize]);
  Button1.Caption := '&Start';
end;

procedure TForm1.InitTimer;
begin
  TimeTicks := Time;
end;

procedure TForm1.DoneTimer;
var
  EndTime : TDateTime;
begin
  EndTime := Time - TimeTicks;
  lblTime.Caption := 'Scanning time : '+TimeToStr(EndTime);
end;

procedure TForm1.ScannerContextFound(AFileName: String; ASize,
  APos: Integer);
begin
  Memo.Lines.Add(ExtractFileName(AFileName)+' - '+intToStr(APos));
end;

procedure TForm1.ScannerProcess(ACount, ASize: Cardinal; ACurrent: String;
  ACurrentSize, ACurrentPos: Cardinal);
begin
  Progress.Position := ACurrentPos;
end;

end.
