{-----------------------------------------------------------------------------
  Description: Form Reader, A utility to read DFM files as Text
  Author:      Deepak Shenoy (shenoy@agnisoft.com)
  Version:     1.5
  Copyright (c) Agni Software (P) Ltd., 1999.
  All rights reserved.
-------------------------------------------------------------------------------}
unit mainform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, ExtCtrls, Buttons, Menus,
  Clipbrd, Comctrls, Db, Dbcgrids,
  Dbctrls, Dbgrids, Dblookup, Dbtables, Ddeman,
  Grids, Mask, Mplayer, Oleconst, Olectnrs, Chart,
  Olectrls, Outline, Tabnotbk, Tabs, mwHighlighter, mwPasSyn, mwCustomEdit,
  ToolWin, ImgList, dcjcppsyn;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    DriveComboBox1: TDriveComboBox;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    Panel2: TPanel;
    Splitter1: TSplitter;
    ViewAsFormBTN: TBitBtn;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    SaveAs1: TMenuItem;
    Exit1: TMenuItem;
    SaveDialog1: TSaveDialog;
    Editor: TmwCustomEdit;
    PascalSyntaxHighlighter: TmwPasSyn;
    SettingsCombo: TComboBox;
    Label1: TLabel;
    HideFileList1: TMenuItem;
    Splitter2: TSplitter;
    procedure FileListBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure ViewAsFormBTNClick(Sender: TObject);
    procedure SettingsComboChange(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure HideFileList1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure FindMethod(Reader: TReader; const MethodName: string;
    var Address: Pointer; var Error: Boolean);
  end;

var
  Form1: TForm1;

implementation

uses aboutfrm;

{$R *.DFM}
type
    TClassArray = array [1..148] of TPersistentClass;
const

  ClassArray: TClassArray = (
    TBitmap, TGraphic, TOutlineNode, TGraphicsObject,
    TBrush, THeaderSection, TParams, TCanvas,
    THeaderSections, TPen, TIcon, TPicture,
    TIconOptions, TCollection, TCollectionItem, TColumn,
    TStatusPanel, TColumnTitle, TStatusPanels, TClipboard,
    TControlScrollBar, TListColumn, TStringList, TListItem,
    TStrings, TListItems, TMetafile, TMetafileCanvas,
    TTreeNode, TFont, TParaAttributes, TTreeNodes,
    TApplication, TDDEServerItem, TPanel, TAutoIncField,
    TDirectoryListBox, TPopupMenu, TBatchMove, TDrawGrid,
    TPrintDialog, TBCDField, TDriveComboBox, TPrinterSetupDialog,
    TBevel, TEdit, TProgressBar, TBitBtn,
    TField, TQuery, TBlobField, TFileListBox,
    TRadioButton, TBooleanField, TFilterComboBox, TRadioGroup,
    TButton, TFindDialog, TReplaceDialog, TBytesField,
    TFloatField, TCheckBox, TFontDialog,
    TRichEdit, TColorDialog, TForm, TSaveDialog,
    TComboBox, TGraphicField, TScreen, TCurrencyField,
    TGroupBox, TScrollBar, TDatabase, THeader,
    TScrollBox, TDataSource, THeaderControl, TSession,
    TDateField, THotKey, TShape, TStaticText, TDateTimeField,
    TImage, TSmallIntField, TDBCheckBox, TImageList,
    TSpeedButton, TDBComboBox, TIntegerField, TStatusBar,
    TDBCtrlGrid, TLabel, TStoredProc, TDBEdit,
    TListBox, TStringField, TDBGrid, TListView,
    TStringGrid, TDBImage, TMainMenu, TTabbedNotebook,
    TDBListBox, TMaskEdit, TTabControl, TDBLookupCombo,
    TMediaPlayer, TTable, TMemoField, TDBLookupComboBox,
    TMemo, TTabSet, TDBLookupList, TTabSheet, TToolBar,
    TCoolBar, TToolButton, 
    TDBLookupListBox, TMenuItem, TTimeField, TDBMemo,
    TNotebook, TTable, TDBNavigator, TOleContainer,
    TTimer, TDBRadioGroup, TOpenDialog, TTrackBar,
    TDBText, TOutline, TTreeView, TDDEClientConv,
    TOutline, TUpdateSQL, TDDEClientItem, TPageControl,
    TUpDown, TDDEServerConv, TPaintBox, TVarBytesField,
    TWordField, TSplitter, TMwCustomEdit, TmwPasSyn, TDcjCppSyn);

procedure TForm1.FileListBox1Change(Sender: TObject);
var fStream : TFileStream;
    outStream : TMemoryStream;

begin
     if FileListBox1.FileName = '' then Exit;
     fStream := TFileStream.Create(FileListBox1.FileName,fmOpenRead or fmShareDenyNone);
     OutStream := TMemoryStream.Create;
     ObjectResourceToText(fStream, OutStream);
     OutStream.Position := 0;
     Editor.Lines.Clear;
     Editor.Lines.LoadFromStream( OutStream );
     outStream.Free;
     fStream.Free;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
      DriveComboBox1.Align := alTop;
      DirectoryListBox1.Align := alTop;
      Splitter1.Align := alTop;
      FileListBox1.Align := alClient;
      RegisterClasses (ClassArray);

      SettingsCombo.Items.Clear;
      Editor.Highlighter.EnumUserSettings( SettingsCombo.Items ) ;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
     Close;
end;

procedure TForm1.SaveAs1Click(Sender: TObject);
var
   inStream : TMemoryStream;
   fStream  : TFileStream;
begin
     if SaveDialog1.Execute then
     begin
         fStream := TFileStream.Create(SaveDialog1.FileName,fmCreate or fmShareExclusive);
         inStream := TMemoryStream.Create;
         try
            Editor.Lines.SaveToStream( inStream);
            inStream.Position := 0;
            ObjectTextToResource( inStream, fStream );
         finally
            fStream.Free;
            inStream.Free;
         end;
     end;
end;

procedure TForm1.ViewAsFormBTNClick(Sender: TObject);
var
   Input			: TFileStream;
   Reader          : TReader;
   bWriteProperty  : boolean;
   sPropertyName   : string;
   slStrings		: TStringList;

   procedure WriteStr(const S: string);
   begin
       slStrings.Add(S);
   end;

   procedure ConvertValue; forward;

   procedure ConvertHeader;
   var
       sClassName,
       sObjectName : string;
       Flags       : TFilerFlags;
       Position    : Integer;
   begin
       Reader.ReadPrefix(Flags, Position);
       sClassName := Reader.ReadStr;
       sObjectName := Reader.ReadStr;
   end;

   procedure ConvertBinary;
   var
       lCount      : Longint;
       pBuffer     : PChar;
   begin
       Reader.ReadValue;
       Reader.Read(lCount, SizeOf(lCount));

       GetMem(pBuffer, lCount+1);
       Reader.Read(pBuffer^, lCount);
       FreeMem(pBuffer);
   end;

   procedure ConvertProperty; forward;

   procedure ConvertValue;
   begin
       case Reader.NextValue of
           vaList:
            begin
               Reader.ReadValue;
               while not Reader.EndOfList do
                   ConvertValue;
               Reader.ReadListEnd;
            end;
           vaInt8,
           vaInt16,
           vaInt32:
               Reader.ReadInteger;
           vaExtended:
               Reader.ReadFloat;
           vaString,
           vaLString:
               if bWriteProperty then
                   WriteStr(Reader.ReadString)
               else
                   Reader.ReadString;
           vaIdent,
           vaFalse,
           vaTrue,
           vaNil:
               Reader.ReadIdent;
           vaBinary:
               ConvertBinary;
           vaSet:
            begin
               Reader.ReadValue;
               while Reader.ReadStr <> '' do
                begin
                end;
            end;
           vaCollection:
            begin
               Reader.ReadValue;
               while not Reader.EndOfList do
                begin
                   if Reader.NextValue in [vaInt8, vaInt16, vaInt32] then
                       ConvertValue;
                   Reader.ReadValue;
                   while not Reader.EndOfList do
                       ConvertProperty;
                   Reader.ReadListEnd;
                end;
               Reader.ReadListEnd;
            end;
       end;
   end;

   procedure ConvertProperty;
   begin
       sPropertyName := Reader.ReadStr;
//       bWriteProperty := WriteProperty(sPropertyName);
       ConvertValue;
   end;

   procedure ConvertObject;
   begin
       ConvertHeader;
       while not Reader.EndOfList do
           ConvertProperty;
       Reader.ReadListEnd;
       while not Reader.EndOfList do
           ConvertObject;
       Reader.ReadListEnd;
   end;

var
   frm : TForm;
begin
	//EditClearFormMIClick(EditClearFormMI);
   frm := TForm.Create( Application );

   Input := TFileStream.Create(FileListBox1.FileName, fmOpenRead);
   slStrings := TStringList.Create;

   try
       Input.ReadResHeader;

       Reader := TReader.Create(Input, 4096);
       Reader.OnFindMethod := FindMethod;
       Reader.ReadRootComponent(frm);
     {
       Reader := TReader.Create(Input, 4096);
       Reader.ReadSignature;

       ConvertObject;
     }
       frm.ShowModal;
   finally
      frm.Free;
      Reader.Free;
      Input.Free;
      slStrings.Free;
   end;
end;

procedure TForm1.FindMethod(Reader: TReader; const MethodName: string;
    var Address: Pointer; var Error: Boolean);
begin
	Address := nil;
   Error := False;
end;

procedure TForm1.SettingsComboChange(Sender: TObject);
var bOk : boolean;
begin
    bOk := PascalSyntaxHighlighter.UseUserSettings( SettingsCombo.ItemIndex );
    if not bOk then
       MessageDlg('Could not load User Settings', mtError, [mbOk], 0)
    else
        Editor.Color := PascalSyntaxHighlighter.SpaceAttri.Background;

end;

procedure TForm1.About1Click(Sender: TObject);
begin
     with TAboutForm.Create( nil ) do
     try
          ShowModal;
     finally
          Free;
     end;
end;

procedure TForm1.HideFileList1Click(Sender: TObject);
begin
     Panel1.Visible := Not Panel1.Visible;
     HideFileList1.Checked := Not HideFileList1.Checked;
     Splitter2.Visible := not Splitter2.Visible;
end;

end.
