{=============================================================================}
{  LsFileExplorer28 Demo1 (version 2.80)                                      }
{=============================================================================}
{
This Demo was compiled by Delphi 5.  DFM files (ie. FileExpl28_Demo1Main.dfm,
About.dfm and FileDate.dfm) are saved in binary format, instead of its default
TextFormat,  thus they will be bachwards compatible with previous versions of
Delphi.

If you want to re-compile it under Delphi 4 or 3, just load all files (including
FileExpl28_Demo1.dpr, FileExpl28_Demo1Main.pas, About.pas and FileDate.pas) into
Delphi's IDE befor rebuilding it. However, under D3 you'll encounter many error
messages, because some properties on MainForm, AboutForm and FileDateForm are
not available in D3.  But don't worry, just ignore all error messages, then
proceed.

Binary DFM files created by D5 can be converted to D5's default text format
by using 'textDFM' option in D5's context menu.

{=============================================================================}


unit FileExpl28_Demo1Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, LsFileExplorer28, ToolWin, Menus, FileCtrl
  {$IFNDEF VER100},
  ImgList
  {$ENDIF};

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    QuickView1: TMenuItem;
    N1: TMenuItem;
    DeleteFiles1: TMenuItem;
    RenameFile1: TMenuItem;
    N2: TMenuItem;
    NewFolder1: TMenuItem;
    DeleteFolder1: TMenuItem;
    RenameFolder1: TMenuItem;
    N3: TMenuItem;
    Attribute1: TMenuItem;
    N4: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N5: TMenuItem;
    SelectAll1: TMenuItem;
    View1: TMenuItem;
    LargeIcon1: TMenuItem;
    SmallIcon1: TMenuItem;
    List1: TMenuItem;
    Detail1: TMenuItem;
    N6: TMenuItem;
    Refresh1: TMenuItem;
    Network1: TMenuItem;
    ConnecttoNetwork1: TMenuItem;
    DisconnectFromNetwork1: TMenuItem;
    Tools1: TMenuItem;
    FindFolderorFiles1: TMenuItem;
    Goto1: TMenuItem;
    N7: TMenuItem;
    CalculateTreeSize1: TMenuItem;
    N8: TMenuItem;
    RewriteFileDateTime1: TMenuItem;
    Help1: TMenuItem;
    LsDirTree21ShortCuts1: TMenuItem;
    LsFileListView28ShortCuts1: TMenuItem;
    N9: TMenuItem;
    AboutLsFileExplorer281: TMenuItem;
    StatusBar1: TStatusBar;
    ToolBar1: TToolBar;
    BtnAddFolder: TToolButton;
    BtnDeleteFolder: TToolButton;
    BtnEditFolder: TToolButton;
    ToolButton4: TToolButton;
    BtnTreeSize: TToolButton;
    BtnSearch: TToolButton;
    ToolButton10: TToolButton;
    BtnConnect: TToolButton;
    BtnDisconnect: TToolButton;
    ToolButton13: TToolButton;
    BtnRefresh: TToolButton;
    BtnPrevLevel: TToolButton;
    BtnShowFolder: TToolButton;
    ToolButton17: TToolButton;
    BtnFileDate: TToolButton;
    ToolButton19: TToolButton;
    BtnCut: TToolButton;
    BtnCopy: TToolButton;
    BtnPaste: TToolButton;
    ToolButton23: TToolButton;
    BtnIcon: TToolButton;
    BtnSIcon: TToolButton;
    BtnList: TToolButton;
    BtnDetail: TToolButton;
    ToolButton28: TToolButton;
    BtnExit: TToolButton;
    Panel1: TPanel;
    Splitter1: TSplitter;
    EditPath: TEdit;
    Label1: TLabel;
    CbxMask: TComboBox;
    Label2: TLabel;
    ImageList1: TImageList;
    LsDirTree211: TLsDirTree21;
    LsFilelistView281: TLsFilelistView28;
    procedure BtnExitClick(Sender: TObject);
    procedure BtnShowFolderClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SetBtnMenuState(Sender: TObject);
    procedure GetStatistics(Sender: TObject);
    procedure BtnAddFolderClick(Sender: TObject);
    procedure BtnDeleteFolderClick(Sender: TObject);
    procedure BtnEditFolderClick(Sender: TObject);
    procedure BtnTreeSizeClick(Sender: TObject);
    procedure BtnSearchClick(Sender: TObject);
    procedure BtnConnectClick(Sender: TObject);
    procedure BtnDisconnectClick(Sender: TObject);
    procedure BtnRefreshClick(Sender: TObject);
    procedure BtnPrevLevelClick(Sender: TObject);
    procedure BtnFileDateClick(Sender: TObject);
    procedure BtnCutClick(Sender: TObject);
    procedure BtnCopyClick(Sender: TObject);
    procedure BtnPasteClick(Sender: TObject);
    procedure BtnIconClick(Sender: TObject);
    procedure BtnSIconClick(Sender: TObject);
    procedure BtnListClick(Sender: TObject);
    procedure BtnDetailClick(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure QuickView1Click(Sender: TObject);
    procedure DeleteFiles1Click(Sender: TObject);
    procedure RenameFile1Click(Sender: TObject);
    procedure Attribute1Click(Sender: TObject);
    procedure SelectAll1Click(Sender: TObject);
    procedure Goto1Click(Sender: TObject);
    procedure LsDirTree21ShortCuts1Click(Sender: TObject);
    procedure LsFileListView28ShortCuts1Click(Sender: TObject);
    procedure AboutLsFileExplorer281Click(Sender: TObject);
    procedure LsFilelistView281Change(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure LsFilelistView281Click(Sender: TObject);
    procedure LsFilelistView281DblClick(Sender: TObject);
    procedure LsFilelistView281KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LsFilelistView281MouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure CbxMaskClick(Sender: TObject);
  private
    { Private declarations }
    CanPaste: Boolean;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses FileDate, About;

{$R *.DFM}


procedure TMainForm.FormCreate(Sender: TObject);
var
  CurDir: string;
begin
  CurDir := GetCurrentDir;
  if CurDir <> '' then
  begin
    LsFilelistView281.Directory := CurDir;
    LsDirTree211.OpenPath(CurDir);
  end;
  SetBtnMenuState(Sender);
  LsFilelistView281.ShowFolders := True;
  BtnShowFolder.Down := True;
end;  //FormCreate

procedure TMainForm.SetBtnMenuState(Sender: TObject);
begin
  BtnAddFolder.Enabled := (Assigned(LsDirTree211.Selected)) and
    (LsDirTree211.Selected.Level > 0);
  BtnDeleteFolder.Enabled := (Assigned(LsDirTree211.Selected)) and
    (LsDirTree211.Selected.Level > 1);
  BtnEditFolder.Enabled := (Assigned(LsDirTree211.Selected)) and
    (LsDirTree211.Selected.Level > 1);
  BtnTreeSize.Enabled := (Assigned(LsDirTree211.Selected)) and
    (LsDirTree211.Selected.Level > 0);
  BtnCut.Enabled := Assigned(LsFilelistView281.Selected);
  BtnCopy.Enabled := Assigned(LsFilelistView281.Selected);
  BtnPaste.Enabled := (CanPaste = True);
  Cut1.Enabled := Assigned(LsFilelistView281.Selected);
  Copy1.Enabled := Assigned(LsFilelistView281.Selected);
  Paste1.Enabled := CanPaste = True;
  Open1.Enabled := Assigned(LsFilelistView281.Selected);
  QuickView1.Enabled := Assigned(LsFilelistView281.Selected);
  DeleteFiles1.Enabled := Assigned(LsFilelistView281.Selected);
  RenameFile1.Enabled := Assigned(LsFilelistView281.Selected);
  Attribute1.Enabled := Assigned(LsFilelistView281.Selected);
end; //SetBtnMenuState

procedure TMainForm.GetStatistics(Sender: TObject);
begin
  StatusBar1.Panels[0].Text := '';
  StatusBar1.Panels[1].Text := '';
  with LsFilelistView281 do
  begin
    if Selected <> nil then
    begin
      StatusBar1.Panels[0].Text := IntToStr(Items.Count) + ' object(s)  --  ' +
        IntToStr(SelectedNumber) + '  selected ';
      StatusBar1.Panels[1].Text := ' Selected Size = ' +
        FormatFloat('###,##0.00 KB', (SelectedSize / 1024)) +
        '( Disk free space: ' +
        FormatFloat('###,### MB', (DriveFreeSpace)) + ' )';
    end
    else begin
      StatusBar1.Panels[0].Text := IntToStr(Items.Count) + ' object(s)';
      StatusBar1.Panels[1].Text := ' Selected Size = 0 KB' +
        '  ( Disk free space: ' +
        FormatFloat('###,### MB', (DriveFreeSpace)) + ' )';
    end;
  end;
  EditPath.Text := LsFilelistView281.Directory;
end; //GetStatistics


procedure TMainForm.BtnAddFolderClick(Sender: TObject);
var
  PNode: TTreeNode;
  NewFolder: string;
begin
  with LsDirTree211 do
  begin
    NewFolder := '';
    PNode := Selected;
    if Assigned(Selected) then
    begin
      LsDirTree211.AddNewNode(PNode, '');
    end;
  end;
end; //BtnAddFolderClick


procedure TMainForm.BtnDeleteFolderClick(Sender: TObject);
begin
  with LsDirTree211 do
  begin
    if (Selected <> nil) and (Assigned(Selected)) then
      DeleteNode(Selected);
  end;
end;

procedure TMainForm.BtnEditFolderClick(Sender: TObject);
begin
  with LsDirTree211 do
  begin
    if (Selected <> nil) and (Assigned(Selected)) then
      Selected.EditText;
  end;
end;

procedure TMainForm.BtnTreeSizeClick(Sender: TObject);
begin
  if LsDirTree211.Selected <> nil then
    LsDirTree211.GetTreeSize;
end;

procedure TMainForm.BtnSearchClick(Sender: TObject);
begin
  LsFilelistView281.SetFocus;
  LsFilelistView281.FindFile;
end;

procedure TMainForm.BtnConnectClick(Sender: TObject);
var
  Drives: set of 0..25;
  ADrv: integer;
  DrvLtr: Char;
  TreePath: string;
begin
  DrvLtr := ' ';
  Integer(Drives) := GetLogicalDrives;
  for ADrv := 0 to 25 do
    if ADrv in Drives then
      DrvLtr := Chr(ADrv + Ord('B'));
  if WNetConnectionDialog(Application.Handle, RESOURCETYPE_DISK) =
    NO_ERROR then
  begin
    with LsDirTree211 do
    begin
      TreePath := (DrvLtr + ':\');
      Reload;
      OpenPath(TreePath);
    end;
    LsFilelistView281.Directory := TreePath;
  end;
end; //ConnecttoNetWork1Click


procedure TMainForm.BtnDisconnectClick(Sender: TObject);
begin
  WNetDisconnectDialog(Application.Handle, RESOURCETYPE_DISK);
  LsDirTree211.SelectedPath := 'Drives';
  BtnRefreshClick(Sender);
  LsDirTree211.Items[0].Expand(False);
end; //DisconnectfromNetWork1Click

procedure TMainForm.BtnRefreshClick(Sender: TObject);
var
  TreePath: string;
begin
  TreePath := '';
  with LsDirTree211 do
  begin
    if (Selected <> nil) and (Assigned(Selected)) then
      TreePath := SelectedPath;
    ReLoad;
    OpenPath(TreePath);
  end;
  BtnShowFolder.Down := True;
  LsFilelistView281.ShowFolders := True;
  LsFilelistView281.Directory := TreePath;
  LsFilelistView281.UpdateFileList;
end; //BtnRefreshClick


procedure TMainForm.BtnPrevLevelClick(Sender: TObject);
begin
  LsFilelistView281.OneLevelUp;
  SetBtnMenuState(Sender);
end; //BtnPrevLevelClick

procedure TMainForm.BtnShowFolderClick(Sender: TObject);
begin
  if LsFilelistView281.ShowFolders = True then
  begin
    LsFilelistView281.ShowFolders := False;
    BtnShowFolder.Down := False;
  end
  else begin
    LsFilelistView281.ShowFolders := True;
    BtnShowFolder.Down := True;
  end;
end;  //BtnShowFolderClick


procedure TMainForm.BtnFileDateClick(Sender: TObject);
var
  i: integer;
  FDate: Longint;
  NewDateTime: TDateTime;
  SelFileName: string;
  SelFile: File;
  OldCur: TCursor;
begin
  NewDateTime := Now;
  with LsFilelistView281 do
  begin
    if Selected = nil then
    begin
      ShowMessage('No file selected');
      exit;
    end;

    if FileDateForm.ShowModal = mrOK then
      NewDateTime := FileDateForm.SelectedDateTime;
    FDate := DateTimeToFileDate(NewDateTime);

    Items.BeginUpdate;
    OldCur := Screen.Cursor;
    Screen.Cursor := crHourGlass;
    for i := 0 to Items.Count - 1 do
    begin
      if Items[i].Selected then
      begin
        System.FileMode := fmOpenWrite;
        SelFileName := Items[i].SubItems[4];
        AssignFile(SelFile, SelFileName );
        {$I-}
        Reset(SelFile);
        {$I+}
        if IOResult <> 0 then
        begin
          ShowMessage('Could not open ' + ExtractFileName(SelFileName));
          exit;
        end;
        FileSetDate(TFileRec(SelFile).Handle, FDate);
        System.CloseFile(SelFile);
      end;
    end;
    Items.EndUpdate;
    Screen.Cursor := OldCur;
    BtnRefreshClick(Sender);
  end;
end;  //SetFileDateClick

procedure TMainForm.BtnCutClick(Sender: TObject);
begin
  LsFilelistView281.CutCopy(2);
  Cut1.Enabled := False;
  CanPaste := True;
  SetBtnMenuState(Sender);
end; //BtnCutClick


procedure TMainForm.BtnCopyClick(Sender: TObject);
begin
  LsFilelistView281.CutCopy(0);
  Copy1.Enabled := False;
  CanPaste := True;
  SetBtnMenuState(Sender);
end; //BtnCopyClick


procedure TMainForm.BtnPasteClick(Sender: TObject);
begin
  LsFilelistView281.Paste;
  CanPaste := False;
  Cut1.Enabled := True;
  Copy1.Enabled := True;
  SetBtnMenuState(Sender);
end; //BtnPasteClick


procedure TMainForm.BtnIconClick(Sender: TObject);
begin
  LsFilelistView281.ViewStyle := vsIcon;
end;  //BtnIconClick

procedure TMainForm.BtnSIconClick(Sender: TObject);
begin
  LsFilelistView281.ViewStyle := vsSmallIcon;
end; //BtnSIconClick

procedure TMainForm.BtnListClick(Sender: TObject);
begin
  LsFilelistView281.ViewStyle := vsList;
end; //BtnListClick

procedure TMainForm.BtnDetailClick(Sender: TObject);
begin
  LsFilelistView281.ViewStyle := vsReport;
end; //BtnDetailClick

procedure TMainForm.BtnExitClick(Sender: TObject);
begin
  Close;
end;


procedure TMainForm.Open1Click(Sender: TObject);
begin
  LsFilelistView281.OpenItem;
end;  //Open1Click

procedure TMainForm.QuickView1Click(Sender: TObject);
begin
  if Assigned(LsFilelistView281) then
    if LsFilelistView281.Selected <> nil then
      LsFilelistView281.ViewFile;
end; //QuickView1Click

procedure TMainForm.DeleteFiles1Click(Sender: TObject);
begin
  LsFilelistView281.DeleteItems;
end; //DeleteFiles1Click

procedure TMainForm.RenameFile1Click(Sender: TObject);
begin
  LsFilelistView281.RenameFile;
end; //RenameFile1Click




procedure TMainForm.Attribute1Click(Sender: TObject);
begin
  if Assigned(LsFilelistView281) then
    if LsFilelistView281.Selected <> nil then
      LsFilelistView281.FileAttr;
end; //Attribute1Click

procedure TMainForm.SelectAll1Click(Sender: TObject);
var
  i: integer;
begin
  if not Assigned(LsFilelistView281) then exit;
  with LsFilelistView281 do
  begin
    if Items.Count = 0 then exit;
    for i := 0 to Items.Count - 1 do
      Selected := Items[i];
  end;
end; //SelectAll1Click

procedure TMainForm.Goto1Click(Sender: TObject);
var
  PathName: string;
begin
  InputQuery('Go to Folder', 'Enter the name and path of the folder to open',
    PathName);
  if (PathName = '') or (Length(PathName) = 1) then exit;
  if PathName[Length(PathName)] <> '\' then
    PathName := PathName + '\';
  if DirectoryExists(PathName) then
  begin
    LsFilelistView281.Directory := PathName;
    LsDirTree211.OpenPath(PathName);
  end
  else begin
    if (Length(PathName) <= 3) and (PathName[2] = ':') then
      MessageDlg(UpperCase(PathName) + '  not ready', mtError, [mbOK], 0)
    else
      MessageDlg(PathName + '  not found', mtError, [mbOK], 0);
    exit;
  end;
end; //BtnSearchClick


procedure TMainForm.LsDirTree21ShortCuts1Click(Sender: TObject);
begin
  AboutForm.PageControl1.ActivePage := AboutForm.TabSheet1;
  AboutForm.ShowModal;
end; //LsDirTree21ShortCuts1Click

procedure TMainForm.LsFileListView28ShortCuts1Click(Sender: TObject);
begin
  AboutForm.PageControl1.ActivePage := AboutForm.TabSheet2;
  AboutForm.ShowModal;
end; //LsFilelistView28ShortCuts1Click

procedure TMainForm.AboutLsFileExplorer281Click(Sender: TObject);
begin
  AboutForm.PageControl1.ActivePage := AboutForm.TabSheet3;
  AboutForm.ShowModal;
end; //AboutLsFileExplorer261Click


procedure TMainForm.LsFilelistView281Change(Sender: TObject;
  Item: TListItem; Change: TItemChange);
begin
  SetBtnMenuState(Sender);
end; //LsFilelistView281Change


procedure TMainForm.LsFilelistView281Click(Sender: TObject);
begin
  SetBtnMenuState(Sender);
  EditPath.Text := LsFilelistView281.Directory;
end; //LsFilelistView281Click

procedure TMainForm.LsFilelistView281DblClick(Sender: TObject);
begin
  LsFilelistView281.OpenItem;
end; //LsFilelistView281DblClick

procedure TMainForm.LsFilelistView281KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = VK_Return) or (key = VK_Space) or (Key = VK_BACK) or
    (Key = VK_Up) or (Key = VK_Down) then
    GetStatistics(Sender);
end; //LsFilelistView281KeyUp

procedure TMainForm.LsFilelistView281MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then
    GetStatistics(Sender);
end; //LsFilelistView281MouseUp



procedure TMainForm.CbxMaskClick(Sender: TObject);
begin
  LsFilelistView281.Mask := CbxMask.Text;
end;  //CbxMaskClick

end.
