library ExprtMgr3;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  View-Project Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the DELPHIMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using DELPHIMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  SysUtils,
  Classes,
  ToolIntf,
  ExptIntf,
  Forms,
  ExpertManager in 'ExpertManager.pas',
  ExpertMgrFrm in 'ExpertMgrFrm.pas' {ExpertMgrFrm};

{Register the expert}
function InitExpert(ToolServices: TIToolServices;
   RegisterProc: TExpertRegisterProc;
   var Terminate: TExpertTerminateProc): Boolean; export; stdcall;
begin
   ExptIntf.ToolServices := ToolServices;
   if ToolServices <> nil then
      Application.Handle := ToolServices.GetParentHandle;
   Result := RegisterProc(TExpertManager.Create(@RegisterProc));
end;

exports
   InitExpert name ExpertEntryPoint resident;

begin
end.
