unit ExpertMgrFrm;

interface

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   StdCtrls, ComCtrls, ExpertManager, Grids, ExtCtrls, Buttons;

type
   TExpertMgrFrm = class(TForm)
      UnInstallButton: TButton;
      InstallButton: TButton;
      ExprtGrid: TStringGrid;
      AddButton: TButton;
      RemoveButton: TButton;
      OpenDialog: TOpenDialog;
      BitBtn1: TBitBtn;
      BitBtn2: TBitBtn;
      Bevel1: TBevel;
      procedure UnInstallButtonClick(Sender: TObject);
      procedure FormCreate(Sender: TObject);
      procedure InstallButtonClick(Sender: TObject);
      procedure AboutButtonClick(Sender: TObject);
      procedure AddButtonClick(Sender: TObject);
      procedure RemoveButtonClick(Sender: TObject);
   private
      { Private declarations }
      FExpertManager : TExpertManager;
      procedure SetExpertManager(const Value: TExpertManager);
      procedure Refresh;
   public
      { Public declarations }
      property ExpertManager : TExpertManager read FExpertManager write SetExpertManager;
   end;

const
   EXPRT_MGR_VERSION_NUMBER = '0.98';

implementation

{$R *.DFM}

uses
   ExptIntf;

//setup the grid columns
procedure TExpertMgrFrm.FormCreate(Sender: TObject);
begin
   {titles}
   with ExprtGrid do
   begin
      Cells[0, 0] := 'File Name';
      Cells[1, 0] := 'ID String';
      Cells[2, 0] := 'Style';
      Cells[3, 0] := 'Loaded'; 
      Cells[4, 0] := 'Path';
   end;
end;

procedure TExpertMgrFrm.SetExpertManager(const Value: TExpertManager);
var
   i_count : integer;
   ExpertCollectionItem : TExpertCollectionItem;
begin
   FExpertManager := Value;
   with ExprtGrid do
   begin
      {clear the grid}
      RowCount  := 1;
      RowCount := FExpertManager.Experts.Count + 1;
      FixedRows := 1;

      for i_count := 0 to FExpertManager.Experts.Count -1 do
      begin
         ExpertCollectionItem := FExpertManager.Experts.items[i_count] as TExpertCollectionItem;
         Objects[0, i_count+1] := ExpertCollectionItem;

         Cells[0, i_count+1] := ExpertCollectionItem.DisplayName;
         if ExpertCollectionItem.Expert <> nil then
         begin
            Cells[1, i_count+1] := ExpertCollectionItem.Expert.GetIDString;
            {could use rtti to turn the enumerated value into text or do this for simplicity}
            case ExpertCollectionItem.Expert.GetStyle of
               esStandard : Cells[2, i_count+1] := 'esStandard';
               esForm     : Cells[2, i_count+1] := 'esForm';
               esProject  : Cells[2, i_count+1] := 'esProject';
               esAddIn    : Cells[2, i_count+1] := 'esAddIn';
               else Cells[2, i_count+1] := '<unknown>';
            end;
         end
         else begin
            Cells[1, i_count+1] := '';
            Cells[2, i_count+1] := '';
         end;
         if ExpertCollectionItem.Loaded then
            Cells[3, i_count+1] := 'Yes'
         else
            Cells[3, i_count+1] := 'No';
         Cells[4, i_count+1] := ExtractFilePath(ExpertCollectionItem.FileName);
      end;
   end; {with}
   InstallButton.Enabled   := FExpertManager.Experts.Count > 0;
   UnInstallButton.Enabled := FExpertManager.Experts.Count > 0;
   AddButton.Enabled       := TRUE;
   RemoveButton.Enabled    := FExpertManager.Experts.Count > 0;
end;

procedure TExpertMgrFrm.Refresh;
begin
   {refresh}
   SetExpertManager(FExpertManager);
end;

procedure TExpertMgrFrm.InstallButtonClick(Sender: TObject);
var
   i_row : integer;
begin
   screen.cursor := crHourGlass;
   try
      if ExprtGrid.Row > 0 then
      begin
         if (ExprtGrid.Objects[0, ExprtGrid.Row] <> nil) and
            (ExprtGrid.Objects[0, ExprtGrid.Row] is TExpertCollectionItem) then
         begin
            i_row := ExprtGrid.Row;
            TExpertCollectionItem(ExprtGrid.Objects[0, ExprtGrid.Row]).Loaded := TRUE;
            Refresh;
            ExprtGrid.Row := i_row;
         end;
      end;
   finally
      screen.cursor := crDefault;
   end;
end;

procedure TExpertMgrFrm.UnInstallButtonClick(Sender: TObject);
var
   i_row : integer;
begin
   screen.cursor := crHourGlass;
   try
      if ExprtGrid.Row > 0 then
      begin
         if (ExprtGrid.Objects[0, ExprtGrid.Row] <> nil) and
            (ExprtGrid.Objects[0, ExprtGrid.Row] is TExpertCollectionItem) then
         begin
            i_row := ExprtGrid.Row;
            TExpertCollectionItem(ExprtGrid.Objects[0, ExprtGrid.Row]).Loaded := FALSE;
            Refresh;
            ExprtGrid.Row := i_row;
         end;
      end;
   finally
      screen.cursor := crDefault;
   end;
end;

procedure TExpertMgrFrm.AboutButtonClick(Sender: TObject);
begin
   ShowMessage(
   'Expert Manager (version '+EXPRT_MGR_VERSION_NUMBER+') is freeware. ' +
   'Written by Richard Brooks (copyright 1999)'+#10#13+
   #10#13+
    'For bug reports, suggestions or comments please contact : '+#10#13+
    #9+'rjb@rjexpert.freeserve.co.uk'+#10#13+
    'or visit'+#10#13+
    #9+'www.rjexpert.freeserve.co.uk'
   );
end;

procedure TExpertMgrFrm.AddButtonClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      screen.cursor := crHourGlass;
      try
         FExpertManager.AddExpert(OpenDialog.FileName);
         Refresh;
      finally
         screen.cursor := crDefault;
      end;
   end;
end;

procedure TExpertMgrFrm.RemoveButtonClick(Sender: TObject);
begin
   screen.cursor := crHourGlass;
   try
      if ExprtGrid.Row > 0 then
      begin
         if (ExprtGrid.Objects[0, ExprtGrid.Row] <> nil) and
            (ExprtGrid.Objects[0, ExprtGrid.Row] is TExpertCollectionItem)
         then
            FExpertManager.RemoveExpert(TExpertCollectionItem(ExprtGrid.Objects[0, ExprtGrid.Row]).FileName);
            {just freeing the TExpertCollectionItem would remove it from delphi but
             would not remove the registry item so it would be reloaded when the
             manager was reloaded}
      end;
      Refresh;
   finally
      screen.cursor := crDefault;
   end;
end;

end.
