unit ExDBGridCtls;

interface

uses
    Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
    Buttons, ExtCtrls, StdCtrls, Db, DbTables, ComCtrls, AdvStatusBar,
    DBCtrls, Menus;

type
    TExDBGridCtlsForm = class(TForm)
        Memo1: TMemo;
        ScrollBox1: TScrollBox;
        AdvStatusBar1: TAdvStatusBar;
        Okbtn: TSpeedButton;
        Cancelbtn: TSpeedButton;
        DBImage: TDBImage;
        PopupMenu: TPopupMenu;
        Cut1: TMenuItem;
        Copy1: TMenuItem;
        Paste1: TMenuItem;
        N1: TMenuItem;
        Clear1: TMenuItem;
        OpenDialog: TOpenDialog;
        SaveDialog: TSaveDialog;
        N2: TMenuItem;
        Open1: TMenuItem;
        Save1: TMenuItem;
        procedure CancelbtnClick(Sender: TObject);
        procedure OkbtnClick(Sender: TObject);
        procedure FormActivate(Sender: TObject);
        procedure MenuClick(Sender: TObject);
        procedure FileOpen(Sender: TObject);
        procedure SaveBtnClick(Sender: TObject);
    private
        { Private declarations }
        FBlobCaption: string;
        FBlobField: TField;
        FDataSource: TDataSource;
    public
        { Public declarations }
        property BlobCaption: string read FBlobCaption write FBlobCaption;
        property BlobField: TField read FBlobField write FBlobField;
        property DataSource: TDataSource read FDataSource write FDataSource;
    end;

var
    ExDBGridCtlsForm: TExDBGridCtlsForm;

implementation

{$R *.DFM}

procedure TExDBGridCtlsForm.CancelbtnClick(Sender: TObject);
begin
    ExDBGridCtlsForm.ModalResult := mrCancel;
end;

procedure TExDBGridCtlsForm.OkbtnClick(Sender: TObject);
begin
    if Memo1.Visible = True then
        begin
            if Assigned(FDataSource) then
                begin
                    FDataSource.DataSet.Edit;
                    FBlobField.AsString := Memo1.Lines.Text;
                end
            else
                raise(Exception.Create('Datasource Not Assigned'));
        end
    else
        begin
            if FDataSource.State in [dsEdit, dsInsert] then
                FDataSource.DataSet.FieldByName(DBImage.DataField).Assign(DBImage.Picture);
        end;

    ExDBGridCtlsForm.ModalResult := mrYes;
end;

procedure TExDBGridCtlsForm.FormActivate(Sender: TObject);
begin
    ExDBGridCtlsForm.Caption := FBlobCaption;

    case FBlobField.DataType of
        ftMemo, ftFmtMemo:
            begin
                Memo1.Lines.Text := FBlobField.AsString;
                Memo1.Visible := True;
            end;

        ftGraphic, ftTypedBinary:
            begin
                try
                    DBImage.DataSource := FDataSource;
                    DBImage.DataField := FBlobField.FieldName;
                    ScrollBox1.Visible := True;
                except
                    ExDBGridCtlsForm.ModalResult := mrCancel;
                end;
            end;
    end;
end;

procedure TExDBGridCtlsForm.MenuClick(Sender: TObject);
begin
    case Integer(TMenuItem(Sender).Tag) of
        1: DBImage.Perform(WM_CUT, 0, 0);
        2: DBImage.Perform(WM_COPY, 0, 0);
        3: DBImage.Perform(WM_PASTE, 0, 0);
        4: DBImage.Picture.Graphic := nil;
    end;
end;

procedure TExDBGridCtlsForm.FileOpen(Sender: TObject);
begin
    with OpenDialog do
        if Execute then DBImage.Picture.LoadFromFile(FileName);
end;

procedure TExDBGridCtlsForm.SaveBtnClick(Sender: TObject);
begin
    with SaveDialog do
        if Execute then DBImage.Picture.SaveToFile(FileName);
end;

end.

