//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "Unit2.h"
#include "math.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "ExPars"
#pragma link "ParsType"
#pragma link "Exprbldr"
#pragma link "Exprfns"
#pragma link "Fnlists"
#pragma link "parstype"
#pragma link "Vars"
#pragma link "ExFuncs"
#pragma resource "*.dfm"
TForm1 *Form1;


//--------------------------------------------------------
__fastcall TMyUserData::TMyUserData(): TUserData()
{
}

void __fastcall TMyUserData::Assign(TPersistent *Source)
{
   TUserData::Assign(Source);
   if (dynamic_cast<TMyUserData*>(Source))
      FldName=((TMyUserData *)Source)->FldName;
}

void __fastcall TMyUserData::ReadFromStream(TStream *S)
{
   TUserData::ReadFromStream(S);
   FldName = ReadStr(S);
}

void __fastcall TMyUserData::WriteToStream(TStream *S)
{
   TUserData::WriteToStream(S);
   WriteStr(S,FldName);
}

//---------------------------------------------------------------------------
__fastcall TMyUserDataList::TMyUserDataList(): TUserDataList()
{
}

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
   RegisterClass(__classid(TMyUserData));
   RegisterClass(__classid(TMyUserDataList));
   IsSolveMode = False;
   Table1->Open(); VarsTbl->Open(); DataTbl->Open();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
   IsSolveMode = false;
   ExprBuilderDlg1->Execute();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{
   IsSolveMode = true;
  // Here you may place a code that finds appropriate records containing desired
  //   set of variable values in VarsTbl and/or DataTbl, or initilize them manually
   MessageDlg("Result: "+ExprSolver1->F(OPENARRAY(Variant,(0))),
              mtInformation, TMsgDlgButtons() << mbOK,0);
   IsSolveMode = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ExprSolver1BeforeEvaluate(TObject *Sender)
{
  /* Here you may place a code if you want to initilize some variables
   which values can't be fetched from INI-file or from a field in a dataset.
   A list of variables used by a given expression can be retrived
   from ExprParser1.UsedVariables */
}
//---------------------------------------------------------------------------

Variant __fastcall TForm1::ExParser1Variable(TObject *Sender,
      const AnsiString VarName)
{
 //  if you specify the representation of the user data in expression to be by Name (UDRepresentAs:=udrt_Name),
 //  here you must check a VarName for any User data and return an Index of user data represented by VarName}

   Variant Result;
   TUserDataList *UserData;

   if (IsSolveMode)
      UserData=ExprSolver1->UserData;
   else UserData=ExprBuilderDlg1->UserData;
   if (UserData != NULL) Result=UserData->IndexOf(VarName); else Result=-1;
   if (Result==-1) throw EBadName(Parstype_msgInvalidIdent+": "+VarName);
     else return Result;
}
//---------------------------------------------------------------------------

Variant __fastcall TForm1::ExParser1Function(TObject *Sender,
      const AnsiString FuncName, const ArgArray &FuncParams,
      const int Param_High)
{
   Variant Result = 0;
   TUserDataList *UserData;
   int UDIdx;
   SmallString<255> AFldName;

   if (IsSolveMode)
      UserData=ExprSolver1->UserData;
   else UserData=ExprBuilderDlg1->UserData;

   if (CompareText(FuncName,"GETFLDVALUE")==0)
   {
     if (Param_High>=0)
     {
       try
       {
         UDIdx=FuncParams[0];
       }
       catch(...)
       {
         throw ESyntaxError(Parstype_msgMismatchArgs);
       }
       if ((UserData != NULL) && (UDIdx>=0) && (UDIdx<UserData->Count))
       {
         AFldName=((TMyUserData *)(UserData->Objects[UDIdx]))->FldName;
         Result=DataTbl->FieldByName(AFldName)->AsFloat;
       } else throw ESyntaxError("Invalid UserData index");
     } else throw ESyntaxError(Parstype_msgMismatchArgs);
   } else throw EBadName(Parstype_msgInvalidIdent+": "+FuncName);
   return Result;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)
{
   ExParser1->Expression=DBMemo1->Lines;
   if (ExParser1->Check(false))
     MessageDlg("Expression is OK!",mtInformation,TMsgDlgButtons() << mbOK,0);
}
//---------------------------------------------------------------------------


bool __fastcall TForm1::ExprBuilderDlg1EditUserData(
      TExprBuilderDlg *ExprBuilder, TUserDataList *&DataList, int Index,
      TUserData *&UserData)
{
    TGetUserDataDlg *ADlg;
    bool AddMode, Result;
    int ACnt;
    HCURSOR LastCur;
    TMyUserData *EditUD;

  // if UserData is nil or Index is = -1 then Add button is pressed,
  // and you must initilize UserData object. Probably you will use your own UserData,
  // and the class must be descendant from TUserData class, and must be registered with RegisterClass,
  // at the begining of your program
   AddMode = (UserData == NULL);
   EditUD = new TMyUserData;
   LastCur=::SetCursor(LoadCursor(0,IDC_WAIT));
   ADlg = new TGetUserDataDlg(this);
   try
     {
     if (AddMode)
     {
       if (DataList==NULL) ACnt=0; else ACnt=DataList->Count;
       EditUD->Name="Data" + IntToStr(ACnt+1);
     } else EditUD->Assign(UserData);

     ADlg->Edit1->Text=EditUD->Name;
     ADlg->ComboBox1->ItemIndex=ADlg->ComboBox1->Items->IndexOf(EditUD->FldName);

     Result=ADlg->ShowModal() == ID_OK;
     if (Result)
     {
      //  if DataList is nil, you may omit initilizing it, by default DataList will be initilized as TUserDataList.
      //  But this example will show you how you may define your own user data list object.
      //  Your user data list class must be derived from TUserDataList,
      //  and must be registered with procedure RegisterClass,
      //  at the begining of your program
       if (DataList==NULL) DataList= new TMyUserDataList;
       if (UserData==NULL) UserData= new TMyUserData;

       EditUD->Name=ADlg->Edit1->Text;
       EditUD->FldName=ADlg->ComboBox1->Text;
       UserData->Assign(EditUD);
     }
     }
   __finally
   {
     delete EditUD; delete ADlg;
     ::SetCursor(LastCur);
   }
   return Result;
}
//---------------------------------------------------------------------------

