{***************************************************************

	IMPORTANT: Please pay attention to the DEFINES below this
 					 documentation!

	WICHTIG: 	 Bitte beachten Sie die DEFINES unter dieser Dokumentation!

   **************************************************************
		German translation follows (deutsche bersetzung weiter unten)
   **************************************************************

   Unit Name: TEuroCalc

   Author   : Robby Wachtel
 						 RWachtel@gmx.de

   History  : V1   - October 1999
   										first release
							 V1.1 - October 1999
              					added StringLists for the countries and
              					currencies
                       added CurrencyName: string and
                       CountryName: string property to
                       TEuroCountry
              V1.2 - November 1999
              					added German strings
                       and documentation

		Written and tested in Delphi 3.02

   Should work with every Delphi version 3.x and above.

   What it does:
   =============

   	TEuroCalc is a Euro calculator for up to two currencies
     	simultaneously. You can calculate Euro in member state's
       currency and vice versa.

   Installing:
   ===========

			In the menu bar open COMPONENTS and select INSTALL COMPONENTS.
     Then install this unit with the OK button.

     Caution: If you have Delphi Standard please follow the
     				 instructions in the code below to get a slow
              and dirty implemented IntPower function.

     Caution: Afaik Delphi 5 doesn't have the DSGNINTF.DCU package:
              Please follow the instructions in the Delphi 5 README.TXT

   Miscellaneous:
		==============

   This component is (c) copyrighted 1999 by Robby Wachtel.

   This component is uncrippled PublicDomain for private use only.
                                                 ================

   For commercial use this component is uncrippled ShareWare, so
   	you have to pay the registration fee mentioned below
     to obtain the right to use this software commercially.

   If you find this component useful or want to use it
   	commercially a donation of 10 Euro (or US-$ 10)
     is appreciated:

     		Robby Wachtel
         Kyffhaeuserstr. 23
         D-50674 Koeln
         GERMANY

   With paying this registration fee you'll also get future
   	versions and bug fixes of this software via eMail
     without any charge.

   If you have any problems or suggestions please feel free
   	to contact me. If you change this software or parts of it
     please send me a copy.

		This software is provided as it is, without any kind of warranty
			given. The auther can not be held responsible for any kind of
			damage, problems etc. arised from using this product.

		You may use this software in any kind of development and redistribute
   	it freely, under the following restrictions :

			1. The origin of this software may not be mispresented, you must
   		 not claim that you wrote the original software. If you use
   		 this software in any kind of product, it would be appreciated
   		 that there in a information box, or in the documentation would
   		 be an acknowledgement like this
        			Parts Copyright  1999 by Robby Wachtel

			2. You may not have any income from distributing this source
   		 to other developers. When you use this product in a comercial
        package, the source may not be charged seperatly.

			3. This notice may not be removed from the source.

   Credits:
   ========

   Thanks to
   	Bea for all the love
			Simon Reinhardt for his DelphiFAQ (http://pics.webset.de/delphi.htm)
   	Lloyd Linklater for his Delphi Notes Help File
     Sven Biehl for a lot of useful hints in programming Delphi
     everyone in news://de.comp.lang.delphi.* for being a great community

   *****************************************
		German translation (deutsche bersetzung)
   *****************************************

   Unit Name: TEuroCalc

   Autor    : Robby Wachtel
 						 RWachtel@gmx.de

   History  : V1   - Oktober 1999
   										erste verffentlichte Version
							 V1.1 - Oktober 1999
              					StringLists fr die Lndernamen und Whrungen eingefgt
                       TEuroCountry mit CurrencyName: string und CountryName: string
                       Eigenschaften erweitert
              V1.2 - November 1999
              					deutsche Lokalisierung der Komponente und der Dokumentation

   Geschrieben und getestet mit Delphi 3.02

   Sollte mit jeder Delphi Version 3.x und hher funktionieren

		Zweck:
   ======

   	TEuroCalc ist ein Euro-Kalkulator fr bis zu zwei Whrungen
     	gleichzeitig. Sie knnen Euro-Betrge in Mitglieder-
       Whrungen und umgekehrt wandeln.

   Installation:
   =============

   	In der Menzeile whlen Sie "Komponente" und dort
     	"Komponente installieren...".
     Dann suchen Sie diese Unit und drcken OK.

     Vorsicht: Wenn Sie Delphi Standard besitzen, mssen Sie
     					die Compiler-Direktive unten im Code entsprechend lschen.
               (Beschreibung finden Sie nochmal dort.)

			Vorsicht: So weit ich weiss, ist in Delphi 5 DSGNINTF.DCU nicht
     					mehr enthalten. Bitte beachten Sie zur weiteren
               Vorgehensweise die Hinweise in der Datei README.TXT
               im Delphi 5 Verzeichnis.

   Verschiedenes:
		==============

   Diese Komponente unterliegt dem Urheberrechtsschutz und
   	ist daher (c) copyrighted 1999 by Robby Wachtel.

   Diese Komponente ist uneingeschrnkte PublicDomain
   	ausschlielich fr private Nutzung!
     ===================================

		Fr jegliche kommerzielle Verwendung ist diese
   	Komponente uneingeschrnkte ShareWare, d.h. sie darf in
     kommerziellen Programmen *nur* nach Zahlung der
     Registrierungsgebhr (s. nchster Absatz) genutzt werden.

   Wenn Sie diese Komponente ntzlich finden und/oder diese
   	Komponenten kommerziell nutzen wollen (also in Programmen,
     die Sie betrieblich und/oder beruflich entwickeln und/oder
     nutzen), senden Sie bitte einen Scheck ber 10 Euro (oder
     US-$ 10) an folgende Adresse:

     	Robby Wachtel
       Kyffhuserstr. 23
       D-50674 Kln
       DEUTSCHLAND

   Sie erhalten dann das Recht, diese Komponente in kommerziellen
   	Programmen jeder Art einzusetzen (also auch in Programmen,
     die Sie weiter veruern). Dies wird Ihnen dann auch nochmal
     per E-Mail besttigt.

   Gleichzeitig erhalten Sie nach Registrierung neue und/oder
   	fehlerbereinigte und/oder verbesserte Versionen dieser
     Komponente automatisch per E-Mail zugesandt.

   Haben Sie Probleme oder nderungsvorschlge, so stehe ich
   	Ihnen gerne zur Verfgung. ndern Sie diese Software
     oder Teile davon, so bitte ich um bersendung einer
     Kopie dieser nderungen.

		Diese Software wird zur Verfgung gestellt, "wie sie ist", ohne
   	Garantien fr die Funktionsfhigkeit oder korrekte Funktion.
     Der Autor kann nicht fr Datenverlust, Beschdigung, Probleme usw.
     aus der Verwendung dieser Software haftbar gemacht werden.
     (Bemerkung: Diese Einschrnkungen sind notwendig, da beim heutigen
                 Stand der technischen Entwicklungen eine 100%ige
                 Fehlerfreiheit von Software einfach nicht *garantiert*
                 werden kann - alleine schon aus Grnden der
                 Vielfltigkeit der sich auf dem Markt befindlichen
                 Prozessoren, Mainboards, Betriebssystemen usw. und deren
                 Zusammenstellungen. Durch die vollstndige
                 Verfgbarkeit des Quellcodes (OpenSource) ist das
                 Risiko allerdings einschtzbar und die Fehlersuche und
                 -behebung schnell und simpel durchfhrbar.)

		Sie knnen diese Software in jeder Form von Entwicklung einsetzen
   	und sie auch beliebig weitergeben, unter folgenden Voraussetzungen:

			1. Die Herkunft dieser Software mu unmiverstndlich dargestellt
     	 werden. Sie drfen nicht behaupten, da Sie das Original dieser
        Software geschrieben haben. Wenn Sie diese Software in irgend
        einem Produkt einsetzen, setzen Sie bitte in einer Info-Box
        oder in der Dokumentation einen Hinweis in der Form
        			Teile (c) 1999 by Robby Wachtel

			2. Sie drfen kein Einkommen aus der Distribution dieses
        Quellcodes an Dritte erzielen. Wenn Sie dieses Produkt
        kommerziell nutzen, drfen Sie den Quellcode dieser
        Software nicht besonders berechenen.

			3. Diese Bemerkungen drfen nicht aus diesem Quellcode
        entfernt werden.

   Credits: (da fllt mir kein passendes deutsches Wort zu ein ;-)
   ========

   Dank an
   	Bea fr all die Liebe
			Simon Reinhardt fr seine DelphiFAQ (http://pics.webset.de/delphi.htm)
   	Lloyd Linklater fr sein "Delphi Notes Help File"
     Sven Biehl fr viele Delphi-Tips
     Alle in news://de.comp.lang.delphi.*

****************************************************************}

unit EuroCalc;

interface

// Delete the following line ({$DEFINE MATH}) if you don't have the math unit
// (i.e. if you have Delphi standard)
//
// Lschen Sie die folgende Zeile ({$DEFINE MATH}), wenn Sie die math unit
// nicht haben (z.B. wenn Sie Delphi Standard besitzen)
{$DEFINE MATH}

// Delete the following line ({$DEFINE GERMAN}) if you want to have
// english country names
//
// Lschen Sie die folgende Zeile ({$DEFINE GERMAN}), wenn Sie
// englische Lndernamen haben wollen
{$DEFINE GERMAN}

{$IFDEF MATH}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Math, DsgnIntf;
{$ELSE}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, DsgnIntf;
{$ENDIF}

{$IFDEF GERMAN}
type TEuroCountries = (Oesterreich, Belgien, Finnland, Frankreich, Deutschland, Irland, Italien, Luxemburg, Holland, Portugal, Spanien);
// zuknftig: Daenemark, England, Griechenland, Schweden
{$ELSE}
type TEuroCountries = (Austria, Belgium, Finland, France, Germany, Ireland, Italy, Luxembourg, Netherlands, Portugal, Spain);
// for future use: Denmark, GreatBritain, Greece, Sweden
{$ENDIF}

type TEuroCurrencies = (ATS, BEF, FIM, FRF, DEM, IEP, ITL, LUF, NLG, PTE, ESP);
// for future use: DKK, GBP, GRD, SEK

type
  TAboutProperty = class(TPropertyEditor)
  public
   procedure Edit; override;
   function GetAttributes: TPropertyAttributes; override;
   function GetValue: string; override;
end;

type
	 TEuroCountry = class(TPersistent)
  private
  	FOwner: TComponent;
  	FCountry: TEuroCountries;
   FCurrency: TEuroCurrencies;
   FConversionRate: extended;
   FAmount: currency;
   FInternalAmount: extended;
   FCountryName: string;
   FCurrencyName: string;
   procedure SetConversionRate(rate: extended);
   procedure SetCountry(eurocountry: TEuroCountries);
   procedure SetCountryName(eurocountryname: string);
		procedure SetCurrency(eurocurrency: TEuroCurrencies);
   procedure SetCurrencyName(eurocurrencyname: string);
   procedure SetAmount(countryamount: currency);
  public
  	property InternalAmount: extended Read FInternalAmount;
  published
  	property ConversionRate: extended Read FConversionRate Write SetConversionRate;
  	property Country: TEuroCountries Read FCountry Write SetCountry;
   property CountryName: string Read FCountryName Write SetCountryName;
		property Currency: TEuroCurrencies Read FCurrency Write SetCurrency;
   property CurrencyName: string Read FCurrencyName Write SetCurrencyName;
   property Amount: currency Read FAmount Write SetAmount;
end;

type
  TEuroCalc = class(TComponent)
  private
    { Private-Deklarationen }
    FAbout: TAboutProperty;
    FCountry1: TEuroCountry;
    FCountry2: TEuroCountry;
    FEuro: currency;
    FInternalEuro: extended;
    FCountryNames: TStrings;
    FCurrencyNames: TStrings;
    procedure SetEuro(euroamount: currency);
    procedure CalculateCountries;
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property InternalEuro: extended Read FInternalEuro;
    property CountryNames: TStrings Read FCountryNames;
    property CurrencyNames: TStrings Read FCurrencyNames;
  published
    { Published-Deklarationen }
    property Euro: currency Read FEuro Write SetEuro;
    property EuroCountry1: TEuroCountry Read FCountry1 Write FCountry1;
    property EuroCountry2: TEuroCountry Read FCountry2 Write FCountry2;
    property About: TAboutProperty Read FAbout Write FAbout;
end;

{$IFDEF GERMAN}
const EuroCountries: Array[0..10] of string =
																							('sterreich',
                                              'Belgien',
                                              'Finnland',
                                              'Frankreich',
                                              'Deutschland',
                                              'Irland',
                                              'Italien',
                                              'Luxemburg',
                                              'Holland',
                                              'Portugal',
                                              'Spanien');
// zuknftig: Daenemark, England, Griechenland, Schweden
{$ELSE}
const EuroCountries: Array[0..10] of string =
																							('Austria',
                                              'Belgium',
                                              'Finland',
                                              'France',
                                              'Germany',
                                              'Ireland',
                                              'Italy',
                                              'Luxembourg',
                                              'Netherlands',
                                              'Portugal',
                                              'Spain');
// for future use: Denmark, GreatBritain, Greece, Sweden
{$ENDIF}

const EuroCurrencies: Array[0..10] of string =
																							('ATS',
                                              'BEF',
                                              'FIM',
                                              'FRF',
                                              'DEM',
                                              'IEP',
                                              'ITL',
                                              'LUF',
                                              'NLG',
                                              'PTE',
                                              'ESP');
// for future use: DKK, GBP, GRD, SEK

const EuroConversionRates: Array[0..10] of extended =
																							(13.7603,
                                              40.3399,
                                              5.94573,
                                              6.55957,
                                              1.95583,
                                             0.787564,
                                              1936.27,
                                              40.3399,
                                              2.20371,
                                              200.482,
                                              166.386);

const EuroNumericScale: Array[0..10] of ShortInt =
																							(2,0,2,2,2,2,0,0,2,0,0);

{$IFDEF GERMAN}
const EuroErrorCountryName = 'EuroCalc' + #13#13 + 'Ungltiger Wert:' + #13 + 'Land unbekannt!';
const EuroErrorCurrencyName = 'EuroCalc' + #13#13 + 'Ungltiger Wert:' + #13 + 'Whrung unbekannt!';
{$ELSE}
const EuroErrorCountryName = 'EuroCalc' + #13#13 + 'Value out of Range:' + #13 + 'Country not recognized!';
const EuroErrorCurrencyName = 'EuroCalc' + #13#13 + 'Value out of Range:' + #13 + 'Currency not recognized!';
{$ENDIF}

procedure Register;

function FinancialRound(amount: currency; numericscale: ShortInt): currency;

{$IFNDEF MATH}
function IntPower(base: extended; exponent: Integer): extended;
{$ENDIF}

implementation

//********** RegisterComponent **********
// Register the component in the palette
procedure Register;
begin
  RegisterComponents('MPS', [TEuroCalc]);
  RegisterPropertyEditor(TypeInfo(TAboutProperty), TEuroCalc, 'About', TAboutProperty);
end;

//********** TAboutProperty.Edit **********
procedure TAboutProperty.Edit;
begin
  ShowMessage('EuroCalc Component v1.2' + #13#13 +
  				     ' Copyright 1999 by Robby Wachtel, all rights reserved.' + #13#13 +
              '   eMail rwachtel@gmx.de');
end;

//********** TAboutProperty.GetAttributes **********
function TAboutProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paReadOnly];
end;

//********** TAboutProperty.GetValue **********
function TAboutProperty.GetValue: string;
begin
  Result := 'About...';
end;


//********** TEuroCountry.SetConversionRate **********
procedure TEuroCountry.SetConversionRate(rate: extended);
begin
end;

//********** TEuroCountry.SetCountry **********
procedure TEuroCountry.SetCountry(eurocountry: TEuroCountries);
begin
 FCountry := eurocountry;
 FCurrency := TEuroCurrencies(Ord(FCountry));
 FConversionRate := EuroConversionRates[Ord(FCountry)];
 FCountryName := EuroCountries[Ord(FCountry)];
 FCurrencyName := EuroCurrencies[Ord(FCountry)];
 if FOwner <> nil then begin
  	FInternalAmount := TEuroCalc(FOwner).FInternalEuro * FConversionRate;
   FAmount := FinancialRound(FInternalAmount, EuroNumericScale[Ord(Fcountry)]);
 end;
end;

//********** TEuroCountry.SetCurrency **********
procedure TEuroCountry.SetCurrency(eurocurrency: TEuroCurrencies);
begin
 Country := TEuroCountries(Ord(eurocurrency)); // set country / Land setzen
end;

//********** TEuroCountry.SetAmount **********
procedure TEuroCountry.SetAmount(countryamount: currency);
begin
	FAmount := FinancialRound(countryamount, EuroNumericScale[Ord(Fcountry)]);
 FInternalAmount := FAmount;
 if FOwner <> nil then begin
 	TEuroCalc(FOwner).FInternalEuro := FInternalAmount / FConversionRate;
   TEuroCalc(FOwner).FEuro := FinancialRound(TEuroCalc(FOwner).FInternalEuro, 2);
   TEuroCalc(FOwner).CalculateCountries;
 end;
end;

//********** TEuroCountry.SetCountryName **********
procedure TEuroCountry.SetCountryName(eurocountryname: string);
var
	i: TEuroCountries;
 error: boolean;
begin
	error := true;
	for i := Low(TEuroCountries) to High(TEuroCountries) do
		if eurocountryname = EuroCountries[Ord(i)] then begin
			Country := i;
     error := false;
     break;
   end;
 	if error then raise ERangeError.Create(EuroErrorCountryName);
end;

//********** TEuroCountry.SetCurrencyName **********
procedure TEuroCountry.SetCurrencyName(eurocurrencyname: string);
var
	i: TEuroCurrencies;
 error: boolean;
begin
	error := true;
	for i := Low(TEuroCurrencies) to High(TEuroCurrencies) do
		if eurocurrencyname = EuroCurrencies[Ord(i)] then begin
			Currency := i;
     error := false;
     break;
   end;
 	if error then raise ERangeError.Create(EuroErrorCurrencyName);
end;

//********** TEuroCalc.Create **********
constructor TEuroCalc.Create(AOwner: TComponent);
var
	i: integer;
begin
	inherited Create(AOwner);
 FCountry1 := TEuroCountry.Create;
 FCountry1.FOwner := self;
 FCountry1.Country := TEuroCountries(4); // Germany / Deutschland
 FCountry2 := TEuroCountry.Create;
 FCountry2.FOwner := self;
 FCountry2.Country := TEuroCountries(4); // Germany / Deutschland
	FCountryNames := TStringList.Create;
 FCurrencyNames := TStringList.Create;
 for i := Low(EuroCountries) to High(EuroCountries) do
 	FCountryNames.Add(EuroCountries[i]);
 for i := Low(EuroCurrencies) to High(EuroCurrencies) do
 	FCurrencyNames.Add(EuroCurrencies[i]);
end;

//********** TEuroCalc.SetEuro **********
// Amount of Euros changed by User
// Euro-Betrag wurde gendert
procedure TEuroCalc.SetEuro(euroamount: currency);
begin
	FEuro :=	FinancialRound(euroamount, 2);
 FInternalEuro := FEuro;
 CalculateCountries;
end;

//********** TEuroCalc.CalculateCountries **********
// Calculate countrie's amounts after change of Euro
// Landeswhrungen nach nderung des Euro-Betrags aktualisieren
procedure TEuroCalc.CalculateCountries;
begin
 FCountry1.FInternalAmount := FInternalEuro * FCountry1.FConversionRate;
 FCountry1.FAmount := FinancialRound(FCountry1.FInternalAmount, EuroNumericScale[Ord(FCountry1.Fcountry)]);
 FCountry2.FInternalAmount := FInternalEuro * FCountry2.FConversionRate;
 FCountry2.FAmount := FinancialRound(FCountry2.FInternalAmount, EuroNumericScale[Ord(FCountry2.Fcountry)]);
end;

//********** TEuroCalc.Destroy **********
destructor TEuroCalc.Destroy;
begin
	FCountry1.Free;
 FCountry1 := nil;
	FCountry2.Free;
 FCountry2 := nil;
 FCountryNames.Free;
 FCountryNames := nil;
 FCurrencyNames.Free;
 FCurrencyNames := nil;
	inherited Destroy;
end;

//********** FinancialRound **********
function FinancialRound(amount: currency; numericscale: ShortInt): currency;
begin
	Result := Int(amount * IntPower(10, numericscale) + 0.5) / IntPower(10, numericscale);
end;

{$IFNDEF MATH}
//********** IntPower **********
function IntPower(base: extended; exponent: Integer): extended;
begin
	Result := 1;
 while exponent > 0 do begin
		dec(exponent);
   Result := Result * base;
 end;
end;
{$ENDIF}

end.
