unit PrintForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  EasyReport, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Report: TEasyReport;
    Title: TEasyPrintArea;
    Sumary: TEasyPrintArea;
    PageHeader: TEasyPrintArea;
    PageFooter: TEasyPrintArea;
    ColumnHeader: TEasyPrintArea;
    ColumnFooter: TEasyPrintArea;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    function ReportIsLastPage(Sender: TObject): Boolean;
    procedure ReportBeforePrint(Sender: TObject);
    procedure ReportAfterPrint(Sender: TObject);
    function CalcHeight(Sender: TObject; Canvas: TCanvas): Integer;
    procedure TitlePrint(Sender: TObject; Canvas: TCanvas; Area: TRect);
    procedure PageHeaderPrint(Sender: TObject; Canvas: TCanvas;
      Area: TRect);
    procedure ColumnHeaderPrint(Sender: TObject; Canvas: TCanvas;
      Area: TRect);
    procedure ColumnFooterPrint(Sender: TObject; Canvas: TCanvas;
      Area: TRect);
    procedure PageFooterPrint(Sender: TObject; Canvas: TCanvas;
      Area: TRect);
    procedure SumaryPrint(Sender: TObject; Canvas: TCanvas; Area: TRect);
    function ReportDetailPrint(Sender: TObject; Canvas: TCanvas;
      var Area: TRect): Boolean;
  private
    Column:Integer;
    procedure AreaPrint(Value:string; Canvas: TCanvas; Area: TRect);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
   Column:=1;
   Report.Print;
end;

function TForm1.ReportIsLastPage(Sender: TObject): Boolean;
begin
// This is a one page demo.
// It is important to know if it is the last page whe you dont want
// the page footer on it (its printed on the page start)
   Result:=True;
end;

procedure TForm1.ReportBeforePrint(Sender: TObject);
begin
// I use this to record tables positions, disable controls and going to
// the first recorx
end;

procedure TForm1.ReportAfterPrint(Sender: TObject);
begin
// Go back in databases and enable controls
end;

function TForm1.CalcHeight(Sender: TObject; Canvas: TCanvas): Integer;
begin
   Result:=Round(Canvas.TextHeight('Mg')*1.2);
end;

procedure TForm1.TitlePrint(Sender: TObject; Canvas: TCanvas; Area: TRect);
begin
   AreaPrint('Title',Canvas,Area);
end;

procedure TForm1.PageHeaderPrint(Sender: TObject; Canvas: TCanvas;
  Area: TRect);
begin
   AreaPrint('Page Header',Canvas,Area);
end;

procedure TForm1.ColumnHeaderPrint(Sender: TObject; Canvas: TCanvas;
  Area: TRect);
begin
   AreaPrint('Column Header',Canvas,Area);
end;

procedure TForm1.ColumnFooterPrint(Sender: TObject; Canvas: TCanvas;
  Area: TRect);
begin
   AreaPrint('Column Footer',Canvas,Area);
end;

procedure TForm1.PageFooterPrint(Sender: TObject; Canvas: TCanvas;
  Area: TRect);
begin
   AreaPrint('Page Footer',Canvas,Area);
end;

procedure TForm1.SumaryPrint(Sender: TObject; Canvas: TCanvas;
  Area: TRect);
begin
   AreaPrint('Sumary',Canvas,Area);
end;

procedure TForm1.AreaPrint(Value:string; Canvas: TCanvas; Area: TRect);
var x,y:Integer;
begin
   Canvas.Rectangle(Area.Left,Area.Top,Area.Right,Area.Bottom);
   x:=(Area.Left+Area.Right-Canvas.TextWidth(Value)) div 2;
   y:=(Area.Top+Area.Bottom-Canvas.TextHeight(Value)) div 2;
   Canvas.TextOut(x,y,Value);
end;

function TForm1.ReportDetailPrint(Sender: TObject; Canvas: TCanvas;
  var Area: TRect): Boolean;
var count:integer;
    y,h:integer;
begin
   if Column=1 then
   begin
      h:=Canvas.TextHeight('Mg');
      y:=Area.Top;
      while (Area.Bottom-y)>h do
      begin
         AreaPrint('Detail',Canvas,Rect(Area.Left,y,Area.Right,y+h));
         inc(y,h);
      end;
      Area.Top:=y;
      Column:=2;
      Result:=False;
   end
   else
   begin
      h:=Canvas.TextHeight('Mg');
      y:=Area.Top;
      count:=0;
      while ((Area.Bottom-y)>h) and (count<20)do
      begin
         AreaPrint('Detail',Canvas,Rect(Area.Left,y,Area.Right,y+h));
         inc(y,h);
         inc(count);
      end;
      Column:=3;
      Result:=True;
      Area.Top:=y;
   end;
end;

end.
