{***************************************************************

		Unit Name: EditOnTime

		Author   : Robert Wachtel
							 rwachtel@gmx.de
							 http://www.mpscologne.de

		History  :

		Written and tested in Delphi 5

		Should work with every Delphi version 3.x and above.

		Installing:
		===========

			In the menu bar open COMPONENTS and select INSTALL COMPONENTS.
			Then install this unit with the OK button.

		Properties:
		===========

			Active
				set to TRUE if you want the component to be active (what else ;-)

			Name
				the name

			Tag
				the tag

		Tip:
		====

		Miscellaneous:
		==============

		This Component is FreeWare.

		If you have any problems or suggestions please feel free
			to contact me.

		If you improve or change the code, please be so kind to send me a copy.

		Credits:
		========

		Thanks to
			Bea for all the love
			Simon Reinhardt for his DelphiFAQ (http://www.picsoft.de)
			Lloyd Linklater for his Delphi Notes Help File
			Sven Eisenkraemer for a lot of useful hints in programming Delphi
			everyone in news://de.comp.lang.delphi.* for being a great community

****************************************************************}

unit EditOnTime;

interface

uses
	 Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ExtCtrls, StdCtrls;

type
	TEditOnTime = class(TEdit)
	private
		FInterval: integer;
		FTimer: TTimer;
		FOnTimer: TNotifyEvent;
		procedure SetInterval(Interval: integer);
		procedure Timer(Sender: TObject);
	 protected
	 	procedure KeyPress(var Key: char); override;
	 public
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
	 published
		property Interval: integer read FInterval write SetInterval default 750;
		property OnTimer: TNotifyEvent read FOnTimer write FOnTimer;
	 end;

procedure Register;

implementation

//******************* RegisterComponent *************************
procedure Register;
begin
	 RegisterComponents('MPS', [TEditOnTime]);
end;

//******************* TEditOnTime.SetInterval *************************
procedure TEditOnTime.SetInterval(Interval: integer);
begin
	FInterval := Interval;
	if Assigned(FTimer) then
		FTimer.Interval := FInterval;
end;

//******************* TEditOnTime.Create *************************
constructor TEditOnTime.Create(AOwner: TComponent);
begin
	FInterval := 750;
	inherited Create(AOwner);
	if not (csDesigning in ComponentState) then
	try
		FTimer := TTimer.Create(self);
		FTimer.Enabled := false;
		FTimer.Interval := FInterval;
		FTimer.OnTimer := Timer;
	except
		FreeAndNil(FTimer);
	end;
end;

//******************* TEditOnTime.Destroy *************************
destructor TEditOnTime.Destroy;
begin
	if Assigned(FTimer) then
		FreeAndNil(FTimer);
	inherited Destroy;
end;

//******************* TEditOnTime.OnTimer *************************
procedure TEditOnTime.Timer(Sender: TObject);
begin
	FTimer.Enabled := false;
	if Assigned(FOnTimer) then
		FOnTimer(self);
end;

//******************* TEditOnTime.KeyPress *************************
procedure TEditOnTime.KeyPress(var Key: char);
begin
	FTimer.Enabled := false;
	inherited KeyPress(Key);
	FTimer.Enabled := (Text <> '') and Assigned(FTimer) and Assigned(FOnTimer);
end;

end.

